/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.HuTuckerTransformationStrategy;
import it.unimi.dsi.bits.TransformationStrategies;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.io.FileLinesByteArrayIterable;
import it.unimi.dsi.io.FileLinesMutableStringIterable;
import it.unimi.dsi.sux4j.mph.AbstractHashFunction;
import it.unimi.dsi.sux4j.mph.GOV3Function;
import it.unimi.dsi.sux4j.mph.HollowTrieDistributor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HollowTrieDistributorMonotoneMinimalPerfectHashFunction<T>
extends AbstractHashFunction<T>
implements Size64,
Serializable {
    public static final long serialVersionUID = 5L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HollowTrieDistributorMonotoneMinimalPerfectHashFunction.class);
    private final long size;
    private final int bucketSize;
    private final int log2BucketSize;
    private final TransformationStrategy<? super T> transform;
    private final HollowTrieDistributor<BitVector> distributor;
    private final GOV3Function<BitVector> offset;

    public long getLong(Object o) {
        if (this.size <= 1L) {
            return this.defRetValue;
        }
        BitVector bv = this.transform.toBitVector(o).fast();
        long bucket = this.distributor.getLong(bv);
        return (bucket << this.log2BucketSize) + this.offset.getLong(bv);
    }

    public HollowTrieDistributorMonotoneMinimalPerfectHashFunction(Iterable<? extends T> elements, TransformationStrategy<? super T> transform) throws IOException {
        this(elements, transform, null);
    }

    public HollowTrieDistributorMonotoneMinimalPerfectHashFunction(Iterable<? extends T> elements, TransformationStrategy<? super T> transform, File tempDir) throws IOException {
        this.transform = transform;
        long maxLength = 0L;
        long totalLength = 0L;
        long c = 0L;
        for (T s : elements) {
            BitVector bv = transform.toBitVector(s);
            maxLength = Math.max(maxLength, bv.length());
            totalLength += bv.length();
            ++c;
        }
        this.size = c;
        long l = this.defRetValue = this.size == 1L ? 0L : -1L;
        if (this.size <= 1L) {
            this.log2BucketSize = 0;
            this.bucketSize = 0;
            this.distributor = null;
            this.offset = null;
            return;
        }
        long averageLength = (totalLength + this.size - 1L) / this.size;
        int l2 = Fast.ceilLog2((int)Math.round((long)((Math.log(averageLength) + 2.0) * Math.log(2.0) / GOV3Function.C)));
        this.log2BucketSize = this.size / (long)(1 << l2) <= 1L ? 0 : l2;
        this.bucketSize = 1 << this.log2BucketSize;
        final int bucketMask = this.bucketSize - 1;
        LOGGER.debug("Bucket size: " + this.bucketSize);
        Iterable bitVectors = TransformationStrategies.wrap(elements, transform);
        this.distributor = new HollowTrieDistributor(bitVectors, this.log2BucketSize, TransformationStrategies.identity(), tempDir);
        this.offset = new GOV3Function.Builder().keys(bitVectors).transform(TransformationStrategies.identity()).values((LongIterable)new AbstractLongBigList(){

            public long getLong(long index) {
                return index & (long)bucketMask;
            }

            public long size64() {
                return HollowTrieDistributorMonotoneMinimalPerfectHashFunction.this.size;
            }
        }, this.log2BucketSize).build();
        LOGGER.debug("Forecast bit cost per element: " + (GOV3Function.C * (1.0 / Math.log(2.0) + 2.0 + Fast.log2((double)(Math.log(2.0) / GOV3Function.C))) + Fast.log2((double)(2.0 + Fast.log2((double)(averageLength + 1L))))));
        LOGGER.info("Actual bit cost per element: " + (double)this.numBits() / (double)this.size);
    }

    @Override
    public long size64() {
        return this.size;
    }

    public long numBits() {
        return this.distributor.numBits() + this.offset.numBits() + this.transform.numBits();
    }

    public static void main(String[] arg) throws NoSuchMethodException, IOException, JSAPException {
        SimpleJSAP jsap = new SimpleJSAP(HollowTrieDistributorMonotoneMinimalPerfectHashFunction.class.getName(), "Builds a monotone minimal perfect hash using a hollow trie as a distributor reading a newline-separated list of strings.", new Parameter[]{new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The string file encoding."), new Switch("huTucker", 'h', "hu-tucker", "Use Hu-Tucker coding to reduce string length."), new Switch("iso", 'i', "iso", "Use ISO-8859-1 coding internally (i.e., just use the lower eight bits of each character)."), new Switch("utf32", '\u0000', "utf-32", "Use UTF-32 internally (handles surrogate pairs)."), new Switch("byteArray", 'b', "byte-array", "Create a function on byte arrays (no character encoding)."), new Switch("zipped", 'z', "zipped", "The string list is compressed in gzip format."), new FlaggedOption("decompressor", (StringParser)JSAP.CLASS_PARSER, JSAP.NO_DEFAULT, false, 'd', "decompressor", "Use this extension of InputStream to decompress the strings (e.g., java.util.zip.GZIPInputStream)."), new FlaggedOption("tempDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 't', "temp-dir", "A temporary directory for the files created during the construction."), new UnflaggedOption("function", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised monotone minimal perfect hash function."), new UnflaggedOption("stringFile", (StringParser)JSAP.STRING_PARSER, "-", false, false, "The name of a file containing a newline-separated list of strings, or - for standard input; in the second case, strings must be fewer than 2^31 and will be loaded into core memory.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String functionName = jsapResult.getString("function");
        String stringFile = jsapResult.getString("stringFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        Class<GZIPInputStream> decompressor = jsapResult.getClass("decompressor");
        boolean iso = jsapResult.getBoolean("iso");
        boolean utf32 = jsapResult.getBoolean("utf32");
        boolean huTucker = jsapResult.getBoolean("huTucker");
        boolean byteArray = jsapResult.getBoolean("byteArray");
        File tempDir = jsapResult.getFile("tempDir");
        if (zipped && decompressor != null) {
            throw new IllegalArgumentException("The zipped and decompressor options are incompatible");
        }
        if (zipped) {
            decompressor = GZIPInputStream.class;
        }
        if (byteArray) {
            if ("-".equals(stringFile)) {
                throw new IllegalArgumentException("Cannot read from standard input when building byte-array functions");
            }
            if (iso || utf32 || huTucker || jsapResult.userSpecified("encoding")) {
                throw new IllegalArgumentException("Encoding options are not available when building byte-array functions");
            }
            FileLinesByteArrayIterable keys = new FileLinesByteArrayIterable(stringFile, decompressor);
            BinIO.storeObject(new HollowTrieDistributorMonotoneMinimalPerfectHashFunction(keys, TransformationStrategies.prefixFreeByteArray(), tempDir), (CharSequence)functionName);
        } else {
            ObjectArrayList keys;
            if ("-".equals(stringFile)) {
                ObjectArrayList list;
                keys = list = new ObjectArrayList();
                FileLinesMutableStringIterable.iterator((InputStream)System.in, (Charset)encoding, decompressor).forEachRemaining(s -> list.add((Object)s.toString()));
            } else {
                keys = new FileLinesMutableStringIterable(stringFile, encoding, decompressor);
            }
            HuTuckerTransformationStrategy transformationStrategy = huTucker ? new HuTuckerTransformationStrategy((Iterable)keys, true) : (iso ? TransformationStrategies.prefixFreeIso() : (utf32 ? TransformationStrategies.prefixFreeUtf32() : TransformationStrategies.prefixFreeUtf16()));
            BinIO.storeObject(new HollowTrieDistributorMonotoneMinimalPerfectHashFunction(keys, transformationStrategy, tempDir), (CharSequence)functionName);
        }
        LOGGER.info("Completed.");
    }
}

