/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.LongBigArrayBitVector;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.sux4j.bits.SimpleBigSelect;
import it.unimi.dsi.sux4j.util.MappedEliasFanoMonotoneLongBigList;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.NoSuchElementException;

public class EliasFanoMonotoneBigLongBigList
extends AbstractLongBigList
implements Serializable {
    private static final long serialVersionUID = 5L;
    protected final long length;
    protected final int l;
    protected transient long[][] upperBits;
    protected long[][] lowerBits;
    protected final SimpleBigSelect selectUpper;
    protected final long lowerBitsMask;

    protected EliasFanoMonotoneBigLongBigList(long length, int l, long[][] upperBits, long[][] lowerBits, SimpleBigSelect selectUpper) {
        this.length = length;
        this.l = l;
        this.upperBits = upperBits;
        this.lowerBits = lowerBits;
        this.selectUpper = selectUpper;
        this.lowerBitsMask = (1L << l) - 1L;
    }

    public EliasFanoMonotoneBigLongBigList(IntIterable list) {
        this(() -> LongIterators.wrap((IntIterator)list.iterator()));
    }

    public EliasFanoMonotoneBigLongBigList(ShortIterable list) {
        this(() -> LongIterators.wrap((ShortIterator)list.iterator()));
    }

    public EliasFanoMonotoneBigLongBigList(ByteIterable list) {
        this(() -> LongIterators.wrap((ByteIterator)list.iterator()));
    }

    public EliasFanoMonotoneBigLongBigList(LongIterable list) {
        this(EliasFanoMonotoneBigLongBigList.computeParameters(list.iterator()), list.iterator());
    }

    private static long[] computeParameters(LongIterator iterator) {
        long v = -1L;
        long prev = -1L;
        long c = 0L;
        while (iterator.hasNext()) {
            v = iterator.nextLong();
            if (prev > v) {
                throw new IllegalArgumentException("The list of values is not monotone: " + prev + " > " + v);
            }
            prev = v;
            ++c;
        }
        return new long[]{c, v};
    }

    public EliasFanoMonotoneBigLongBigList(long n, long upperBound, ByteIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ByteIterator)iterator));
    }

    public EliasFanoMonotoneBigLongBigList(long n, long upperBound, ShortIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ShortIterator)iterator));
    }

    public EliasFanoMonotoneBigLongBigList(long n, long upperBound, IntIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((IntIterator)iterator));
    }

    public EliasFanoMonotoneBigLongBigList(long n, long upperBound, LongIterator iterator) {
        this(new long[]{n, upperBound}, iterator);
    }

    protected EliasFanoMonotoneBigLongBigList(long[] a, LongIterator iterator) {
        this.length = a[0];
        long v = -1L;
        long upperBound = a[1];
        this.l = this.length == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(upperBound / this.length)));
        this.lowerBitsMask = (1L << this.l) - 1L;
        long lowerBitsMask = (1L << this.l) - 1L;
        LongBigArrayBitVector lowerBitsVector = LongBigArrayBitVector.getInstance();
        LongBigList lowerBitsList = lowerBitsVector.asLongBigList(this.l);
        lowerBitsList.size(this.length + 1L);
        LongBigArrayBitVector upperBits = LongBigArrayBitVector.getInstance().length(this.length + (upperBound >>> this.l) + 2L);
        long last = -1L;
        long finalUpperBound = upperBound;
        for (long i = 0L; i < this.length; ++i) {
            v = iterator.nextLong();
            if (v > upperBound) {
                throw new IllegalArgumentException("Too large value: " + v + " > " + upperBound);
            }
            if (v == finalUpperBound) {
                upperBits.length(this.length + (++finalUpperBound >>> this.l) + 2L);
            }
            if (v < last) {
                throw new IllegalArgumentException("Values are not nondecreasing: " + v + " < " + last);
            }
            if (this.l != 0) {
                lowerBitsList.set(i, v & lowerBitsMask);
            }
            upperBits.set((v >>> this.l) + i);
            last = v;
        }
        if (this.l != 0) {
            lowerBitsList.set(this.length, finalUpperBound & lowerBitsMask);
        }
        upperBits.set((finalUpperBound >>> this.l) + this.length);
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("There are more than " + this.length + " values in the provided iterator");
        }
        this.lowerBits = this.l == 0 ? LongBigArrays.newBigArray((long)1L) : lowerBitsVector.bigBits();
        this.upperBits = upperBits.bigBits();
        this.selectUpper = new SimpleBigSelect(upperBits);
    }

    public long numBits() {
        return this.selectUpper.numBits() + this.selectUpper.bitVector().length() + LongBigArrayBitVector.bits((long)BigArrays.length((long[][])this.lowerBits));
    }

    public long getLong(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        int l = this.l;
        long upperBits = this.selectUpper.select(index) - index;
        long position = index * (long)l;
        long startWord = LongBigArrayBitVector.word((long)position);
        int startBit = LongArrayBitVector.bit((long)position);
        long result = BigArrays.get((long[][])this.lowerBits, (long)startWord) >>> startBit;
        return upperBits << l | (startBit + l <= 64 ? result : result | BigArrays.get((long[][])this.lowerBits, (long)(startWord + 1L)) << -startBit) & this.lowerBitsMask;
    }

    public long getDelta(long index) {
        assert (index >= 0L);
        assert (index < this.length - 1L);
        long[] dest = new long[2];
        this.selectUpper.select(index, dest, 0, 2);
        int l = this.l;
        long[][] lowerBits = this.lowerBits;
        long position = index * (long)l;
        long startWord = LongBigArrayBitVector.word((long)position);
        int startBit = LongArrayBitVector.bit((long)position);
        long first = BigArrays.get((long[][])lowerBits, (long)startWord) >>> startBit;
        first = dest[0] - index++ << l | (startBit + l <= 64 ? first : first | BigArrays.get((long[][])lowerBits, (long)(startWord + 1L)) << -startBit) & this.lowerBitsMask;
        startWord = LongBigArrayBitVector.word((long)(position += (long)l));
        startBit = LongArrayBitVector.bit((long)position);
        long second = BigArrays.get((long[][])lowerBits, (long)startWord) >>> startBit;
        second = dest[1] - index << l | (startBit + l <= 64 ? second : second | BigArrays.get((long[][])lowerBits, (long)(startWord + 1L)) << -startBit) & this.lowerBitsMask;
        return second - first;
    }

    public long[] get(long index, long[] dest, int offset, int length) {
        assert (index >= 0L);
        assert (index < this.length);
        assert (offset >= 0);
        assert (offset < dest.length);
        assert (length >= 0);
        assert (offset + length <= dest.length);
        this.selectUpper.select(index, dest, offset, length);
        int l = this.l;
        long lowerBitsMask = this.lowerBitsMask;
        long[][] lowerBits = this.lowerBits;
        long position = index * (long)l;
        for (int i = 0; i < length; ++i) {
            long startWord = LongBigArrayBitVector.word((long)position);
            int startBit = LongArrayBitVector.bit((long)position);
            long result = BigArrays.get((long[][])lowerBits, (long)startWord) >>> startBit;
            dest[offset + i] = dest[offset + i] - index++ << l | (startBit + l <= 64 ? result : result | BigArrays.get((long[][])lowerBits, (long)(startWord + 1L)) << -startBit) & lowerBitsMask;
            position += (long)l;
        }
        return dest;
    }

    public long[] get(long index, long[] dest) {
        return this.get(index, dest, 0, dest.length);
    }

    public EliasFanoMonotoneLongBigListIterator listIterator(long from) {
        return new EliasFanoMonotoneLongBigListIterator(from);
    }

    public EliasFanoMonotoneLongBigListIterator listIterator() {
        return new EliasFanoMonotoneLongBigListIterator(0L);
    }

    public EliasFanoMonotoneLongBigListIterator iterator() {
        return this.listIterator();
    }

    public long size64() {
        return this.length;
    }

    public void dump(String basename) throws IOException {
        this.dump(basename, ByteOrder.nativeOrder());
    }

    public void dump(String basename, ByteOrder byteOrder) throws IOException {
        BinIO.storeObject((Object)new MappedEliasFanoMonotoneLongBigList(this.length, this.l, this.upperBits, this.selectUpper, byteOrder == ByteOrder.LITTLE_ENDIAN), (CharSequence)(basename + ".object"));
        FileChannel fileChannel = FileChannel.open(new File(basename + ".lowerbits").toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024);
        byteBuffer.order(byteOrder);
        long[][] lArray = this.lowerBits;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[] s;
            for (long l : s = lArray[i]) {
                byteBuffer.putLong(l);
                if (byteBuffer.hasRemaining()) continue;
                byteBuffer.flip();
                fileChannel.write(byteBuffer);
                byteBuffer.clear();
            }
        }
        byteBuffer.flip();
        fileChannel.write(byteBuffer);
        fileChannel.close();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.upperBits = this.selectUpper.bitVector().bigBits();
        if (this.lowerBits.length == 0) {
            this.lowerBits = LongBigArrays.newBigArray((long)1L);
        }
    }

    public class EliasFanoMonotoneLongBigListIterator
    implements LongBigListIterator {
        protected long index;
        protected long word;
        protected long window;
        protected long lowerBitsPosition;

        protected EliasFanoMonotoneLongBigListIterator(long from) {
            this.index = from;
            long position = EliasFanoMonotoneBigLongBigList.this.selectUpper.select(from);
            this.word = LongBigArrayBitVector.word((long)position);
            this.window = BigArrays.get((long[][])EliasFanoMonotoneBigLongBigList.this.upperBits, (long)this.word) & -1L << (int)position;
            this.lowerBitsPosition = this.index * (long)EliasFanoMonotoneBigLongBigList.this.l;
        }

        private long getNextUpperBits() {
            while (this.window == 0L) {
                this.window = BigArrays.get((long[][])EliasFanoMonotoneBigLongBigList.this.upperBits, (long)(++this.word));
            }
            long upperBits = LongBigArrayBitVector.bits((long)this.word) + (long)Long.numberOfTrailingZeros(this.window) - this.index++;
            this.window &= this.window - 1L;
            return upperBits;
        }

        public long previousIndex() {
            return this.index - 1L;
        }

        public long nextIndex() {
            return this.index;
        }

        public boolean hasPrevious() {
            return this.index > 0L;
        }

        public boolean hasNext() {
            return this.index < EliasFanoMonotoneBigLongBigList.this.length;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextLongUnsafe();
        }

        public long nextLongUnsafe() {
            int l = EliasFanoMonotoneBigLongBigList.this.l;
            long startWord = LongBigArrayBitVector.word((long)this.lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            long lower = BigArrays.get((long[][])EliasFanoMonotoneBigLongBigList.this.lowerBits, (long)startWord) >>> startBit;
            if (startBit + l > 64) {
                lower |= BigArrays.get((long[][])EliasFanoMonotoneBigLongBigList.this.lowerBits, (long)(startWord + 1L)) << -startBit;
            }
            this.lowerBitsPosition += (long)l;
            return this.getNextUpperBits() << l | lower & EliasFanoMonotoneBigLongBigList.this.lowerBitsMask;
        }

        public long previousLong() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.previousLongUnsafe();
        }

        public long previousLongUnsafe() {
            int l = EliasFanoMonotoneBigLongBigList.this.l;
            --this.index;
            long position = EliasFanoMonotoneBigLongBigList.this.selectUpper.select(this.index);
            this.word = LongBigArrayBitVector.word((long)position);
            this.window = BigArrays.get((long[][])EliasFanoMonotoneBigLongBigList.this.upperBits, (long)this.word) & -1L << (int)position;
            this.lowerBitsPosition = this.index * (long)l;
            long startWord = LongBigArrayBitVector.word((long)this.lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            long lower = BigArrays.get((long[][])EliasFanoMonotoneBigLongBigList.this.lowerBits, (long)startWord) >>> startBit;
            if (startBit + l > 64) {
                lower |= BigArrays.get((long[][])EliasFanoMonotoneBigLongBigList.this.lowerBits, (long)(startWord + 1L)) << -startBit;
            }
            return position - this.index << l | lower & EliasFanoMonotoneBigLongBigList.this.lowerBitsMask;
        }
    }
}

