/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;

public class IncrementalImmutableSequentialGraph
extends ImmutableSequentialGraph {
    public static long[][] END_OF_GRAPH = new long[0][0];
    private long n = -1L;
    private final ArrayBlockingQueue<long[][]> successorQueue = new ArrayBlockingQueue(100);

    @Override
    public long numNodes() {
        if (this.n == -1L) {
            throw new UnsupportedOperationException("The number of nodes is unknown (you need to complete a traversal)");
        }
        return this.n;
    }

    @Override
    public NodeIterator nodeIterator() {
        if (this.n != -1L) {
            throw new IllegalStateException();
        }
        return new NodeIterator(){
            long i = 0L;
            private long[][] currentSuccessor;
            private long[][] nextSuccessor;

            public boolean hasNext() {
                boolean end;
                if (this.nextSuccessor == END_OF_GRAPH) {
                    return false;
                }
                if (this.nextSuccessor != null) {
                    return true;
                }
                try {
                    this.nextSuccessor = (long[][])IncrementalImmutableSequentialGraph.this.successorQueue.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                boolean bl = end = this.nextSuccessor == END_OF_GRAPH;
                if (end) {
                    IncrementalImmutableSequentialGraph.this.n = this.i;
                }
                return !end;
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.currentSuccessor = this.nextSuccessor;
                this.nextSuccessor = null;
                return this.i++;
            }

            @Override
            public long outdegree() {
                if (this.currentSuccessor == null) {
                    throw new IllegalStateException();
                }
                return LongBigArrays.length((long[][])this.currentSuccessor);
            }

            @Override
            public long[][] successorBigArray() {
                if (this.currentSuccessor == null) {
                    throw new IllegalStateException();
                }
                return this.currentSuccessor;
            }
        };
    }

    public void add(long[][] successor, long offset, long length) throws InterruptedException {
        this.successorQueue.put(LongBigArrays.copy((long[][])successor, (long)offset, (long)length));
    }

    public void add(long[][] successor) throws InterruptedException {
        this.successorQueue.put(successor);
    }

    public void add(long[] successor, int offset, int length) throws InterruptedException {
        this.add(LongBigArrays.wrap((long[])successor), (long)offset, (long)length);
    }

    public void add(long[] successor) throws InterruptedException {
        this.add(LongBigArrays.wrap((long[])successor));
    }
}

