/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.LazyIntIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;

public class LazyIntIterators {
    public static final LazyIntIterator EMPTY_ITERATOR = new LazyIntIterator(){

        @Override
        public int nextInt() {
            return -1;
        }

        @Override
        public int skip(int n) {
            return 0;
        }
    };

    protected LazyIntIterators() {
    }

    public static int unwrap(LazyIntIterator lazyIntIterator, int[] array) {
        int t;
        int j;
        int l = array.length;
        for (j = 0; j < l && (t = lazyIntIterator.nextInt()) != -1; ++j) {
            array[j] = t;
        }
        return j;
    }

    public static int unwrap(LazyIntIterator lazyIntIterator, int[] array, int offset, int length) {
        int t;
        int j;
        int l = Math.min(length, array.length - offset);
        for (j = 0; j < l && (t = lazyIntIterator.nextInt()) != -1; ++j) {
            array[offset + j] = t;
        }
        return j;
    }

    public static int[] unwrap(LazyIntIterator lazyIntIterator) {
        int t;
        int[] array = new int[16];
        int j = 0;
        while ((t = lazyIntIterator.nextInt()) != -1) {
            if (j == array.length) {
                array = IntArrays.grow((int[])array, (int)(j + 1));
            }
            array[j++] = t;
        }
        return IntArrays.trim((int[])array, (int)j);
    }

    public static int[] unwrapLoosely(LazyIntIterator lazyIntIterator) {
        int t;
        int[] array = new int[16];
        int j = 0;
        while ((t = lazyIntIterator.nextInt()) != -1) {
            if (j == array.length) {
                array = IntArrays.grow((int[])array, (int)(j + 1));
            }
            array[j++] = t;
        }
        return array;
    }

    public static LazyIntIterator wrap(int[] array, int length) {
        if (length == 0) {
            return EMPTY_ITERATOR;
        }
        return new ArrayLazyIntIterator(array, length);
    }

    public static LazyIntIterator wrap(LazyLongIterator iterator) {
        return new LazyLongIteratorLazyIntIterator(iterator);
    }

    public static LazyIntIterator wrap(int[] array) {
        return LazyIntIterators.wrap(array, array.length);
    }

    public static IntIterator eager(LazyIntIterator lazyIntIterator) {
        return new LazyToEagerIntIterator(lazyIntIterator);
    }

    public static LazyIntIterator lazy(IntIterator eagerIntIterator) {
        return new EagerToLazyIntIterator(eagerIntIterator);
    }

    private static final class EagerToLazyIntIterator
    implements LazyIntIterator {
        private final IntIterator underlying;

        public EagerToLazyIntIterator(IntIterator underlying) {
            this.underlying = underlying;
        }

        @Override
        public int nextInt() {
            return this.underlying.hasNext() ? this.underlying.nextInt() : -1;
        }

        @Override
        public int skip(int n) {
            return this.underlying.skip(n);
        }
    }

    private static final class LazyToEagerIntIterator
    implements IntIterator {
        private final LazyIntIterator lazyIntIterator;
        private boolean advanced;
        private int next;

        public LazyToEagerIntIterator(LazyIntIterator lazyIntIterator) {
            this.lazyIntIterator = lazyIntIterator;
        }

        public boolean hasNext() {
            if (!this.advanced) {
                this.advanced = true;
                this.next = this.lazyIntIterator.nextInt();
            }
            return this.next != -1;
        }

        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.advanced = false;
            return this.next;
        }

        public int skip(int n) {
            if (n == 0) {
                return 0;
            }
            int increment = this.advanced ? 1 : 0;
            this.advanced = false;
            return this.lazyIntIterator.skip(n - increment) + increment;
        }
    }

    private static final class LazyLongIteratorLazyIntIterator
    implements LazyIntIterator {
        LazyLongIterator iterator;

        private LazyLongIteratorLazyIntIterator(LazyLongIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public int nextInt() {
            return (int)this.iterator.nextLong();
        }

        @Override
        public int skip(int n) {
            return (int)this.iterator.skip(n);
        }
    }

    private static final class ArrayLazyIntIterator
    implements LazyIntIterator {
        private final int[] a;
        private final int length;
        private int pos;

        public ArrayLazyIntIterator(int[] a, int length) {
            this.a = a;
            this.length = length;
        }

        @Override
        public int nextInt() {
            if (this.pos == this.length) {
                return -1;
            }
            return this.a[this.pos++];
        }

        @Override
        public int skip(int n) {
            int toSkip = Math.min(n, this.length - this.pos);
            this.pos += toSkip;
            return toSkip;
        }
    }
}

