/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.big.webgraph.GraphClassParser;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.TextIO;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;

public class Stats {
    private Stats() {
    }

    public static void run(ImmutableGraph graph, LongArrayBitVector buckets, long[][] sccsize, CharSequence resultsBasename, ProgressLogger pl) throws IOException {
        Stats.run(graph, buckets, sccsize, resultsBasename, false, pl);
    }

    public static void run(ImmutableGraph graph, LongArrayBitVector buckets, long[][] sccsize, CharSequence resultsBasename, boolean saveDegrees, ProgressLogger pl) throws IOException {
        long d;
        NodeIterator nodeIterator = graph.nodeIterator();
        long[] count = LongArrays.EMPTY_ARRAY;
        long[][] indegree = LongBigArrays.newBigArray((long)graph.numNodes());
        long maxd = 0L;
        long maxNode = 0L;
        long mind = Long.MAX_VALUE;
        long minNode = 0L;
        long dangling = 0L;
        long terminal = 0L;
        long loops = 0L;
        long numArcs = 0L;
        long numGaps = 0L;
        BigInteger totLoc = BigInteger.ZERO;
        BigInteger totGap = BigInteger.ZERO;
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = graph.numNodes();
            pl.start((CharSequence)"Scanning...");
        }
        PrintWriter outdegreesPrintWriter = saveDegrees ? new PrintWriter(new BufferedWriter(new FileWriter(resultsBasename + ".outdegrees"))) : null;
        long[] successorDeltaStats = new long[64];
        long i = graph.numNodes();
        while (i-- != 0L) {
            long curr = nodeIterator.nextLong();
            d = nodeIterator.outdegree();
            if (d > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("The current implementation of " + Stats.class.getSimpleName() + " cannot handle outdegrees beyond 2^31.");
            }
            if (saveDegrees) {
                outdegreesPrintWriter.println(d);
            }
            long[][] successor = nodeIterator.successorBigArray();
            if (d > 1L) {
                totGap = totGap.add(BigInteger.valueOf(LongBigArrays.get((long[][])successor, (long)(d - 1L)) - LongBigArrays.get((long[][])successor, (long)0L)));
                totGap = totGap.add(BigInteger.valueOf(Fast.int2nat((long)(LongBigArrays.get((long[][])successor, (long)0L) - curr))));
                numGaps += d;
            }
            long s = d;
            while (s-- != 0L) {
                totLoc = totLoc.add(BigInteger.valueOf(Math.abs(LongBigArrays.get((long[][])successor, (long)s) - curr)));
                if (LongBigArrays.get((long[][])successor, (long)s) != curr) {
                    int n = Fast.mostSignificantBit((long)Math.abs(curr - LongBigArrays.get((long[][])successor, (long)s)));
                    successorDeltaStats[n] = successorDeltaStats[n] + 1L;
                } else {
                    ++loops;
                }
                LongBigArrays.incr((long[][])indegree, (long)LongBigArrays.get((long[][])successor, (long)s));
            }
            if (d == 0L) {
                ++dangling;
                ++terminal;
            }
            if (d == 1L && LongBigArrays.get((long[][])successor, (long)0L) == curr) {
                ++terminal;
            }
            if (d < mind) {
                mind = d;
                minNode = curr;
            }
            if (d > maxd) {
                maxd = d;
                maxNode = curr;
            }
            numArcs += d;
            if (d >= (long)count.length) {
                count = LongArrays.grow((long[])count, (int)((int)d + 1));
            }
            int n = (int)d;
            count[n] = count[n] + 1L;
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (pl != null) {
            pl.done();
        }
        if (saveDegrees) {
            outdegreesPrintWriter.close();
            TextIO.storeLongs((long[][])indegree, (CharSequence)(resultsBasename + ".indegrees"));
        }
        PrintWriter properties = new PrintWriter(new FileWriter(resultsBasename + ".stats"));
        properties.println("nodes=" + graph.numNodes());
        properties.println("arcs=" + numArcs);
        properties.println("loops=" + loops);
        properties.println("successoravggap=" + new BigDecimal(totGap).divide(BigDecimal.valueOf(Math.max(1L, numGaps)), 3, RoundingMode.HALF_EVEN));
        properties.println("avglocality=" + new BigDecimal(totLoc).divide(BigDecimal.valueOf(Math.max(1L, numArcs)), 3, RoundingMode.HALF_EVEN));
        properties.println("minoutdegree=" + mind);
        properties.println("maxoutdegree=" + maxd);
        properties.println("minoutdegreenode=" + minNode);
        properties.println("maxoutdegreenode=" + maxNode);
        properties.println("dangling=" + dangling);
        properties.println("terminal=" + terminal);
        properties.println("percdangling=" + 100.0 * (double)dangling / (double)graph.numNodes());
        properties.println("avgoutdegree=" + (double)numArcs / (double)graph.numNodes());
        int l = successorDeltaStats.length;
        while (l-- != 0 && successorDeltaStats[l] == 0L) {
        }
        StringBuilder s = new StringBuilder();
        double totLogDelta = 0.0;
        long numDelta = 0L;
        long g = 1L;
        for (int i2 = 0; i2 <= l; ++i2) {
            if (i2 != 0) {
                s.append(',');
            }
            s.append(successorDeltaStats[i2]);
            numDelta += successorDeltaStats[i2];
            totLogDelta += (Fast.log2((double)(g * 2L + g + 1L)) - 1.0) * (double)successorDeltaStats[i2];
            g *= 2L;
        }
        properties.println("successorlogdeltastats=" + s.toString());
        properties.println("successoravglogdelta=" + (numDelta == 0L ? "0" : new BigDecimal(totLogDelta).divide(BigDecimal.valueOf(Math.max(1L, numDelta * 2L)), 3, RoundingMode.HALF_EVEN).toString()));
        TextIO.storeLongs((long[])count, (int)0, (int)((int)(maxd + 1L)), (CharSequence)(resultsBasename + ".outdegree"));
        Arrays.fill(count, 0L);
        minNode = 0L;
        maxNode = 0L;
        maxd = 0L;
        mind = Long.MAX_VALUE;
        long n = graph.numNodes();
        int i3 = indegree.length;
        while (i3-- != 0) {
            long[] t = indegree[i3];
            int p = t.length;
            while (p-- != 0) {
                --n;
                d = t[p];
                if (d > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("The current implementation of " + Stats.class.getSimpleName() + " cannot handle indegrees beyond 2^31.");
                }
                if (d >= (long)count.length) {
                    count = LongArrays.grow((long[])count, (int)((int)(d + 1L)));
                }
                if (d < mind) {
                    mind = d;
                    minNode = n;
                }
                if (d > maxd) {
                    maxd = d;
                    maxNode = n;
                }
                int n2 = (int)d;
                count[n2] = count[n2] + 1L;
            }
        }
        TextIO.storeLongs((long[])count, (int)0, (int)((int)(maxd + 1L)), (CharSequence)(resultsBasename + ".indegree"));
        properties.println("minindegree=" + mind);
        properties.println("maxindegree=" + maxd);
        properties.println("minindegreenode=" + minNode);
        properties.println("maxindegreenode=" + maxNode);
        properties.println("avgindegree=" + (double)numArcs / (double)graph.numNodes());
        if (buckets != null) {
            long numBuckets = buckets.count();
            properties.println("buckets=" + numBuckets);
            properties.println("percbuckets=" + 100.0 * (double)numBuckets / (double)graph.numNodes());
        }
        if (sccsize != null) {
            LongBigArrays.quickSort((long[][])sccsize);
            long m = LongBigArrays.length((long[][])sccsize);
            long maxSize = LongBigArrays.get((long[][])sccsize, (long)(m - 1L));
            long minSize = LongBigArrays.get((long[][])sccsize, (long)0L);
            properties.println("sccs=" + m);
            properties.println("maxsccsize=" + maxSize);
            properties.println("percmaxscc=" + 100.0 * (double)maxSize / (double)graph.numNodes());
            properties.println("minsccsize=" + minSize);
            properties.println("percminscc=" + 100.0 * (double)minSize / (double)graph.numNodes());
            PrintWriter pw = new PrintWriter(resultsBasename + ".sccdistr");
            long current = maxSize;
            int c = 0;
            int i4 = sccsize.length;
            while (i4-- != 0) {
                long[] t = sccsize[i4];
                int j = t.length;
                while (j-- != 0) {
                    if (t[j] != current) {
                        pw.println(current + "\t" + c);
                        current = t[j];
                        c = 0;
                    }
                    ++c;
                }
            }
            pw.println(current + "\t" + c);
            pw.flush();
            pw.close();
        }
        properties.close();
    }

    public static void main(String[] arg) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, JSAPException, IOException, ClassNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(Stats.class.getName(), "Computes statistical data of a given graph.", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("saveDegrees", 's', "save-degrees", "Save indegrees and outdegrees in text format."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("resultsBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the resulting files.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        Class graphClass = jsapResult.getClass("graphClass");
        String basename = jsapResult.getString("basename");
        String resultsBasename = jsapResult.userSpecified("resultsBasename") ? jsapResult.getString("resultsBasename") : basename;
        ProgressLogger pl = new ProgressLogger();
        pl.logInterval = jsapResult.getLong("logInterval");
        ImmutableGraph graph = graphClass != null ? (ImmutableGraph)graphClass.getMethod("loadOffline", CharSequence.class).invoke(null, basename) : ImmutableGraph.loadOffline(basename, pl);
        LongArrayBitVector buckets = (LongArrayBitVector)(new File(basename + ".buckets").exists() ? BinIO.loadObject((CharSequence)(basename + ".buckets")) : null);
        long[][] sccsize = new File(basename + ".sccsizes").exists() ? BinIO.loadLongsBig((CharSequence)(basename + ".sccsizes")) : (long[][])null;
        Stats.run(graph, buckets, sccsize, resultsBasename, jsapResult.getBoolean("saveDegrees"), pl);
    }
}

