/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterators;
import it.unimi.dsi.big.webgraph.MergedLongIterator;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.big.webgraph.Transform;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionImmutableGraph
extends ImmutableGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transform.class);
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private final ImmutableGraph g0;
    private final ImmutableGraph g1;
    private final long n0;
    private final long n1;
    private final long numNodes;
    private final long cachedNode = -1L;
    private long outdegree;
    private long[][] cache = LongBigArrays.EMPTY_BIG_ARRAY;

    public UnionImmutableGraph(ImmutableGraph g0, ImmutableGraph g1) {
        this.g0 = g0;
        this.g1 = g1;
        this.n0 = g0.numNodes();
        this.n1 = g1.numNodes();
        this.numNodes = Math.max(this.n0, this.n1);
    }

    @Override
    public UnionImmutableGraph copy() {
        return new UnionImmutableGraph(this.g0.copy(), this.g1.copy());
    }

    @Override
    public NodeIterator nodeIterator(final long from) {
        return new NodeIterator(){
            private long[][] cache = LongBigArrays.EMPTY_BIG_ARRAY;
            private long outdegree = -1L;
            private NodeIterator i0 = from < UnionImmutableGraph.access$000(UnionImmutableGraph.this) ? UnionImmutableGraph.access$100(UnionImmutableGraph.this).nodeIterator(from) : null;
            private NodeIterator i1 = from < UnionImmutableGraph.access$200(UnionImmutableGraph.this) ? UnionImmutableGraph.access$300(UnionImmutableGraph.this).nodeIterator(from) : null;

            public boolean hasNext() {
                return this.i0 != null && this.i0.hasNext() || this.i1 != null && this.i1.hasNext();
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.outdegree = -1L;
                long result = -1L;
                if (this.i0 != null) {
                    if (this.i0.hasNext()) {
                        result = this.i0.nextLong();
                    } else {
                        this.i0 = null;
                    }
                }
                if (this.i1 != null) {
                    if (this.i1.hasNext()) {
                        result = this.i1.nextLong();
                    } else {
                        this.i1 = null;
                    }
                }
                return result;
            }

            @Override
            public long[][] successorBigArray() {
                long t;
                if (this.outdegree != -1L) {
                    return this.cache;
                }
                if (this.i0 == null) {
                    this.outdegree = this.i1.outdegree();
                    this.cache = this.i1.successorBigArray();
                    return this.cache;
                }
                if (this.i1 == null) {
                    this.outdegree = this.i0.outdegree();
                    this.cache = this.i0.successorBigArray();
                    return this.cache;
                }
                MergedLongIterator merge = new MergedLongIterator(this.i0.successors(), this.i1.successors());
                this.outdegree = LazyLongIterators.unwrap((LazyLongIterator)merge, this.cache);
                while ((t = merge.nextLong()) != -1L) {
                    long upto = LongBigArrays.length((long[][])this.cache);
                    this.cache = LongBigArrays.grow((long[][])this.cache, (long)(upto + 1L));
                    LongBigArrays.set((long[][])this.cache, (long)upto++, (long)t);
                    ++this.outdegree;
                    this.outdegree += LazyLongIterators.unwrap((LazyLongIterator)merge, this.cache, upto, LongBigArrays.length((long[][])this.cache) - upto);
                }
                return this.cache;
            }

            @Override
            public long outdegree() {
                this.successorBigArray();
                return this.outdegree;
            }
        };
    }

    @Override
    public long numNodes() {
        return this.numNodes;
    }

    @Override
    public boolean randomAccess() {
        return this.g0.randomAccess() && this.g1.randomAccess();
    }

    @Override
    public long[][] successorBigArray(long x) {
        long t;
        if (x == -1L) {
            return this.cache;
        }
        MergedLongIterator merge = new MergedLongIterator(x < this.n0 ? this.g0.successors(x) : LazyLongIterators.EMPTY_ITERATOR, x < this.n1 ? this.g1.successors(x) : LazyLongIterators.EMPTY_ITERATOR);
        this.outdegree = LazyLongIterators.unwrap((LazyLongIterator)merge, this.cache);
        while ((t = merge.nextLong()) != -1L) {
            long upto = LongBigArrays.length((long[][])this.cache);
            this.cache = LongBigArrays.grow((long[][])this.cache, (long)(upto + 1L));
            LongBigArrays.set((long[][])this.cache, (long)upto++, (long)t);
            ++this.outdegree;
            this.outdegree += LazyLongIterators.unwrap((LazyLongIterator)merge, this.cache, upto, LongBigArrays.length((long[][])this.cache) - upto);
        }
        return this.cache;
    }

    @Override
    public long outdegree(long x) {
        this.successorBigArray(x);
        return this.outdegree;
    }

    static /* synthetic */ long access$000(UnionImmutableGraph x0) {
        return x0.n0;
    }

    static /* synthetic */ ImmutableGraph access$100(UnionImmutableGraph x0) {
        return x0.g0;
    }

    static /* synthetic */ long access$200(UnionImmutableGraph x0) {
        return x0.n1;
    }

    static /* synthetic */ ImmutableGraph access$300(UnionImmutableGraph x0) {
        return x0.g1;
    }
}

