/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.UnionImmutableGraph;
import it.unimi.dsi.big.webgraph.algo.ParallelBreadthFirstVisit;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedComponents {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectedComponents.class);
    public final long numberOfComponents;
    public final long[][] component;

    protected ConnectedComponents(long numberOfComponents, long[][] component) {
        this.numberOfComponents = numberOfComponents;
        this.component = component;
    }

    public static ConnectedComponents compute(ImmutableGraph symGraph, int threads, ProgressLogger pl) {
        ParallelBreadthFirstVisit visit = new ParallelBreadthFirstVisit(symGraph, threads, false, pl);
        visit.visitAll();
        AtomicLongArray[] visited = visit.marker;
        long numberOfComponents = visit.round + 1L;
        visit = null;
        long[][] component = LongBigArrays.newBigArray((long)symGraph.numNodes());
        int i = component.length;
        while (i-- != 0) {
            long[] t = component[i];
            int j = t.length;
            while (j-- != 0) {
                t[j] = visited[i].get(j);
            }
        }
        return new ConnectedComponents(numberOfComponents, component);
    }

    public long[][] computeSizes() {
        long[][] size = LongBigArrays.newBigArray((long)this.numberOfComponents);
        int i = this.component.length;
        while (i-- != 0) {
            long[] t = this.component[i];
            int d = t.length;
            while (d-- != 0) {
                LongBigArrays.incr((long[][])size, (long)t[d]);
            }
        }
        return size;
    }

    public void sortBySize(long[][] size) {
        long[] t;
        long[][] perm = Util.identity((long)LongBigArrays.length((long[][])size));
        LongBigArrays.quickSort((long[][])perm, (long)0L, (long)LongBigArrays.length((long[][])perm), (x, y) -> {
            long t = LongBigArrays.get((long[][])size, (long)y) - LongBigArrays.get((long[][])size, (long)x);
            return t == 0L ? 0 : (t < 0L ? -1 : 1);
        });
        long[][] copy = LongBigArrays.copy((long[][])size);
        int i = size.length;
        while (i-- != 0) {
            t = size[i];
            long[] u = perm[i];
            int d = t.length;
            while (d-- != 0) {
                t[d] = LongBigArrays.get((long[][])copy, (long)u[d]);
            }
        }
        Util.invertPermutationInPlace((long[][])perm);
        i = this.component.length;
        while (i-- != 0) {
            t = this.component[i];
            int d = t.length;
            while (d-- != 0) {
                t[d] = LongBigArrays.get((long[][])perm, (long)t[d]);
            }
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(ConnectedComponents.class.getName(), "Computes the connected components of a symmetric graph of given basename. The resulting data is saved in files stemmed from the given basename with extension .wcc (a list of binary integers specifying the component of each node) and .wccsizes (a list of binary integer specifying the size of each component). The symmetric graph can also be specified using a generic (non-symmetric) graph and its transpose.", new Parameter[]{new Switch("sizes", 's', "sizes", "Compute component sizes."), new Switch("renumber", 'r', "renumber", "Renumber components in decreasing-size order."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("mapped", 'm', "mapped", "Do not load the graph in main memory, but rather memory-map it."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 'T', "threads", "The number of threads to be used. If 0, the number will be estimated automatically."), new FlaggedOption("basenamet", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 't', "transpose", "The basename of the transpose, in case the graph is not symmetric."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of a symmetric graph (or of a generic graph, if the transpose is provided, too)."), new UnflaggedOption("resultsBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the resulting files.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String basename = jsapResult.getString("basename");
        String basenamet = jsapResult.getString("basenamet");
        String resultsBasename = jsapResult.getString("resultsBasename", basename);
        int threads = jsapResult.getInt("threads");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        ImmutableGraph immutableGraph = graph = jsapResult.userSpecified("mapped") ? ImmutableGraph.loadMapped(basename) : ImmutableGraph.load(basename, pl);
        ImmutableGraph grapht = basenamet == null ? null : (jsapResult.userSpecified("mapped") ? ImmutableGraph.loadMapped(basenamet) : ImmutableGraph.load(basenamet, pl));
        ConnectedComponents components = ConnectedComponents.compute(basenamet != null ? new UnionImmutableGraph(graph, grapht) : graph, threads, pl);
        if (jsapResult.getBoolean("sizes") || jsapResult.getBoolean("renumber")) {
            long[][] size = components.computeSizes();
            if (jsapResult.getBoolean("renumber")) {
                components.sortBySize(size);
            }
            if (jsapResult.getBoolean("sizes")) {
                BinIO.storeLongs((long[][])size, (CharSequence)(resultsBasename + ".wccsizes"));
            }
        }
        BinIO.storeLongs((long[][])components.component, (CharSequence)(resultsBasename + ".wcc"));
    }
}

