/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.webgraph.GraphClassParser;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.big.webgraph.algo.EliasFanoCumulativeOutdegreeList;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatBigArrays;
import it.unimi.dsi.fastutil.ints.Int2DoubleFunction;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.io.SafelyCloseable;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.util.HyperLogLogCounterArray;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperBall
extends HyperLogLogCounterArray
implements SafelyCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HyperBall.class);
    public static final boolean ASSERTS = false;
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_GRANULARITY = 16384;
    public static final int DEFAULT_BUFFER_SIZE = 0x400000;
    protected final boolean gotTranspose;
    protected boolean systolic;
    protected boolean preLocal;
    protected boolean local;
    protected final boolean doSumOfDistances;
    protected boolean doSumOfInverseDistances;
    public final DoubleArrayList neighbourhoodFunction;
    public final float[][] sumOfDistances;
    public final float[][] sumOfInverseDistances;
    public final Int2DoubleFunction[] discountFunction;
    public final float[][][] discountedCentrality;
    protected final long numNodes;
    protected long numArcs;
    protected final double squareNumNodes;
    protected final int numberOfThreads;
    protected final int bufferSize;
    protected final long granularity;
    protected long adaptiveGranularity;
    protected double last;
    protected double current;
    protected int iteration;
    protected final File updateFile;
    protected final FileChannel fileChannel;
    protected RandomAccessFile randomAccessFile;
    protected final EliasFanoCumulativeOutdegreeList cumulativeOutdegrees;
    protected final ProgressLogger pl;
    protected final ReentrantLock lock;
    protected final Condition allWaiting;
    protected final Condition start;
    public int phase;
    protected boolean closed;
    protected final IterationThread[] thread;
    protected final AtomicLong nodes;
    protected final AtomicLong arcs;
    protected volatile int aliveThreads;
    protected volatile boolean completed;
    protected volatile long numberOfWrites;
    protected volatile long totalIoMillis;
    protected long nextNode;
    protected long nextArcs;
    protected final AtomicLong modified;
    protected final AtomicLong unwritten;
    protected double relativeIncrement;
    protected boolean external;
    protected final long[][] resultBits;
    protected final LongBigList[] resultRegisters;
    protected boolean[][] modifiedCounter;
    protected boolean[][] modifiedResultCounter;
    protected boolean[][] nextMustBeChecked;
    protected boolean[][] mustBeChecked;
    protected long[] localCheckList;
    protected final LongSet localNextMustBeChecked;
    protected volatile Throwable threadThrowable;

    protected static final int ensureRegisters(int log2m) {
        if (log2m < 4) {
            throw new IllegalArgumentException("There must be at least 16 registers per counter");
        }
        if (log2m > 60) {
            throw new IllegalArgumentException("There can be at most 2^60 registers per counter");
        }
        return log2m;
    }

    private static final int numberOfThreads(int suggestedNumberOfThreads) {
        if (suggestedNumberOfThreads != 0) {
            return suggestedNumberOfThreads;
        }
        return Runtime.getRuntime().availableProcessors();
    }

    public HyperBall(ImmutableGraph g, ImmutableGraph gt, int log2m, ProgressLogger pl, int numberOfThreads, int bufferSize, int granularity, boolean external) throws IOException {
        this(g, gt, log2m, pl, numberOfThreads, bufferSize, granularity, external, false, false, null, Util.randomSeed());
    }

    public HyperBall(ImmutableGraph g, ImmutableGraph gt, int log2m) throws IOException {
        this(g, gt, log2m, null, 0, 0, 0, false);
    }

    public HyperBall(ImmutableGraph g, ImmutableGraph gt, int log2m, ProgressLogger pl) throws IOException {
        this(g, null, log2m, pl, 0, 0, 0, false);
    }

    public HyperBall(ImmutableGraph g, int log2m) throws IOException {
        this(g, null, log2m);
    }

    public HyperBall(ImmutableGraph g, int log2m, long seed) throws IOException {
        this(g, null, log2m, null, 0, 0, 0, false, false, false, null, seed);
    }

    public HyperBall(ImmutableGraph g, int log2m, ProgressLogger pl) throws IOException {
        this(g, null, log2m, pl);
    }

    public HyperBall(ImmutableGraph g, ImmutableGraph gt, int log2m, ProgressLogger pl, int numberOfThreads, int bufferSize, int granularity, boolean external, boolean doSumOfDistances, boolean doSumOfInverseDistances, Int2DoubleFunction[] discountFunction, long seed) throws IOException {
        super(g.numNodes(), g.numNodes(), HyperBall.ensureRegisters(log2m), seed);
        int i;
        this.info("Seed : " + Long.toHexString(seed));
        this.gotTranspose = gt != null;
        this.localNextMustBeChecked = this.gotTranspose ? LongSets.synchronize((LongSet)new LongOpenHashSet(16, 0.25f)) : null;
        this.numNodes = g.numNodes();
        try {
            this.numArcs = g.numArcs();
        }
        catch (UnsupportedOperationException e) {
            long a = 0L;
            NodeIterator nodeIterator = g.nodeIterator();
            long i2 = g.numNodes();
            while (i2-- != 0L) {
                nodeIterator.nextLong();
                a += nodeIterator.outdegree();
            }
            this.numArcs = a;
        }
        this.squareNumNodes = (double)this.numNodes * (double)this.numNodes;
        this.cumulativeOutdegrees = new EliasFanoCumulativeOutdegreeList(g, this.numArcs, Math.max(0, 64 / this.m - 1));
        this.modifiedCounter = BooleanBigArrays.newBigArray((long)this.numNodes);
        boolean[][] blArray = this.modifiedResultCounter = external ? (boolean[][])null : BooleanBigArrays.newBigArray((long)this.numNodes);
        if (gt != null) {
            this.mustBeChecked = BooleanBigArrays.newBigArray((long)this.numNodes);
            this.nextMustBeChecked = BooleanBigArrays.newBigArray((long)this.numNodes);
            if (gt.numNodes() != g.numNodes()) {
                throw new IllegalArgumentException("The graph and its transpose have a different number of nodes");
            }
            if (gt.numArcs() != g.numArcs()) {
                throw new IllegalArgumentException("The graph and its transpose have a different number of arcs");
            }
        }
        this.pl = pl;
        this.external = external;
        this.doSumOfDistances = doSumOfDistances;
        this.doSumOfInverseDistances = doSumOfInverseDistances;
        this.discountFunction = discountFunction == null ? new Int2DoubleFunction[]{} : discountFunction;
        this.numberOfThreads = HyperBall.numberOfThreads(numberOfThreads);
        this.granularity = numberOfThreads == 1 ? this.numNodes : (granularity == 0 ? 16384L : (long)(granularity + 64 - 1 & 0xFFFFFFC0));
        this.bufferSize = Math.max(1, (bufferSize == 0 ? 0x400000 : bufferSize) / (8 * (this.counterLongwords + 1)));
        this.info("Relative standard deviation: " + Util.format((double)(100.0 * HyperLogLogCounterArray.relativeStandardDeviation((int)log2m))) + "% (" + this.m + " registers/counter, " + this.registerSize + " bits/register, " + Util.format((double)((double)(this.m * this.registerSize) / 8.0)) + " bytes/counter)");
        if (external) {
            this.info("Running " + this.numberOfThreads + " threads with a buffer of " + Util.formatSize((long)this.bufferSize) + " counters");
        } else {
            this.info("Running " + this.numberOfThreads + " threads");
        }
        this.thread = new IterationThread[this.numberOfThreads];
        if (external) {
            this.info("Creating update list...");
            this.updateFile = File.createTempFile(HyperBall.class.getName(), "-temp");
            this.updateFile.deleteOnExit();
            this.randomAccessFile = new RandomAccessFile(this.updateFile, "rw");
            this.fileChannel = this.randomAccessFile.getChannel();
        } else {
            this.updateFile = null;
            this.fileChannel = null;
        }
        this.nodes = new AtomicLong();
        this.arcs = new AtomicLong();
        this.modified = new AtomicLong();
        this.unwritten = new AtomicLong();
        this.neighbourhoodFunction = new DoubleArrayList();
        this.sumOfDistances = doSumOfDistances ? FloatBigArrays.newBigArray((long)this.numNodes) : (float[][])null;
        this.sumOfInverseDistances = doSumOfInverseDistances ? FloatBigArrays.newBigArray((long)this.numNodes) : (float[][])null;
        this.discountedCentrality = new float[this.discountFunction.length][][];
        for (i = 0; i < this.discountFunction.length; ++i) {
            this.discountedCentrality[i] = FloatBigArrays.newBigArray((long)this.numNodes);
        }
        this.info("HyperBall memory usage: " + Util.formatSize2((long)this.usedMemory()) + " [not counting graph(s)]");
        if (!external) {
            this.info("Allocating result bit vectors...");
            this.resultBits = new long[this.bits.length][];
            this.resultRegisters = new LongBigList[this.bits.length];
            i = this.bits.length;
            while (i-- != 0) {
                this.resultBits[i] = new long[this.bits[i].length];
                this.resultRegisters[i] = LongArrayBitVector.wrap((long[])this.resultBits[i]).asLongBigList(this.registerSize);
            }
        } else {
            this.resultBits = null;
            this.resultRegisters = null;
        }
        this.lock = new ReentrantLock();
        this.allWaiting = this.lock.newCondition();
        this.start = this.lock.newCondition();
        this.aliveThreads = this.numberOfThreads;
        if (this.numberOfThreads == 1) {
            this.thread[0] = new IterationThread(g, gt, 0);
            this.thread[0].start();
        } else {
            for (i = 0; i < this.numberOfThreads; ++i) {
                this.thread[i] = new IterationThread(g.copy(), gt != null ? gt.copy() : null, i);
                this.thread[i].start();
            }
        }
        this.lock.lock();
        try {
            while (this.aliveThreads != 0) {
                this.allWaiting.await();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void info(String s) {
        if (this.pl != null) {
            this.pl.logger().info(s);
        }
    }

    private long usedMemory() {
        long bytes = 0L;
        for (long[] a : this.bits) {
            bytes += (long)a.length * 8L;
        }
        if (!this.external) {
            bytes *= 2L;
        }
        if (this.sumOfDistances != null) {
            bytes += (long)this.sumOfDistances.length * 4L;
        }
        if (this.sumOfInverseDistances != null) {
            bytes += (long)this.sumOfInverseDistances.length * 4L;
        }
        int i = this.discountFunction.length;
        while (i-- != 0) {
            bytes += (long)this.discountedCentrality[i].length * 4L;
        }
        if (this.modifiedCounter != null) {
            bytes += (long)this.modifiedCounter.length;
        }
        if (this.modifiedResultCounter != null) {
            bytes += (long)this.modifiedResultCounter.length;
        }
        if (this.nextMustBeChecked != null) {
            bytes += (long)this.nextMustBeChecked.length;
        }
        if (this.mustBeChecked != null) {
            bytes += (long)this.mustBeChecked.length;
        }
        return bytes;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("This " + HyperBall.class.getSimpleName() + " has been closed.");
        }
    }

    public void init() {
        this.init(this.seed);
    }

    public void init(long seed) {
        this.ensureOpen();
        this.info("Clearing all registers...");
        this.clear(seed);
        long i = this.numNodes;
        while (i-- != 0L) {
            this.add(i, i);
        }
        this.iteration = -1;
        this.preLocal = false;
        this.local = false;
        this.systolic = false;
        this.completed = false;
        if (!this.external) {
            for (long[] a : this.resultBits) {
                Arrays.fill(a, 0L);
            }
        }
        if (this.sumOfDistances != null) {
            FloatBigArrays.fill((float[][])this.sumOfDistances, (float)0.0f);
        }
        if (this.sumOfInverseDistances != null) {
            FloatBigArrays.fill((float[][])this.sumOfInverseDistances, (float)0.0f);
        }
        for (int i2 = 0; i2 < this.discountFunction.length; ++i2) {
            FloatBigArrays.fill((float[][])this.discountedCentrality[i2], (float)0.0f);
        }
        this.last = this.numNodes;
        this.neighbourhoodFunction.add(this.last);
        BooleanBigArrays.fill((boolean[][])this.modifiedCounter, (boolean)true);
        if (this.pl != null) {
            this.pl.displayFreeMemory = true;
            this.pl.itemsName = "iterates";
            this.pl.start((CharSequence)"Iterating...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.lock.lock();
        try {
            this.completed = true;
            for (IterationThread t : this.thread) {
                t.threadShouldWait = false;
            }
            this.start.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        for (IterationThread t : this.thread) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.external) {
            this.randomAccessFile.close();
            this.fileChannel.close();
            this.updateFile.delete();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                LOGGER.warn("This " + ((Object)((Object)this)).getClass().getName() + " [" + ((Object)((Object)this)).toString() + "] should have been closed.");
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate() throws IOException {
        this.ensureOpen();
        try {
            boolean[][] t;
            ProgressLogger npl;
            ++this.iteration;
            boolean previousWasSystolic = this.systolic;
            boolean previousWasLocal = this.local;
            this.systolic = this.gotTranspose && this.iteration > 0 && this.modified.get() < this.numNodes / 2L;
            this.current = this.systolic ? this.last : 0.0;
            this.local = this.preLocal;
            this.preLocal = this.systolic && (double)this.modified.get() < 0.1 * (double)this.numNodes * (double)this.numNodes / (double)this.numArcs;
            this.info("Starting " + (this.systolic ? "systolic iteration (local: " + this.local + "; pre-local: " + this.preLocal + ")" : "standard " + (this.external ? "external " : "") + "iteration"));
            if (!this.external) {
                if (previousWasLocal) {
                    for (long x : this.localCheckList) {
                        BooleanBigArrays.set((boolean[][])this.modifiedResultCounter, (long)x, (boolean)false);
                    }
                } else {
                    BooleanBigArrays.fill((boolean[][])this.modifiedResultCounter, (boolean)false);
                }
            }
            if (this.local) {
                this.localCheckList = this.localNextMustBeChecked.toLongArray();
                LongArrays.parallelQuickSort((long[])this.localCheckList);
                this.localNextMustBeChecked.clear();
            } else if (this.systolic) {
                BooleanBigArrays.fill((boolean[][])this.nextMustBeChecked, (boolean)false);
                if (!previousWasSystolic) {
                    BooleanBigArrays.fill((boolean[][])this.mustBeChecked, (boolean)true);
                }
            }
            this.adaptiveGranularity = this.granularity;
            if (this.numberOfThreads > 1 && !this.local) {
                if (this.iteration > 0) {
                    this.adaptiveGranularity = (long)Math.min((double)Math.max(1L, this.numNodes / (long)this.numberOfThreads), (double)this.granularity * ((double)this.numNodes / Math.max(1.0, (double)this.modified())));
                    this.adaptiveGranularity = this.adaptiveGranularity + 64L - 1L & 0xFFFFFFFFFFFFFFC0L;
                }
                this.info("Adaptive granularity for this iteration: " + this.adaptiveGranularity);
            }
            this.modified.set(0L);
            this.totalIoMillis = 0L;
            this.numberOfWrites = 0L;
            ProgressLogger progressLogger = npl = this.pl == null ? null : new ProgressLogger(LOGGER, 1L, TimeUnit.MINUTES, "arcs");
            if (npl != null) {
                this.arcs.set(0L);
                npl.expectedUpdates = this.systolic || this.local ? -1L : this.numArcs;
                npl.start((CharSequence)"Scanning graph...");
            }
            this.nodes.set(0L);
            this.nextArcs = 0L;
            this.nextNode = 0L;
            this.unwritten.set(0L);
            if (this.external) {
                this.fileChannel.position(0L);
            }
            this.lock.lock();
            try {
                this.phase = 0;
                this.aliveThreads = this.numberOfThreads;
                IterationThread[] iterationThreadArray = this.thread;
                int n = iterationThreadArray.length;
                for (int x = 0; x < n; ++x) {
                    IterationThread t2 = iterationThreadArray[x];
                    t2.threadShouldWait = false;
                }
                this.start.signalAll();
                while (this.aliveThreads != 0) {
                    this.allWaiting.await(1L, TimeUnit.MINUTES);
                    if (this.threadThrowable != null) {
                        throw new RuntimeException(this.threadThrowable);
                    }
                    int aliveThreads = this.aliveThreads;
                    if (npl == null || aliveThreads == 0) continue;
                    if (this.arcs.longValue() != 0L) {
                        npl.set(this.arcs.longValue());
                    }
                    if (this.external && this.numberOfWrites > 0L) {
                        long time = npl.millis();
                        this.info("Writes: " + this.numberOfWrites + "; per second: " + Util.format((double)(1000.0 * (double)this.numberOfWrites / (double)time)));
                        this.info("I/O time: " + Util.format((double)((double)this.totalIoMillis / 1000.0)) + "s; per write: " + (double)this.totalIoMillis / 1000.0 / (double)this.numberOfWrites + "s");
                    }
                    if (aliveThreads == 0) continue;
                    this.info("Alive threads: " + aliveThreads + " (" + Util.format((double)(100.0 * (double)aliveThreads / (double)this.numberOfThreads)) + "%)");
                }
            }
            finally {
                this.lock.unlock();
            }
            if (npl != null) {
                npl.done(this.arcs.longValue());
                if (!this.external) {
                    this.info("Unwritten counters: " + Util.format((long)this.unwritten.longValue()) + " (" + Util.format((double)(100.0 * (double)this.unwritten.longValue() / (double)this.numNodes)) + "%)");
                }
                this.info("Unmodified counters: " + Util.format((long)(this.numNodes - this.modified.longValue())) + " (" + Util.format((double)(100.0 * (double)(this.numNodes - this.modified.longValue()) / (double)this.numNodes)) + "%)");
            }
            if (this.external) {
                if (npl != null) {
                    npl.itemsName = "counters";
                    npl.start((CharSequence)"Updating counters...");
                }
                this.fileChannel.truncate(this.fileChannel.position());
                this.fileChannel.position(0L);
                if (!this.preLocal) {
                    BooleanBigArrays.fill((boolean[][])this.modifiedCounter, (boolean)false);
                }
                this.lock.lock();
                try {
                    this.phase = 1;
                    this.aliveThreads = this.numberOfThreads;
                    for (IterationThread t2 : this.thread) {
                        t2.threadShouldWait = false;
                    }
                    this.start.signalAll();
                    while (this.aliveThreads != 0) {
                        this.allWaiting.await();
                    }
                    if (this.threadThrowable != null) {
                        throw new RuntimeException(this.threadThrowable);
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (npl != null) {
                    npl.count = this.modified();
                    npl.done();
                }
            } else {
                for (int i = 0; i < this.bits.length; ++i) {
                    if (npl != null) {
                        npl.update((long)this.bits[i].length);
                    }
                    LongBigList r = this.registers[i];
                    this.registers[i] = this.resultRegisters[i];
                    this.resultRegisters[i] = r;
                    long[] b = this.bits[i];
                    this.bits[i] = this.resultBits[i];
                    this.resultBits[i] = b;
                }
                t = this.modifiedCounter;
                this.modifiedCounter = this.modifiedResultCounter;
                this.modifiedResultCounter = t;
            }
            if (this.systolic) {
                t = this.mustBeChecked;
                this.mustBeChecked = this.nextMustBeChecked;
                this.nextMustBeChecked = t;
            }
            this.last = this.current;
            double lastOutput = this.neighbourhoodFunction.getDouble(this.neighbourhoodFunction.size() - 1);
            if (this.current < lastOutput) {
                this.current = lastOutput;
            }
            this.relativeIncrement = this.current / lastOutput;
            if (this.pl != null) {
                this.pl.logger().info("Pairs: " + this.current + " (" + this.current * 100.0 / this.squareNumNodes + "%)");
                this.pl.logger().info("Absolute increment: " + (this.current - lastOutput));
                this.pl.logger().info("Relative increment: " + this.relativeIncrement);
            }
            this.neighbourhoodFunction.add(this.current);
            if (this.pl != null) {
                this.pl.updateAndDisplay();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public long modified() {
        return this.modified.get();
    }

    public void run() throws IOException {
        this.run(Long.MAX_VALUE);
    }

    public void run(long upperBound) throws IOException {
        this.run(upperBound, -1.0);
    }

    public void run(long upperBound, double threshold) throws IOException {
        this.run(upperBound, threshold, this.seed);
    }

    public void run(long upperBound, double threshold, long seed) throws IOException {
        upperBound = Math.min(upperBound, this.numNodes);
        this.init(seed);
        for (long i = 0L; i < upperBound; ++i) {
            this.iterate();
            if (this.modified() == 0L) {
                this.info("Terminating approximation after " + i + " iteration(s) by stabilisation");
                break;
            }
            if (i <= 3L || !(this.relativeIncrement < 1.0 + threshold)) continue;
            this.info("Terminating approximation after " + i + " iteration(s) by relative bound on the neighbourhood function");
            break;
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new NotSerializableException();
    }

    public static void main(String[] arg) throws IOException, JSAPException, IllegalArgumentException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        float d;
        long i;
        DataOutputStream dos;
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(HyperBall.class.getName(), "Runs HyperBall on the given graph, possibly computing positive geometric centralities.\n\nPlease note that to compute negative centralities on directed graphs (which is usually what you want) you have to compute positive centralities on the transpose.", new Parameter[]{new FlaggedOption("log2m", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, true, 'l', "log2m", "The logarithm of the number of registers."), new FlaggedOption("upperBound", (StringParser)JSAP.LONGSIZE_PARSER, Long.toString(Long.MAX_VALUE), false, 'u', "upper-bound", "An upper bound to the number of iterations."), new FlaggedOption("threshold", (StringParser)JSAP.DOUBLE_PARSER, "-1", false, 't', "threshold", "A threshold that will be used to stop the computation by relative increment. If it is -1, the iteration will stop only when all registers do not change their value (recommended)."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 'T', "threads", "The number of threads to be used. If 0, the number will be estimated automatically."), new FlaggedOption("granularity", (StringParser)JSAP.INTSIZE_PARSER, Integer.toString(16384), false, 'g', "granularity", "The number of node per task in a multicore environment."), new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, Util.formatBinarySize((long)0x400000L), false, 'b', "buffer-size", "The size of an I/O buffer in bytes."), new FlaggedOption("neighbourhoodFunction", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'n', "neighbourhood-function", "Store an approximation the neighbourhood function in text format."), new FlaggedOption("sumOfDistances", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'd', "sum-of-distances", "Store an approximation of the sum of distances from each node as a binary list of floats."), new FlaggedOption("harmonicCentrality", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'h', "harmonic-centrality", "Store an approximation of the positive harmonic centrality (the sum of the reciprocals of distances from each node) as a binary list of floats."), new FlaggedOption("discountedGainCentrality", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'z', "discounted-gain-centrality", "A positive discounted gain centrality to be approximated and stored; it is specified as O:F where O is the spec of an object of type Int2DoubleFunction and F is the name of the file where the binary list of floats will be stored. The spec can be either the name of a public field of HyperBall, or a constructor invocation of a class implementing Int2DoubleFunction.").setAllowMultipleDeclarations(true), new FlaggedOption("closenessCentrality", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "closeness-centrality", "Store an approximation of the positive closeness centrality of each node (the reciprocal of sum of the distances from each node) as a binary list of floats. Terminal nodes will have centrality equal to zero."), new FlaggedOption("linCentrality", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'L', "lin-centrality", "Store an approximation of the positive Lin centrality of each node (the reciprocal of sum of the distances from each node multiplied by the square of the number of nodes reachable from the node) as a binary list of floats. Terminal nodes will have centrality equal to one."), new FlaggedOption("nieminenCentrality", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'N', "nieminen-centrality", "Store an approximation of the positive Nieminen centrality of each node (the square of the number of nodes reachable from each node minus the sum of the distances from the node) as a binary list of floats."), new FlaggedOption("reachable", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'r', "reachable", "Store an approximation of the number of nodes reachable from each node as a binary list of floats."), new FlaggedOption("seed", (StringParser)JSAP.LONG_PARSER, JSAP.NO_DEFAULT, false, 'S', "seed", "The random seed."), new Switch("spec", 's', "spec", "The basename is not a basename but rather a specification of the form <ImmutableGraphImplementation>(arg,arg,...)."), new Switch("offline", 'o', "offline", "Do not load the graph in main memory. If this option is used, the graph will be loaded in offline (for one thread) or mapped (for several threads) mode."), new Switch("external", 'e', "external", "Use an external dump file instead of core memory to store new counter values. Note that the file might be very large: you might need to set suitably the Java temporary directory (-Djava.io.tmpdir=DIR)."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("basenamet", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the transpose graph for systolic computations (strongly suggested). If it is equal to <basename>, the graph will be assumed to be symmetric and will be loaded just once.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        boolean spec = jsapResult.getBoolean("spec");
        boolean external = jsapResult.getBoolean("external");
        boolean offline = jsapResult.getBoolean("offline");
        String neighbourhoodFunctionFile = jsapResult.getString("neighbourhoodFunction");
        boolean neighbourhoodFunction = jsapResult.userSpecified("neighbourhoodFunction");
        String sumOfDistancesFile = jsapResult.getString("sumOfDistances");
        boolean sumOfDistances = jsapResult.userSpecified("sumOfDistances");
        String harmonicCentralityFile = jsapResult.getString("harmonicCentrality");
        boolean harmonicCentrality = jsapResult.userSpecified("harmonicCentrality");
        String closenessCentralityFile = jsapResult.getString("closenessCentrality");
        boolean closenessCentrality = jsapResult.userSpecified("closenessCentrality");
        String linCentralityFile = jsapResult.getString("linCentrality");
        boolean linCentrality = jsapResult.userSpecified("linCentrality");
        String nieminenCentralityFile = jsapResult.getString("nieminenCentrality");
        boolean nieminenCentrality = jsapResult.userSpecified("nieminenCentrality");
        String reachableFile = jsapResult.getString("reachable");
        boolean reachable = jsapResult.userSpecified("reachable");
        String basename = jsapResult.getString("basename");
        String basenamet = jsapResult.getString("basenamet");
        ProgressLogger pl = new ProgressLogger(LOGGER);
        int log2m = jsapResult.getInt("log2m");
        int threads = jsapResult.getInt("threads");
        int bufferSize = jsapResult.getInt("bufferSize");
        int granularity = jsapResult.getInt("granularity");
        long seed = jsapResult.userSpecified("seed") ? jsapResult.getLong("seed") : Util.randomSeed();
        String[] discountedGainCentralitySpec = jsapResult.getStringArray("discountedGainCentrality");
        Int2DoubleFunction[] discountFunction = new Int2DoubleFunction[discountedGainCentralitySpec.length];
        String[] discountedGainCentralityFile = new String[discountedGainCentralitySpec.length];
        for (int i2 = 0; i2 < discountedGainCentralitySpec.length; ++i2) {
            Int2DoubleFunction candidateFunction;
            int pos = discountedGainCentralitySpec[i2].indexOf(58);
            if (pos < 0) {
                throw new IllegalArgumentException("Wrong spec <" + discountedGainCentralitySpec[i2] + ">");
            }
            discountedGainCentralityFile[i2] = discountedGainCentralitySpec[i2].substring(pos + 1);
            String gainSpec = discountedGainCentralitySpec[i2].substring(0, pos);
            try {
                candidateFunction = (Int2DoubleFunction)HyperBall.class.getField(gainSpec).get(null);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException("Field " + gainSpec + " exists but cannot be accessed", e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Field " + gainSpec + " exists but it is not of type Int2DoubleFunction", e);
            }
            catch (NoSuchFieldException e) {
                candidateFunction = null;
            }
            discountFunction[i2] = candidateFunction == null ? (Int2DoubleFunction)ObjectParser.fromSpec((String)gainSpec, Int2DoubleFunction.class) : candidateFunction;
        }
        ImmutableGraph immutableGraph = spec ? (ImmutableGraph)ObjectParser.fromSpec((String)basename, ImmutableGraph.class, (String[])GraphClassParser.PACKAGE) : (offline ? (HyperBall.numberOfThreads(threads) == 1 && basenamet == null ? ImmutableGraph.loadOffline(basename) : ImmutableGraph.loadMapped(basename, new ProgressLogger())) : (graph = ImmutableGraph.load(basename, new ProgressLogger())));
        ImmutableGraph grapht = basenamet == null ? null : (basenamet.equals(basename) ? graph : (spec ? (ImmutableGraph)ObjectParser.fromSpec((String)basenamet, ImmutableGraph.class, (String[])GraphClassParser.PACKAGE) : (offline ? ImmutableGraph.loadMapped(basenamet, new ProgressLogger()) : ImmutableGraph.load(basenamet, new ProgressLogger()))));
        HyperBall hyperBall = new HyperBall(graph, grapht, log2m, pl, threads, bufferSize, granularity, external, sumOfDistances || closenessCentrality || linCentrality || nieminenCentrality, harmonicCentrality, discountFunction, seed);
        hyperBall.run(jsapResult.getLong("upperBound"), jsapResult.getDouble("threshold"));
        hyperBall.close();
        if (neighbourhoodFunction) {
            PrintStream stream = new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(neighbourhoodFunctionFile)));
            DoubleListIterator i3 = hyperBall.neighbourhoodFunction.iterator();
            while (i3.hasNext()) {
                stream.println(BigDecimal.valueOf(i3.nextDouble()).toPlainString());
            }
            stream.close();
        }
        if (sumOfDistances) {
            BinIO.storeFloats((float[][])hyperBall.sumOfDistances, (CharSequence)sumOfDistancesFile);
        }
        if (harmonicCentrality) {
            BinIO.storeFloats((float[][])hyperBall.sumOfInverseDistances, (CharSequence)harmonicCentralityFile);
        }
        for (int i4 = 0; i4 < discountedGainCentralitySpec.length; ++i4) {
            BinIO.storeFloats((float[][])hyperBall.discountedCentrality[i4], (CharSequence)discountedGainCentralityFile[i4]);
        }
        if (closenessCentrality) {
            long n = graph.numNodes();
            dos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(closenessCentralityFile)));
            for (i = 0L; i < n; ++i) {
                d = FloatBigArrays.get((float[][])hyperBall.sumOfDistances, (long)i);
                dos.writeFloat(d == 0.0f ? 0.0f : 1.0f / d);
            }
            dos.close();
        }
        if (linCentrality) {
            long n = graph.numNodes();
            dos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(linCentralityFile)));
            for (i = 0L; i < n; ++i) {
                d = FloatBigArrays.get((float[][])hyperBall.sumOfDistances, (long)i);
                if (d == 0.0f) {
                    dos.writeFloat(1.0f);
                    continue;
                }
                double count = hyperBall.count(i);
                dos.writeFloat((float)(count * count / (double)d));
            }
            dos.close();
        }
        if (nieminenCentrality) {
            long n = graph.numNodes();
            dos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(nieminenCentralityFile)));
            for (i = 0L; i < n; ++i) {
                double count = hyperBall.count(i);
                dos.writeFloat((float)(count * count - (double)FloatBigArrays.get((float[][])hyperBall.sumOfDistances, (long)i)));
            }
            dos.close();
        }
        if (reachable) {
            long n = graph.numNodes();
            dos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(reachableFile)));
            for (i = 0L; i < n; ++i) {
                dos.writeFloat((float)hyperBall.count(i));
            }
            dos.close();
        }
    }

    static /* synthetic */ long[][] access$200(HyperBall x0) {
        return x0.bits;
    }

    private final class IterationThread
    extends Thread {
        private final ImmutableGraph g;
        private final ImmutableGraph gt;
        private final int index;
        private boolean threadShouldWait;

        private IterationThread(ImmutableGraph g, ImmutableGraph gt, int index) {
            this.g = g;
            this.gt = gt;
            this.index = index;
        }

        private final boolean synchronize(int phase) throws InterruptedException {
            HyperBall.this.lock.lock();
            try {
                this.threadShouldWait = true;
                if (--HyperBall.this.aliveThreads == 0) {
                    HyperBall.this.allWaiting.signal();
                }
                if (HyperBall.this.aliveThreads < 0) {
                    throw new IllegalStateException();
                }
                while (this.threadShouldWait) {
                    HyperBall.this.start.await();
                }
                if (HyperBall.this.completed) {
                    boolean bl = true;
                    return bl;
                }
                if (phase != HyperBall.this.phase) {
                    throw new IllegalStateException("Main thread is in phase " + HyperBall.this.phase + ", but thread " + this.index + " is heading to phase " + phase);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                HyperBall.this.lock.unlock();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 22[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public String toString() {
            return "Thread " + this.index;
        }
    }
}

