/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.algo;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.webgraph.GraphClassParser;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.Transform;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrayBigList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigArrayBigList;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.objects.ObjectBigArrayBigList;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StronglyConnectedComponents {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(StronglyConnectedComponents.class);
    public final long numberOfComponents;
    public final long[][] component;
    public final LongArrayBitVector buckets;

    protected StronglyConnectedComponents(long numberOfComponents, long[][] component, LongArrayBitVector buckets) {
        this.numberOfComponents = numberOfComponents;
        this.component = component;
        this.buckets = buckets;
    }

    public static StronglyConnectedComponents compute(ImmutableGraph graph, boolean computeBuckets, ProgressLogger pl) {
        long n = graph.numNodes();
        Visit visit = new Visit(graph, LongBigArrays.newBigArray((long)n), computeBuckets ? LongArrayBitVector.ofLength((long)n) : null, pl);
        visit.run();
        return new StronglyConnectedComponents(visit.numberOfComponents, visit.status, visit.buckets);
    }

    public static StronglyConnectedComponents compute(ArcLabelledImmutableGraph graph, Transform.LabelledArcFilter filter, boolean computeBuckets, ProgressLogger pl) {
        long n = graph.numNodes();
        FilteredVisit filteredVisit = new FilteredVisit(graph, filter, LongBigArrays.newBigArray((long)n), computeBuckets ? LongArrayBitVector.ofLength((long)n) : null, pl);
        filteredVisit.run();
        return new StronglyConnectedComponents(filteredVisit.numberOfComponents, filteredVisit.status, filteredVisit.buckets);
    }

    public long[][] computeSizes() {
        long[][] size = LongBigArrays.newBigArray((long)this.numberOfComponents);
        int i = this.component.length;
        while (i-- != 0) {
            long[] t = this.component[i];
            int d = t.length;
            while (d-- != 0) {
                LongBigArrays.incr((long[][])size, (long)t[d]);
            }
        }
        return size;
    }

    public void sortBySize(long[][] size) {
        long[] t;
        long[][] perm = Util.identity((long)LongBigArrays.length((long[][])size));
        LongBigArrays.quickSort((long[][])perm, (long)0L, (long)LongBigArrays.length((long[][])perm), (x, y) -> Long.compare(LongBigArrays.get((long[][])size, (long)y), LongBigArrays.get((long[][])size, (long)x)));
        long[][] copy = LongBigArrays.copy((long[][])size);
        int i = size.length;
        while (i-- != 0) {
            t = size[i];
            long[] u = perm[i];
            int d = t.length;
            while (d-- != 0) {
                t[d] = LongBigArrays.get((long[][])copy, (long)u[d]);
            }
        }
        Util.invertPermutationInPlace((long[][])perm);
        i = this.component.length;
        while (i-- != 0) {
            t = this.component[i];
            int d = t.length;
            while (d-- != 0) {
                t[d] = LongBigArrays.get((long[][])perm, (long)t[d]);
            }
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException {
        StronglyConnectedComponents components;
        SimpleJSAP jsap = new SimpleJSAP(StronglyConnectedComponents.class.getName(), "Computes the strongly connected components (and optionally the buckets) of a graph of given basename. The resulting data is saved in files stemmed from the given basename with extension .scc (a list of binary integers specifying the component of each node), .sccsizes (a list of binary integer specifying the size of each component) and .buckets  (a serialised LongArrayBitVector specifying buckets). Please use suitable JVM options to set a large stack size.", new Parameter[]{new Switch("sizes", 's', "sizes", "Compute component sizes."), new Switch("renumber", 'r', "renumber", "Renumber components in decreasing-size order."), new Switch("buckets", 'b', "buckets", "Compute buckets (nodes belonging to a bucket component, i.e., a terminal nondangling component)."), new FlaggedOption("filter", (StringParser)new ObjectParser(Transform.LabelledArcFilter.class, GraphClassParser.PACKAGE), JSAP.NO_DEFAULT, false, 'f', "filter", "A filter for labelled arcs; requires the provided graph to be arc labelled."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the graph."), new UnflaggedOption("resultsBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the resulting files.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        String basename = jsapResult.getString("basename");
        String resultsBasename = jsapResult.getString("resultsBasename", basename);
        Transform.LabelledArcFilter filter = (Transform.LabelledArcFilter)jsapResult.getObject("filter");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        StronglyConnectedComponents stronglyConnectedComponents = components = filter != null ? StronglyConnectedComponents.compute(ArcLabelledImmutableGraph.load(basename), filter, jsapResult.getBoolean("buckets"), pl) : StronglyConnectedComponents.compute(ImmutableGraph.load(basename), jsapResult.getBoolean("buckets"), pl);
        if (jsapResult.getBoolean("sizes") || jsapResult.getBoolean("renumber")) {
            long[][] size = components.computeSizes();
            if (jsapResult.getBoolean("renumber")) {
                components.sortBySize(size);
            }
            if (jsapResult.getBoolean("sizes")) {
                BinIO.storeLongs((long[][])size, (CharSequence)(resultsBasename + ".sccsizes"));
            }
        }
        BinIO.storeLongs((long[][])components.component, (CharSequence)(resultsBasename + ".scc"));
        if (components.buckets != null) {
            BinIO.storeObject((Object)components.buckets, (CharSequence)(resultsBasename + ".buckets"));
        }
    }

    private static final class FilteredVisit {
        private final ArcLabelledImmutableGraph graph;
        private final long n;
        private final ProgressLogger pl;
        private final Transform.LabelledArcFilter filter;
        private final boolean computeBuckets;
        private final long[][] status;
        private final LongArrayBitVector buckets;
        private final LongBigArrayBigList componentStack;
        private long clock;
        private long numberOfComponents;

        private FilteredVisit(ArcLabelledImmutableGraph graph, Transform.LabelledArcFilter filter, long[][] status, LongArrayBitVector buckets, ProgressLogger pl) {
            this.graph = graph;
            this.filter = filter;
            this.buckets = buckets;
            this.status = status;
            this.pl = pl;
            this.computeBuckets = buckets != null;
            this.n = graph.numNodes();
            this.componentStack = new LongBigArrayBigList(this.n);
        }

        private long filteredOutdegree(long node) {
            long s;
            long filteredOutdegree = 0L;
            ArcLabelledNodeIterator.LabelledArcIterator successors = this.graph.successors(node);
            while ((s = successors.nextLong()) != -1L) {
                if (!this.filter.accept(node, s, successors.label())) continue;
                ++filteredOutdegree;
            }
            return filteredOutdegree;
        }

        private void visit(long startNode) {
            LongArrayBitVector olderNodeFound = LongArrayBitVector.ofLength((long)this.n);
            LongBigArrayBigList nodeStack = new LongBigArrayBigList();
            ObjectBigArrayBigList successorsStack = new ObjectBigArrayBigList();
            long[][] status = this.status;
            LongArrayBitVector nonBuckets = this.buckets;
            LongBigArrays.set((long[][])status, (long)startNode, (long)(++this.clock));
            this.componentStack.push(startNode);
            nodeStack.push(startNode);
            successorsStack.push((Object)this.graph.successors(startNode));
            if (this.computeBuckets && this.filteredOutdegree(startNode) == 0L) {
                nonBuckets.set(startNode);
            }
            block0: while (!nodeStack.isEmpty()) {
                long z;
                long s;
                long currentNode = nodeStack.topLong();
                ArcLabelledNodeIterator.LabelledArcIterator successors = (ArcLabelledNodeIterator.LabelledArcIterator)successorsStack.top();
                while ((s = successors.nextLong()) != -1L) {
                    if (!this.filter.accept(currentNode, s, successors.label())) continue;
                    long successorStatus = LongBigArrays.get((long[][])status, (long)s);
                    if (successorStatus == 0L) {
                        LongBigArrays.set((long[][])status, (long)s, (long)(++this.clock));
                        nodeStack.push(s);
                        this.componentStack.push(s);
                        successorsStack.push((Object)this.graph.successors(s));
                        if (!this.computeBuckets || this.filteredOutdegree(s) != 0L) continue block0;
                        nonBuckets.set(s);
                        continue block0;
                    }
                    if (successorStatus > 0L) {
                        if (successorStatus >= LongBigArrays.get((long[][])status, (long)currentNode)) continue;
                        LongBigArrays.set((long[][])status, (long)currentNode, (long)successorStatus);
                        olderNodeFound.set(currentNode);
                        continue;
                    }
                    if (!this.computeBuckets) continue;
                    nonBuckets.set(currentNode);
                }
                nodeStack.popLong();
                successorsStack.pop();
                if (this.pl != null) {
                    this.pl.lightUpdate();
                }
                if (olderNodeFound.getBoolean(currentNode)) {
                    long parentNode = nodeStack.topLong();
                    long currentNodeStatus = LongBigArrays.get((long[][])status, (long)currentNode);
                    if (currentNodeStatus < LongBigArrays.get((long[][])status, (long)parentNode)) {
                        LongBigArrays.set((long[][])status, (long)parentNode, (long)currentNodeStatus);
                        olderNodeFound.set(parentNode);
                    }
                    if (!this.computeBuckets || !nonBuckets.getBoolean(currentNode)) continue;
                    nonBuckets.set(parentNode);
                    continue;
                }
                if (this.computeBuckets && !nodeStack.isEmpty()) {
                    nonBuckets.set(nodeStack.topLong());
                }
                boolean notABucket = this.computeBuckets ? nonBuckets.getBoolean(currentNode) : false;
                ++this.numberOfComponents;
                do {
                    z = this.componentStack.popLong();
                    LongBigArrays.set((long[][])status, (long)z, (long)(-this.numberOfComponents));
                    if (!notABucket) continue;
                    nonBuckets.set(z);
                } while (z != currentNode);
            }
        }

        public void run() {
            if (this.pl != null) {
                this.pl.itemsName = "nodes";
                this.pl.expectedUpdates = this.n;
                this.pl.displayFreeMemory = true;
                this.pl.start((CharSequence)"Computing strongly connected components...");
            }
            for (long x = 0L; x < this.n; ++x) {
                if (LongBigArrays.get((long[][])this.status, (long)x) != 0L) continue;
                this.visit(x);
            }
            if (this.pl != null) {
                this.pl.done();
            }
            int i = this.status.length;
            while (i-- != 0) {
                long[] t = this.status[i];
                int d = t.length;
                while (d-- != 0) {
                    t[d] = -t[d] - 1L;
                }
            }
            if (this.buckets != null) {
                this.buckets.flip();
            }
        }
    }

    private static final class Visit {
        private final ImmutableGraph graph;
        private final long n;
        private final ProgressLogger pl;
        private final boolean computeBuckets;
        private final long[][] status;
        private final LongArrayBitVector buckets;
        private final LongBigArrayBigList componentStack;
        private long clock;
        private long numberOfComponents;

        private Visit(ImmutableGraph graph, long[][] status, LongArrayBitVector buckets, ProgressLogger pl) {
            this.graph = graph;
            this.buckets = buckets;
            this.status = status;
            this.pl = pl;
            this.computeBuckets = buckets != null;
            this.n = graph.numNodes();
            this.componentStack = new LongBigArrayBigList(this.n);
        }

        private void visit(long startNode) {
            BooleanBigArrayBigList olderNodeFound = new BooleanBigArrayBigList();
            LongBigArrayBigList nodeStack = new LongBigArrayBigList();
            ObjectBigArrayBigList successorsStack = new ObjectBigArrayBigList();
            long[][] status = this.status;
            LongArrayBitVector nonBuckets = this.buckets;
            LongBigArrays.set((long[][])status, (long)startNode, (long)(++this.clock));
            this.componentStack.push(startNode);
            nodeStack.push(startNode);
            successorsStack.push((Object)this.graph.successors(startNode));
            olderNodeFound.push(false);
            if (this.computeBuckets && this.graph.outdegree(startNode) == 0L) {
                nonBuckets.set(startNode);
            }
            block0: while (!nodeStack.isEmpty()) {
                long z;
                long s;
                long currentNode = nodeStack.topLong();
                LazyLongIterator successors = (LazyLongIterator)successorsStack.top();
                while ((s = successors.nextLong()) != -1L) {
                    long successorStatus = LongBigArrays.get((long[][])status, (long)s);
                    if (successorStatus == 0L) {
                        LongBigArrays.set((long[][])status, (long)s, (long)(++this.clock));
                        nodeStack.push(s);
                        this.componentStack.push(s);
                        successorsStack.push((Object)this.graph.successors(s));
                        olderNodeFound.push(false);
                        if (!this.computeBuckets || this.graph.outdegree(s) != 0L) continue block0;
                        nonBuckets.set(s);
                        continue block0;
                    }
                    if (successorStatus > 0L) {
                        if (successorStatus >= LongBigArrays.get((long[][])status, (long)currentNode)) continue;
                        LongBigArrays.set((long[][])status, (long)currentNode, (long)successorStatus);
                        olderNodeFound.popBoolean();
                        olderNodeFound.push(true);
                        continue;
                    }
                    if (!this.computeBuckets) continue;
                    nonBuckets.set(currentNode);
                }
                nodeStack.popLong();
                successorsStack.pop();
                if (this.pl != null) {
                    this.pl.lightUpdate();
                }
                if (olderNodeFound.popBoolean()) {
                    long parentNode = nodeStack.topLong();
                    long currentNodeStatus = LongBigArrays.get((long[][])status, (long)currentNode);
                    if (currentNodeStatus < LongBigArrays.get((long[][])status, (long)parentNode)) {
                        LongBigArrays.set((long[][])status, (long)parentNode, (long)currentNodeStatus);
                        olderNodeFound.popBoolean();
                        olderNodeFound.push(true);
                    }
                    if (!this.computeBuckets || !nonBuckets.getBoolean(currentNode)) continue;
                    nonBuckets.set(parentNode);
                    continue;
                }
                if (this.computeBuckets && !nodeStack.isEmpty()) {
                    nonBuckets.set(nodeStack.topLong());
                }
                boolean notABucket = this.computeBuckets ? nonBuckets.getBoolean(currentNode) : false;
                ++this.numberOfComponents;
                do {
                    z = this.componentStack.popLong();
                    LongBigArrays.set((long[][])status, (long)z, (long)(-this.numberOfComponents));
                    if (!notABucket) continue;
                    nonBuckets.set(z);
                } while (z != currentNode);
            }
        }

        public void run() {
            if (this.pl != null) {
                this.pl.itemsName = "nodes";
                this.pl.expectedUpdates = this.n;
                this.pl.displayFreeMemory = true;
                this.pl.start((CharSequence)"Computing strongly connected components...");
            }
            for (long x = 0L; x < this.n; ++x) {
                if (LongBigArrays.get((long[][])this.status, (long)x) != 0L) continue;
                this.visit(x);
            }
            if (this.pl != null) {
                this.pl.done();
            }
            int i = this.status.length;
            while (i-- != 0) {
                long[] t = this.status[i];
                int d = t.length;
                while (d-- != 0) {
                    t[d] = -t[d] - 1L;
                }
            }
            if (this.buckets != null) {
                this.buckets.flip();
            }
        }
    }
}

