/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.examples;

import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.NoSuchElementException;

public class IntegerListImmutableGraph
extends ImmutableSequentialGraph {
    private final String filename;
    private final long numNodes;

    private IntegerListImmutableGraph(CharSequence filename) throws IOException {
        this.filename = filename.toString();
        DataInputStream dis = new DataInputStream(new FileInputStream(this.filename));
        this.numNodes = dis.readLong();
        dis.close();
    }

    @Override
    public long numNodes() {
        return this.numNodes;
    }

    @Override
    public NodeIterator nodeIterator() {
        try {
            return new NodeIterator(){
                final long n;
                final DataInputStream dis;
                long curr;
                long outdegree;
                long[][] successorsArray;
                {
                    this.n = IntegerListImmutableGraph.this.numNodes();
                    this.dis = new DataInputStream(new FileInputStream(IntegerListImmutableGraph.this.filename));
                    this.curr = -1L;
                    this.successorsArray = LongBigArrays.EMPTY_BIG_ARRAY;
                    try {
                        this.dis.readInt();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public long nextLong() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        this.outdegree = this.dis.readLong();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return ++this.curr;
                }

                public boolean hasNext() {
                    return this.curr < this.n - 1L;
                }

                @Override
                public long[][] successorBigArray() {
                    if (this.curr == -1L) {
                        throw new IllegalStateException();
                    }
                    this.successorsArray = LongBigArrays.ensureCapacity((long[][])this.successorsArray, (long)this.outdegree, (long)0L);
                    try {
                        for (long i = 0L; i < this.outdegree; ++i) {
                            LongBigArrays.set((long[][])this.successorsArray, (long)i, (long)this.dis.readLong());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return this.successorsArray;
                }

                @Override
                public long outdegree() {
                    if (this.curr == -1L) {
                        throw new IllegalStateException();
                    }
                    return this.outdegree;
                }

                protected void finalize() throws Throwable {
                    try {
                        this.dis.close();
                    }
                    finally {
                        super.finalize();
                    }
                }
            };
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImmutableGraph load(CharSequence basename, ProgressLogger pl) {
        throw new UnsupportedOperationException("Graphs may be loaded offline only");
    }

    public static ImmutableGraph load(CharSequence basename) {
        return IntegerListImmutableGraph.load(basename, null);
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) {
        return IntegerListImmutableGraph.load(basename, pl);
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename) {
        return IntegerListImmutableGraph.load(basename, null);
    }

    public static ImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return new IntegerListImmutableGraph(basename);
    }

    public static ImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return IntegerListImmutableGraph.loadOffline(basename, null);
    }
}

