/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.labelling;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.big.webgraph.AbstractLazyLongIterator;
import it.unimi.dsi.big.webgraph.BVGraph;
import it.unimi.dsi.big.webgraph.GraphClassParser;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.AbstractIntLabel;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.big.webgraph.labelling.BitStreamArcLabelledImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.Label;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcRelabelledImmutableGraph
extends ArcLabelledImmutableGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArcRelabelledImmutableGraph.class);
    public static final LabelConversionStrategy INT_LABEL_CONVERSION_STRATEGY = new LabelConversionStrategy(){

        @Override
        public void convert(Label from, Label to, long source, long target) {
            ((AbstractIntLabel)to).value = ((AbstractIntLabel)from).value;
        }
    };
    private final ArcLabelledImmutableGraph wrappedGraph;
    private final Label newLabelPrototype;
    private final LabelConversionStrategy conversionStrategy;

    public ArcRelabelledImmutableGraph(ArcLabelledImmutableGraph wrappedGraph, Label newLabelPrototype, LabelConversionStrategy conversionStrategy) {
        this.wrappedGraph = wrappedGraph;
        this.newLabelPrototype = newLabelPrototype;
        this.conversionStrategy = conversionStrategy;
    }

    @Override
    public ArcRelabelledImmutableGraph copy() {
        return new ArcRelabelledImmutableGraph(this.wrappedGraph.copy(), this.newLabelPrototype.copy(), this.conversionStrategy);
    }

    @Override
    public ArcLabelledNodeIterator nodeIterator(final long from) {
        return new ArcLabelledNodeIterator(){
            private long current = -1L;
            ArcLabelledNodeIterator wrappedNodeIterator = ArcRelabelledImmutableGraph.access$200(ArcRelabelledImmutableGraph.this).nodeIterator(from);

            @Override
            public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                return new RelabelledArcIterator(this.wrappedNodeIterator.successors(), this.current);
            }

            @Override
            public long outdegree() {
                return this.wrappedNodeIterator.outdegree();
            }

            public boolean hasNext() {
                return this.wrappedNodeIterator.hasNext();
            }

            public long nextLong() {
                this.current = this.wrappedNodeIterator.nextLong();
                return this.current;
            }
        };
    }

    @Override
    public ArcLabelledNodeIterator.LabelledArcIterator successors(long x) {
        return new RelabelledArcIterator(this.wrappedGraph.successors(x), x);
    }

    @Override
    public Label prototype() {
        return this.newLabelPrototype;
    }

    @Override
    public long numNodes() {
        return this.wrappedGraph.numNodes();
    }

    @Override
    public boolean randomAccess() {
        return this.wrappedGraph.randomAccess();
    }

    @Override
    public long outdegree(long x) {
        return this.wrappedGraph.outdegree(x);
    }

    public static void main(String[] arg) throws JSAPException, IOException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, InstantiationException {
        SimpleJSAP jsap = new SimpleJSAP(ArcRelabelledImmutableGraph.class.getName(), "Relabels a graph with given basename, with integer labels, saving it with a different basename and using another (typically: different) type of integer labels, specified via a spec, and possibly using a different kind of graph class.", new Parameter[]{new FlaggedOption("underlyingGraphClass", (StringParser)GraphClassParser.getParser(), BVGraph.class.getName(), false, 'u', "underlying-graph-class", "Forces a Java immutable graph class to be used for saving the underlying graph (if the latter did not exist before)."), new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), BitStreamArcLabelledImmutableGraph.class.getName(), false, 'g', "graph-class", "Forces a Java arc-labelled graph class to be used for saving."), new UnflaggedOption("spec", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The label spec (e.g. FixedWidthIntLabel(FOO,10))."), new UnflaggedOption("source", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the source arc-labelled graph."), new UnflaggedOption("target", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the target arc-labelled graph.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        Class destClass = jsapResult.getClass("graphClass");
        Class underlyingDestClass = jsapResult.getClass("underlyingGraphClass");
        String sourceBasename = jsapResult.getString("source");
        String targetBasename = jsapResult.getString("target");
        String spec = jsapResult.getString("spec");
        Label label = (Label)ObjectParser.fromSpec((String)spec, Label.class);
        ImmutableGraph source = ImmutableGraph.loadOffline(sourceBasename);
        if (!(source instanceof ArcLabelledImmutableGraph)) {
            throw new IllegalArgumentException("The graph " + sourceBasename + " of class " + sourceBasename.getClass().getName() + " is not arc-labelled");
        }
        ArcLabelledImmutableGraph labSource = (ArcLabelledImmutableGraph)source;
        if (!(labSource.prototype() instanceof AbstractIntLabel) || !(label instanceof AbstractIntLabel)) {
            throw new IllegalArgumentException("Relabelling from command line is only allowed for int labels, not for " + labSource.prototype().getClass().getName() + " -> " + label.getClass().getName());
        }
        ArcRelabelledImmutableGraph labTarget = new ArcRelabelledImmutableGraph(labSource, label, INT_LABEL_CONVERSION_STRATEGY);
        ProgressLogger pl = new ProgressLogger(LOGGER);
        Properties prop = new Properties();
        prop.load(new FileInputStream(sourceBasename + ".properties"));
        String underlyingBasename = prop.getProperty("underlyinggraph");
        if (underlyingBasename == null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = labTarget;
            underlyingBasename = targetBasename + "-underlying";
            objectArray[1] = underlyingBasename;
            objectArray[2] = pl;
            underlyingDestClass.getMethod("store", ImmutableGraph.class, CharSequence.class, ProgressLogger.class).invoke(null, objectArray);
        }
        destClass.getMethod("store", ArcLabelledImmutableGraph.class, CharSequence.class, CharSequence.class, ProgressLogger.class).invoke(null, labTarget, targetBasename, underlyingBasename, pl);
    }

    static /* synthetic */ ArcLabelledImmutableGraph access$200(ArcRelabelledImmutableGraph x0) {
        return x0.wrappedGraph;
    }

    private final class RelabelledArcIterator
    extends AbstractLazyLongIterator
    implements ArcLabelledNodeIterator.LabelledArcIterator {
        private final ArcLabelledNodeIterator.LabelledArcIterator wrappedArcIterator;
        private final long source;
        private long target;

        public RelabelledArcIterator(ArcLabelledNodeIterator.LabelledArcIterator wrappedArcIterator, long source) {
            this.wrappedArcIterator = wrappedArcIterator;
            this.source = source;
        }

        @Override
        public Label label() {
            ArcRelabelledImmutableGraph.this.conversionStrategy.convert(this.wrappedArcIterator.label(), ArcRelabelledImmutableGraph.this.newLabelPrototype, this.source, this.target);
            return ArcRelabelledImmutableGraph.this.newLabelPrototype;
        }

        @Override
        public long nextLong() {
            this.target = this.wrappedArcIterator.nextLong();
            return this.target;
        }
    }

    public static interface LabelConversionStrategy {
        public void convert(Label var1, Label var2, long var3, long var5);
    }
}

