/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.labelling;

import it.unimi.dsi.big.webgraph.AbstractLazyLongIterator;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.big.webgraph.labelling.Label;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastMultiByteArrayInputStream;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectBigArrays;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;

public class BitStreamArcLabelledImmutableGraph
extends ArcLabelledImmutableGraph {
    public static final String LABELS_EXTENSION = ".labels";
    public static final String LABEL_OFFSETS_EXTENSION = ".labeloffsets";
    public static final String LABELSPEC_PROPERTY_KEY = "labelspec";
    private static final int STD_BUFFER_SIZE = 0x100000;
    public final ImmutableGraph g;
    protected final Label prototype;
    private final byte[] byteArray;
    private final FastMultiByteArrayInputStream labelStream;
    protected final CharSequence basename;
    protected final EliasFanoMonotoneLongBigList offset;

    protected BitStreamArcLabelledImmutableGraph(CharSequence basename, ImmutableGraph g, Label prototype, byte[] byteArray, FastMultiByteArrayInputStream labelStream, EliasFanoMonotoneLongBigList offset) {
        this.g = g;
        this.byteArray = byteArray;
        this.labelStream = labelStream;
        this.prototype = prototype;
        this.basename = basename;
        this.offset = offset;
    }

    @Override
    public BitStreamArcLabelledImmutableGraph copy() {
        return new BitStreamArcLabelledImmutableGraph(this.basename, this.g.copy(), this.prototype.copy(), this.byteArray, this.labelStream, this.offset);
    }

    protected InputBitStream newInputBitStream() throws FileNotFoundException {
        return this.byteArray != null ? new InputBitStream(this.byteArray) : (this.labelStream != null ? new InputBitStream((InputStream)new FastMultiByteArrayInputStream(this.labelStream)) : new InputBitStream(this.basename + LABELS_EXTENSION));
    }

    @Override
    public CharSequence basename() {
        return this.basename;
    }

    protected long offset(long x) {
        return this.offset.getLong(x);
    }

    @Override
    public ArcLabelledNodeIterator.LabelledArcIterator successors(long x) {
        return new BitStreamLabelledArcIterator(this, x);
    }

    @Override
    public long[][] successorBigArray(long x) {
        return this.g.successorBigArray(x);
    }

    @Override
    public long numNodes() {
        return this.g.numNodes();
    }

    @Override
    public long numArcs() {
        return this.g.numArcs();
    }

    @Override
    public boolean randomAccess() {
        return this.g.randomAccess() && this.offset != null;
    }

    @Override
    public long outdegree(long x) {
        return this.g.outdegree(x);
    }

    @Deprecated
    public static BitStreamArcLabelledImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.SEQUENTIAL, basename, null);
    }

    @Deprecated
    public static BitStreamArcLabelledImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.SEQUENTIAL, basename, pl);
    }

    public static BitStreamArcLabelledImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename, null);
    }

    public static BitStreamArcLabelledImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename, pl);
    }

    public static BitStreamArcLabelledImmutableGraph load(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, null);
    }

    public static BitStreamArcLabelledImmutableGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, pl);
    }

    protected static BitStreamArcLabelledImmutableGraph load(ImmutableGraph.LoadMethod method, CharSequence basename, ProgressLogger pl) throws IOException {
        Label prototype;
        FileInputStream propertyFile = new FileInputStream(basename + ".properties");
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        if (properties.getProperty("underlyinggraph") == null) {
            throw new IOException("The property file for " + basename + " does not contain an underlying graph basename");
        }
        String graphName = properties.getProperty("underlyinggraph");
        if (!new File(graphName).isAbsolute()) {
            graphName = new File(new File(basename.toString()).getParentFile(), properties.getProperty("underlyinggraph")).toString();
        }
        FileInputStream graphPropertyFile = new FileInputStream(graphName + ".properties");
        Properties graphProperties = new Properties();
        graphProperties.load(graphPropertyFile);
        graphPropertyFile.close();
        final ImmutableGraph g = ImmutableGraph.load(method, graphName, null, pl);
        if (properties.getProperty(LABELSPEC_PROPERTY_KEY) == null) {
            throw new IOException("The property file for " + basename + " does not contain a label specification");
        }
        try {
            try {
                prototype = (Label)ObjectParser.fromSpec((Object)new File(basename.toString()).getParentFile(), (String)properties.getProperty(LABELSPEC_PROPERTY_KEY), Label.class);
            }
            catch (NoSuchMethodException e) {
                prototype = (Label)ObjectParser.fromSpec((String)properties.getProperty(LABELSPEC_PROPERTY_KEY), Label.class);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] byteArray = null;
        FastMultiByteArrayInputStream labelStream = null;
        EliasFanoMonotoneLongBigList offsets = null;
        if (method != ImmutableGraph.LoadMethod.OFFLINE) {
            FileInputStream fis;
            long size;
            if (pl != null) {
                pl.itemsName = "bytes";
                pl.start((CharSequence)"Loading labels...");
            }
            if ((size = (fis = new FileInputStream(basename + LABELS_EXTENSION)).getChannel().size()) <= Integer.MAX_VALUE) {
                byteArray = BinIO.loadBytes((CharSequence)(basename + LABELS_EXTENSION));
            } else {
                labelStream = new FastMultiByteArrayInputStream((InputStream)fis, size);
            }
            if (pl != null) {
                pl.count = size;
                pl.done();
            }
            if (method != ImmutableGraph.LoadMethod.SEQUENTIAL) {
                if (pl != null) {
                    pl.itemsName = "deltas";
                    pl.expectedUpdates = g.numNodes() + 1L;
                    pl.start((CharSequence)"Loading label offsets...");
                }
                final InputBitStream offsetStream = new InputBitStream(basename + LABEL_OFFSETS_EXTENSION);
                offsets = new EliasFanoMonotoneLongBigList(g.numNodes() + 1L, size * 8L + 1L, new LongIterator(){
                    private long off;
                    private int i;

                    public boolean hasNext() {
                        return (long)this.i <= g.numNodes();
                    }

                    public long nextLong() {
                        ++this.i;
                        try {
                            this.off = offsetStream.readLongGamma() + this.off;
                            return this.off;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                offsetStream.close();
                if (pl != null) {
                    pl.count = g.numNodes() + 1L;
                    pl.done();
                    pl.logger().info("Label pointer bits per node: " + (double)offsets.numBits() / ((double)g.numNodes() + 1.0));
                }
            }
            fis.close();
        }
        return new BitStreamArcLabelledImmutableGraph(basename, g, prototype, byteArray, labelStream, offsets);
    }

    @Override
    public ArcLabelledNodeIterator nodeIterator(long from) {
        try {
            return new BitStreamArcLabelledNodeIterator(from, this.g, this.prototype, this.newInputBitStream());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Label prototype() {
        return this.prototype;
    }

    public static void store(ArcLabelledImmutableGraph graph, CharSequence basename, CharSequence underlyingBasename) throws IOException {
        BitStreamArcLabelledImmutableGraph.store(graph, basename, underlyingBasename, null);
    }

    public static void store(ArcLabelledImmutableGraph graph, CharSequence basename, CharSequence underlyingBasename, ProgressLogger pl) throws IOException {
        OutputBitStream labels = new OutputBitStream(basename + LABELS_EXTENSION, 0x100000);
        OutputBitStream offsets = new OutputBitStream(basename + LABEL_OFFSETS_EXTENSION, 0x100000);
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = graph.numNodes();
            pl.start((CharSequence)"Saving labels...");
        }
        ArcLabelledNodeIterator nodeIterator = graph.nodeIterator();
        offsets.writeGamma(0);
        while (nodeIterator.hasNext()) {
            long curr = nodeIterator.nextLong();
            ArcLabelledNodeIterator.LabelledArcIterator successors = nodeIterator.successors();
            long count = 0L;
            while (successors.nextLong() != -1L) {
                count += (long)successors.label().toBitStream(labels, curr);
            }
            offsets.writeLongGamma(count);
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (pl != null) {
            pl.done();
        }
        labels.close();
        offsets.close();
        PrintWriter properties = new PrintWriter(new FileOutputStream(basename + ".properties"));
        properties.println("graphclass = " + BitStreamArcLabelledImmutableGraph.class.getName());
        properties.println("underlyinggraph = " + underlyingBasename);
        properties.println("labelspec = " + graph.prototype().toSpec());
        properties.close();
    }

    private static final class BitStreamArcLabelledNodeIterator
    extends ArcLabelledNodeIterator {
        private final NodeIterator underlyingNodeIterator;
        private final InputBitStream ibs;
        private final Label prototype;
        private Label[][] label = new Label[0][0];

        public BitStreamArcLabelledNodeIterator(long from, ImmutableGraph g, Label prototype, InputBitStream ibs) {
            this.prototype = prototype;
            this.ibs = ibs;
            this.underlyingNodeIterator = g.nodeIterator();
            long i = from;
            while (i-- != 0L) {
                this.nextLong();
            }
        }

        @Override
        public ArcLabelledNodeIterator.LabelledArcIterator successors() {
            return new BitStreamArcLabelledNodeIteratorArcIterator(this.underlyingNodeIterator.outdegree(), this.underlyingNodeIterator.successorBigArray(), this.label);
        }

        @Override
        public long[][] successorBigArray() {
            return this.underlyingNodeIterator.successorBigArray();
        }

        @Override
        public Label[][] labelBigArray() {
            return this.label;
        }

        @Override
        public long outdegree() {
            return this.underlyingNodeIterator.outdegree();
        }

        public long nextLong() {
            long curr = this.underlyingNodeIterator.nextLong();
            long d = this.underlyingNodeIterator.outdegree();
            if (ObjectBigArrays.length((Object[][])this.label) < d) {
                this.label = (Label[][])ObjectBigArrays.grow((Object[][])this.label, (long)d);
                int i = this.label.length;
                block2: while (i-- != 0) {
                    Label[] t = this.label[i];
                    int j = t.length;
                    while (j-- != 0) {
                        if (t[j] != null) break block2;
                        t[j] = this.prototype.copy();
                    }
                }
            }
            try {
                for (long i = 0L; i < d; ++i) {
                    ((Label)ObjectBigArrays.get((Object[][])this.label, (long)i)).fromBitStream(this.ibs, curr);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return curr;
        }

        public boolean hasNext() {
            return this.underlyingNodeIterator.hasNext();
        }

        private static final class BitStreamArcLabelledNodeIteratorArcIterator
        extends AbstractLazyLongIterator
        implements ArcLabelledNodeIterator.LabelledArcIterator {
            private final Label[][] label;
            private final long[][] successor;
            private final long outdegree;
            private long curr;

            public BitStreamArcLabelledNodeIteratorArcIterator(long outdegree, long[][] ls, Label[][] label) {
                this.outdegree = outdegree;
                this.successor = ls;
                this.label = label;
                this.curr = -1L;
            }

            @Override
            public Label label() {
                if (this.curr == -1L) {
                    throw new IllegalStateException("This successor iterator is currently not valid");
                }
                return (Label)ObjectBigArrays.get((Object[][])this.label, (long)this.curr);
            }

            @Override
            public long nextLong() {
                if (this.curr == this.outdegree - 1L) {
                    return -1L;
                }
                return LongBigArrays.get((long[][])this.successor, (long)(++this.curr));
            }

            @Override
            public long skip(long n) {
                long toSkip = Math.min(n, this.outdegree - 1L - this.curr);
                this.curr += toSkip;
                return toSkip;
            }
        }
    }

    protected static class BitStreamLabelledArcIterator
    extends AbstractLazyLongIterator
    implements ArcLabelledNodeIterator.LabelledArcIterator {
        protected final LazyLongIterator underlyingIterator;
        protected final InputBitStream ibs;
        protected final Label label;
        protected final long from;

        public BitStreamLabelledArcIterator(BitStreamArcLabelledImmutableGraph alg, long x) {
            this.from = x;
            this.underlyingIterator = alg.g.successors(this.from);
            try {
                this.ibs = alg.newInputBitStream();
                this.ibs.position(alg.offset(x));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.label = alg.prototype.copy();
        }

        @Override
        public Label label() {
            return this.label;
        }

        @Override
        public long nextLong() {
            long successor = this.underlyingIterator.nextLong();
            if (successor == -1L) {
                return -1L;
            }
            try {
                this.label.fromBitStream(this.ibs, this.from);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return successor;
        }
    }
}

