/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.labelling;

import it.unimi.dsi.big.webgraph.labelling.AbstractIntListLabel;
import it.unimi.dsi.big.webgraph.labelling.Label;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.util.Arrays;

public class FixedWidthIntListLabel
extends AbstractIntListLabel {
    private final int width;

    public FixedWidthIntListLabel(String key, int width, int[] value) {
        super(key, value);
        if (width < 0 || width > 31) {
            throw new IllegalArgumentException("Width out of range: " + width);
        }
        int i = value.length;
        while (i-- != 0) {
            if (value[i] >= 0 && (long)value[i] < 1L << width) continue;
            throw new IllegalArgumentException("Value out of range: " + Integer.toString(value[i]));
        }
        this.width = width;
    }

    public FixedWidthIntListLabel(String key, int width) {
        this(key, width, IntArrays.EMPTY_ARRAY);
    }

    public FixedWidthIntListLabel(String ... arg) {
        this(arg[0], Integer.parseInt(arg[1]));
    }

    @Override
    public Label copy() {
        return new FixedWidthIntListLabel(this.key, this.width, (int[])this.value.clone());
    }

    @Override
    public int fromBitStream(InputBitStream inputBitStream, long sourceUnused) throws IOException {
        long readBits = inputBitStream.readBits();
        this.value = new int[inputBitStream.readGamma()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = inputBitStream.readInt(this.width);
        }
        return (int)(inputBitStream.readBits() - readBits);
    }

    @Override
    public int toBitStream(OutputBitStream outputBitStream, long sourceUnused) throws IOException {
        int bits = outputBitStream.writeGamma(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            bits += outputBitStream.writeInt(this.value[i], this.width);
        }
        return bits;
    }

    @Override
    public int fixedWidth() {
        return -1;
    }

    @Override
    public String toString() {
        return this.key + ":" + Arrays.toString(this.value) + " (width:" + this.width + ")";
    }

    @Override
    public String toSpec() {
        return this.getClass().getName() + "(" + this.key + "," + this.width + ")";
    }
}

