/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.labelling;

import it.unimi.dsi.big.webgraph.Transform;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.big.webgraph.labelling.Label;
import it.unimi.dsi.big.webgraph.labelling.LabelMergeStrategy;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.objects.ObjectBigArrays;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionArcLabelledImmutableGraph
extends ArcLabelledImmutableGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transform.class);
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = true;
    private final ArcLabelledImmutableGraph g0;
    private final ArcLabelledImmutableGraph g1;
    private final long n0;
    private final long n1;
    private final long numNodes;
    private final LabelMergeStrategy labelMergeStrategy;
    private final int cachedNode = -1;
    private int outdegree;
    private long[][] cache = LongBigArrays.EMPTY_BIG_ARRAY;
    private Label[][] labelCache = new Label[0][0];
    private final Label prototype;

    @Override
    public UnionArcLabelledImmutableGraph copy() {
        return new UnionArcLabelledImmutableGraph(this.g0.copy(), this.g1.copy(), this.labelMergeStrategy);
    }

    public UnionArcLabelledImmutableGraph(ArcLabelledImmutableGraph g0, ArcLabelledImmutableGraph g1, LabelMergeStrategy labelMergeStrategy) {
        this.g0 = g0;
        this.g1 = g1;
        this.labelMergeStrategy = labelMergeStrategy;
        this.n0 = g0.numNodes();
        this.n1 = g1.numNodes();
        this.numNodes = Math.max(this.n0, this.n1);
        if (g0.prototype().getClass() != g1.prototype().getClass()) {
            throw new IllegalArgumentException("The two graphs have different label classes (" + g0.prototype().getClass().getSimpleName() + ", " + g1.prototype().getClass().getSimpleName() + ")");
        }
        this.prototype = g0.prototype();
    }

    @Override
    public ArcLabelledNodeIterator nodeIterator(final long from) {
        return new ArcLabelledNodeIterator(){
            private long[][] cache = LongBigArrays.EMPTY_BIG_ARRAY;
            private Label[][] labelCache = new Label[0][0];
            private long outdegree = -1L;
            private ArcLabelledNodeIterator i0 = from < UnionArcLabelledImmutableGraph.access$000(UnionArcLabelledImmutableGraph.this) ? UnionArcLabelledImmutableGraph.access$100(UnionArcLabelledImmutableGraph.this).nodeIterator(from) : null;
            private ArcLabelledNodeIterator i1 = from < UnionArcLabelledImmutableGraph.access$200(UnionArcLabelledImmutableGraph.this) ? UnionArcLabelledImmutableGraph.access$300(UnionArcLabelledImmutableGraph.this).nodeIterator(from) : null;

            public boolean hasNext() {
                return this.i0 != null && this.i0.hasNext() || this.i1 != null && this.i1.hasNext();
            }

            public long nextLong() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.outdegree = -1L;
                long result = -1L;
                if (this.i0 != null) {
                    if (this.i0.hasNext()) {
                        result = this.i0.nextLong();
                    } else {
                        this.i0 = null;
                    }
                }
                if (this.i1 != null) {
                    if (this.i1.hasNext()) {
                        result = this.i1.nextLong();
                    } else {
                        this.i1 = null;
                    }
                }
                return result;
            }

            @Override
            public long[][] successorBigArray() {
                if (this.outdegree != -1L) {
                    return this.cache;
                }
                if (this.i0 == null) {
                    this.outdegree = this.i1.outdegree();
                    this.cache = this.i1.successorBigArray();
                    this.labelCache = this.i1.labelBigArray();
                    return this.cache;
                }
                if (this.i1 == null) {
                    this.outdegree = this.i0.outdegree();
                    this.cache = this.i0.successorBigArray();
                    this.labelCache = this.i0.labelBigArray();
                    return this.cache;
                }
                ArcLabelledNodeIterator.LabelledArcIterator succ0 = this.i0.successors();
                ArcLabelledNodeIterator.LabelledArcIterator succ1 = this.i1.successors();
                long s0 = -1L;
                long s1 = -1L;
                Label l0 = null;
                Label l1 = null;
                this.outdegree = 0L;
                while ((s0 != -1L || (s0 = succ0.nextLong()) != -1L) | (s1 != -1L || (s1 = succ1.nextLong()) != -1L)) {
                    if (s0 != -1L) {
                        l0 = succ0.label().copy();
                    }
                    if (s1 != -1L) {
                        l1 = succ1.label().copy();
                    }
                    assert (s0 >= 0L || s1 >= 0L);
                    this.cache = LongBigArrays.grow((long[][])this.cache, (long)(this.outdegree + 1L));
                    this.labelCache = (Label[][])ObjectBigArrays.grow((Object[][])this.labelCache, (long)(this.outdegree + 1L));
                    if (s1 < 0L || 0L <= s0 && s0 < s1) {
                        LongBigArrays.set((long[][])this.cache, (long)this.outdegree, (long)s0);
                        ObjectBigArrays.set((Object[][])this.labelCache, (long)this.outdegree, (Object)l0);
                        s0 = -1L;
                    } else if (s0 < 0L || 0L <= s1 && s1 < s0) {
                        LongBigArrays.set((long[][])this.cache, (long)this.outdegree, (long)s1);
                        ObjectBigArrays.set((Object[][])this.labelCache, (long)this.outdegree, (Object)l1);
                        s1 = -1L;
                    } else {
                        assert (s0 == s1 && s0 >= 0L);
                        LongBigArrays.set((long[][])this.cache, (long)this.outdegree, (long)s0);
                        ObjectBigArrays.set((Object[][])this.labelCache, (long)this.outdegree, (Object)UnionArcLabelledImmutableGraph.this.labelMergeStrategy.merge(l0, l1));
                        s1 = -1L;
                        s0 = -1L;
                    }
                    ++this.outdegree;
                }
                return this.cache;
            }

            @Override
            public long outdegree() {
                this.successorBigArray();
                return this.outdegree;
            }

            @Override
            public Label[][] labelBigArray() {
                this.successorBigArray();
                return this.labelCache;
            }

            @Override
            public ArcLabelledNodeIterator.LabelledArcIterator successors() {
                this.successorBigArray();
                return new ArcLabelledNodeIterator.LabelledArcIterator(){
                    long nextToBeReturned = 0L;

                    @Override
                    public Label label() {
                        return (Label)ObjectBigArrays.get((Object[][])labelCache, (long)(this.nextToBeReturned - 1L));
                    }

                    @Override
                    public long nextLong() {
                        if (this.nextToBeReturned == outdegree) {
                            return -1L;
                        }
                        return LongBigArrays.get((long[][])cache, (long)this.nextToBeReturned++);
                    }

                    @Override
                    public long skip(long x) {
                        long skipped = Math.min(x, outdegree - this.nextToBeReturned);
                        this.nextToBeReturned += skipped;
                        return skipped;
                    }
                };
            }
        };
    }

    @Override
    public long numNodes() {
        return this.numNodes;
    }

    @Override
    public boolean randomAccess() {
        return this.g0.randomAccess() && this.g1.randomAccess();
    }

    @Override
    public long[][] successorBigArray(long x) {
        if (x == -1L) {
            return this.cache;
        }
        ArcLabelledNodeIterator.LabelledArcIterator succ0 = x < this.n0 ? this.g0.successors(x) : ObjectIterators.EMPTY_ITERATOR;
        ArcLabelledNodeIterator.LabelledArcIterator succ1 = x < this.n1 ? this.g1.successors(x) : ObjectIterators.EMPTY_ITERATOR;
        long outdegree = 0L;
        long s0 = -1L;
        long s1 = -1L;
        Label l0 = null;
        Label l1 = null;
        while ((s0 != -1L || (s0 = succ0.nextLong()) != -1L) | (s1 != -1L || (s1 = succ1.nextLong()) != -1L)) {
            if (s0 != -1L) {
                l0 = succ0.label().copy();
            }
            if (s1 != -1L) {
                l1 = succ1.label().copy();
            }
            assert (s0 >= 0L || s1 >= 0L);
            this.cache = LongBigArrays.grow((long[][])this.cache, (long)(outdegree + 1L));
            this.labelCache = (Label[][])ObjectBigArrays.grow((Object[][])this.labelCache, (long)(outdegree + 1L));
            if (s1 < 0L || 0L <= s0 && s0 < s1) {
                LongBigArrays.set((long[][])this.cache, (long)outdegree, (long)s0);
                ObjectBigArrays.set((Object[][])this.labelCache, (long)outdegree, (Object)l0);
                s0 = -1L;
            } else if (s0 < 0L || 0L <= s1 && s1 < s0) {
                LongBigArrays.set((long[][])this.cache, (long)outdegree, (long)s1);
                ObjectBigArrays.set((Object[][])this.labelCache, (long)outdegree, (Object)l1);
                s1 = -1L;
            } else {
                assert (s0 == s1 && s0 >= 0L);
                LongBigArrays.set((long[][])this.cache, (long)outdegree, (long)s0);
                ObjectBigArrays.set((Object[][])this.labelCache, (long)outdegree, (Object)this.labelMergeStrategy.merge(l0, l1));
                s1 = -1L;
                s0 = -1L;
            }
            ++outdegree;
        }
        return this.cache;
    }

    @Override
    public long outdegree(long x) {
        this.successorBigArray(x);
        return this.outdegree;
    }

    @Override
    public Label[][] labelBigArray(long x) {
        this.successorBigArray(x);
        return this.labelCache;
    }

    @Override
    public ArcLabelledNodeIterator.LabelledArcIterator successors(long x) {
        this.successorBigArray(x);
        return new ArcLabelledNodeIterator.LabelledArcIterator(){
            long nextToBeReturned = 0L;

            @Override
            public Label label() {
                return (Label)ObjectBigArrays.get((Object[][])UnionArcLabelledImmutableGraph.this.labelCache, (long)this.nextToBeReturned);
            }

            @Override
            public long nextLong() {
                if (this.nextToBeReturned == (long)UnionArcLabelledImmutableGraph.this.outdegree) {
                    return -1L;
                }
                return LongBigArrays.get((long[][])UnionArcLabelledImmutableGraph.this.cache, (long)this.nextToBeReturned++);
            }

            @Override
            public long skip(long x) {
                long skipped = Math.min(x, (long)UnionArcLabelledImmutableGraph.this.outdegree - this.nextToBeReturned);
                this.nextToBeReturned += skipped;
                return skipped;
            }
        };
    }

    @Override
    public Label prototype() {
        return this.prototype;
    }

    static /* synthetic */ long access$000(UnionArcLabelledImmutableGraph x0) {
        return x0.n0;
    }

    static /* synthetic */ ArcLabelledImmutableGraph access$100(UnionArcLabelledImmutableGraph x0) {
        return x0.g0;
    }

    static /* synthetic */ long access$200(UnionArcLabelledImmutableGraph x0) {
        return x0.n1;
    }

    static /* synthetic */ ArcLabelledImmutableGraph access$300(UnionArcLabelledImmutableGraph x0) {
        return x0.g1;
    }
}

