/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import com.google.common.base.Charsets;
import com.google.common.net.InternetDomainName;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.BufferedReader;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildHostMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildHostMap.class);
    public static final Pattern DOTTED_ADDRESS = Pattern.compile("(([0-9A-Fa-f]+[:])*[0-9A-Fa-f]+)|((((0x[0-9A-Fa-f]+)|([0-9]+))\\.)*((0x[0-9A-Fa-f]+)|([0-9]+)))");

    public static void run(BufferedReader br, PrintStream hosts, DataOutputStream mapDos, DataOutputStream countDos, boolean topPrivateDomain, ProgressLogger pl) throws IOException, URISyntaxException {
        String s;
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        long[] count = new long[1024];
        map.defaultReturnValue(-1);
        int hostIndex = -1;
        if (pl != null) {
            pl.start((CharSequence)"Reading URLS...");
        }
        while ((s = br.readLine()) != null) {
            InternetDomainName idn;
            URI uri = new URI(s);
            String name = uri.getHost();
            if (name == null) {
                throw new IllegalArgumentException();
            }
            if (topPrivateDomain && !DOTTED_ADDRESS.matcher(name).matches() && (idn = InternetDomainName.from((String)name)).isUnderPublicSuffix()) {
                name = idn.topPrivateDomain().toString();
            }
            if ((hostIndex = map.getInt((Object)name)) == -1) {
                hosts.println(name);
                hostIndex = map.size();
                map.put((Object)name, hostIndex);
            }
            mapDos.writeLong(hostIndex);
            count = LongArrays.grow((long[])count, (int)(hostIndex + 1));
            int n = hostIndex;
            count[n] = count[n] + 1L;
            if (pl == null) continue;
            pl.lightUpdate();
        }
        BinIO.storeLongs((long[])count, (int)0, (int)map.size(), (DataOutput)countDos);
        if (pl != null) {
            pl.done();
        }
    }

    public static void main(String[] arg) throws IOException, JSAPException, URISyntaxException {
        SimpleJSAP jsap = new SimpleJSAP(BuildHostMap.class.getName(), "Reads a list of URLs from standard input, computes the host map and counts and saves the host list to standard output.", new Parameter[]{new Switch("topPrivateDomain", 't', "top-private-domain", "Use top private domains instead of hosts."), new UnflaggedOption("map", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where the host map will be stored as a list of longs in DataOutput format."), new UnflaggedOption("counts", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename where the host count will be stored as a list of longs in DataOutput format.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        BufferedReader fbr = new BufferedReader(new InputStreamReader(System.in, Charsets.ISO_8859_1));
        DataOutputStream mapDos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(jsapResult.getString("map"))));
        DataOutputStream countDos = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(jsapResult.getString("counts"))));
        BuildHostMap.run(fbr, System.out, mapDos, countDos, jsapResult.getBoolean("topPrivateDomain"), new ProgressLogger(LOGGER));
        mapDos.close();
        countDos.close();
    }
}

