/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.NoSuchElementException;

public class LazyLongIterators {
    public static final LazyLongIterator EMPTY_ITERATOR = new LazyLongIterator(){

        @Override
        public long nextLong() {
            return -1L;
        }

        @Override
        public long skip(long n) {
            return 0L;
        }
    };

    protected LazyLongIterators() {
    }

    public static int unwrap(LazyLongIterator lazyLongIterator, long[] array) {
        long t;
        int j;
        int l = array.length;
        for (j = 0; j < l && (t = lazyLongIterator.nextLong()) != -1L; ++j) {
            array[j] = t;
        }
        return j;
    }

    public static int unwrap(LazyLongIterator lazyLongIterator, long[] array, int offset, int length) {
        long t;
        int j;
        int l = Math.min(length, array.length - offset);
        for (j = 0; j < l && (t = lazyLongIterator.nextLong()) != -1L; ++j) {
            array[offset + j] = t;
        }
        return j;
    }

    public static long unwrap(LazyLongIterator lazyLongIterator, long[][] array) {
        long t;
        long j;
        long l = BigArrays.length((long[][])array);
        for (j = 0L; j < l && (t = lazyLongIterator.nextLong()) != -1L; ++j) {
            BigArrays.set((long[][])array, (long)j, (long)t);
        }
        return j;
    }

    public static long unwrap(LazyLongIterator lazyLongIterator, long[][] array, long offset, long length) {
        long t;
        long j;
        long l = Math.min(length, BigArrays.length((long[][])array) - offset);
        for (j = 0L; j < l && (t = lazyLongIterator.nextLong()) != -1L; ++j) {
            BigArrays.set((long[][])array, (long)(offset + j), (long)t);
        }
        return j;
    }

    public static long[][] unwrap(LazyLongIterator lazyLongIterator) {
        long t;
        long[][] array = LongBigArrays.newBigArray((long)16L);
        int j = 0;
        while ((t = lazyLongIterator.nextLong()) != -1L) {
            if ((long)j == BigArrays.length((long[][])array)) {
                array = BigArrays.grow((long[][])array, (long)(j + 1));
            }
            BigArrays.set((long[][])array, (long)j++, (long)t);
        }
        return BigArrays.trim((long[][])array, (long)j);
    }

    public static long[][] unwrapLoosely(LazyLongIterator lazyLongIterator) {
        long t;
        long[][] array = LongBigArrays.newBigArray((long)16L);
        int j = 0;
        while ((t = lazyLongIterator.nextLong()) != -1L) {
            if ((long)j == BigArrays.length((long[][])array)) {
                array = BigArrays.grow((long[][])array, (long)(j + 1));
            }
            BigArrays.set((long[][])array, (long)j++, (long)t);
        }
        return array;
    }

    public static LazyLongIterator wrap(long[] array, int length) {
        if (length == 0) {
            return EMPTY_ITERATOR;
        }
        return new ArrayLazyLongIterator(array, length);
    }

    public static LazyLongIterator wrap(long[][] array, long length) {
        if (length == 0L) {
            return EMPTY_ITERATOR;
        }
        return new BigArrayLazyLongIterator(array, length);
    }

    public static LazyLongIterator wrap(long[] array) {
        return LazyLongIterators.wrap(array, array.length);
    }

    public static LazyLongIterator wrap(long[][] array) {
        return LazyLongIterators.wrap(array, BigArrays.length((long[][])array));
    }

    public static LongIterator eager(LazyLongIterator lazyLongIterator) {
        return new LazyToEagerLongIterator(lazyLongIterator);
    }

    public static LazyLongIterator lazy(LongIterator eagerLongIterator) {
        return new EagerToLazyLongIterator(eagerLongIterator);
    }

    private static final class ArrayLazyLongIterator
    implements LazyLongIterator {
        private final long[] a;
        private final int length;
        private int pos;

        public ArrayLazyLongIterator(long[] a, int length) {
            this.a = a;
            this.length = length;
        }

        @Override
        public long nextLong() {
            if (this.pos == this.length) {
                return -1L;
            }
            return this.a[this.pos++];
        }

        @Override
        public long skip(long n) {
            long toSkip = Math.min(n, (long)(this.length - this.pos));
            this.pos = (int)((long)this.pos + toSkip);
            return toSkip;
        }
    }

    private static final class BigArrayLazyLongIterator
    implements LazyLongIterator {
        private final long[][] a;
        private final long length;
        private long pos;

        public BigArrayLazyLongIterator(long[][] a, long length) {
            this.a = a;
            this.length = length;
        }

        @Override
        public long nextLong() {
            if (this.pos == this.length) {
                return -1L;
            }
            return BigArrays.get((long[][])this.a, (long)this.pos++);
        }

        @Override
        public long skip(long n) {
            long toSkip = Math.min(n, this.length - this.pos);
            this.pos += toSkip;
            return toSkip;
        }
    }

    private static final class LazyToEagerLongIterator
    implements LongIterator {
        private final LazyLongIterator lazyLongIterator;
        private boolean advanced;
        private long next;

        public LazyToEagerLongIterator(LazyLongIterator lazyLongIterator) {
            this.lazyLongIterator = lazyLongIterator;
        }

        public boolean hasNext() {
            if (!this.advanced) {
                this.advanced = true;
                this.next = this.lazyLongIterator.nextLong();
            }
            return this.next != -1L;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.advanced = false;
            return this.next;
        }

        public int skip(int n) {
            if (n == 0) {
                return 0;
            }
            int increment = this.advanced ? 1 : 0;
            this.advanced = false;
            return (int)(this.lazyLongIterator.skip(n - increment) + (long)increment);
        }
    }

    private static final class EagerToLazyLongIterator
    implements LazyLongIterator {
        private final LongIterator underlying;

        public EagerToLazyLongIterator(LongIterator underlying) {
            this.underlying = underlying;
        }

        @Override
        public long nextLong() {
            return this.underlying.hasNext() ? this.underlying.nextLong() : -1L;
        }

        @Override
        public long skip(long n) {
            long t = 0L;
            while (n > 0L) {
                int actual = (int)Math.min(n, 0x40000000L);
                t += (long)this.underlying.skip(actual);
                n -= (long)actual;
            }
            return t;
        }
    }
}

