/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.LazyLongIterator;

public class MaskedLongIterator
implements LazyLongIterator {
    private final LazyLongIterator underlying;
    private final long[] mask;
    private final int maskLen;
    private int currMask;
    private long left;

    public MaskedLongIterator(long[] mask, LazyLongIterator underlying) {
        this(mask, mask == null ? 0 : mask.length, underlying);
    }

    public MaskedLongIterator(long[] mask, int maskLen, LazyLongIterator underlying) {
        this.mask = mask;
        this.maskLen = maskLen;
        this.underlying = underlying;
        if (maskLen != 0) {
            this.left = mask[this.currMask++];
            this.advance();
        } else {
            this.left = -1L;
        }
    }

    @Override
    public long nextLong() {
        if (this.left == 0L) {
            return -1L;
        }
        long next = this.underlying.nextLong();
        if (this.left == -1L || next == -1L) {
            return next;
        }
        if (this.left > 0L) {
            --this.left;
            this.advance();
        }
        return next;
    }

    private void advance() {
        assert (this.left != -1L);
        if (this.left == 0L && this.currMask < this.maskLen) {
            this.underlying.skip(this.mask[this.currMask++]);
            this.left = this.currMask < this.maskLen ? this.mask[this.currMask++] : -1L;
        }
    }

    @Override
    public long skip(long n) {
        int skipped = 0;
        while ((long)skipped < n && this.left != 0L) {
            if (this.left == -1L) {
                long result = this.underlying.skip(n - (long)skipped);
                if ((long)(skipped = (int)((long)skipped + result)) >= n) continue;
                break;
            }
            if (n - (long)skipped < this.left) {
                this.underlying.skip(n - (long)skipped);
                this.left -= n - (long)skipped;
                return n;
            }
            this.underlying.skip(this.left);
            skipped = (int)((long)skipped + this.left);
            this.left = 0L;
            this.advance();
        }
        return skipped;
    }
}

