/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.algo;

import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.sux4j.bits.SimpleSelectZero;

public final class EliasFanoCumulativeOutdegreeList {
    private final int l;
    private final long roundingMask;
    private final long[] upperBits;
    private final LongBigList lowerBits;
    private final long numNodes;
    private long window;
    private int curr;
    private long currentIndex;
    private final SimpleSelectZero simpleSelectZero;

    public EliasFanoCumulativeOutdegreeList(ImmutableGraph graph) {
        this(graph, graph.numArcs());
    }

    public EliasFanoCumulativeOutdegreeList(ImmutableGraph graph, long numArcs) {
        this(graph, numArcs, 0L);
    }

    public EliasFanoCumulativeOutdegreeList(ImmutableGraph graph, long numArcs, long roundingMask) {
        if (roundingMask + 1L != Long.highestOneBit(roundingMask + 1L)) {
            throw new IllegalArgumentException("Illegal rounding mask: " + roundingMask);
        }
        this.roundingMask = roundingMask;
        long length = this.numNodes = graph.numNodes();
        long upperBound = numArcs;
        this.l = length == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(upperBound / length)));
        long lowerBitsMask = (1L << this.l) - 1L;
        LongBigList lowerBitsList = LongArrayBitVector.getInstance().asLongBigList(this.l);
        lowerBitsList.size(length);
        LongArrayBitVector upperBitsVector = LongArrayBitVector.getInstance().length(length + (upperBound >>> this.l) + 1L);
        long v = 0L;
        for (long i = 0L; i < length; ++i) {
            if ((v += graph.outdegree(i)) > upperBound) {
                throw new IllegalArgumentException("Too large value: " + v + " > " + upperBound);
            }
            if (this.l != 0) {
                lowerBitsList.set(i, v & lowerBitsMask);
            }
            upperBitsVector.set((v >>> this.l) + i);
        }
        this.lowerBits = lowerBitsList;
        this.upperBits = upperBitsVector.bits();
        this.simpleSelectZero = new SimpleSelectZero((BitVector)upperBitsVector);
        this.currentIndex = -1L;
    }

    private long getNextUpperBits() {
        assert (this.currentIndex < this.numNodes);
        while (this.window == 0L) {
            this.window = this.upperBits[++this.curr];
        }
        long upperBits = (long)this.curr * 64L + (long)Long.numberOfTrailingZeros(this.window) - this.currentIndex++;
        this.window &= this.window - 1L;
        return upperBits;
    }

    public long currentIndex() {
        return this.currentIndex;
    }

    public long skipTo(long lowerBound) {
        long lower;
        long last;
        long zeroesToSkip = (lowerBound >>> this.l) - 1L;
        long position = zeroesToSkip == -1L ? 0L : this.simpleSelectZero.selectZero(zeroesToSkip);
        this.curr = LongArrayBitVector.word((long)position);
        this.window = this.upperBits[this.curr];
        this.window &= -1L << (int)(position % 64L);
        this.currentIndex = zeroesToSkip == -1L ? 0L : position - zeroesToSkip;
        do {
            lower = this.lowerBits.getLong(this.currentIndex);
        } while (((last = this.getNextUpperBits() << this.l | lower) < lowerBound || (this.currentIndex & this.roundingMask) != 0L) && this.currentIndex != this.numNodes);
        return last;
    }
}

