/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.algo;

import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.longs.LongBigArrayBigList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.logging.ProgressLogger;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class ParallelBreadthFirstVisit {
    public final ImmutableGraph graph;
    public final LongBigArrayBigList queue;
    public final LongBigArrayBigList cutPoints;
    public final boolean parent;
    public final AtomicLongArray[] marker;
    private final ProgressLogger pl;
    private final int numberOfThreads;
    private final AtomicLong progress;
    private final AtomicLong nextPosition;
    private volatile boolean completed;
    private volatile CyclicBarrier barrier;
    private volatile Throwable threadThrowable;
    public long round;

    public ParallelBreadthFirstVisit(ImmutableGraph graph, int requestedThreads, boolean parent, ProgressLogger pl) {
        this.graph = graph;
        this.parent = parent;
        this.pl = pl;
        this.queue = new LongBigArrayBigList(graph.numNodes());
        this.progress = new AtomicLong();
        this.nextPosition = new AtomicLong();
        this.cutPoints = new LongBigArrayBigList();
        this.numberOfThreads = requestedThreads != 0 ? requestedThreads : Runtime.getRuntime().availableProcessors();
        this.marker = new AtomicLongArray[(int)(graph.numNodes() + 0x8000000L - 1L >>> 27)];
        if ((graph.numNodes() & 0x7FFFFFFL) != 0L) {
            this.marker[this.marker.length - 1] = new AtomicLongArray((int)(graph.numNodes() & 0x7FFFFFFL));
            int i = this.marker.length - 1;
            while (i-- != 0) {
                this.marker[i] = new AtomicLongArray(0x8000000);
            }
        } else {
            int i = this.marker.length;
            while (i-- != 0) {
                this.marker[i] = new AtomicLongArray(0x8000000);
            }
        }
        this.clear();
    }

    public void clear() {
        this.round = -1L;
        int s = this.marker.length;
        while (s-- != 0) {
            AtomicLongArray t = this.marker[s];
            int d = t.length();
            while (d-- != 0) {
                t.set(d, -1L);
            }
        }
    }

    public long visit(long start) {
        return this.visit(start, -1L);
    }

    public long visit(long start, long expectedSize) {
        if (this.marker[BigArrays.segment((long)start)].get(BigArrays.displacement((long)start)) != -1L) {
            return 0L;
        }
        ++this.round;
        this.completed = false;
        this.queue.clear();
        this.cutPoints.clear();
        this.queue.add(start);
        this.cutPoints.add(0L);
        this.marker[BigArrays.segment((long)start)].set(BigArrays.displacement((long)start), this.parent ? start : this.round);
        IterationThread[] thread = new IterationThread[this.numberOfThreads];
        int i = thread.length;
        while (i-- != 0) {
            thread[i] = new IterationThread();
        }
        this.progress.set(0L);
        if (this.pl != null) {
            this.pl.start((CharSequence)"Starting visit...");
            this.pl.expectedUpdates = expectedSize != -1L ? expectedSize : this.graph.numNodes();
            this.pl.itemsName = "nodes";
        }
        this.barrier = new CyclicBarrier(this.numberOfThreads, () -> {
            if (this.pl != null) {
                this.pl.set(this.progress.get());
            }
            if (this.queue.size64() == this.cutPoints.getLong(this.cutPoints.size64() - 1L)) {
                this.completed = true;
                return;
            }
            this.cutPoints.add(this.queue.size64());
            this.nextPosition.set(0L);
        });
        i = thread.length;
        while (i-- != 0) {
            thread[i].start();
        }
        i = thread.length;
        while (i-- != 0) {
            try {
                thread[i].join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.threadThrowable != null) {
            throw new RuntimeException(this.threadThrowable);
        }
        if (this.pl != null) {
            this.pl.done();
        }
        return this.queue.size64();
    }

    public void visitAll() {
        IterationThread[] thread = new IterationThread[this.numberOfThreads];
        int i = thread.length;
        while (i-- != 0) {
            thread[i] = new IterationThread();
        }
        final long n = this.graph.numNodes();
        this.completed = false;
        this.clear();
        this.queue.clear();
        this.cutPoints.clear();
        this.progress.set(0L);
        if (this.pl != null) {
            this.pl.start((CharSequence)"Starting visits...");
            this.pl.expectedUpdates = this.graph.numNodes();
            this.pl.displayLocalSpeed = true;
            this.pl.itemsName = "nodes";
        }
        this.barrier = new CyclicBarrier(this.numberOfThreads, new Runnable(){
            long curr = -1L;

            @Override
            public void run() {
                if (ParallelBreadthFirstVisit.this.pl != null) {
                    ParallelBreadthFirstVisit.this.pl.set(ParallelBreadthFirstVisit.this.progress.get());
                }
                if (this.curr == -1L || ParallelBreadthFirstVisit.this.queue.size64() == ParallelBreadthFirstVisit.this.cutPoints.getLong(ParallelBreadthFirstVisit.this.cutPoints.size64() - 1L)) {
                    if (ParallelBreadthFirstVisit.this.pl != null) {
                        ParallelBreadthFirstVisit.this.pl.set(ParallelBreadthFirstVisit.this.progress.get());
                    }
                    while (true) {
                        if (++this.curr < n && ParallelBreadthFirstVisit.this.marker[BigArrays.segment((long)this.curr)].get(BigArrays.displacement((long)this.curr)) != -1L) {
                            continue;
                        }
                        if (this.curr == n) {
                            ParallelBreadthFirstVisit.this.completed = true;
                            return;
                        }
                        ++ParallelBreadthFirstVisit.this.round;
                        ParallelBreadthFirstVisit.this.marker[BigArrays.segment((long)this.curr)].set(BigArrays.displacement((long)this.curr), ParallelBreadthFirstVisit.this.parent ? this.curr : ParallelBreadthFirstVisit.this.round);
                        long d = ParallelBreadthFirstVisit.this.graph.outdegree(this.curr);
                        if (d != 0L && (d != 1L || ParallelBreadthFirstVisit.this.graph.successors(this.curr).nextLong() != this.curr)) break;
                    }
                    ParallelBreadthFirstVisit.this.queue.clear();
                    ParallelBreadthFirstVisit.this.queue.add(this.curr);
                    ParallelBreadthFirstVisit.this.cutPoints.clear();
                    ParallelBreadthFirstVisit.this.cutPoints.add(0L);
                }
                ParallelBreadthFirstVisit.this.cutPoints.add(ParallelBreadthFirstVisit.this.queue.size64());
                ParallelBreadthFirstVisit.this.nextPosition.set(0L);
            }
        });
        int i2 = thread.length;
        while (i2-- != 0) {
            thread[i2].start();
        }
        i2 = thread.length;
        while (i2-- != 0) {
            try {
                thread[i2].join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.threadThrowable != null) {
            throw new RuntimeException(this.threadThrowable);
        }
        if (this.pl != null) {
            this.pl.done();
        }
    }

    public long nodeAtMaxDistance() {
        return this.queue.getLong(this.queue.size64() - 1L);
    }

    public long maxDistance() {
        return this.cutPoints.size64() - 2L;
    }

    private final class IterationThread
    extends Thread {
        private static final int GRANULARITY = 1000;

        private IterationThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                AtomicLongArray[] marker = ParallelBreadthFirstVisit.this.marker;
                ImmutableGraph graph = ParallelBreadthFirstVisit.this.graph.copy();
                boolean parent = ParallelBreadthFirstVisit.this.parent;
                block4: while (true) {
                    ParallelBreadthFirstVisit.this.barrier.await();
                    if (ParallelBreadthFirstVisit.this.completed) {
                        return;
                    }
                    LongBigArrayBigList out = new LongBigArrayBigList();
                    long first = ParallelBreadthFirstVisit.this.cutPoints.getLong(ParallelBreadthFirstVisit.this.cutPoints.size64() - 2L);
                    long last = ParallelBreadthFirstVisit.this.cutPoints.getLong(ParallelBreadthFirstVisit.this.cutPoints.size64() - 1L);
                    long mark = ParallelBreadthFirstVisit.this.round;
                    while (true) {
                        long start;
                        if ((start = first + ParallelBreadthFirstVisit.this.nextPosition.getAndAdd(1000L)) >= last) {
                            ParallelBreadthFirstVisit.this.nextPosition.getAndAdd(-1000L);
                            continue block4;
                        }
                        long end = Math.min(last, start + 1000L);
                        out.clear();
                        for (long pos = start; pos < end; ++pos) {
                            long s;
                            long curr = ParallelBreadthFirstVisit.this.queue.getLong(pos);
                            if (parent) {
                                mark = curr;
                            }
                            LazyLongIterator successors = graph.successors(curr);
                            while ((s = successors.nextLong()) != -1L) {
                                if (!marker[BigArrays.segment((long)s)].compareAndSet(BigArrays.displacement((long)s), -1L, mark)) continue;
                                out.add(s);
                            }
                        }
                        ParallelBreadthFirstVisit.this.progress.addAndGet(end - start);
                        if (out.isEmpty()) continue;
                        LongBigArrayBigList longBigArrayBigList = ParallelBreadthFirstVisit.this.queue;
                        synchronized (longBigArrayBigList) {
                            ParallelBreadthFirstVisit.this.queue.addAll((LongBigList)out);
                        }
                    }
                    break;
                }
            }
            catch (Throwable t) {
                ParallelBreadthFirstVisit.this.threadThrowable = t;
                return;
            }
        }
    }
}

