/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import com.google.common.base.Charsets;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.big.webgraph.GraphClassParser;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.LongBigArrayBigList;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASCIIGraph
extends ImmutableSequentialGraph {
    private static final String ASCII_GRAPH_EXTENSION = ".graph-txt";
    private static final Logger LOGGER = LoggerFactory.getLogger(ASCIIGraph.class);
    private final long n;
    private final CharSequence graphFile;
    private final FastBufferedReader fbr;

    protected ASCIIGraph(CharSequence graphFile) throws NumberFormatException, IOException {
        this.graphFile = graphFile;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(graphFile.toString() + ASCII_GRAPH_EXTENSION));
        this.n = Long.parseLong(bufferedReader.readLine());
        bufferedReader.close();
        this.fbr = null;
        if (this.n < 0L) {
            throw new IllegalArgumentException("Number of nodes must be nonnegative");
        }
    }

    public ASCIIGraph(InputStream is) throws NumberFormatException, IOException {
        this.graphFile = null;
        this.fbr = new FastBufferedReader((Reader)new InputStreamReader(is, "ASCII"));
        this.n = Long.parseLong(this.fbr.readLine(new MutableString()).toString());
        if (this.n < 0L) {
            throw new IllegalArgumentException("Number of nodes must be nonnegative");
        }
    }

    @Override
    public long numNodes() {
        return this.n;
    }

    @Override
    public NodeIterator nodeIterator(final long from) {
        if (from < 0L || from > this.n) {
            throw new IllegalArgumentException();
        }
        try {
            FastBufferedReader fbr = this.fbr != null ? this.fbr : new FastBufferedReader((Reader)new FileReader(this.graphFile + ASCII_GRAPH_EXTENSION));
            MutableString s = new MutableString();
            long i = from + (long)(this.fbr != null ? 0 : 1);
            while (i-- != 0L) {
                fbr.readLine(s);
            }
            final StreamTokenizer st = new StreamTokenizer((Reader)fbr);
            st.eolIsSignificant(true);
            st.parseNumbers();
            return new NodeIterator(){
                long i;
                LongBigArrayBigList successors;
                {
                    this.i = from;
                    this.successors = new LongBigArrayBigList();
                }

                public boolean hasNext() {
                    return this.i < ASCIIGraph.this.n;
                }

                @Override
                public long[][] successorBigArray() {
                    return this.successors.elements();
                }

                public long nextLong() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.successors.clear();
                    try {
                        int tokenType;
                        do {
                            if ((tokenType = st.nextToken()) == -2) {
                                long dep = (long)st.nval;
                                this.successors.add(dep);
                                if (dep >= 0L && dep < ASCIIGraph.this.n) continue;
                                throw new IOException("The value " + dep + " is not a node index at line " + st.lineno());
                            }
                            if (tokenType == 10) continue;
                            throw new IOException("Unexpected token " + st.toString());
                        } while (tokenType != 10);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return this.i++;
                }

                @Override
                public long outdegree() {
                    return this.successors.size64();
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return ASCIIGraph.loadOffline(basename);
    }

    @Deprecated
    public static ASCIIGraph loadSequential(CharSequence basename, ProgressLogger unused) throws IOException {
        return ASCIIGraph.loadOffline(basename, unused);
    }

    public static ASCIIGraph loadOffline(CharSequence basename) throws IOException {
        return ASCIIGraph.loadOffline(basename, null);
    }

    public static ASCIIGraph loadOffline(CharSequence basename, ProgressLogger unused) throws IOException {
        return new ASCIIGraph(basename);
    }

    public static ASCIIGraph loadMapped(CharSequence basename) throws IOException {
        return ASCIIGraph.loadOffline(basename);
    }

    public static ASCIIGraph loadMapped(CharSequence basename, ProgressLogger unused) throws IOException {
        return ASCIIGraph.loadOffline(basename);
    }

    public static ASCIIGraph loadOnce(InputStream is) throws IOException {
        return new ASCIIGraph(is);
    }

    public static ImmutableGraph load(CharSequence basename) throws IOException {
        return ASCIIGraph.load(basename, null);
    }

    public static ImmutableGraph load(CharSequence basename, ProgressLogger unused) throws IOException {
        return ImmutableGraph.wrap(new ArrayListMutableGraph(ImmutableGraph.wrap(ASCIIGraph.loadOffline(basename))).immutableView());
    }

    public static void store(ImmutableGraph graph, CharSequence basename, ProgressLogger unused) throws IOException {
        ASCIIGraph.store(graph, basename);
    }

    public static void store(ImmutableGraph graph, CharSequence basename) throws IOException {
        PrintStream ps = new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename + ASCII_GRAPH_EXTENSION)), false, Charsets.US_ASCII.toString());
        long n = graph.numNodes();
        ps.println(n);
        NodeIterator nodeIterator = graph.nodeIterator();
        while (nodeIterator.hasNext()) {
            nodeIterator.nextLong();
            long d = nodeIterator.outdegree();
            LazyLongIterator successors = nodeIterator.successors();
            while (d-- != 0L) {
                ps.print(successors.nextLong() + " ");
            }
            ps.println();
        }
        ps.close();
    }

    public static void main(String[] args) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException, ClassNotFoundException, InstantiationException {
        SimpleJSAP jsap = new SimpleJSAP(ASCIIGraph.class.getName(), "Reads a graph with a given basename, or a given spec, and writes it out in ASCII format with another basename", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph"), new Switch("spec", 's', "spec", "The source is not a basename but rather a spec of the form ImmutableGraphClass(arg,arg,...)."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("sourceBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the source graph, or a source spec if --spec was given; it is immaterial when --once is specified."), new UnflaggedOption("destBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the destination graph")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            return;
        }
        Class graphClass = jsapResult.getClass("graphClass");
        String sourceBasename = jsapResult.getString("sourceBasename");
        String destBasename = jsapResult.getString("destBasename");
        boolean spec = jsapResult.getBoolean("spec");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        if (graphClass != null && spec) {
            System.err.println("Options --graphClass and --spec are incompatible");
            return;
        }
        ImmutableGraph graph = !spec ? (graphClass != null ? (ImmutableGraph)graphClass.getMethod("loadOffline", CharSequence.class, ProgressLogger.class).invoke(null, sourceBasename, pl) : ImmutableGraph.loadOffline(sourceBasename, pl)) : (ImmutableGraph)ObjectParser.fromSpec((String)sourceBasename, ImmutableGraph.class, (String[])GraphClassParser.PACKAGE);
        ASCIIGraph.store(graph, destBasename);
    }
}

