/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import com.google.common.base.Charsets;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.big.webgraph.GraphClassParser;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.ImmutableSequentialGraph;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.longs.LongBigArrayBigList;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.webgraph.ArrayListMutableGraph;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcListASCIIGraph
extends ImmutableSequentialGraph {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ArcListASCIIGraph.class);
    private long n;
    private final FastBufferedReader fbr;
    private final long shift;

    public ArcListASCIIGraph(InputStream is, int shift) throws NumberFormatException, IOException {
        this.shift = shift;
        this.fbr = new FastBufferedReader((Reader)new InputStreamReader(is, "ASCII"));
        this.n = -1L;
    }

    @Override
    public long numNodes() {
        if (this.n == -1L) {
            throw new UnsupportedOperationException("The number of nodes is unknown (you need to complete a traversal)");
        }
        return this.n;
    }

    @Override
    public NodeIterator nodeIterator(final long from) {
        if (from < 0L) {
            throw new IllegalArgumentException();
        }
        try {
            final StreamTokenizer st = new StreamTokenizer((Reader)this.fbr);
            st.eolIsSignificant(true);
            st.parseNumbers();
            return new NodeIterator(){
                long maxNodeSeen;
                long following = -1L;
                long curr = -1L;
                boolean eof;
                LongBigArrayBigList successors = new LongBigArrayBigList();
                {
                    this.fillNextLine();
                    for (long i = 0L; i < from; ++i) {
                        this.nextLong();
                    }
                }

                private void ensureNumberToken() {
                    if (st.ttype != -2 || st.nval != (double)((long)st.nval)) {
                        throw new IllegalArgumentException("Expected integer, found " + st.toString());
                    }
                    if ((long)st.nval + ArcListASCIIGraph.this.shift < 0L) {
                        throw new IllegalArgumentException("Integer plus shift is negative: " + st.toString());
                    }
                }

                private void fillNextLine() throws IOException {
                    if (this.eof) {
                        return;
                    }
                    this.successors.clear();
                    if (this.following == -1L) {
                        while (st.nextToken() == 10) {
                        }
                        this.ensureNumberToken();
                    }
                    if (this.following > (long)st.nval + ArcListASCIIGraph.this.shift) {
                        throw new IllegalArgumentException("Source nodes must be sorted");
                    }
                    this.following = (long)st.nval + ArcListASCIIGraph.this.shift;
                    if (this.following > this.maxNodeSeen) {
                        this.maxNodeSeen = this.following;
                    }
                    st.nextToken();
                    this.ensureNumberToken();
                    long successor = (long)st.nval + ArcListASCIIGraph.this.shift;
                    this.successors.add(successor);
                    if (successor > this.maxNodeSeen) {
                        this.maxNodeSeen = successor;
                    }
                    st.nextToken();
                    while (true) {
                        int nextToken;
                        if ((nextToken = st.nextToken()) == -1) {
                            this.eof = true;
                            ArcListASCIIGraph.this.n = this.maxNodeSeen + 1L;
                            break;
                        }
                        if (nextToken == 10) continue;
                        this.ensureNumberToken();
                        if ((long)st.nval + ArcListASCIIGraph.this.shift != this.following) {
                            if (this.following > (long)st.nval + ArcListASCIIGraph.this.shift) {
                                throw new IllegalArgumentException("Source nodes must be sorted");
                            }
                            if ((long)st.nval + ArcListASCIIGraph.this.shift <= this.maxNodeSeen) break;
                            this.maxNodeSeen = (long)st.nval + ArcListASCIIGraph.this.shift;
                            break;
                        }
                        st.nextToken();
                        this.ensureNumberToken();
                        successor = (long)st.nval + ArcListASCIIGraph.this.shift;
                        this.successors.add(successor);
                        if (successor > this.maxNodeSeen) {
                            this.maxNodeSeen = successor;
                        }
                        st.nextToken();
                    }
                    LongBigArrays.quickSort((long[][])this.successors.elements(), (long)0L, (long)this.successors.size64());
                }

                public boolean hasNext() {
                    return this.curr < this.maxNodeSeen;
                }

                @Override
                public long[][] successorBigArray() {
                    if (this.curr == -1L) {
                        throw new IllegalStateException();
                    }
                    return this.curr == this.following ? this.successors.elements() : LongBigArrays.EMPTY_BIG_ARRAY;
                }

                public final long nextLong() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    if (++this.curr > this.following) {
                        try {
                            this.fillNextLine();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return this.curr;
                }

                @Override
                public long outdegree() {
                    if (this.curr == -1L) {
                        throw new IllegalStateException();
                    }
                    return this.curr == this.following ? this.successors.size64() : 0L;
                }
            };
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename, ProgressLogger unused) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ImmutableGraph loadOffline(CharSequence basename, ProgressLogger unused) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ImmutableGraph loadMapped(CharSequence basename) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ImmutableGraph loadMapped(CharSequence basename, ProgressLogger unused) throws IOException {
        return ArcListASCIIGraph.load(basename);
    }

    public static ArcListASCIIGraph loadOnce(InputStream is) throws IOException {
        return new ArcListASCIIGraph(is, 0);
    }

    public static ArcListASCIIGraph loadOnce(InputStream is, int shift) throws IOException {
        return new ArcListASCIIGraph(is, shift);
    }

    public static ImmutableGraph load(CharSequence basename) throws IOException {
        return ArcListASCIIGraph.load(basename, null);
    }

    public static ImmutableGraph load(CharSequence basename, ProgressLogger unused) throws IOException {
        return ImmutableGraph.wrap(new ArrayListMutableGraph(ImmutableGraph.wrap(ArcListASCIIGraph.loadOnce((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(basename.toString()))))).immutableView());
    }

    public static void store(ImmutableGraph graph, CharSequence basename, ProgressLogger unused) throws IOException {
        ArcListASCIIGraph.store(graph, basename);
    }

    public static void store(ImmutableGraph graph, CharSequence basename) throws IOException {
        ArcListASCIIGraph.store(graph, basename, 0);
    }

    public static void store(ImmutableGraph graph, CharSequence basename, int shift) throws IOException {
        PrintStream ps = new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename.toString())), false, Charsets.US_ASCII.toString());
        NodeIterator nodeIterator = graph.nodeIterator();
        while (nodeIterator.hasNext()) {
            long s = nodeIterator.nextLong();
            long d = nodeIterator.outdegree();
            long[][] successor = nodeIterator.successorBigArray();
            for (long i = 0L; i < d; ++i) {
                ps.println(s + (long)shift + "\t" + (BigArrays.get((long[][])successor, (long)i) + (long)shift));
            }
        }
        ps.close();
    }

    public static void main(String[] args) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException {
        ImmutableGraph graph;
        SimpleJSAP jsap = new SimpleJSAP(ArcListASCIIGraph.class.getName(), "Reads a graph with a given basename and writes it out in ASCII format with another basename", new Parameter[]{new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph"), new FlaggedOption("shift", (StringParser)JSAP.INTEGER_PARSER, null, false, 'S', "shift", "A shift that will be added to each node index."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("sourceBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the source graph"), new UnflaggedOption("destBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the destination graph")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            return;
        }
        Class graphClass = jsapResult.getClass("graphClass");
        String sourceBasename = jsapResult.getString("sourceBasename");
        String destBasename = jsapResult.getString("destBasename");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        ImmutableGraph immutableGraph = graph = graphClass != null ? (ImmutableGraph)graphClass.getMethod("loadOffline", CharSequence.class, ProgressLogger.class).invoke(null, sourceBasename, pl) : ImmutableGraph.loadOffline(sourceBasename, pl);
        if (jsapResult.userSpecified("shift")) {
            ArcListASCIIGraph.store(graph, (CharSequence)destBasename, jsapResult.getInt("shift"));
        } else {
            ArcListASCIIGraph.store(graph, destBasename);
        }
    }
}

