/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.big.webgraph.AbstractLazyLongIterator;
import it.unimi.dsi.big.webgraph.CompressionFlags;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterators;
import it.unimi.dsi.big.webgraph.LongIntervalSequenceIterator;
import it.unimi.dsi.big.webgraph.MaskedLongIterator;
import it.unimi.dsi.big.webgraph.MergedLongIterator;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastMultiByteArrayInputStream;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.io.ByteBufferInputStream;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.NullOutputStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneBigLongBigList;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import it.unimi.dsi.webgraph.GraphClassParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Formatter;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BVGraph
extends ImmutableGraph
implements CompressionFlags,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BVGraph.class);
    public static final int SEQUENTIAL = 0;
    public static final int OFFLINE = -1;
    public static final String GRAPH_EXTENSION = ".graph";
    public static final String OFFSETS_EXTENSION = ".offsets";
    public static final String OFFSETS_BIG_LIST_EXTENSION = ".obl";
    public static final String OUTDEGREES_EXTENSION = ".outdegrees";
    private static final int STD_BUFFER_SIZE = 0x100000;
    private static final int MULTITHREAD_BUFFER_SIZE = 0x1000000;
    public static final int BVGRAPH_VERSION = 0;
    protected static final int INITIAL_SUCCESSOR_LIST_LENGTH = 1024;
    public static final int NO_INTERVALS = 0;
    protected CharSequence basename;
    protected long n;
    protected long m;
    protected boolean isMemory;
    protected boolean isMapped;
    protected byte[] graphMemory;
    protected FastMultiByteArrayInputStream graphStream;
    protected ByteBufferInputStream mappedGraphStream;
    protected LongBigList offsets;
    protected int offsetType;
    protected transient long cachedNode = Long.MIN_VALUE;
    protected int cachedOutdegree;
    protected long cachedPointer;
    protected int maxRefCount = 3;
    public static final int DEFAULT_MAX_REF_COUNT = 3;
    protected int windowSize = 7;
    public static final int DEFAULT_WINDOW_SIZE = 7;
    protected int minIntervalLength = 4;
    public static final int DEFAULT_MIN_INTERVAL_LENGTH = 4;
    protected int zetaK = 3;
    public static final int DEFAULT_ZETA_K = 3;
    public static final int OUTDEGREES_GAMMA = 2;
    public static final int OUTDEGREES_DELTA = 1;
    public static final int BLOCKS_GAMMA = 32;
    public static final int BLOCKS_DELTA = 16;
    public static final int RESIDUALS_GAMMA = 512;
    public static final int RESIDUALS_ZETA = 1536;
    public static final int RESIDUALS_DELTA = 256;
    public static final int RESIDUALS_NIBBLE = 1792;
    public static final int RESIDUALS_GOLOMB = 768;
    public static final int REFERENCES_GAMMA = 8192;
    public static final int REFERENCES_DELTA = 4096;
    public static final int REFERENCES_UNARY = 20480;
    public static final int BLOCK_COUNT_GAMMA = 131072;
    public static final int BLOCK_COUNT_DELTA = 65536;
    public static final int BLOCK_COUNT_UNARY = 327680;
    public static final int OFFSETS_GAMMA = 0x200000;
    public static final int OFFSETS_DELTA = 0x100000;
    protected int outdegreeCoding = 2;
    protected int blockCoding = 2;
    protected int residualCoding = 6;
    protected int referenceCoding = 5;
    protected int blockCountCoding = 2;
    protected int offsetCoding = 2;
    private int flags = 0;
    private static final boolean STATS = false;
    private static final boolean DEBUG = false;
    private PrintWriter offsetStats;
    private PrintWriter outdegreeStats;
    private PrintWriter blockCountStats;
    private PrintWriter blockStats;
    private PrintWriter intervalCountStats;
    private PrintWriter referenceStats;
    private PrintWriter leftStats;
    private PrintWriter lenStats;
    private PrintWriter residualStats;
    private PrintWriter residualCountStats;
    private transient InputBitStream outdegreeIbs;

    @Override
    public BVGraph copy() {
        BVGraph result = new BVGraph();
        result.basename = this.basename;
        result.n = this.n;
        result.m = this.m;
        result.isMemory = this.isMemory;
        result.isMapped = this.isMapped;
        result.graphMemory = this.graphMemory;
        result.graphStream = this.graphStream != null ? new FastMultiByteArrayInputStream(this.graphStream) : null;
        result.mappedGraphStream = this.mappedGraphStream != null ? this.mappedGraphStream.copy() : null;
        result.offsets = this.offsets;
        result.maxRefCount = this.maxRefCount;
        result.windowSize = this.windowSize;
        result.minIntervalLength = this.minIntervalLength;
        result.offsetType = this.offsetType;
        result.zetaK = this.zetaK;
        result.outdegreeCoding = this.outdegreeCoding;
        result.blockCoding = this.blockCoding;
        result.residualCoding = this.residualCoding;
        result.referenceCoding = this.referenceCoding;
        result.blockCountCoding = this.blockCountCoding;
        result.offsetCoding = this.offsetCoding;
        result.flags = this.flags;
        result.outdegreeIbs = this.offsetType <= 0 ? null : (this.isMemory ? new InputBitStream(this.graphMemory) : new InputBitStream((InputStream)(this.isMapped ? this.mappedGraphStream.copy() : new FastMultiByteArrayInputStream(this.graphStream)), 0));
        return result;
    }

    protected BVGraph() {
    }

    @Override
    public long numNodes() {
        return this.n;
    }

    @Override
    public long numArcs() {
        return this.m;
    }

    @Override
    public boolean randomAccess() {
        return this.offsets != null;
    }

    @Override
    public CharSequence basename() {
        return this.basename;
    }

    public int maxRefCount() {
        return this.maxRefCount;
    }

    public int windowSize() {
        return this.windowSize;
    }

    protected final long readOffset(InputBitStream ibs) throws IOException {
        switch (this.offsetCoding) {
            case 2: {
                return ibs.readLongGamma();
            }
            case 1: {
                return ibs.readLongDelta();
            }
        }
        throw new UnsupportedOperationException("The required offset coding (" + this.offsetCoding + ") is not supported.");
    }

    protected final int writeOffset(OutputBitStream obs, long x) throws IOException {
        switch (this.offsetCoding) {
            case 2: {
                return obs.writeLongGamma(x);
            }
            case 1: {
                return obs.writeLongDelta(x);
            }
        }
        throw new UnsupportedOperationException("The required offset coding (" + this.offsetCoding + ") is not supported.");
    }

    protected final int readOutdegree(InputBitStream ibs) throws IOException {
        switch (this.outdegreeCoding) {
            case 2: {
                return ibs.readGamma();
            }
            case 1: {
                return ibs.readDelta();
            }
        }
        throw new UnsupportedOperationException("The required outdegree coding (" + this.outdegreeCoding + ") is not supported.");
    }

    protected final int readOutdegree(InputBitStream ibs, long offset) throws IOException {
        ibs.position(offset);
        return this.readOutdegree(ibs);
    }

    protected final int writeOutdegree(OutputBitStream obs, int d) throws IOException {
        switch (this.outdegreeCoding) {
            case 2: {
                return obs.writeGamma(d);
            }
            case 1: {
                return obs.writeDelta(d);
            }
        }
        throw new UnsupportedOperationException("The required outdegree coding (" + this.outdegreeCoding + ") is not supported.");
    }

    protected final int readReference(InputBitStream ibs) throws IOException {
        int ref;
        switch (this.referenceCoding) {
            case 5: {
                ref = ibs.readUnary();
                break;
            }
            case 2: {
                ref = ibs.readGamma();
                break;
            }
            case 1: {
                ref = ibs.readDelta();
                break;
            }
            default: {
                throw new UnsupportedOperationException("The required reference coding (" + this.referenceCoding + ") is not supported.");
            }
        }
        if (ref > this.windowSize) {
            throw new IllegalStateException("The required reference (" + ref + ") is incompatible with the window size (" + this.windowSize + ")");
        }
        return ref;
    }

    protected final int writeReference(OutputBitStream obs, int ref) throws IOException {
        if (ref > this.windowSize) {
            throw new IllegalStateException("The required reference (" + ref + ") is incompatible with the window size (" + this.windowSize + ")");
        }
        switch (this.referenceCoding) {
            case 5: {
                return obs.writeUnary(ref);
            }
            case 2: {
                return obs.writeGamma(ref);
            }
            case 1: {
                return obs.writeDelta(ref);
            }
        }
        throw new UnsupportedOperationException("The required reference coding (" + this.referenceCoding + ") is not supported.");
    }

    protected final int readBlockCount(InputBitStream ibs) throws IOException {
        switch (this.blockCountCoding) {
            case 5: {
                return ibs.readUnary();
            }
            case 2: {
                return ibs.readGamma();
            }
            case 1: {
                return ibs.readDelta();
            }
        }
        throw new UnsupportedOperationException("The required block count coding (" + this.blockCountCoding + ") is not supported.");
    }

    protected final int writeBlockCount(OutputBitStream obs, int count) throws IOException {
        switch (this.blockCountCoding) {
            case 5: {
                return obs.writeUnary(count);
            }
            case 2: {
                return obs.writeGamma(count);
            }
            case 1: {
                return obs.writeDelta(count);
            }
        }
        throw new UnsupportedOperationException("The required block count coding (" + this.blockCountCoding + ") is not supported.");
    }

    protected final int readBlock(InputBitStream ibs) throws IOException {
        switch (this.blockCoding) {
            case 5: {
                return ibs.readUnary();
            }
            case 2: {
                return ibs.readGamma();
            }
            case 1: {
                return ibs.readDelta();
            }
        }
        throw new UnsupportedOperationException("The required block coding (" + this.blockCoding + ") is not supported.");
    }

    protected final int writeBlock(OutputBitStream obs, int block) throws IOException {
        switch (this.blockCoding) {
            case 5: {
                return obs.writeUnary(block);
            }
            case 2: {
                return obs.writeGamma(block);
            }
            case 1: {
                return obs.writeDelta(block);
            }
        }
        throw new UnsupportedOperationException("The required block coding (" + this.blockCoding + ") is not supported.");
    }

    protected final long readResidual(InputBitStream ibs) throws IOException {
        switch (this.residualCoding) {
            case 2: {
                return ibs.readLongGamma();
            }
            case 6: {
                return ibs.readLongZeta(this.zetaK);
            }
            case 1: {
                return ibs.readLongDelta();
            }
            case 3: {
                return ibs.readLongGolomb((long)this.zetaK);
            }
            case 7: {
                return ibs.readLongNibble();
            }
        }
        throw new UnsupportedOperationException("The required residuals coding (" + this.residualCoding + ") is not supported.");
    }

    protected final long writeResidual(OutputBitStream obs, long residual) throws IOException {
        switch (this.residualCoding) {
            case 2: {
                return obs.writeLongGamma(residual);
            }
            case 6: {
                return obs.writeLongZeta(residual, this.zetaK);
            }
            case 1: {
                return obs.writeLongDelta(residual);
            }
            case 3: {
                return obs.writeLongGolomb(residual, (long)this.zetaK);
            }
            case 7: {
                return obs.writeLongNibble(residual);
            }
        }
        throw new UnsupportedOperationException("The required residuals coding (" + this.residualCoding + ") is not supported.");
    }

    @Override
    public long outdegree(long x) throws IllegalStateException {
        if (x == this.cachedNode) {
            return this.cachedOutdegree;
        }
        if (x < 0L || x >= this.n) {
            throw new IllegalArgumentException("Node index out of range: " + x);
        }
        try {
            if (this.offsetType <= 0) {
                throw new IllegalStateException("You cannot compute the outdegree of a random node without offsets");
            }
            this.cachedNode = x;
            this.outdegreeIbs.position(this.offsets.getLong(this.cachedNode));
            this.cachedOutdegree = this.readOutdegree(this.outdegreeIbs);
            this.cachedPointer = this.outdegreeIbs.position();
            return this.cachedOutdegree;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int outdegreeInternal(long x) throws IOException {
        if (x == this.cachedNode) {
            return this.cachedOutdegree;
        }
        this.cachedNode = x;
        this.outdegreeIbs.position(this.offsets.getLong(this.cachedNode));
        this.cachedOutdegree = this.readOutdegree(this.outdegreeIbs);
        this.cachedPointer = this.outdegreeIbs.position();
        return this.cachedOutdegree;
    }

    @Override
    public LazyLongIterator successors(long x) {
        if (x < 0L || x >= this.n) {
            throw new IllegalArgumentException("Node index out of range: " + x);
        }
        if (this.offsetType <= 0) {
            throw new UnsupportedOperationException("Random access to successor lists is not possible with sequential or offline graphs");
        }
        InputBitStream ibs = this.isMemory ? new InputBitStream(this.graphMemory) : new InputBitStream((InputStream)(this.isMapped ? this.mappedGraphStream.copy() : new FastMultiByteArrayInputStream(this.graphStream)), 0);
        return this.successors(x, ibs, null, null);
    }

    protected LazyLongIterator successors(long x, InputBitStream ibs, long[][] window, int[] outd) throws IllegalStateException {
        int blockCount = 0;
        long[] block = null;
        long[] left = null;
        long[] len = null;
        if (x < 0L || x >= this.n) {
            throw new IllegalArgumentException("Node index out of range:" + x);
        }
        try {
            MaskedLongIterator blockIterator;
            ResidualLongIterator extraIterator;
            int residualCount;
            ResidualLongIterator residualIterator;
            int extraCount;
            int i;
            int d;
            int cyclicBufferSize = this.windowSize + 1;
            if (window == null) {
                d = this.outdegreeInternal(x);
                ibs.position(this.cachedPointer);
            } else {
                int n = this.readOutdegree(ibs);
                outd[(int)(x % (long)cyclicBufferSize)] = n;
                d = n;
            }
            if (d == 0) {
                return LazyLongIterators.EMPTY_ITERATOR;
            }
            int ref = this.windowSize > 0 ? this.readReference(ibs) : -1;
            int refIndex = (int)((x - (long)ref + (long)cyclicBufferSize) % (long)cyclicBufferSize);
            if (ref > 0) {
                blockCount = this.readBlockCount(ibs);
                if (blockCount != 0) {
                    block = new long[blockCount];
                }
                int copied = 0;
                int total = 0;
                for (i = 0; i < blockCount; ++i) {
                    block[i] = this.readBlock(ibs) + (i == 0 ? 0 : 1);
                    total = (int)((long)total + block[i]);
                    if (i % 2 != 0) continue;
                    copied = (int)((long)copied + block[i]);
                }
                if (blockCount % 2 == 0) {
                    copied += (window != null ? outd[refIndex] : this.outdegreeInternal(x - (long)ref)) - total;
                }
                extraCount = d - copied;
            } else {
                extraCount = d;
            }
            int intervalCount = 0;
            if (extraCount > 0 && this.minIntervalLength != 0 && (intervalCount = ibs.readGamma()) != 0) {
                long prev = 0L;
                left = new long[intervalCount];
                len = new long[intervalCount];
                left[0] = prev = Fast.nat2int((long)ibs.readLongGamma()) + x;
                len[0] = ibs.readLongGamma() + (long)this.minIntervalLength;
                prev += len[0];
                extraCount = (int)((long)extraCount - len[0]);
                for (i = 1; i < intervalCount; ++i) {
                    left[i] = prev = ibs.readLongGamma() + prev + 1L;
                    len[i] = ibs.readLongGamma() + (long)this.minIntervalLength;
                    prev += len[i];
                    extraCount = (int)((long)extraCount - len[i]);
                }
            }
            ResidualLongIterator residualLongIterator = residualIterator = (residualCount = extraCount) == 0 ? null : new ResidualLongIterator(this, ibs, residualCount, x);
            LazyLongIterator lazyLongIterator = intervalCount == 0 ? residualIterator : (extraIterator = residualCount == 0 ? new LongIntervalSequenceIterator(left, len) : new MergedLongIterator(new LongIntervalSequenceIterator(left, len), residualIterator));
            MaskedLongIterator maskedLongIterator = ref <= 0 ? null : (blockIterator = new MaskedLongIterator(block, window != null ? LazyLongIterators.wrap(window[refIndex], outd[refIndex]) : this.successors(x - (long)ref, this.isMemory ? new InputBitStream(this.graphMemory) : new InputBitStream((InputStream)(this.isMapped ? this.mappedGraphStream.copy() : new FastMultiByteArrayInputStream(this.graphStream)), 0), null, null)));
            if (ref <= 0) {
                return extraIterator;
            }
            return extraIterator == null ? blockIterator : new MergedLongIterator(blockIterator, extraIterator, d);
        }
        catch (IOException e) {
            LOGGER.error("Exception while accessing node " + x, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public NodeIterator nodeIterator(long from) {
        try {
            return new BVGraphNodeIterator(from);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("The graph file \"" + this.basename + GRAPH_EXTENSION + "\" cannot be found");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setFlags(int flags) {
        this.flags = flags;
        if ((flags & 0xF) != 0) {
            this.outdegreeCoding = flags & 0xF;
        }
        if ((flags >>> 4 & 0xF) != 0) {
            this.blockCoding = flags >>> 4 & 0xF;
        }
        if ((flags >>> 8 & 0xF) != 0) {
            this.residualCoding = flags >>> 8 & 0xF;
        }
        if ((flags >>> 12 & 0xF) != 0) {
            this.referenceCoding = flags >>> 12 & 0xF;
        }
        if ((flags >>> 16 & 0xF) != 0) {
            this.blockCountCoding = flags >>> 16 & 0xF;
        }
        if ((flags >>> 20 & 0xF) != 0) {
            this.offsetCoding = flags >>> 20 & 0xF;
        }
    }

    private static MutableString flags2String(int flags) {
        MutableString s = new MutableString();
        if ((flags & 0xF) != 0) {
            s.append(" | ").append("OUTDEGREES_").append(CompressionFlags.CODING_NAME[flags & 0xF]);
        }
        if ((flags >>> 4 & 0xF) != 0) {
            s.append(" | ").append("BLOCKS_").append(CompressionFlags.CODING_NAME[flags >>> 4 & 0xF]);
        }
        if ((flags >>> 8 & 0xF) != 0) {
            s.append(" | ").append("RESIDUALS_").append(CompressionFlags.CODING_NAME[flags >>> 8 & 0xF]);
        }
        if ((flags >>> 12 & 0xF) != 0) {
            s.append(" | ").append("REFERENCES_").append(CompressionFlags.CODING_NAME[flags >>> 12 & 0xF]);
        }
        if ((flags >>> 16 & 0xF) != 0) {
            s.append(" | ").append("BLOCK_COUNT_").append(CompressionFlags.CODING_NAME[flags >>> 16 & 0xF]);
        }
        if ((flags >>> 20 & 0xF) != 0) {
            s.append(" | ").append("OFFSETS_").append(CompressionFlags.CODING_NAME[flags >>> 20 & 0xF]);
        }
        if (s.length() != 0) {
            s.delete(0, 3);
        }
        return s;
    }

    private static int string2Flags(String flagString) throws IOException {
        int flags = 0;
        if (flagString != null && flagString.length() != 0) {
            String[] f;
            for (String element : f = flagString.split("\\|")) {
                try {
                    flags |= BVGraph.class.getField(element.trim()).getInt(BVGraph.class);
                }
                catch (Exception notFound) {
                    throw new IOException("Compression flag " + element + " unknown.");
                }
            }
        }
        return flags;
    }

    public static BVGraph load(CharSequence basename, int offsetType, ProgressLogger pl) throws IOException {
        return new BVGraph().loadInternal(basename, offsetType, pl);
    }

    public static BVGraph load(CharSequence basename, int offsetType) throws IOException {
        return BVGraph.load(basename, offsetType, null);
    }

    public static BVGraph load(CharSequence basename) throws IOException {
        return BVGraph.load(basename, 1);
    }

    public static BVGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return BVGraph.load(basename, 1, pl);
    }

    public static BVGraph loadMapped(CharSequence basename, ProgressLogger pl) throws IOException {
        return BVGraph.load(basename, 2, pl);
    }

    public static BVGraph loadMapped(CharSequence basename) throws IOException {
        return BVGraph.loadMapped(basename, null);
    }

    @Deprecated
    public static BVGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return BVGraph.load(basename, 0, pl);
    }

    @Deprecated
    public static BVGraph loadSequential(CharSequence basename) throws IOException {
        return BVGraph.loadSequential(basename, null);
    }

    public static BVGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return BVGraph.load(basename, -1, pl);
    }

    public static BVGraph loadOffline(CharSequence basename) throws IOException {
        return BVGraph.loadOffline(basename, null);
    }

    protected BVGraph loadInternal(CharSequence basename, int offsetType, ProgressLogger pl) throws IOException {
        InputBitStream offsetIbs;
        FileInputStream propertyFile = new FileInputStream(basename + ".properties");
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        this.offsetType = offsetType;
        this.basename = new MutableString(basename);
        if (!this.getClass().getName().equals(properties.getProperty("graphclass").replace("it.unimi.dsi.webgraph", "it.unimi.dsi.big.webgraph"))) {
            throw new IOException("This class (" + this.getClass().getName() + ") cannot load a graph stored using class \"" + properties.getProperty("graphclass") + "\"");
        }
        this.setFlags(BVGraph.string2Flags(properties.getProperty("compressionflags")));
        if (properties.getProperty("version") == null) {
            throw new IOException("Missing format version information");
        }
        if (Integer.parseInt(properties.getProperty("version")) > 0) {
            throw new IOException("This graph uses format " + properties.getProperty("version") + ", but this class can understand only graphs up to format " + 0);
        }
        this.n = Long.parseLong(properties.getProperty("nodes"));
        this.m = Long.parseLong(properties.getProperty("arcs"));
        this.windowSize = Integer.parseInt(properties.getProperty("windowsize"));
        this.maxRefCount = Integer.parseInt(properties.getProperty("maxrefcount"));
        this.minIntervalLength = Integer.parseInt(properties.getProperty("minintervallength"));
        if (properties.getProperty("zetak") != null) {
            this.zetaK = Integer.parseInt(properties.getProperty("zetak"));
        }
        if (offsetType < -1 || offsetType > 2) {
            throw new IllegalArgumentException("Illegal offset type " + offsetType);
        }
        InputBitStream inputBitStream = offsetIbs = offsetType > 0 ? new InputBitStream(new FileInputStream(basename + OFFSETS_EXTENSION), 0x100000) : null;
        if (offsetType >= 0) {
            FileInputStream fis = new FileInputStream(basename + GRAPH_EXTENSION);
            if (offsetType == 2) {
                this.mappedGraphStream = ByteBufferInputStream.map((FileChannel)fis.getChannel(), (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY);
                this.isMapped = true;
            } else {
                if (pl != null) {
                    pl.itemsName = "bytes";
                    pl.start((CharSequence)"Loading graph...");
                }
                if (fis.getChannel().size() <= Integer.MAX_VALUE) {
                    this.graphMemory = new byte[(int)fis.getChannel().size()];
                    BinIO.loadBytes((InputStream)fis, (byte[])this.graphMemory);
                    fis.close();
                    this.isMemory = true;
                } else {
                    this.graphStream = new FastMultiByteArrayInputStream((InputStream)fis, fis.getChannel().size());
                }
                if (pl != null) {
                    pl.count = this.isMemory ? (long)this.graphMemory.length : this.graphStream.length;
                    pl.done();
                }
            }
        }
        if (offsetType == 1 || offsetType == 2) {
            File offsetsBigListFile;
            if (pl != null) {
                pl.itemsName = "deltas";
                pl.start((CharSequence)"Loading offsets...");
            }
            if ((offsetsBigListFile = new File(basename + OFFSETS_BIG_LIST_EXTENSION)).exists()) {
                if (new File(basename + OFFSETS_EXTENSION).lastModified() > offsetsBigListFile.lastModified()) {
                    LOGGER.warn("A cached long big list of offsets was found, but the corresponding offsets file has a later modification time");
                } else {
                    try {
                        this.offsets = (LongBigList)BinIO.loadObject((File)offsetsBigListFile);
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.warn("A cached long big list of offsets was found, but its class is unknown", (Throwable)e);
                    }
                }
            }
            long upperBound = (this.isMapped ? this.mappedGraphStream.length() : (this.isMemory ? (long)this.graphMemory.length : this.graphStream.length)) * 8L + 1L;
            OffsetsLongIterator offsetsIterator = new OffsetsLongIterator(this, offsetIbs);
            if (this.offsets == null) {
                Object object = this.offsets = EliasFanoMonotoneLongBigList.fits((long)(this.n + 1L), (long)upperBound) ? new EliasFanoMonotoneLongBigList(this.n + 1L, upperBound, (LongIterator)offsetsIterator) : new EliasFanoMonotoneBigLongBigList(this.n + 1L, upperBound, (LongIterator)offsetsIterator);
            }
            if (pl != null) {
                pl.count = this.n + 1L;
                pl.done();
                if (this.offsets instanceof EliasFanoMonotoneLongBigList) {
                    pl.logger().info("Pointer bits per node: " + Util.format((double)((double)((EliasFanoMonotoneLongBigList)this.offsets).numBits() / ((double)this.n + 1.0))));
                }
                if (this.offsets instanceof EliasFanoMonotoneBigLongBigList) {
                    pl.logger().info("Pointer bits per node: " + Util.format((double)((double)((EliasFanoMonotoneBigLongBigList)this.offsets).numBits() / ((double)this.n + 1.0))));
                }
            }
        }
        if (offsetIbs != null) {
            offsetIbs.close();
        }
        if (offsetType >= 0) {
            this.outdegreeIbs = this.isMemory ? new InputBitStream(this.graphMemory) : new InputBitStream((InputStream)(this.isMapped ? this.mappedGraphStream.copy() : new FastMultiByteArrayInputStream(this.graphStream)), 0);
        }
        return this;
    }

    protected static int intervalize(LongArrayList x, int minInterval, LongArrayList left, LongArrayList len, LongArrayList residuals) {
        int nInterval = 0;
        int vl = x.size();
        long[] v = x.elements();
        left.clear();
        len.clear();
        residuals.clear();
        for (int i = 0; i < vl; ++i) {
            int j = 0;
            if (i < vl - 1 && v[i] + 1L == v[i + 1]) {
                while (i + ++j < vl - 1 && v[i + j] + 1L == v[i + j + 1]) {
                }
                if (++j >= minInterval) {
                    left.add(v[i]);
                    len.add((long)j);
                    ++nInterval;
                    i += j - 1;
                }
            }
            if (j >= minInterval) continue;
            residuals.add(v[i]);
        }
        return nInterval;
    }

    public static void store(ImmutableGraph graph, CharSequence basename, int windowSize, int maxRefCount, int minIntervalLength, int zetaK, int flags, int numberOfThreads, ProgressLogger pl) throws IOException {
        BVGraph g = new BVGraph();
        if (windowSize != -1) {
            g.windowSize = windowSize;
        }
        if (maxRefCount != -1) {
            g.maxRefCount = maxRefCount;
        }
        if (minIntervalLength != -1) {
            g.minIntervalLength = minIntervalLength;
        }
        if (zetaK != -1) {
            g.zetaK = zetaK;
        }
        g.setFlags(flags);
        g.storeInternal(graph, basename, numberOfThreads, pl);
    }

    public static void store(ImmutableGraph graph, CharSequence basename, int windowSize, int maxRefCount, int minIntervalLength, int zetaK, int flags, ProgressLogger pl) throws IOException {
        BVGraph.store(graph, basename, windowSize, maxRefCount, minIntervalLength, zetaK, flags, 0, pl);
    }

    public static void store(ImmutableGraph graph, CharSequence basename, int windowSize, int maxRefCount, int minIntervalLength, int zetaK, int flags) throws IOException {
        BVGraph.store(graph, basename, windowSize, maxRefCount, minIntervalLength, zetaK, flags, null);
    }

    public static void store(ImmutableGraph graph, CharSequence basename, ProgressLogger pl) throws IOException {
        BVGraph.store(graph, basename, -1, -1, -1, -1, 0, pl);
    }

    public static void store(ImmutableGraph graph, CharSequence basename) throws IOException {
        BVGraph.store(graph, basename, (ProgressLogger)null);
    }

    protected static void updateBins(long currNode, long[] list, int length, long[] bin) {
        int i = length - 1;
        while (i-- != 0) {
            int n = Fast.mostSignificantBit((long)(list[i + 1] - list[i]));
            bin[n] = bin[n] + 1L;
        }
        int msb = Fast.mostSignificantBit((long)Fast.int2nat((long)(list[0] - currNode)));
        if (msb >= 0) {
            int n = msb;
            bin[n] = bin[n] + 1L;
        }
    }

    private static final long aggregateLong(CompressionThread[] compressionThread, String fieldName) {
        long v = 0L;
        for (CompressionThread t : compressionThread) {
            try {
                if (t.nodeIterator == null) continue;
                v += CompressionThread.class.getField(fieldName).getLong(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return v;
    }

    private static final long[] aggregateStats(CompressionThread[] compressionThread, String fieldName) {
        long[] stats = new long[64];
        for (CompressionThread t : compressionThread) {
            try {
                if (t.nodeIterator == null) continue;
                long[] s = (long[])CompressionThread.class.getField(fieldName).get(t);
                int i = stats.length;
                while (i-- != 0) {
                    int n = i;
                    stats[n] = stats[n] + s[i];
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return stats;
    }

    private void storeInternal(ImmutableGraph graph, CharSequence basename, int numberOfThreads, ProgressLogger pl) throws IOException {
        int i;
        long n;
        try {
            n = graph.numNodes();
        }
        catch (Exception e) {
            n = -1L;
        }
        if (numberOfThreads <= 0) {
            numberOfThreads = Runtime.getRuntime().availableProcessors();
            if (n != -1L && (long)numberOfThreads > n / 100000L) {
                numberOfThreads = Math.max(1, (int)(n / 100000L));
            }
        }
        if (!((numberOfThreads = Integer.parseInt(System.getProperty("it.unimi.dsi.webgraph.threads", Integer.toString(numberOfThreads)))) <= 1 || n != -1L && graph.hasCopiableIterators())) {
            if (n == -1L) {
                LOGGER.warn("Number of nodes not available: using just one thread");
            } else {
                LOGGER.warn("The source graph does not provide copiable iterators: using just one thread");
            }
            numberOfThreads = 1;
        }
        LOGGER.info("Compressing using " + numberOfThreads + " threads");
        long statsThreshold = (1L << 20 + Fast.mostSignificantBit((int)numberOfThreads)) - 1L;
        ExecutorService executorService = Executors.newFixedThreadPool(numberOfThreads, new ThreadFactoryBuilder().setNameFormat("ProcessingThread-%d").build());
        ExecutorCompletionService<Void> executorCompletionService = new ExecutorCompletionService<Void>(executorService);
        CompressionThread[] compressionThread = new CompressionThread[numberOfThreads];
        if (numberOfThreads == 1) {
            compressionThread[0] = new CompressionThread(0, n, graph.nodeIterator(), basename, 0x100000, statsThreshold, pl);
            executorCompletionService.submit(compressionThread[0]);
        } else {
            NodeIterator[] splitNodeIterators = graph.splitNodeIterators(numberOfThreads);
            i = numberOfThreads;
            while (i-- != 0) {
                File tempFile = File.createTempFile(BVGraph.class.getSimpleName(), "-tmp.graph");
                tempFile.deleteOnExit();
                compressionThread[i] = new CompressionThread(i, n, splitNodeIterators[i], tempFile.toString(), 0x1000000, statsThreshold, pl);
                executorCompletionService.submit(compressionThread[i]);
            }
        }
        Throwable problem = null;
        i = numberOfThreads;
        while (i-- != 0) {
            try {
                executorCompletionService.take().get();
            }
            catch (Exception e) {
                problem = e.getCause();
            }
        }
        executorService.shutdown();
        if (problem != null) {
            Throwables.throwIfUnchecked((Throwable)problem);
            throw new RuntimeException(problem);
        }
        if (pl != null) {
            pl.done();
        }
        if (numberOfThreads > 1) {
            if (pl != null) {
                pl.logger().info("Copying streams...");
            }
            OutputBitStream graphObs = new OutputBitStream(basename + GRAPH_EXTENSION, 0x100000);
            OutputBitStream offsetsObs = new OutputBitStream(basename + OFFSETS_EXTENSION, 0x100000);
            this.writeOffset(offsetsObs, 0L);
            for (CompressionThread t : compressionThread) {
                if (t.nodeIterator == null) continue;
                File graphFile = new File(t.threadBasename.toString() + GRAPH_EXTENSION);
                File offsetFile = new File(t.threadBasename.toString() + OFFSETS_EXTENSION);
                InputBitStream graphIbs = new InputBitStream(graphFile);
                InputBitStream offsetsIbs = new InputBitStream(offsetFile);
                this.readOffset(offsetsIbs);
                graphIbs.copyTo(graphObs, t.graphWrittenBits);
                offsetsIbs.copyTo(offsetsObs, t.offsetsWrittenBits - offsetsIbs.position());
                graphIbs.close();
                offsetsIbs.close();
                graphFile.delete();
                offsetFile.delete();
            }
            graphObs.close();
            offsetsObs.close();
            if (pl != null) {
                pl.logger().info("Copy completed.");
            }
        }
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        format.applyPattern("0.###");
        Properties properties = new Properties();
        n = graph.numNodes();
        properties.setProperty("nodes", String.valueOf(n));
        long totLinks = BVGraph.aggregateLong(compressionThread, "totLinks");
        properties.setProperty("arcs", String.valueOf(totLinks));
        properties.setProperty("windowsize", String.valueOf(this.windowSize));
        properties.setProperty("maxrefcount", String.valueOf(this.maxRefCount));
        properties.setProperty("minintervallength", String.valueOf(this.minIntervalLength));
        if (this.residualCoding == 6) {
            properties.setProperty("zetak", String.valueOf(this.zetaK));
        }
        properties.setProperty("compressionflags", BVGraph.flags2String(this.flags).toString());
        properties.setProperty("avgref", format.format((double)BVGraph.aggregateLong(compressionThread, "totRef") / (double)n));
        properties.setProperty("avgdist", format.format((double)BVGraph.aggregateLong(compressionThread, "totDist") / (double)n));
        properties.setProperty("copiedarcs", String.valueOf(BVGraph.aggregateLong(compressionThread, "copiedArcs")));
        properties.setProperty("intervalisedarcs", String.valueOf(BVGraph.aggregateLong(compressionThread, "intervalisedArcs")));
        properties.setProperty("residualarcs", String.valueOf(BVGraph.aggregateLong(compressionThread, "residualArcs")));
        long writtenBits = BVGraph.aggregateLong(compressionThread, "graphWrittenBits");
        properties.setProperty("bitsperlink", format.format((double)writtenBits / (double)totLinks));
        properties.setProperty("compratio", format.format((double)writtenBits * Math.log(2.0) / (BVGraph.stirling((double)n * (double)n) - BVGraph.stirling(totLinks) - BVGraph.stirling((double)n * (double)n - (double)totLinks))));
        properties.setProperty("bitspernode", format.format((double)writtenBits / (double)n));
        properties.setProperty("avgbitsforoutdegrees", format.format((double)BVGraph.aggregateLong(compressionThread, "bitsForOutdegrees") / (double)n));
        properties.setProperty("avgbitsforreferences", format.format((double)BVGraph.aggregateLong(compressionThread, "bitsForReferences") / (double)n));
        properties.setProperty("avgbitsforblocks", format.format((double)BVGraph.aggregateLong(compressionThread, "bitsForBlocks") / (double)n));
        properties.setProperty("avgbitsforresiduals", format.format((double)BVGraph.aggregateLong(compressionThread, "bitsForResiduals") / (double)n));
        properties.setProperty("avgbitsforintervals", format.format((double)BVGraph.aggregateLong(compressionThread, "bitsForIntervals") / (double)n));
        properties.setProperty("bitsforoutdegrees", Long.toString(BVGraph.aggregateLong(compressionThread, "bitsForOutdegrees")));
        properties.setProperty("bitsforreferences", Long.toString(BVGraph.aggregateLong(compressionThread, "bitsForReferences")));
        properties.setProperty("bitsforblocks", Long.toString(BVGraph.aggregateLong(compressionThread, "bitsForBlocks")));
        properties.setProperty("bitsforresiduals", Long.toString(BVGraph.aggregateLong(compressionThread, "bitsForResiduals")));
        properties.setProperty("bitsforintervals", Long.toString(BVGraph.aggregateLong(compressionThread, "bitsForIntervals")));
        properties.setProperty("graphclass", this.getClass().getName());
        properties.setProperty("version", String.valueOf(0));
        FileOutputStream propertyFile = new FileOutputStream(basename + ".properties");
        long[] successorGapStats = BVGraph.aggregateStats(compressionThread, "successorGapStats");
        int l = successorGapStats.length;
        while (l-- != 0 && successorGapStats[l] == 0L) {
        }
        StringBuilder s = new StringBuilder();
        BigInteger totGap = BigInteger.ZERO;
        double totLogGap = 0.0;
        long numGaps = 0L;
        long g = 1L;
        for (int i2 = 0; i2 <= l; ++i2) {
            if (i2 != 0) {
                s.append(',');
            }
            s.append(successorGapStats[i2]);
            numGaps += successorGapStats[i2];
            totGap = totGap.add(BigInteger.valueOf(g * 2L + g - 1L).multiply(BigInteger.valueOf(successorGapStats[i2])));
            totLogGap += (Fast.log2((double)(g * 2L + g + 1L)) - 1.0) * (double)successorGapStats[i2];
            g *= 2L;
        }
        properties.setProperty("successorexpstats", s.toString());
        properties.setProperty("successoravggap", numGaps == 0L ? "0" : new BigDecimal(totGap).divide(BigDecimal.valueOf(numGaps * 2L), 3, RoundingMode.HALF_EVEN).toString());
        properties.setProperty("successoravgloggap", numGaps == 0L ? "0" : Double.toString(totLogGap / (double)numGaps));
        s.setLength(0);
        long[] residualGapStats = BVGraph.aggregateStats(compressionThread, "residualGapStats");
        l = residualGapStats.length;
        while (l-- != 0 && residualGapStats[l] == 0L) {
        }
        g = 1L;
        numGaps = 0L;
        totLogGap = 0.0;
        totGap = BigInteger.ZERO;
        for (int i3 = 0; i3 <= l; ++i3) {
            if (i3 != 0) {
                s.append(',');
            }
            s.append(residualGapStats[i3]);
            totGap = totGap.add(BigInteger.valueOf(g * 2L + g - 1L).multiply(BigInteger.valueOf(residualGapStats[i3])));
            totLogGap += (Fast.log2((double)(g * 2L + g + 1L)) - 1.0) * (double)residualGapStats[i3];
            numGaps += residualGapStats[i3];
            g *= 2L;
        }
        properties.setProperty("residualexpstats", s.toString());
        properties.setProperty("residualavggap", numGaps == 0L ? "0" : new BigDecimal(totGap).divide(BigDecimal.valueOf(numGaps * 2L), 3, RoundingMode.HALF_EVEN).toString());
        properties.setProperty("residualavgloggap", numGaps == 0L ? "0" : Double.toString(totLogGap / (double)numGaps));
        properties.store(propertyFile, "BVGraph properties");
        propertyFile.close();
    }

    private static double stirling(double n) {
        return n * Math.log(n) - n + 0.5 * Math.log(Math.PI * 2 * n);
    }

    public void writeOffsets(OutputBitStream obs, ProgressLogger pl) throws IOException {
        BVGraphNodeIterator nodeIterator = (BVGraphNodeIterator)this.nodeIterator(0L);
        long n = this.numNodes();
        long lastOffset = 0L;
        while (n-- != 0L) {
            this.writeOffset(obs, (int)(nodeIterator.ibs.readBits() - lastOffset));
            lastOffset = nodeIterator.ibs.readBits();
            nodeIterator.nextLong();
            nodeIterator.outdegree();
            nodeIterator.successorBigArray();
            if (pl == null) continue;
            pl.update();
        }
        this.writeOffset(obs, nodeIterator.ibs.readBits() - lastOffset);
    }

    public static void main(String[] args) throws SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException, JSAPException, ClassNotFoundException, InstantiationException {
        ImmutableGraph graph;
        int flags = 0;
        SimpleJSAP jsap = new SimpleJSAP(BVGraph.class.getName(), "Compresses differentially a graph. Source and destination are basenames from which suitable filenames will be stemmed; alternatively, if the suitable option was specified, source is a spec (see below). For more information about the compression techniques, see the Javadoc documentation.", new Parameter[]{new FlaggedOption("comp", (StringParser)JSAP.STRING_PARSER, null, false, 'c', "comp", "A compression flag (may be specified several times).").setAllowMultipleDeclarations(true), new FlaggedOption("windowSize", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(7), false, 'w', "window-size", "Reference window size (0 to disable)."), new FlaggedOption("maxRefCount", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(3), false, 'm', "max-ref-count", "Maximum number of backward references (-1 for \u221e)."), new FlaggedOption("minIntervalLength", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(4), false, 'i', "min-interval-length", "Minimum length of an interval (0 to disable)."), new FlaggedOption("zetaK", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(3), false, 'k', "zeta-k", "The k parameter for zeta-k codes."), new FlaggedOption("graphClass", (StringParser)GraphClassParser.getParser(), null, false, 'g', "graph-class", "Forces a Java class for the source graph."), new Switch("spec", 's', "spec", "The source is not a basename but rather a specification of the form <ImmutableGraphImplementation>(arg,arg,...)."), new FlaggedOption("threads", (StringParser)JSAP.INTSIZE_PARSER, "0", false, 't', "threads", "The number of threads (0 for the number of available processors)."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new Switch("offline", 'o', "offline", "No-op for backward compatibility."), new Switch("once", '1', "once", "Use the read-once load method to read a graph from standard input."), new Switch("offsets", 'O', "offsets", "Generates offsets for the source graph."), new Switch("list", 'L', "list", "Precomputes an Elias-Fano list of offsets for the source graph."), new Switch("degrees", 'd', "degrees", "Stores the outdegrees of all nodes using &gamma; coding."), new UnflaggedOption("sourceBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the source graph, or a source spec if --spec was given; it is immaterial when --once is specified."), new UnflaggedOption("destBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the destination graph; if omitted, no recompression is performed. This is useful in conjunction with --offsets and --list.")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        for (String compressionFlag : jsapResult.getStringArray("comp")) {
            try {
                flags |= BVGraph.class.getField(compressionFlag).getInt(BVGraph.class);
            }
            catch (Exception notFound) {
                throw new JSAPException("Compression method " + compressionFlag + " unknown.");
            }
        }
        int windowSize = jsapResult.getInt("windowSize");
        int zetaK = jsapResult.getInt("zetaK");
        int maxRefCount = jsapResult.getInt("maxRefCount");
        if (maxRefCount == -1) {
            maxRefCount = Integer.MAX_VALUE;
        }
        int minIntervalLength = jsapResult.getInt("minIntervalLength");
        boolean once = jsapResult.getBoolean("once");
        boolean spec = jsapResult.getBoolean("spec");
        boolean writeOffsets = jsapResult.getBoolean("offsets");
        boolean list = jsapResult.getBoolean("list");
        boolean degrees = jsapResult.getBoolean("degrees");
        int numberOfThreads = jsapResult.getInt("threads");
        Class graphClass = jsapResult.getClass("graphClass");
        String source = jsapResult.getString("sourceBasename");
        String dest = jsapResult.getString("destBasename");
        ProgressLogger pl = new ProgressLogger(LOGGER, jsapResult.getLong("logInterval"), TimeUnit.MILLISECONDS);
        if (graphClass != null) {
            if (spec) {
                System.err.println("Options --graph-class and --spec are incompatible");
                System.exit(1);
            }
            graph = once ? (ImmutableGraph)graphClass.getMethod(ImmutableGraph.LoadMethod.ONCE.toMethod(), InputStream.class).invoke(null, System.in) : (ImmutableGraph)graphClass.getMethod(numberOfThreads == 1 ? ImmutableGraph.LoadMethod.OFFLINE.toMethod() : ImmutableGraph.LoadMethod.MAPPED.toMethod(), CharSequence.class).invoke(null, source);
        } else {
            graph = !spec ? (once ? ImmutableGraph.loadOnce(System.in) : (numberOfThreads == 1 || dest == null ? ImmutableGraph.loadOffline(source, pl) : ImmutableGraph.loadMapped(source, pl))) : (ImmutableGraph)ObjectParser.fromSpec((String)source, ImmutableGraph.class, (String[])GraphClassParser.PACKAGE);
        }
        if (dest != null) {
            if (writeOffsets || list || degrees) {
                throw new IllegalArgumentException("You cannot specify a destination graph with these options");
            }
            BVGraph.store(graph, dest, windowSize, maxRefCount, minIntervalLength, zetaK, flags, pl);
        } else {
            OutputBitStream offsets;
            if (!(graph instanceof BVGraph)) {
                throw new IllegalArgumentException("The source graph is not a BVGraph");
            }
            BVGraph bvGraph = (BVGraph)graph;
            if (writeOffsets) {
                offsets = new OutputBitStream(graph.basename() + OFFSETS_EXTENSION, 65536);
                pl.expectedUpdates = graph.numNodes();
                pl.start((CharSequence)"Writing offsets...");
                ((BVGraph)graph).writeOffsets(offsets, pl);
                offsets.close();
                pl.count = graph.numNodes();
                pl.done();
            }
            if (list) {
                offsets = new InputBitStream(graph.basename() + OFFSETS_EXTENSION);
                long upperBound = new File(graph.basename() + GRAPH_EXTENSION).length() * 8L + 1L;
                BinIO.storeObject((Object)(EliasFanoMonotoneLongBigList.fits((long)(graph.numNodes() + 1L), (long)upperBound) ? new EliasFanoMonotoneLongBigList(graph.numNodes() + 1L, upperBound, (LongIterator)new OffsetsLongIterator(bvGraph, (InputBitStream)offsets)) : new EliasFanoMonotoneBigLongBigList(graph.numNodes() + 1L, upperBound, (LongIterator)new OffsetsLongIterator(bvGraph, (InputBitStream)offsets))), (CharSequence)(graph.basename() + OFFSETS_BIG_LIST_EXTENSION));
                offsets.close();
            }
            if (degrees) {
                OutputBitStream outdegrees = new OutputBitStream(graph.basename() + OUTDEGREES_EXTENSION, 65536);
                NodeIterator nodeIterator = graph.nodeIterator();
                long i = graph.numNodes();
                while (i-- != 0L) {
                    nodeIterator.nextLong();
                    outdegrees.writeLongGamma(nodeIterator.outdegree());
                }
                outdegrees.close();
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.outdegreeIbs = new InputBitStream(this.graphMemory);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.graphStream != null) {
            throw new IllegalStateException("BVGraph instances using FastMultiByteArrayInputStream cannot be serialized");
        }
        if (this.mappedGraphStream != null) {
            throw new IllegalStateException("BVGraph instances using memory mapping cannot be serialized");
        }
        s.defaultWriteObject();
    }

    private static final class ResidualLongIterator
    extends AbstractLazyLongIterator {
        private final BVGraph g;
        private final InputBitStream ibs;
        private long next;
        private int remaining;

        private ResidualLongIterator(BVGraph g, InputBitStream ibs, int residualCount, long x) {
            this.g = g;
            this.remaining = residualCount;
            this.ibs = ibs;
            try {
                this.next = x + Fast.nat2int((long)g.readResidual(ibs));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long nextLong() {
            if (this.remaining == 0) {
                return -1L;
            }
            try {
                long result = this.next;
                if (--this.remaining != 0) {
                    this.next += this.g.readResidual(this.ibs) + 1L;
                }
                return result;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public long skip(long n) {
            if (n >= (long)this.remaining) {
                n = this.remaining;
                this.remaining = 0;
                return n;
            }
            try {
                long i = n;
                while (i-- != 0L) {
                    this.next += this.g.readResidual(this.ibs) + 1L;
                }
                this.remaining = (int)((long)this.remaining - n);
                return n;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class BVGraphNodeIterator
    extends NodeIterator {
        private final long n;
        final InputBitStream ibs;
        private final int cyclicBufferSize;
        private final long[][] window;
        private final int[] outd;
        private final long from;
        private long curr;
        private final long hasNextLimit;

        private BVGraphNodeIterator(long from, long upperBound, long streamPosition, long[][] window, int[] outd) throws IOException {
            this.n = BVGraph.this.numNodes();
            this.cyclicBufferSize = BVGraph.this.windowSize + 1;
            this.window = new long[this.cyclicBufferSize][1024];
            this.outd = new int[this.cyclicBufferSize];
            if (from < 0L || from > this.n) {
                throw new IllegalArgumentException("Node index out of range: " + from);
            }
            this.from = from;
            this.ibs = this.createInputBitStream();
            this.ibs.position(streamPosition);
            if (window != null) {
                for (int i = 0; i < window.length; ++i) {
                    this.window[i] = LongArrays.grow((long[])this.window[i], (int)outd[i], (int)0);
                    System.arraycopy(window[i], 0, this.window[i], 0, outd[i]);
                }
                System.arraycopy(outd, 0, this.outd, 0, outd.length);
            } else if (from != 0L) {
                if (BVGraph.this.offsetType <= 0) {
                    throw new IllegalStateException("You cannot iterate from a chosen node without offsets");
                }
                int i = 1;
                while ((long)i < Math.min(from + 1L, (long)this.cyclicBufferSize)) {
                    int pos = (int)((from - (long)i + (long)this.cyclicBufferSize) % (long)this.cyclicBufferSize);
                    this.outd[pos] = BVGraph.this.outdegreeInternal(from - (long)i);
                    this.window[pos] = LongArrays.grow((long[])this.window[pos], (int)this.outd[pos], (int)0);
                    BigArrays.copyFromBig((long[][])BVGraph.this.successorBigArray(from - (long)i), (long)0L, (long[])this.window[pos], (int)0, (int)this.outd[pos]);
                    ++i;
                }
                this.ibs.position(BVGraph.this.offsets.getLong(from));
            }
            this.curr = from - 1L;
            this.hasNextLimit = Math.min(upperBound, this.n) - 1L;
        }

        private BVGraphNodeIterator(long from) throws IOException {
            this(from, Long.MAX_VALUE, 0L, null, null);
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int currIndex = (int)(++this.curr % (long)this.cyclicBufferSize);
            LazyLongIterator i = BVGraph.this.successors(this.curr, this.ibs, this.window, this.outd);
            int d = this.outd[currIndex];
            if (this.window[currIndex].length < d) {
                this.window[currIndex] = new long[d];
            }
            long[] w = this.window[currIndex];
            for (int j = 0; j < d; ++j) {
                w[j] = i.nextLong();
            }
            return this.curr;
        }

        public boolean hasNext() {
            return this.curr < this.hasNextLimit;
        }

        @Override
        public LazyLongIterator successors() {
            if (this.curr == this.from - 1L) {
                throw new IllegalStateException();
            }
            int currIndex = (int)(this.curr % (long)this.cyclicBufferSize);
            return LazyLongIterators.wrap(this.window[currIndex], this.outd[currIndex]);
        }

        @Override
        public long[][] successorBigArray() {
            if (this.curr == this.from - 1L) {
                throw new IllegalStateException();
            }
            int index = (int)(this.curr % (long)this.cyclicBufferSize);
            if (this.window[index].length > 0x8000000 && this.outd[index] <= 0x8000000) {
                long[] a = new long[0x8000000];
                System.arraycopy(this.window[index], 0, a, 0, this.outd[index]);
                this.window[index] = a;
            }
            return BigArrays.wrap((long[])this.window[index]);
        }

        @Override
        public long outdegree() {
            if (this.curr == this.from - 1L) {
                throw new IllegalStateException();
            }
            return this.outd[(int)(this.curr % (long)this.cyclicBufferSize)];
        }

        protected void finalize() throws Throwable {
            try {
                this.ibs.close();
            }
            finally {
                super.finalize();
            }
        }

        @Override
        public NodeIterator copy(long upperBound) {
            try {
                return new BVGraphNodeIterator(this.curr + 1L, upperBound, this.ibs.position(), this.window, this.outd);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private InputBitStream createInputBitStream() throws FileNotFoundException {
            if (BVGraph.this.offsetType == -1) {
                return new InputBitStream(new FileInputStream(BVGraph.this.basename + BVGraph.GRAPH_EXTENSION), 0x100000);
            }
            if (BVGraph.this.isMemory) {
                return new InputBitStream(BVGraph.this.graphMemory);
            }
            if (BVGraph.this.isMapped) {
                return new InputBitStream((InputStream)BVGraph.this.mappedGraphStream.copy());
            }
            return new InputBitStream((InputStream)new FastMultiByteArrayInputStream(BVGraph.this.graphStream), 0);
        }
    }

    private static final class OffsetsLongIterator
    implements LongIterator {
        private final InputBitStream offsetIbs;
        private final long n;
        private long off;
        private long i;
        private final BVGraph g;

        private OffsetsLongIterator(BVGraph g, InputBitStream offsetIbs) {
            this.offsetIbs = offsetIbs;
            this.g = g;
            this.n = g.numNodes();
        }

        public boolean hasNext() {
            return this.i <= this.n;
        }

        public long nextLong() {
            ++this.i;
            try {
                this.off = this.g.readOffset(this.offsetIbs) + this.off;
                return this.off;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private final class CompressionThread
    implements Callable<Void> {
        public final CharSequence threadBasename;
        private final ProgressLogger pl;
        public final NodeIterator nodeIterator;
        public long[] successorGapStats;
        public long[] residualGapStats;
        public long bitsForOutdegrees;
        public long bitsForReferences;
        public long bitsForBlocks;
        public long bitsForResiduals;
        public long bitsForIntervals;
        public long copiedArcs;
        public long intervalisedArcs;
        public long residualArcs;
        public long totRef = 0L;
        public long totDist = 0L;
        public long totLinks = 0L;
        private final int index;
        private final long numNodes;
        private final LongArrayList extras = new LongArrayList();
        private final LongArrayList blocks = new LongArrayList();
        private final LongArrayList residuals = new LongArrayList();
        private final LongArrayList left = new LongArrayList();
        private final LongArrayList len = new LongArrayList();
        private OutputBitStream graphObs;
        public long graphWrittenBits;
        public long offsetsWrittenBits;
        private final int bufferSize;
        private final long statsThreshold;

        private CompressionThread(int index, long numNodes, NodeIterator nodeIterator, CharSequence basename, int bufferSize, long statsThreshold, ProgressLogger pl) {
            this.index = index;
            this.numNodes = numNodes;
            this.nodeIterator = nodeIterator;
            this.bufferSize = bufferSize;
            this.threadBasename = basename;
            this.statsThreshold = statsThreshold;
            this.pl = pl;
        }

        private long diffComp(OutputBitStream obs, long currNode, int ref, long[] refList, int refLen, long[] currList, int currLen, boolean forReal) throws IOException {
            int i;
            int t;
            long writtenBitsAtStart = obs.writtenBits();
            int j = 0;
            int k = 0;
            int currBlockLen = 0;
            long prev = 0L;
            boolean copying = true;
            if (ref == 0) {
                refLen = 0;
            }
            this.extras.clear();
            this.blocks.clear();
            while (j < currLen && k < refLen) {
                if (copying) {
                    if (currList[j] > refList[k]) {
                        this.blocks.add((long)currBlockLen);
                        copying = false;
                        currBlockLen = 0;
                        continue;
                    }
                    if (currList[j] < refList[k]) {
                        this.extras.add(currList[j++]);
                        continue;
                    }
                    ++j;
                    ++k;
                    ++currBlockLen;
                    if (!forReal) continue;
                    ++this.copiedArcs;
                    continue;
                }
                if (currList[j] < refList[k]) {
                    this.extras.add(currList[j++]);
                    continue;
                }
                if (currList[j] > refList[k]) {
                    ++k;
                    ++currBlockLen;
                    continue;
                }
                this.blocks.add((long)currBlockLen);
                copying = true;
                currBlockLen = 0;
            }
            if (copying && k < refLen) {
                this.blocks.add((long)currBlockLen);
            }
            while (j < currLen) {
                this.extras.add(currList[j++]);
            }
            long[] block = this.blocks.elements();
            long blockCount = this.blocks.size();
            long extraCount = this.extras.size();
            if (BVGraph.this.windowSize > 0) {
                t = BVGraph.this.writeReference(obs, ref);
                if (forReal) {
                    this.bitsForReferences += (long)t;
                }
            }
            if (ref != 0) {
                t = BVGraph.this.writeBlockCount(obs, (int)blockCount);
                if (forReal) {
                    this.bitsForBlocks += (long)t;
                }
                if (blockCount > 0L) {
                    t = BVGraph.this.writeBlock(obs, (int)block[0]);
                    if (forReal) {
                        this.bitsForBlocks += (long)t;
                    }
                    i = 1;
                    while ((long)i < blockCount) {
                        t = BVGraph.this.writeBlock(obs, (int)(block[i] - 1L));
                        if (forReal) {
                            this.bitsForBlocks += (long)t;
                        }
                        ++i;
                    }
                }
            }
            if (extraCount > 0L) {
                int residualCount;
                long[] residual;
                if (BVGraph.this.minIntervalLength != 0) {
                    int intervalCount = BVGraph.intervalize(this.extras, BVGraph.this.minIntervalLength, this.left, this.len, this.residuals);
                    t = obs.writeGamma(intervalCount);
                    if (forReal) {
                        this.bitsForIntervals += (long)t;
                    }
                    for (i = 0; i < intervalCount; ++i) {
                        if (i == 0) {
                            prev = this.left.getLong(i);
                            t = obs.writeLongGamma(Fast.int2nat((long)(prev - currNode)));
                        } else {
                            t = obs.writeLongGamma(this.left.getLong(i) - prev - 1L);
                        }
                        if (forReal) {
                            this.bitsForIntervals += (long)t;
                        }
                        long currIntLen = this.len.getLong(i);
                        prev = this.left.getLong(i) + currIntLen;
                        if (forReal) {
                            this.intervalisedArcs += currIntLen;
                        }
                        t = obs.writeLongGamma(currIntLen - (long)BVGraph.this.minIntervalLength);
                        if (!forReal) continue;
                        this.bitsForIntervals += (long)t;
                    }
                    residual = this.residuals.elements();
                    residualCount = this.residuals.size();
                } else {
                    residual = this.extras.elements();
                    residualCount = this.extras.size();
                }
                if (residualCount != 0) {
                    if (forReal) {
                        this.residualArcs += (long)residualCount;
                        BVGraph.updateBins(currNode, residual, residualCount, this.residualGapStats);
                    }
                    prev = residual[0];
                    long u = BVGraph.this.writeResidual(obs, Fast.int2nat((long)(prev - currNode)));
                    if (forReal) {
                        this.bitsForResiduals += u;
                    }
                    for (i = 1; i < residualCount; ++i) {
                        if (residual[i] == prev) {
                            throw new IllegalArgumentException("Repeated successor " + prev + " in successor list of node " + currNode);
                        }
                        u = BVGraph.this.writeResidual(obs, residual[i] - prev - 1L);
                        if (forReal) {
                            this.bitsForResiduals += u;
                        }
                        prev = residual[i];
                    }
                }
            }
            return obs.writtenBits() - writtenBitsAtStart;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            if (this.nodeIterator == null) {
                return null;
            }
            OutputBitStream bitCount = new OutputBitStream((OutputStream)NullOutputStream.getInstance(), 0);
            long bitOffset = 0L;
            this.graphObs = new OutputBitStream(new FileOutputStream(this.threadBasename + BVGraph.GRAPH_EXTENSION), this.bufferSize);
            OutputBitStream offsetObs = new OutputBitStream(new FileOutputStream(this.threadBasename + BVGraph.OFFSETS_EXTENSION), this.bufferSize);
            int cyclicBufferSize = BVGraph.this.windowSize + 1;
            long[][] list = new long[cyclicBufferSize][1024];
            int[] listLen = new int[cyclicBufferSize];
            int[] refCount = new int[cyclicBufferSize];
            this.successorGapStats = new long[64];
            this.residualGapStats = new long[64];
            this.nodeIterator.hasNext();
            if (this.pl != null && this.index == 0) {
                this.pl.itemsName = "nodes";
                try {
                    this.pl.expectedUpdates = this.numNodes;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                this.pl.start((CharSequence)"Storing...");
            }
            long updates = 0L;
            while (this.nodeIterator.hasNext()) {
                long currNode = this.nodeIterator.nextLong();
                long longOutd = this.nodeIterator.outdegree();
                if (longOutd > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("This big implementation of BVGraph requires outdegrees to be less than 2^31");
                }
                int outd = (int)longOutd;
                int currIndex = (int)(currNode % (long)cyclicBufferSize);
                BVGraph.this.writeOffset(offsetObs, this.graphObs.writtenBits() - bitOffset);
                bitOffset = this.graphObs.writtenBits();
                this.bitsForOutdegrees += (long)BVGraph.this.writeOutdegree(this.graphObs, outd);
                if (outd > list[currIndex].length) {
                    list[currIndex] = LongArrays.ensureCapacity((long[])list[currIndex], (int)outd);
                }
                BigArrays.copyFromBig((long[][])this.nodeIterator.successorBigArray(), (long)0L, (long[])list[currIndex], (int)0, (int)outd);
                listLen[currIndex] = outd;
                if (outd > 0) {
                    BVGraph.updateBins(currNode, list[currIndex], outd, this.successorGapStats);
                    try {
                        long bestComp = Long.MAX_VALUE;
                        int bestCand = -1;
                        int bestRef = -1;
                        int cand = -1;
                        refCount[currIndex] = -1;
                        for (int ref = 0; ref < cyclicBufferSize; ++ref) {
                            long diffComp;
                            cand = (int)((currNode - (long)ref + (long)cyclicBufferSize) % (long)cyclicBufferSize);
                            if (refCount[cand] >= BVGraph.this.maxRefCount || listLen[cand] == 0 || (diffComp = this.diffComp(bitCount, currNode, ref, list[cand], listLen[cand], list[currIndex], listLen[currIndex], false)) >= bestComp) continue;
                            bestComp = diffComp;
                            bestCand = cand;
                            bestRef = ref;
                        }
                        assert (bestCand >= 0);
                        refCount[currIndex] = refCount[bestCand] + 1;
                        this.diffComp(this.graphObs, currNode, bestRef, list[bestCand], listLen[bestCand], list[currIndex], listLen[currIndex], true);
                        this.totLinks += (long)outd;
                        this.totRef += (long)refCount[currIndex];
                        this.totDist += (long)bestRef;
                    }
                    catch (RuntimeException e) {
                        LOGGER.debug("An exception occurred while storing node " + currNode + " with first outlinks " + BigArrays.toString((long[][])BigArrays.copy((long[][])this.nodeIterator.successorBigArray(), (long)0L, (long)Math.min(16L, this.nodeIterator.outdegree()))));
                        throw e;
                    }
                }
                if (this.pl == null) continue;
                if ((currNode + 1L & this.statsThreshold) == 0L) {
                    this.pl.logger().info(new Formatter(Locale.ROOT).format("bits/link: %.3f; bits/node: %.3f; avgref: %.3f; avgdist: %.3f.", (double)this.graphObs.writtenBits() / (double)(this.totLinks != 0L ? this.totLinks : 1L), (double)this.graphObs.writtenBits() / (double)currNode, (double)this.totRef / (double)currNode, (double)this.totDist / (double)currNode).toString());
                }
                if ((++updates & 0xFFFFL) != 0L) continue;
                ProgressLogger progressLogger = this.pl;
                synchronized (progressLogger) {
                    this.pl.update(updates);
                }
                updates = 0L;
            }
            if (this.pl != null) {
                ProgressLogger progressLogger = this.pl;
                synchronized (progressLogger) {
                    this.pl.update(updates);
                }
            }
            BVGraph.this.writeOffset(offsetObs, this.graphObs.writtenBits() - bitOffset);
            this.graphWrittenBits = this.graphObs.writtenBits();
            this.offsetsWrittenBits = offsetObs.writtenBits();
            this.graphObs.close();
            offsetObs.close();
            return null;
        }
    }
}

