/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.LazyLongIterators;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongBigArrays;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;
import java.util.Properties;

public class ImmutableSubgraph
extends ImmutableGraph {
    private static final boolean DEBUG = false;
    public static final String SUBGRAPHNODES_PROPERTY_KEY = "subgraphnodes";
    public static final String SUPERGRAPHBASENAME_PROPERTY_KEY = "supergraphbasename";
    protected final ImmutableGraph supergraph;
    protected final ImmutableSubgraph supergraphAsSubgraph;
    protected final long[][] subgraphNode;
    protected final long[][] supergraphNode;
    protected final long subgraphSize;
    protected final long supergraphNumNodes;
    protected CharSequence basename;
    private long cacheNode = -1L;
    private long[][] cacheSuccessors;

    public ImmutableSubgraph(ImmutableGraph supergraph, long[][] subgraphNode) {
        this.supergraph = supergraph;
        this.supergraphAsSubgraph = supergraph instanceof ImmutableSubgraph ? (ImmutableSubgraph)supergraph : null;
        this.subgraphNode = subgraphNode;
        this.subgraphSize = BigArrays.length((long[][])subgraphNode);
        this.supergraphNumNodes = supergraph.numNodes();
        this.supergraphNode = LongBigArrays.newBigArray((long)this.supergraphNumNodes);
        BigArrays.fill((long[][])this.supergraphNode, (long)-1L);
        long i = this.subgraphSize;
        while (i-- != 0L) {
            BigArrays.set((long[][])this.supergraphNode, (long)BigArrays.get((long[][])subgraphNode, (long)i), (long)i);
        }
        for (i = 1L; i < this.subgraphSize; ++i) {
            if (BigArrays.get((long[][])subgraphNode, (long)(i - 1L)) < BigArrays.get((long[][])subgraphNode, (long)i)) continue;
            throw new IllegalArgumentException("The provided integer array is not strictly increasing: " + (i - 1L) + "-th element is " + BigArrays.get((long[][])subgraphNode, (long)(i - 1L)) + ", " + i + "-th element is " + BigArrays.get((long[][])subgraphNode, (long)i));
        }
        if (this.subgraphSize > 0L && BigArrays.get((long[][])subgraphNode, (long)(this.subgraphSize - 1L)) >= this.supergraphNumNodes) {
            throw new IllegalArgumentException("Subnode index out of bounds: " + BigArrays.get((long[][])subgraphNode, (long)(this.subgraphSize - 1L)));
        }
    }

    protected ImmutableSubgraph(ImmutableSubgraph immutableSubgraph) {
        this.supergraphNumNodes = immutableSubgraph.supergraphNumNodes;
        this.subgraphSize = immutableSubgraph.subgraphSize;
        this.supergraph = immutableSubgraph.supergraph.copy();
        this.supergraphAsSubgraph = this.supergraph instanceof ImmutableSubgraph ? (ImmutableSubgraph)this.supergraph : null;
        this.subgraphNode = immutableSubgraph.subgraphNode;
        this.supergraphNode = immutableSubgraph.supergraphNode;
    }

    protected ImmutableSubgraph(ImmutableGraph immutableGraph) {
        this.subgraphSize = this.supergraphNumNodes = immutableGraph.numNodes();
        this.supergraph = immutableGraph;
        this.supergraphAsSubgraph = null;
        this.supergraphNode = null;
        this.subgraphNode = null;
    }

    @Override
    public long numNodes() {
        return this.subgraphSize;
    }

    @Override
    public long numArcs() {
        throw new UnsupportedOperationException("Cannot determine the number of arcs in a subgraph");
    }

    @Override
    public boolean randomAccess() {
        return this.supergraph.randomAccess();
    }

    @Override
    public boolean hasCopiableIterators() {
        return this.supergraph.hasCopiableIterators();
    }

    @Override
    public CharSequence basename() {
        if (this.basename == null) {
            throw new IllegalStateException("This immutable subgraph has no basename");
        }
        return this.basename;
    }

    public CharSequence rootBasename() {
        return this.supergraphAsSubgraph != null ? this.supergraphAsSubgraph.rootBasename() : this.supergraph.basename();
    }

    public long toSupergraphNode(long x) {
        if (x < 0L || x >= this.subgraphSize) {
            throw new IllegalArgumentException();
        }
        return BigArrays.get((long[][])this.subgraphNode, (long)x);
    }

    public long fromSupergraphNode(long x) {
        return BigArrays.get((long[][])this.supergraphNode, (long)x);
    }

    public long toRootNode(long x) {
        return this.supergraphAsSubgraph != null ? this.supergraphAsSubgraph.toRootNode(this.toSupergraphNode(x)) : this.toSupergraphNode(x);
    }

    public long fromRootNode(long x) {
        if (this.supergraphAsSubgraph == null) {
            return this.fromSupergraphNode(x);
        }
        long y = this.supergraphAsSubgraph.fromRootNode(x);
        if (y < 0L) {
            return -1L;
        }
        return this.fromSupergraphNode(y);
    }

    @Override
    public NodeIterator nodeIterator(long from) {
        return new ImmutableSubgraphNodeIterator(from, Integer.MAX_VALUE);
    }

    @Override
    public LazyLongIterator successors(long x) {
        return this.successors(x, this.supergraph.successors(this.toSupergraphNode(x)));
    }

    private LazyLongIterator successors(long x, final LazyLongIterator supergraphSuccessors) {
        if (x < 0L || x >= this.subgraphSize) {
            throw new IllegalArgumentException();
        }
        if (this.cacheNode == x) {
            return LazyLongIterators.wrap(this.cacheSuccessors);
        }
        return new LazyLongIterator(){

            @Override
            public long nextLong() {
                long x;
                while ((x = supergraphSuccessors.nextLong()) != -1L) {
                    long result = BigArrays.get((long[][])ImmutableSubgraph.this.supergraphNode, (long)x);
                    if (result < 0L) continue;
                    return result;
                }
                return -1L;
            }

            @Override
            public long skip(long n) {
                long i;
                for (i = 0L; i < n && this.nextLong() != -1L; ++i) {
                }
                return i;
            }
        };
    }

    @Override
    public long outdegree(long x) {
        return this.outdegree(x, this.supergraph.successors(this.toSupergraphNode(x)));
    }

    public long outdegree(long x, LazyLongIterator supergraphSuccessors) {
        if (x < 0L || x >= this.subgraphSize) {
            throw new IllegalArgumentException();
        }
        if (this.cacheNode == x) {
            return BigArrays.length((long[][])this.cacheSuccessors);
        }
        this.cacheSuccessors = LazyLongIterators.unwrap(this.successors(x, supergraphSuccessors));
        this.cacheNode = x;
        assert (this.cacheSuccessors != null);
        return BigArrays.length((long[][])this.cacheSuccessors);
    }

    @Override
    public ImmutableSubgraph copy() {
        return new ImmutableSubgraph(this);
    }

    public static ImmutableSubgraph asImmutableSubgraph(ImmutableGraph graph) {
        return new ImmutableGraphWrapper(graph);
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.STANDARD, basename);
    }

    @Deprecated
    public static ImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, pl);
    }

    public static ImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename);
    }

    public static ImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename, pl);
    }

    public static ImmutableGraph load(CharSequence basename) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.STANDARD, basename);
    }

    public static ImmutableGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, pl);
    }

    private static ImmutableGraph load(ImmutableGraph.LoadMethod method, CharSequence basename) throws IOException {
        return ImmutableSubgraph.load(method, basename, null);
    }

    public static ImmutableGraph loadMapped(CharSequence basename, ProgressLogger pl) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.MAPPED, basename, pl);
    }

    public static ImmutableGraph loadMapped(CharSequence basename) throws IOException {
        return ImmutableSubgraph.load(ImmutableGraph.LoadMethod.MAPPED, basename, null);
    }

    protected static ImmutableGraph load(ImmutableGraph.LoadMethod method, CharSequence basename, ProgressLogger pl) throws IOException {
        String nodes;
        FileInputStream propertyFile = new FileInputStream(basename + ".properties");
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        String graphClassName = properties.getProperty("graphclass");
        if (!graphClassName.equals(ImmutableSubgraph.class.getName())) {
            throw new IOException("This class (" + ImmutableSubgraph.class.getName() + ") cannot load a graph stored using " + graphClassName);
        }
        String supergraphBasename = properties.getProperty(SUPERGRAPHBASENAME_PROPERTY_KEY);
        if (supergraphBasename == null) {
            throw new IOException("This property file does not specify the required property supergraphbasename");
        }
        ImmutableGraph supergraph = ImmutableGraph.load(method, supergraphBasename, null, pl);
        if (pl != null) {
            pl.start((CharSequence)"Reading nodes...");
        }
        ImmutableSubgraph isg = new ImmutableSubgraph(supergraph, BinIO.loadLongsBig((CharSequence)((nodes = properties.getProperty(SUBGRAPHNODES_PROPERTY_KEY)) != null ? nodes : basename + ".nodes")));
        if (pl != null) {
            pl.count = isg.numNodes();
            pl.done();
        }
        isg.basename = new MutableString(basename);
        return isg;
    }

    public static void store(ImmutableGraph graph, CharSequence basename, ProgressLogger pm) {
        throw new UnsupportedOperationException("You cannot store a generic immutable graph as a subgraph");
    }

    public static void store(ImmutableGraph graph, CharSequence basename) {
        ImmutableSubgraph.store(graph, basename, (ProgressLogger)null);
    }

    public void save(CharSequence basename, ProgressLogger pl) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("graphclass", ImmutableSubgraph.class.getName());
        properties.setProperty(SUPERGRAPHBASENAME_PROPERTY_KEY, this.supergraph.basename().toString());
        FileOutputStream propertyFile = new FileOutputStream(basename + ".properties");
        properties.store(propertyFile, null);
        propertyFile.close();
        if (pl != null) {
            pl.start((CharSequence)"Saving nodes...");
        }
        BinIO.storeLongs((long[][])this.subgraphNode, (long)0L, (long)BigArrays.length((long[][])this.subgraphNode), (CharSequence)(basename + ".nodes"));
        if (pl != null) {
            pl.count = BigArrays.length((long[][])this.subgraphNode);
            pl.done();
        }
    }

    public void save(CharSequence basename) throws IOException {
        this.save(basename, null);
    }

    public static void main(String[] args) throws IllegalArgumentException, SecurityException, JSAPException, UnsupportedEncodingException, FileNotFoundException {
        SimpleJSAP jsap = new SimpleJSAP(ImmutableSubgraph.class.getName(), "Writes the property file of an immutable subgraph.", new Parameter[]{new UnflaggedOption("supergraphBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the supergraph."), new FlaggedOption("subgraphNodes", (StringParser)JSAP.STRING_PARSER, null, false, 's', "subgraph-nodes", "Sets a subgraph node file (a list integers in DataInput format). If not specified, the name will be stemmed from the basename."), new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of resulting immutable subgraph.")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(jsapResult.getString("basename") + ".properties"), "UTF-8"));
        pw.println("graphclass = " + ImmutableSubgraph.class.getName());
        pw.println("supergraphbasename = " + jsapResult.getString("supergraphBasename"));
        if (jsapResult.userSpecified("subgraphNodes")) {
            pw.println("subgraphnodes = " + jsapResult.getString("subgraphNodes"));
        }
        pw.close();
    }

    private final class ImmutableSubgraphNodeIterator
    extends NodeIterator {
        private final long from;
        long node;
        long[][] successorsCache = LongBigArrays.EMPTY_BIG_ARRAY;
        long outdegree = -1L;
        final NodeIterator supergraphNodeIterator;
        final long upperBound;

        private ImmutableSubgraphNodeIterator(long from, long to) {
            this.from = from;
            this.node = from;
            this.supergraphNodeIterator = ImmutableSubgraph.this.supergraph.nodeIterator(BigArrays.get((long[][])ImmutableSubgraph.this.subgraphNode, (long)from));
            this.upperBound = to;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.node != this.from) {
                this.supergraphNodeIterator.skip(BigArrays.get((long[][])ImmutableSubgraph.this.subgraphNode, (long)this.node) - BigArrays.get((long[][])ImmutableSubgraph.this.subgraphNode, (long)(this.node - 1L)));
            } else {
                this.supergraphNodeIterator.nextLong();
            }
            this.outdegree = -1L;
            return this.node++;
        }

        public boolean hasNext() {
            return this.node < Math.min(ImmutableSubgraph.this.subgraphSize, this.upperBound);
        }

        private void unwrapSuccessors() {
            long done;
            long start = 0L;
            LazyLongIterator i = ImmutableSubgraph.this.successors(this.node - 1L, this.supergraphNodeIterator.successors());
            while ((done = LazyLongIterators.unwrap(i, this.successorsCache, start, BigArrays.length((long[][])this.successorsCache) - start)) == BigArrays.length((long[][])this.successorsCache) - start) {
                start = BigArrays.length((long[][])this.successorsCache);
                this.successorsCache = BigArrays.grow((long[][])this.successorsCache, (long)(BigArrays.length((long[][])this.successorsCache) + 1L));
            }
            this.outdegree = start + done;
        }

        @Override
        public LazyLongIterator successors() {
            if (this.node == this.from) {
                throw new IllegalStateException();
            }
            if (this.outdegree == -1L) {
                this.unwrapSuccessors();
            }
            return LazyLongIterators.wrap(this.successorsCache, this.outdegree);
        }

        @Override
        public long outdegree() {
            if (this.node == this.from) {
                throw new IllegalStateException();
            }
            if (this.outdegree == -1L) {
                this.unwrapSuccessors();
            }
            return this.outdegree;
        }

        @Override
        public NodeIterator copy(long upperBound) {
            ImmutableSubgraphNodeIterator result = new ImmutableSubgraphNodeIterator(this.from, upperBound);
            result.node = this.node;
            result.outdegree = this.outdegree;
            return result;
        }
    }

    private static class ImmutableGraphWrapper
    extends ImmutableSubgraph {
        public ImmutableGraphWrapper(ImmutableGraph graph) {
            super(graph);
            try {
                this.basename = graph.basename();
            }
            catch (UnsupportedOperationException e) {
                this.basename = null;
            }
        }

        @Override
        public NodeIterator nodeIterator() {
            return this.supergraph.nodeIterator();
        }

        @Override
        public NodeIterator nodeIterator(long from) {
            return this.supergraph.nodeIterator(from);
        }

        @Override
        public long numArcs() {
            return this.supergraph.numArcs();
        }

        @Override
        public long numNodes() {
            return this.supergraph.numNodes();
        }

        @Override
        public long outdegree(long x) {
            return this.supergraph.outdegree(x);
        }

        @Override
        public LazyLongIterator successors(long x) {
            return this.supergraph.successors(x);
        }

        @Override
        public long toSupergraphNode(long x) {
            return x;
        }

        @Override
        public long fromSupergraphNode(long x) {
            return x;
        }

        @Override
        public long toRootNode(long x) {
            return x;
        }

        @Override
        public long fromRootNode(long x) {
            return x;
        }
    }
}

