/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.LazyLongIterator;

public class LongIntervalSequenceIterator
implements LazyLongIterator {
    private final long[] left;
    private final long[] len;
    private long remaining;
    private int currInterval;
    private int currIndex;
    private long currLeft;

    public LongIntervalSequenceIterator(long[] left, long[] len) {
        this(left, len, left.length);
    }

    public LongIntervalSequenceIterator(long[] left, long[] len, int n) {
        this.left = left;
        this.len = len;
        this.remaining = n;
        if (n != 0) {
            this.currLeft = left[0];
        }
    }

    private void advance() {
        --this.remaining;
        if (this.remaining != 0L) {
            this.currLeft = this.left[++this.currInterval];
        }
        this.currIndex = 0;
    }

    @Override
    public long nextLong() {
        if (this.remaining == 0L) {
            return -1L;
        }
        long next = this.currLeft + (long)this.currIndex++;
        if ((long)this.currIndex == this.len[this.currInterval]) {
            this.advance();
        }
        return next;
    }

    @Override
    public long skip(long n) {
        long skipped;
        for (skipped = 0L; skipped < n && this.remaining != 0L; skipped += this.len[this.currInterval] - (long)this.currIndex) {
            if (n - skipped < this.len[this.currInterval] - (long)this.currIndex) {
                this.currIndex = (int)((long)this.currIndex + (n - skipped));
                return n;
            }
            this.advance();
        }
        return skipped;
    }
}

