/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph;

import it.unimi.dsi.big.webgraph.LazyLongIterator;

public class MergedLongIterator
implements LazyLongIterator {
    private final LazyLongIterator it0;
    private final LazyLongIterator it1;
    private long n;
    private long curr0;
    private long curr1;

    public MergedLongIterator(LazyLongIterator it0, LazyLongIterator it1) {
        this(it0, it1, Integer.MAX_VALUE);
    }

    public MergedLongIterator(LazyLongIterator it0, LazyLongIterator it1, long n) {
        this.it0 = it0;
        this.it1 = it1;
        this.n = n;
        this.curr0 = it0.nextLong();
        this.curr1 = it1.nextLong();
    }

    @Override
    public long nextLong() {
        long result;
        if (this.n == 0L || this.curr0 == -1L && this.curr1 == -1L) {
            return -1L;
        }
        --this.n;
        if (this.curr0 == -1L) {
            result = this.curr1;
            this.curr1 = this.it1.nextLong();
        } else if (this.curr1 == -1L) {
            result = this.curr0;
            this.curr0 = this.it0.nextLong();
        } else if (this.curr0 < this.curr1) {
            result = this.curr0;
            this.curr0 = this.it0.nextLong();
        } else if (this.curr0 > this.curr1) {
            result = this.curr1;
            this.curr1 = this.it1.nextLong();
        } else {
            result = this.curr0;
            this.curr0 = this.it0.nextLong();
            this.curr1 = this.it1.nextLong();
        }
        return result;
    }

    @Override
    public long skip(long s) {
        long i;
        for (i = 0L; i < s && this.n != 0L && (this.curr0 != -1L || this.curr1 != -1L); ++i) {
            --this.n;
            if (this.curr0 == -1L) {
                this.curr1 = this.it1.nextLong();
                continue;
            }
            if (this.curr1 == -1L) {
                this.curr0 = this.it0.nextLong();
                continue;
            }
            if (this.curr0 < this.curr1) {
                this.curr0 = this.it0.nextLong();
                continue;
            }
            if (this.curr0 > this.curr1) {
                this.curr1 = this.it1.nextLong();
                continue;
            }
            this.curr0 = this.it0.nextLong();
            this.curr1 = this.it1.nextLong();
        }
        return i;
    }
}

