/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.labelling;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.big.webgraph.AbstractLazyLongIterator;
import it.unimi.dsi.big.webgraph.BVGraph;
import it.unimi.dsi.big.webgraph.ImmutableGraph;
import it.unimi.dsi.big.webgraph.LazyLongIterator;
import it.unimi.dsi.big.webgraph.NodeIterator;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledImmutableGraph;
import it.unimi.dsi.big.webgraph.labelling.ArcLabelledNodeIterator;
import it.unimi.dsi.big.webgraph.labelling.Label;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastMultiByteArrayInputStream;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.io.ByteBufferInputStream;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneBigLongBigList;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitStreamArcLabelledImmutableGraph
extends ArcLabelledImmutableGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(BitStreamArcLabelledImmutableGraph.class);
    public static final String LABELS_EXTENSION = ".labels";
    public static final String LABEL_OFFSETS_EXTENSION = ".labeloffsets";
    public static final String LABEL_OFFSETS_BIG_LIST_EXTENSION = ".labelobl";
    public static final String LABELSPEC_PROPERTY_KEY = "labelspec";
    private static final int STD_BUFFER_SIZE = 0x100000;
    public final ImmutableGraph g;
    protected final Label prototype;
    private final byte[] byteArray;
    private final FastMultiByteArrayInputStream labelStream;
    private final ByteBufferInputStream mappedLabelStream;
    protected final CharSequence basename;
    protected final LongBigList offset;

    protected BitStreamArcLabelledImmutableGraph(CharSequence basename, ImmutableGraph g, Label prototype, byte[] byteArray, FastMultiByteArrayInputStream labelStream, ByteBufferInputStream mappedLabelStream, LongBigList offset) {
        this.g = g;
        this.byteArray = byteArray;
        this.labelStream = labelStream;
        this.prototype = prototype;
        this.basename = basename;
        this.mappedLabelStream = mappedLabelStream;
        this.offset = offset;
    }

    @Override
    public BitStreamArcLabelledImmutableGraph copy() {
        return new BitStreamArcLabelledImmutableGraph(this.basename, this.g.copy(), this.prototype.copy(), this.byteArray, this.labelStream, this.mappedLabelStream != null ? this.mappedLabelStream.copy() : null, this.offset);
    }

    protected InputBitStream newInputBitStream() throws FileNotFoundException {
        return this.byteArray != null ? new InputBitStream(this.byteArray) : (this.labelStream != null ? new InputBitStream((InputStream)new FastMultiByteArrayInputStream(this.labelStream)) : (this.mappedLabelStream != null ? new InputBitStream((InputStream)this.mappedLabelStream.copy()) : new InputBitStream(this.basename + LABELS_EXTENSION)));
    }

    @Override
    public CharSequence basename() {
        return this.basename;
    }

    protected long offset(long x) {
        return this.offset.getLong(x);
    }

    @Override
    public ArcLabelledNodeIterator.LabelledArcIterator successors(long x) {
        return new BitStreamLabelledArcIterator(this, x);
    }

    @Override
    public long[][] successorBigArray(long x) {
        return this.g.successorBigArray(x);
    }

    @Override
    public long numNodes() {
        return this.g.numNodes();
    }

    @Override
    public long numArcs() {
        return this.g.numArcs();
    }

    @Override
    public boolean randomAccess() {
        return this.g.randomAccess() && this.offset != null;
    }

    @Override
    public boolean hasCopiableIterators() {
        return false;
    }

    @Override
    public long outdegree(long x) {
        return this.g.outdegree(x);
    }

    @Deprecated
    public static BitStreamArcLabelledImmutableGraph loadSequential(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.SEQUENTIAL, basename, null);
    }

    @Deprecated
    public static BitStreamArcLabelledImmutableGraph loadSequential(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.SEQUENTIAL, basename, pl);
    }

    public static BitStreamArcLabelledImmutableGraph loadOffline(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename, null);
    }

    public static BitStreamArcLabelledImmutableGraph loadOffline(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.OFFLINE, basename, pl);
    }

    public static BitStreamArcLabelledImmutableGraph loadMapped(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.MAPPED, basename, null);
    }

    public static BitStreamArcLabelledImmutableGraph loadMapped(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.MAPPED, basename, pl);
    }

    public static BitStreamArcLabelledImmutableGraph load(CharSequence basename) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, null);
    }

    public static BitStreamArcLabelledImmutableGraph load(CharSequence basename, ProgressLogger pl) throws IOException {
        return BitStreamArcLabelledImmutableGraph.load(ImmutableGraph.LoadMethod.STANDARD, basename, pl);
    }

    protected static BitStreamArcLabelledImmutableGraph load(ImmutableGraph.LoadMethod method, CharSequence basename, ProgressLogger pl) throws IOException {
        Label prototype;
        FileInputStream propertyFile = new FileInputStream(basename + ".properties");
        Properties properties = new Properties();
        properties.load(propertyFile);
        propertyFile.close();
        if (properties.getProperty("underlyinggraph") == null) {
            throw new IOException("The property file for " + basename + " does not contain an underlying graph basename");
        }
        String graphName = properties.getProperty("underlyinggraph");
        if (!new File(graphName).isAbsolute()) {
            graphName = new File(new File(basename.toString()).getParentFile(), properties.getProperty("underlyinggraph")).toString();
        }
        FileInputStream graphPropertyFile = new FileInputStream(graphName + ".properties");
        Properties graphProperties = new Properties();
        graphProperties.load(graphPropertyFile);
        graphPropertyFile.close();
        ImmutableGraph g = ImmutableGraph.load(method, graphName, null, pl);
        if (properties.getProperty(LABELSPEC_PROPERTY_KEY) == null) {
            throw new IOException("The property file for " + basename + " does not contain a label specification");
        }
        try {
            try {
                prototype = (Label)ObjectParser.fromSpec((Object)new File(basename.toString()).getParentFile(), (String)properties.getProperty(LABELSPEC_PROPERTY_KEY), Label.class);
            }
            catch (NoSuchMethodException e) {
                prototype = (Label)ObjectParser.fromSpec((String)properties.getProperty(LABELSPEC_PROPERTY_KEY), Label.class);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] byteArray = null;
        FastMultiByteArrayInputStream labelStream = null;
        ByteBufferInputStream mappedLabelStream = null;
        LongBigList offsets = null;
        if (method != ImmutableGraph.LoadMethod.OFFLINE) {
            if (pl != null) {
                pl.itemsName = "bytes";
                pl.start((CharSequence)"Loading labels...");
            }
            FileInputStream fis = new FileInputStream(basename + LABELS_EXTENSION);
            long size = fis.getChannel().size();
            if (method == ImmutableGraph.LoadMethod.MAPPED) {
                mappedLabelStream = ByteBufferInputStream.map((FileChannel)fis.getChannel(), (FileChannel.MapMode)FileChannel.MapMode.READ_ONLY);
            } else if (size <= Integer.MAX_VALUE) {
                byteArray = BinIO.loadBytes((CharSequence)(basename + LABELS_EXTENSION));
            } else {
                labelStream = new FastMultiByteArrayInputStream((InputStream)fis, size);
            }
            if (pl != null) {
                pl.count = size;
                pl.done();
            }
            if (method != ImmutableGraph.LoadMethod.SEQUENTIAL) {
                block22: {
                    File offsetsBigListFile;
                    if (pl != null) {
                        pl.itemsName = "deltas";
                        pl.expectedUpdates = g.numNodes() + 1L;
                        pl.start((CharSequence)"Loading label offsets...");
                    }
                    if ((offsetsBigListFile = new File(basename + LABEL_OFFSETS_BIG_LIST_EXTENSION)).exists()) {
                        try {
                            offsets = (LongBigList)BinIO.loadObject((File)offsetsBigListFile);
                        }
                        catch (ClassNotFoundException e) {
                            if (pl == null) break block22;
                            LOGGER.warn("A cached long big list of offsets was found, but its class is unknown", (Throwable)e);
                        }
                    }
                }
                if (offsets == null) {
                    InputBitStream offsetStream = new InputBitStream(basename + LABEL_OFFSETS_EXTENSION);
                    offsets = EliasFanoMonotoneLongBigList.fits((long)(g.numNodes() + 1L), (long)(size * 8L + 1L)) ? new EliasFanoMonotoneLongBigList(g.numNodes() + 1L, size * 8L + 1L, (LongIterator)new OffsetsLongIterator(g, offsetStream)) : new EliasFanoMonotoneBigLongBigList(g.numNodes() + 1L, size * 8L + 1L, (LongIterator)new OffsetsLongIterator(g, offsetStream));
                    offsetStream.close();
                }
                if (pl != null) {
                    pl.count = g.numNodes() + 1L;
                    pl.done();
                    long offsetsNumBits = offsets instanceof EliasFanoMonotoneLongBigList ? ((EliasFanoMonotoneLongBigList)offsets).numBits() : ((EliasFanoMonotoneBigLongBigList)offsets).numBits();
                    pl.logger().info("Label pointer bits per node: " + (double)offsetsNumBits / ((double)g.numNodes() + 1.0));
                }
            }
            fis.close();
        }
        return new BitStreamArcLabelledImmutableGraph(basename, g, prototype, byteArray, labelStream, mappedLabelStream, offsets);
    }

    @Override
    public ArcLabelledNodeIterator nodeIterator(long from) {
        try {
            return new BitStreamArcLabelledNodeIterator(from, this.g, this.prototype, this.newInputBitStream());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Label prototype() {
        return this.prototype;
    }

    public static void store(ArcLabelledImmutableGraph graph, CharSequence basename, CharSequence underlyingBasename) throws IOException {
        BitStreamArcLabelledImmutableGraph.store(graph, basename, underlyingBasename, null);
    }

    public static void store(ArcLabelledImmutableGraph graph, CharSequence basename, CharSequence underlyingBasename, ProgressLogger pl) throws IOException {
        OutputBitStream labels = new OutputBitStream(basename + LABELS_EXTENSION, 0x100000);
        OutputBitStream offsets = new OutputBitStream(basename + LABEL_OFFSETS_EXTENSION, 0x100000);
        if (pl != null) {
            pl.itemsName = "nodes";
            pl.expectedUpdates = graph.numNodes();
            pl.start((CharSequence)"Saving labels...");
        }
        ArcLabelledNodeIterator nodeIterator = graph.nodeIterator();
        offsets.writeGamma(0);
        while (nodeIterator.hasNext()) {
            long curr = nodeIterator.nextLong();
            ArcLabelledNodeIterator.LabelledArcIterator successors = nodeIterator.successors();
            long count = 0L;
            while (successors.nextLong() != -1L) {
                count += (long)successors.label().toBitStream(labels, curr);
            }
            offsets.writeLongGamma(count);
            if (pl == null) continue;
            pl.lightUpdate();
        }
        if (pl != null) {
            pl.done();
        }
        labels.close();
        offsets.close();
        PrintWriter properties = new PrintWriter(new FileOutputStream(basename + ".properties"));
        properties.println("graphclass = " + BitStreamArcLabelledImmutableGraph.class.getName());
        properties.println("underlyinggraph = " + underlyingBasename);
        properties.println("labelspec = " + graph.prototype().toSpec());
        properties.close();
    }

    public static void main(String[] args) throws JSAPException, IOException {
        SimpleJSAP jsap = new SimpleJSAP(BVGraph.class.getName(), "Write an ArcLabelledGraph as a BitStreamArcLabelledImmutableGraph. Source and destination are basenames from which suitable filenames will be stemmed.", new Parameter[]{new Switch("list", 'L', "list", "Precomputes an Elias-Fano list of offsets for the source labels."), new FlaggedOption("underlyingBasename", (StringParser)JSAP.STRING_PARSER, null, false, 'u', "underlying", "The basename of the underlying graph"), new UnflaggedOption("sourceBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The basename of the source graph, or a source spec if --spec was given; it is immaterial when --once is specified."), new UnflaggedOption("destBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The basename of the destination graph; if omitted, no recompression is performed. This is useful in conjunction with --offsets and --list.")});
        JSAPResult jsapResult = jsap.parse(args);
        if (jsap.messagePrinted()) {
            System.exit(1);
        }
        boolean list = jsapResult.getBoolean("list");
        String source = jsapResult.getString("sourceBasename");
        String dest = jsapResult.getString("destBasename");
        String underlying = jsapResult.getString("underlyingBasename");
        ProgressLogger pl = new ProgressLogger(LOGGER, 10L, TimeUnit.SECONDS);
        ArcLabelledImmutableGraph graph = ArcLabelledImmutableGraph.loadOffline(source, pl);
        if (dest != null) {
            if (list) {
                throw new IllegalArgumentException("You cannot specify a destination graph with these options");
            }
            if (underlying == null) {
                throw new IllegalArgumentException("You must specify an underlying graph with --underlying if you want to store a BitStreamArcLabelledImmutableGraph");
            }
            BitStreamArcLabelledImmutableGraph.store(graph, dest, (CharSequence)underlying, pl);
        } else if (list) {
            FileInputStream fis = new FileInputStream(source + LABELS_EXTENSION);
            long size = fis.getChannel().size();
            ImmutableGraph g = ImmutableGraph.loadOffline(source, pl);
            InputBitStream offsetStream = new InputBitStream(source + LABEL_OFFSETS_EXTENSION);
            EliasFanoMonotoneLongBigList offsets = EliasFanoMonotoneLongBigList.fits((long)(g.numNodes() + 1L), (long)(size * 8L + 1L)) ? new EliasFanoMonotoneLongBigList(g.numNodes() + 1L, size * 8L + 1L, (LongIterator)new OffsetsLongIterator(g, offsetStream)) : new EliasFanoMonotoneBigLongBigList(g.numNodes() + 1L, size * 8L + 1L, (LongIterator)new OffsetsLongIterator(g, offsetStream));
            offsetStream.close();
            fis.close();
            BinIO.storeObject((Object)offsets, (CharSequence)(g.basename() + LABEL_OFFSETS_BIG_LIST_EXTENSION));
        } else {
            throw new IllegalArgumentException("You must specify a destination graph.");
        }
    }

    protected static class BitStreamLabelledArcIterator
    extends AbstractLazyLongIterator
    implements ArcLabelledNodeIterator.LabelledArcIterator {
        protected final LazyLongIterator underlyingIterator;
        protected final InputBitStream ibs;
        protected final Label label;
        protected final long from;

        public BitStreamLabelledArcIterator(BitStreamArcLabelledImmutableGraph alg, long x) {
            this.from = x;
            this.underlyingIterator = alg.g.successors(this.from);
            try {
                this.ibs = alg.newInputBitStream();
                this.ibs.position(alg.offset(x));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.label = alg.prototype.copy();
        }

        @Override
        public Label label() {
            return this.label;
        }

        @Override
        public long nextLong() {
            long successor = this.underlyingIterator.nextLong();
            if (successor == -1L) {
                return -1L;
            }
            try {
                this.label.fromBitStream(this.ibs, this.from);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return successor;
        }
    }

    private static final class OffsetsLongIterator
    implements LongIterator {
        private final InputBitStream offsetStream;
        private final long n;
        private long off;
        private long i;

        private OffsetsLongIterator(ImmutableGraph g, InputBitStream offsetIbs) {
            this.offsetStream = offsetIbs;
            this.n = g.numNodes();
        }

        public boolean hasNext() {
            return this.i <= this.n;
        }

        public long nextLong() {
            ++this.i;
            try {
                this.off = this.offsetStream.readLongGamma() + this.off;
                return this.off;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class BitStreamArcLabelledNodeIterator
    extends ArcLabelledNodeIterator {
        private final NodeIterator underlyingNodeIterator;
        private final InputBitStream ibs;
        private final Label prototype;
        private Label[][] label = Label.EMPTY_LABEL_BIG_ARRAY;

        public BitStreamArcLabelledNodeIterator(long from, ImmutableGraph g, Label prototype, InputBitStream ibs) {
            this.prototype = prototype;
            this.ibs = ibs;
            this.underlyingNodeIterator = g.nodeIterator();
            long i = from;
            while (i-- != 0L) {
                this.nextLong();
            }
        }

        @Override
        public ArcLabelledNodeIterator.LabelledArcIterator successors() {
            return new BitStreamArcLabelledNodeIteratorArcIterator(this.underlyingNodeIterator.outdegree(), this.underlyingNodeIterator.successorBigArray(), this.label);
        }

        @Override
        public long[][] successorBigArray() {
            return this.underlyingNodeIterator.successorBigArray();
        }

        @Override
        public Label[][] labelBigArray() {
            return this.label;
        }

        @Override
        public long outdegree() {
            return this.underlyingNodeIterator.outdegree();
        }

        public long nextLong() {
            long curr = this.underlyingNodeIterator.nextLong();
            long d = this.underlyingNodeIterator.outdegree();
            if (BigArrays.length((Object[][])this.label) < d) {
                this.label = (Label[][])BigArrays.grow((Object[][])this.label, (long)d);
                int i = this.label.length;
                block2: while (i-- != 0) {
                    Label[] t = this.label[i];
                    int j = t.length;
                    while (j-- != 0) {
                        if (t[j] != null) break block2;
                        t[j] = this.prototype.copy();
                    }
                }
            }
            try {
                for (long i = 0L; i < d; ++i) {
                    ((Label)BigArrays.get((Object[][])this.label, (long)i)).fromBitStream(this.ibs, curr);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return curr;
        }

        public boolean hasNext() {
            return this.underlyingNodeIterator.hasNext();
        }

        private static final class BitStreamArcLabelledNodeIteratorArcIterator
        extends AbstractLazyLongIterator
        implements ArcLabelledNodeIterator.LabelledArcIterator {
            private final Label[][] label;
            private final long[][] successor;
            private final long outdegree;
            private long curr;

            public BitStreamArcLabelledNodeIteratorArcIterator(long outdegree, long[][] ls, Label[][] label) {
                this.outdegree = outdegree;
                this.successor = ls;
                this.label = label;
                this.curr = -1L;
            }

            @Override
            public Label label() {
                if (this.curr == -1L) {
                    throw new IllegalStateException("This successor iterator is currently not valid");
                }
                return (Label)BigArrays.get((Object[][])this.label, (long)this.curr);
            }

            @Override
            public long nextLong() {
                if (this.curr == this.outdegree - 1L) {
                    return -1L;
                }
                return BigArrays.get((long[][])this.successor, (long)(++this.curr));
            }

            @Override
            public long skip(long n) {
                long toSkip = Math.min(n, this.outdegree - 1L - this.curr);
                this.curr += toSkip;
                return toSkip;
            }
        }
    }
}

