/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.big.webgraph.labelling;

import it.unimi.dsi.big.webgraph.labelling.AbstractIntLabel;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;

public class GammaCodedIntLabel
extends AbstractIntLabel {
    public GammaCodedIntLabel(String key, int value) {
        super(key, value);
        if (value < 0) {
            throw new IllegalArgumentException("Value cannot be negative: " + value);
        }
    }

    public GammaCodedIntLabel(String ... key) {
        super(key[0], 0);
    }

    @Override
    public GammaCodedIntLabel copy() {
        return new GammaCodedIntLabel(this.key, this.value);
    }

    @Override
    public int fromBitStream(InputBitStream inputBitStream, long sourceUnused) throws IOException {
        long prevRead = inputBitStream.readBits();
        this.value = inputBitStream.readGamma();
        return (int)(inputBitStream.readBits() - prevRead);
    }

    @Override
    public int toBitStream(OutputBitStream outputBitStream, long sourceUnused) throws IOException {
        return outputBitStream.writeGamma(this.value);
    }

    @Override
    public int fixedWidth() {
        return -1;
    }

    @Override
    public String toString() {
        return this.key + ":" + this.value + " (gamma)";
    }

    @Override
    public String toSpec() {
        return this.getClass().getName() + "(" + this.key + ")";
    }
}

