/*
 * Decompiled with CFR 0.152.
 */
package it.zenitlab.jsonrpc.commons;

import it.zenitlab.jsonrpc.commons.JsonRpcException;
import it.zenitlab.jsonrpc.commons.JsonRpcResponse;

public class JsonRpcError {
    public static final int SYNTHAX_ERROR = -32700;
    public static final int INVALID_REQUEST = -32600;
    public static final int METHOD_NOT_FOUND = -32601;
    public static final int INVALID_PARAMS = -32602;
    public static final int INTERNAL_ERROR = -1000;
    public static final int UTENTE_NON_AUTORIZZATO = 100;
    public static final int VALORE_PARAMETRO_NON_VALIDO = 101;
    public static final int OGGETTO_INESITENTE = 102;
    public static final int HTTP_ERROR = 103;
    public static final int ERRORE_GENERICO = 0;
    int code;
    String detailedMessage;
    String userMessage;
    Object data;

    public JsonRpcError() {
    }

    public JsonRpcError(JsonRpcException ex) {
        this.code = ex.code;
        this.detailedMessage = ex.getMessage();
    }

    public JsonRpcError(JsonRpcException ex, String userMessage) {
        this.code = ex.code;
        this.detailedMessage = ex.getMessage();
        this.userMessage = userMessage;
    }

    public JsonRpcError(int code, String userMessage, Object data) {
        this.code = code;
        this.userMessage = userMessage;
        this.data = data;
    }

    public JsonRpcResponse toJsonRpcResponse(Object responseId) {
        JsonRpcResponse res = new JsonRpcResponse();
        res.setError(this);
        res.setId(responseId);
        res.setResult(null);
        return res;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public void setDetailedMessage(String message) {
        this.detailedMessage = message;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public void setUserMessage(String finalMessage) {
        this.userMessage = finalMessage;
    }
}

