/*
 * Decompiled with CFR 0.152.
 */
package it.zenitlab.jsonrpc.servlet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.zenitlab.jsonrpc.commons.JsonRpcError;
import it.zenitlab.jsonrpc.commons.JsonRpcException;
import it.zenitlab.jsonrpc.commons.JsonRpcResponse;
import it.zenitlab.jsonrpc.servlet.DBConnectionMonitor;
import it.zenitlab.jsonrpc.servlet.JsonRpcMethod;
import it.zenitlab.jsonrpc.servlet.JsonRpcRequestJson;
import it.zenitlab.jsonrpc.servlet.JsonRpcService;
import it.zenitlab.jsonrpc.servlet.JsonRpcWsDescriptor;
import it.zenitlab.jsonrpc.servlet.LogAppendersProvider;
import it.zenitlab.sessionmanager.SessionInfo;
import it.zenitlab.sessionmanager.SessionManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;

public class JsonRpcServlet
extends HttpServlet {
    Class serviceClass;
    private ArrayList<JsonRpcWsDescriptor> wsDescriptor;
    private HashMap<String, JsonRpcWsDescriptor> wsMethods = new HashMap();
    private String serviceListKeyword;
    private org.apache.log4j.Logger logger;
    private DBConnectionMonitor dbConnectionMonitor;
    private LogAppendersProvider logAppenderProvider;
    private int parametersMaxLogLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Headers", "origin, x-requested-with, content-type");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST");
        String qs = request.getQueryString();
        if (qs != null && qs.toLowerCase().equals(this.serviceListKeyword.toLowerCase())) {
            this.writeWsDescriptors(response);
            return;
        }
        if (qs != null && (qs.toLowerCase().equals("javaclient") || qs.toLowerCase().equals("rpcdelegate"))) {
            this.writeJavaClient(response);
            return;
        }
        if (qs != null && (qs.toLowerCase().equals("javascriptclient") || qs.toLowerCase().equals("jsclient"))) {
            this.writeJSClient(response, request.getServletPath().replace("/", "_"));
            return;
        }
        JsonRpcRequestJson jsonRequest = this.parseRequest(request, response);
        if (jsonRequest == null) {
            return;
        }
        SessionInfo is = null;
        String username = "";
        if (jsonRequest.getSessionkey() != null && (is = SessionManager.get(jsonRequest.getSessionkey())) != null) {
            username = " username: " + is.getUsername();
            SessionManager.updateExpiration(jsonRequest.getSessionkey());
        }
        if (this.logAppenderProvider != null) {
            for (Appender a : this.logAppenderProvider.getAppenders(jsonRequest.getSessionkey())) {
                this.logger.addAppender(a);
            }
        }
        this.logger.info((Object)(jsonRequest + username));
        JsonRpcService serviceInstance = null;
        try {
            serviceInstance = (JsonRpcService)this.serviceClass.newInstance();
        }
        catch (InstantiationException ex) {
            org.apache.log4j.Logger.getLogger((String)JsonRpcServlet.class.getName()).fatal((Object)(this.serviceClass.getName() + " instantiation error"), (Throwable)ex);
            throw new ServletException(ex.getCause());
        }
        catch (IllegalAccessException ex) {
            org.apache.log4j.Logger.getLogger((String)JsonRpcServlet.class.getName()).fatal((Object)(this.serviceClass.getName() + " access error"), (Throwable)ex);
            throw new ServletException(ex.getCause());
        }
        JsonRpcWsDescriptor ws = this.wsMethods.get(jsonRequest.getMethod());
        if (ws == null) {
            this.writeError(response, jsonRequest.getId(), -32601, "Method \"" + jsonRequest.getMethod() + "\" not found", null);
            return;
        }
        if (!(ws.getRolesAllowed() == null || ws.getRolesAllowed().isEmpty() || is != null && ws.isRoleAllowed(is.getRoles()))) {
            this.writeAuthorizationError(response);
            return;
        }
        Object[] oParams = new Object[ws.getParameterTypes().size()];
        if (jsonRequest.getParams() == null && oParams.length > 0) {
            this.writeError(response, jsonRequest.getId(), -32602, oParams.length + " params required, no param found.", null);
            return;
        }
        int initialConnections = 0;
        if (this.dbConnectionMonitor != null) {
            initialConnections = this.dbConnectionMonitor.getConnectionCount();
        }
        Gson gson = new GsonBuilder().setDateFormat("dd/MM/yyyy HH:mm").create();
        if (jsonRequest.getParams().isJsonArray()) {
            JsonArray ja = jsonRequest.getParams().getAsJsonArray();
            if (ja.size() != oParams.length) {
                this.writeError(response, jsonRequest.getId(), -32602, oParams.length + " params required, " + ja.size() + " param found.", null);
                return;
            }
            String params = "[";
            ArrayList<Type> tipiParametri = ws.getParameterTypes();
            for (int i = 0; i < oParams.length; ++i) {
                JsonElement je;
                String p;
                if (i > 0) {
                    params = params + ",";
                }
                if ((p = (je = ja.get(i)).toString()).length() > this.parametersMaxLogLength) {
                    p = p.substring(0, this.parametersMaxLogLength) + "...";
                }
                params = params + p;
                if (je == null) continue;
                oParams[i] = gson.fromJson(je, tipiParametri.get(i));
            }
            params = params + "]";
            this.logger.debug((Object)params);
        } else {
            JsonObject jo = jsonRequest.getParams().getAsJsonObject();
            int nParams = jo.entrySet().size();
            if (nParams != oParams.length) {
                this.writeError(response, jsonRequest.getId(), -32602, oParams.length + " params required, " + nParams + " param found.", null);
                return;
            }
            ArrayList<String> nomiParametri = ws.getParameterNames();
            ArrayList<Type> tipiParametri = ws.getParameterTypes();
            String params = "{";
            for (int i = 0; i < oParams.length; ++i) {
                String nome = nomiParametri.get(i);
                JsonElement je = jo.get(nome);
                String p = je.toString();
                if (p.length() > this.parametersMaxLogLength) {
                    p = p.substring(0, this.parametersMaxLogLength) + "...";
                }
                params = params + nome + ":" + p;
                if (je == null) continue;
                oParams[i] = gson.fromJson(je, tipiParametri.get(i));
            }
            params = params + "}";
            this.logger.debug((Object)params);
        }
        serviceInstance.setSessionKey(jsonRequest.getSessionkey());
        serviceInstance.setRemoteAddress(request.getRemoteAddr());
        serviceInstance.setHostname(request.getRemoteHost());
        JsonRpcResponse jsonResponse = null;
        if (ws.getReturnType().equals(JsonRpcResponse.class)) {
            try {
                jsonResponse = (JsonRpcResponse)ws.getReflectedMethod().invoke((Object)serviceInstance, oParams);
            }
            catch (Exception e) {
                this.logger.error((Object)"Internal error", (Throwable)e);
                this.writeError(response, jsonRequest.getId(), -1000, e.getCause().getMessage(), null);
                return;
            }
            finally {
                int finalConnections;
                if (this.dbConnectionMonitor != null && (finalConnections = this.dbConnectionMonitor.getConnectionCount()) > initialConnections) {
                    this.logger.debug((Object)("================> Number of connections increased by " + (finalConnections - initialConnections) + " <======================"));
                }
            }
        }
        try {
            Object result = ws.getReflectedMethod().invoke((Object)serviceInstance, oParams);
            jsonResponse = new JsonRpcResponse();
            jsonResponse.setError(null);
            jsonResponse.setResult(result);
        }
        catch (Exception e) {
            if (e.getCause() instanceof JsonRpcException) {
                JsonRpcException je = (JsonRpcException)e.getCause();
                this.writeError(response, jsonRequest.getId(), je.getCode(), je.getDetailedMessage(), je.getUserMessage());
            } else {
                this.logger.error((Object)"Internal error", (Throwable)e);
                this.writeError(response, jsonRequest.getId(), -1000, e.getCause().getMessage(), null);
            }
            return;
        }
        finally {
            int finalConnections;
            if (this.dbConnectionMonitor != null && (finalConnections = this.dbConnectionMonitor.getConnectionCount()) > initialConnections) {
                this.logger.debug((Object)("================> Number of connections increased by " + (finalConnections - initialConnections) + " <======================"));
            }
        }
        jsonResponse.setId(jsonRequest.getId());
        response.setContentType("application/json;charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            String res = gson.toJson((Object)jsonResponse);
            out.print(res);
            out.println();
        }
    }

    private void initWsDescriptor() {
        this.wsDescriptor = new ArrayList();
        this.wsMethods = new HashMap();
        for (Method m : this.serviceClass.getMethods()) {
            if (!m.isAnnotationPresent(JsonRpcMethod.class)) continue;
            JsonRpcWsDescriptor wsd = new JsonRpcWsDescriptor(m);
            this.wsDescriptor.add(wsd);
            this.wsMethods.put(wsd.getMethodName(), wsd);
        }
        Collections.sort(this.wsDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWsDescriptors(HttpServletResponse response) throws IOException {
        response.setContentType("text/plain;charset=UTF-8");
        try (PrintWriter out = response.getWriter();){
            for (JsonRpcWsDescriptor wsd : this.wsDescriptor) {
                out.print(wsd.getReturnType() == null ? "void" : wsd.getReturnType().toString().replace("class ", ""));
                out.print(" " + wsd.getMethodName() + "(");
                if (wsd.getParameterNames().size() > 0) {
                    out.print(wsd.getParameterNames().get(0));
                }
                for (int i = 1; i < wsd.getParameterNames().size(); ++i) {
                    out.print(", " + wsd.getParameterNames().get(i));
                }
                out.println("); - " + wsd.getDescription());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavaClient(HttpServletResponse response) throws IOException {
        response.setContentType("text/plain;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String tab = "   ";
        out.println("public class " + this.serviceClass.getSimpleName() + "RpcDelegate extends it.zenitlab.jsonrpc.client.JsonRpcClient {\n");
        out.println(tab + "final static String urlString = \"PUT YOUR WS URL HERE\";\n");
        out.println(tab + "public " + this.serviceClass.getSimpleName() + "RpcDelegate(String sessionKey) throws java.net.MalformedURLException {");
        out.println(tab + tab + "super(urlString, sessionKey);");
        out.println(tab + "}\n");
        out.println(tab + "public " + this.serviceClass.getSimpleName() + "RpcDelegate() throws java.net.MalformedURLException {");
        out.println(tab + tab + "super(urlString);");
        out.println(tab + "}\n");
        out.println();
        try {
            for (JsonRpcWsDescriptor wsd : this.wsDescriptor) {
                int i;
                out.println(tab + "/**\n" + tab + " * " + wsd.getDescription() + "\n" + tab + " **/");
                out.print(tab + "public " + (wsd.getReturnType() == null ? "void" : wsd.getReturnType().toString().replace("class ", "").replace("java.lang.", "")));
                out.print(" " + wsd.getMethodName() + "(");
                if (wsd.getParameterNames().size() > 0) {
                    out.print(wsd.getParameterTypes().get(0).toString().replace("class ", "").replace("java.lang.", "") + " " + wsd.getParameterNames().get(0));
                }
                for (i = 1; i < wsd.getParameterNames().size(); ++i) {
                    out.print(", " + wsd.getParameterTypes().get(i).toString().replace("class ", "").replace("java.lang.", "") + " " + wsd.getParameterNames().get(i));
                }
                out.println(") throws it.zenitlab.jsonrpc.commons.JsonRpcException {");
                if (wsd.getReturnType().toString().contains("<")) {
                    out.print(tab + tab + "com.google.gson.reflect.TypeToken t=new com.google.gson.reflect.TypeToken<" + wsd.getReturnType().toString().replace("class ", "") + ">() {};\n");
                    out.print(tab + tab + "return (" + wsd.getReturnType().toString().replace("class ", "") + ")call(\"" + wsd.getMethodName() + "\", t.getType()");
                } else {
                    out.print(tab + tab + "return (" + wsd.getReturnType().toString().replace("class ", "") + ")call(\"" + wsd.getMethodName() + "\", " + wsd.getReturnType().toString().replace("class ", "") + ".class");
                }
                for (i = 0; i < wsd.getParameterNames().size(); ++i) {
                    out.print(", " + wsd.getParameterNames().get(i));
                }
                out.println(");");
                out.println(tab + "}");
            }
            out.print("}");
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJSClient(HttpServletResponse response, String urlPath) throws IOException {
        response.setContentType("text/plain;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String tab = "   ";
        String urlVariableName = "service" + urlPath + "_url";
        out.println("<script src=\"https://ajax.googleapis.com/ajax/libs/jquery/2.2.2/jquery.min.js\"></script>");
        out.println();
        out.println("<script>");
        out.println("var " + urlVariableName + " = \"PUT THE URL HERE\";");
        out.println();
        try {
            for (JsonRpcWsDescriptor wsd : this.wsDescriptor) {
                int i;
                out.println("/**\n * " + wsd.getDescription() + "\n**/");
                out.print("function");
                out.print(" " + wsd.getMethodName() + "(");
                if (wsd.getParameterNames().size() > 0) {
                    out.print(wsd.getParameterNames().get(0));
                }
                for (i = 1; i < wsd.getParameterNames().size(); ++i) {
                    out.print(", " + wsd.getParameterNames().get(i));
                }
                out.println(") {");
                out.println(tab + "var id=Math.random().toString();");
                out.print(tab + "var request={\"jsonrpc\":\"2.0\", \"id\":id, \"method\":\"" + wsd.getMethodName() + "\", \"params\":[");
                if (wsd.getParameterNames().size() > 0) {
                    out.print(wsd.getParameterNames().get(0));
                }
                for (i = 1; i < wsd.getParameterNames().size(); ++i) {
                    out.print(", " + wsd.getParameterNames().get(i));
                }
                out.println("]};");
                out.println(tab + "$.ajax({");
                out.println(tab + tab + "type: \"POST\",");
                out.println(tab + tab + "url: " + urlVariableName + ",");
                out.println(tab + tab + "data: JSON.stringify(request),");
                out.println(tab + tab + "success: function(data){");
                out.println(tab + tab + tab + "//write your code here");
                out.println(tab + tab + "},");
                out.println(tab + tab + "error: function(XMLHttpRequest, textStatus, errorThrown){");
                out.println(tab + tab + tab + "//write your code here");
                out.println(tab + tab + "}");
                out.println(tab + "});");
                out.println("}\n");
            }
            out.println("</script>");
        }
        finally {
            out.close();
        }
    }

    public void writeAuthorizationError(HttpServletResponse response) {
        response.setStatus(403);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeError(HttpServletResponse response, Object id, int code, String detailedMessage, String userMessage) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        JsonRpcError error = new JsonRpcError();
        error.setCode(code);
        error.setDetailedMessage(detailedMessage);
        error.setUserMessage(userMessage == null ? "Internal error" : userMessage);
        JsonRpcResponse jsonResponse = new JsonRpcResponse();
        jsonResponse.setId(id);
        jsonResponse.setError(error);
        Gson gson = new Gson();
        try (PrintWriter out = response.getWriter();){
            String s = gson.toJson((Object)jsonResponse);
            out.println(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonRpcRequestJson parseRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BufferedReader in;
        JsonRpcRequestJson jsonRequest = new JsonRpcRequestJson();
        String qs = request.getQueryString();
        if (qs == null && (qs = (in = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()))).readLine()) == null) {
            try (PrintWriter out = response.getWriter();){
                out.println("Ok");
            }
            return null;
        }
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(qs);
        JsonObject jo = je.getAsJsonObject();
        if ((je = jo.get("jsonrpc")) == null) {
            this.writeError(response, null, -32600, "jsonrpc parameter missing", null);
            return null;
        }
        jsonRequest.setJsonrpc(je.getAsString());
        if (!jsonRequest.getJsonrpc().equals("2.0")) {
            this.writeError(response, null, -32600, "jsonrpc parameter must be \"2.0\"", null);
            return null;
        }
        je = jo.get("method");
        if (je == null) {
            this.writeError(response, null, -32600, "method parameter missing", null);
            return null;
        }
        jsonRequest.setMethod(je.getAsString());
        je = jo.get("id");
        if (je != null) {
            try {
                jsonRequest.setId(je.getAsString());
            }
            catch (Exception e1) {
                try {
                    jsonRequest.setId(je.getAsNumber());
                }
                catch (Exception e2) {
                    this.writeError(response, null, -32600, "Invalid id parameter format", null);
                    return null;
                }
            }
        }
        if ((je = jo.get("sessionkey")) != null) {
            jsonRequest.setSessionkey(je.getAsString());
        }
        jsonRequest.setParams(jo.get("params"));
        return jsonRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeServiceList(ArrayList<JsonRpcWsDescriptor> wsDescriptor, HttpServletResponse response) throws IOException {
        JsonRpcResponse jsonResponse = new JsonRpcResponse();
        Gson gson = new Gson();
        try (PrintWriter out = response.getWriter();){
            String s = gson.toJson((Object)jsonResponse);
            out.println(s);
        }
    }

    public void init() throws ServletException {
        String parametersMaxLogLengthS;
        String dbcmClassName;
        super.init();
        String serviceClassName = this.getInitParameter("serviceClass");
        try {
            this.serviceClass = Class.forName(serviceClassName);
        }
        catch (ClassNotFoundException ex) {
            org.apache.log4j.Logger.getLogger((String)JsonRpcServlet.class.getName()).fatal((Object)(serviceClassName + " class not found!"), (Throwable)ex);
            throw new ServletException(serviceClassName + " class not found");
        }
        this.initWsDescriptor();
        this.serviceListKeyword = this.getInitParameter("serviceListKeyword");
        this.logger = org.apache.log4j.Logger.getLogger((Class)this.serviceClass);
        String lapClassName = this.getInitParameter("logAppenderProvider");
        if (lapClassName != null) {
            try {
                Class<?> lapClass = Class.forName(lapClassName);
                this.logAppenderProvider = (LogAppendersProvider)lapClass.newInstance();
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(JsonRpcServlet.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(JsonRpcServlet.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(JsonRpcServlet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((dbcmClassName = this.getInitParameter("dbConnectionMonitor")) != null) {
            try {
                Class<?> dbcmClass = Class.forName(dbcmClassName);
                this.dbConnectionMonitor = (DBConnectionMonitor)dbcmClass.newInstance();
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(JsonRpcServlet.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(JsonRpcServlet.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(JsonRpcServlet.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((parametersMaxLogLengthS = this.getInitParameter("parametersMaxLogLength")) != null) {
            try {
                this.parametersMaxLogLength = Integer.parseInt(parametersMaxLogLengthS);
            }
            catch (NumberFormatException ex) {
                Logger.getLogger(JsonRpcServlet.class.getName()).log(Level.WARNING, "Impostato 1000 come valore di lunghezza massima dei parametri", ex);
                this.parametersMaxLogLength = 1000;
            }
        } else {
            this.parametersMaxLogLength = 1000;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

