/*
 * Decompiled with CFR 0.152.
 */
package it.zenitlab.jsonrpc.servlet;

import it.zenitlab.jsonrpc.servlet.JsonRpcMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.StringTokenizer;

public class JsonRpcWsDescriptor
implements Comparable {
    String methodName;
    String description;
    Type returnType;
    ArrayList<String> parameterDescription = new ArrayList();
    ArrayList<Type> parameterTypes = new ArrayList();
    ArrayList<String> parameterNames = new ArrayList();
    HashSet<String> rolesAllowed = null;
    Method reflectedMethod;

    public JsonRpcWsDescriptor() {
    }

    public JsonRpcWsDescriptor(Method m) {
        this.methodName = m.getName();
        this.description = m.getAnnotation(JsonRpcMethod.class).description();
        this.returnType = m.getGenericReturnType();
        String[] paramNames = m.getAnnotation(JsonRpcMethod.class).paramNames();
        int i = 0;
        for (Type c : m.getGenericParameterTypes()) {
            String nomeParametro = i < paramNames.length ? paramNames[i] : "?";
            String descParametro = c.toString().replace("class ", "") + " " + nomeParametro;
            this.parameterDescription.add(descParametro);
            this.parameterTypes.add(c);
            this.parameterNames.add(nomeParametro);
            ++i;
        }
        if (m.getAnnotation(JsonRpcMethod.class).rolesAllowed() != null) {
            this.rolesAllowed = new HashSet();
            this.rolesAllowed.addAll(Arrays.asList(m.getAnnotation(JsonRpcMethod.class).rolesAllowed()));
        }
        this.reflectedMethod = m;
    }

    public JsonRpcWsDescriptor(String metodo, String descrizione, ArrayList<String> parametri) {
        this.methodName = metodo;
        this.description = descrizione;
        this.parameterDescription = parametri;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArrayList<String> getParameterDescription() {
        return this.parameterDescription;
    }

    public void setParameterDescription(ArrayList<String> parameterDescription) {
        this.parameterDescription = parameterDescription;
    }

    public ArrayList<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(ArrayList<Type> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public ArrayList<String> getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(ArrayList<String> parametersName) {
        this.parameterNames = parametersName;
    }

    public HashSet<String> getRolesAllowed() {
        return this.rolesAllowed;
    }

    public void setRolesAllowed(HashSet<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
    }

    public void addParameter(String parameter) {
        this.parameterDescription.add(parameter);
        StringTokenizer st = new StringTokenizer(parameter, " ");
        String type = st.nextToken();
        String name = st.nextToken();
        if (type.equals("int") || type.equals("Integer")) {
            this.parameterTypes.add((Type)((Object)Integer.class));
        } else if (type.equals("String")) {
            this.parameterTypes.add((Type)((Object)String.class));
        } else if (type.equals("Date")) {
            this.parameterTypes.add((Type)((Object)Date.class));
        } else if (type.equals("Double") || type.equals("double") || type.equals("Float") || type.equals("float")) {
            this.parameterTypes.add((Type)((Object)Double.class));
        }
        this.parameterNames.add(name);
    }

    public Method getReflectedMethod() {
        return this.reflectedMethod;
    }

    public void setReflectedMethod(Method reflectedMethod) {
        this.reflectedMethod = reflectedMethod;
    }

    public boolean isRoleAllowed(String role) {
        return this.rolesAllowed == null || role.equals("superadmin") || this.rolesAllowed.contains(role);
    }

    public boolean isRoleAllowed(Collection<String> roles) {
        if (this.rolesAllowed == null || roles.contains("superadmin")) {
            return true;
        }
        for (String r : roles) {
            if (!this.rolesAllowed.contains(r)) continue;
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.methodName.compareTo(((JsonRpcWsDescriptor)o).methodName);
    }
}

