/*
 * Decompiled with CFR 0.152.
 */
package it.zenitlab.sessionmanager;

import it.zenitlab.sessionmanager.CancellazioneSessioniScaduteTask;
import it.zenitlab.sessionmanager.PersistentSessionManager;
import it.zenitlab.sessionmanager.SessionInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

public class SessionManager {
    private static HashMap<String, SessionInfo> sessions;
    public static final long duration = 10800000L;
    public static final long unlimitedDuration = 2592000000L;
    public static final long expiredSessionDeletionFrequency = 3600000L;
    private static PersistentSessionManager spm;

    public static void init(PersistentSessionManager spm1) {
        spm = spm1;
        sessions = new HashMap();
        sessions = spm.loadSessions();
        spm.deleteExpiredSessions();
        Timer timer = new Timer();
        CancellazioneSessioniScaduteTask task = new CancellazioneSessioniScaduteTask(spm);
        timer.schedule((TimerTask)task, 3600000L, 3600000L);
    }

    public static synchronized void add(String chiave, SessionInfo info) {
        spm.createSession(chiave, info);
        sessions.put(chiave, info);
    }

    public static synchronized SessionInfo get(String chiave) {
        SessionInfo is = sessions.get(chiave);
        if (is != null && is.getExpiration().after(new Date())) {
            return is;
        }
        return null;
    }

    public static synchronized SessionInfo remove(String chiave) {
        spm.deleteSession(chiave);
        return sessions.remove(chiave);
    }

    public static synchronized void updateExpiration(String key) {
        SessionInfo info = sessions.get(key);
        if (info != null) {
            Date scadenza = new Date(new Date().getTime() + info.getDuration());
            Date scadenzaAttuale = info.getExpiration();
            if (scadenza.getTime() - scadenzaAttuale.getTime() > info.getDuration() / 2L) {
                info.setExpiration(scadenza);
                spm.updateExpiration(key, scadenza);
            }
        }
    }

    public static ArrayList<SessionInfo> listAll() {
        return new ArrayList<SessionInfo>(sessions.values());
    }
}

