/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.Info;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class InstallerBase {
    protected static final String LANG_FILE_NAME = "CustomLangpack.xml";

    public void loadInstallData(AutomatedInstallData installdata) throws Exception {
        ObjectInputStream objIn;
        Properties variables = null;
        InputStream in = InstallerBase.class.getResourceAsStream("/vars");
        if (null != in) {
            objIn = new ObjectInputStream(in);
            variables = (Properties)objIn.readObject();
            objIn.close();
        }
        in = InstallerBase.class.getResourceAsStream("/info");
        objIn = new ObjectInputStream(in);
        Info inf = (Info)objIn.readObject();
        objIn.close();
        installdata.setVariable("APP_NAME", inf.getAppName());
        installdata.setVariable("APP_URL", inf.getAppURL());
        installdata.setVariable("APP_VER", inf.getAppVersion());
        in = InstallerBase.class.getResourceAsStream("/panelsOrder");
        objIn = new ObjectInputStream(in);
        List panelsOrder = (List)objIn.readObject();
        objIn.close();
        in = InstallerBase.class.getResourceAsStream("/packs.info");
        objIn = new ObjectInputStream(in);
        int size = objIn.readInt();
        ArrayList<Pack> availablePacks = new ArrayList<Pack>();
        ArrayList<Pack> allPacks = new ArrayList<Pack>();
        for (int i = 0; i < size; ++i) {
            Pack pk = (Pack)objIn.readObject();
            allPacks.add(pk);
            if (!OsConstraint.oneMatchesCurrentSystem(pk.osConstraints)) continue;
            availablePacks.add(pk);
        }
        objIn.close();
        String dir = OsVersion.IS_WINDOWS ? this.buildWindowsDefaultPath() : (OsVersion.IS_OSX ? "/Applications" : (new File("/usr/local/").canWrite() ? "/usr/local" : System.getProperty("user.home")));
        installdata.setVariable("APPLICATIONS_DEFAULT_ROOT", dir);
        dir = dir + File.separator;
        installdata.setVariable("JAVA_HOME", System.getProperty("java.home"));
        installdata.setVariable("USER_HOME", System.getProperty("user.home"));
        installdata.setVariable("USER_NAME", System.getProperty("user.name"));
        installdata.setVariable("FILE_SEPARATOR", File.separator);
        Enumeration<Object> e = System.getProperties().keys();
        while (e.hasMoreElements()) {
            String varName = (String)e.nextElement();
            String varValue = System.getProperty(varName);
            if (varValue == null) continue;
            varName = varName.replace('.', '_');
            installdata.setVariable("SYSTEM_" + varName, varValue);
        }
        if (null != variables) {
            Enumeration<Object> enumeration = variables.keys();
            while (enumeration.hasMoreElements()) {
                String varName = (String)enumeration.nextElement();
                String varValue = variables.getProperty(varName);
                installdata.setVariable(varName, varValue);
            }
        }
        installdata.info = inf;
        installdata.panelsOrder = panelsOrder;
        installdata.availablePacks = availablePacks;
        installdata.allPacks = allPacks;
        Iterator pack_it = availablePacks.iterator();
        while (pack_it.hasNext()) {
            Pack pack = (Pack)pack_it.next();
            if (!pack.preselected) continue;
            installdata.selectedPacks.add(pack);
        }
        String installPath = dir + inf.getAppName();
        if (inf.getInstallationSubPath() != null) {
            installPath = IoHelper.translatePath(dir + inf.getInstallationSubPath(), new VariableSubstitutor(installdata.getVariables()));
        }
        installdata.setInstallPath(installPath);
        this.loadCustomData(installdata);
    }

    protected void addCustomLangpack(AutomatedInstallData idata) {
        try {
            idata.langpack.add(ResourceManager.getInstance().getInputStream(LANG_FILE_NAME));
        }
        catch (Throwable exception) {
            Debug.trace("No custom langpack available.");
            return;
        }
        Debug.trace("Custom langpack for " + idata.localeISO3 + " available.");
    }

    private String buildWindowsDefaultPath() {
        StringBuffer dpath = new StringBuffer("");
        try {
            Properties props = new Properties();
            props.load(InstallerBase.class.getResourceAsStream("/com/izforge/izpack/installer/win32-defaultpaths.properties"));
            String drive = System.getProperty("user.home");
            if (drive.length() > 3) {
                drive = drive.substring(0, 3);
            }
            dpath.append(drive);
            if (drive.length() == 2) {
                dpath.append("\\");
            }
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String language_country = language + "_" + country;
            if (null != props.getProperty(language_country)) {
                dpath.append(props.getProperty(language_country));
            } else if (null != props.getProperty(language)) {
                dpath.append(props.getProperty(language));
            } else {
                dpath.append(props.getProperty(Locale.ENGLISH.getLanguage()));
            }
        }
        catch (Exception err) {
            dpath = new StringBuffer("C:\\Program Files");
        }
        return dpath.toString();
    }

    private void loadCustomData(AutomatedInstallData installdata) throws Exception {
        int i;
        String[] streamNames = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] out = new List[streamNames.length];
        for (i = 0; i < streamNames.length; ++i) {
            out[i] = new ArrayList();
        }
        InputStream in = InstallerBase.class.getResourceAsStream("/customData");
        if (in != null) {
            ObjectInputStream objIn = new ObjectInputStream(in);
            Object listeners = objIn.readObject();
            objIn.close();
            Iterator keys = ((List)listeners).iterator();
            while (keys != null && keys.hasNext()) {
                CustomData ca = (CustomData)keys.next();
                if (ca.osConstraints != null && !OsConstraint.oneMatchesCurrentSystem(ca.osConstraints)) continue;
                switch (ca.type) {
                    case 0: {
                        Class<?> clazz = Class.forName(ca.listenerName);
                        if (clazz == null) {
                            throw new InstallerException("Custom action " + ca.listenerName + " not bound!");
                        }
                        out[ca.type].add(clazz.newInstance());
                        break;
                    }
                    case 1: 
                    case 3: {
                        out[ca.type].add(ca);
                        break;
                    }
                    case 2: {
                        out[ca.type].add(ca.contents);
                    }
                }
            }
            for (i = 0; i < streamNames.length; ++i) {
                installdata.customData.put(streamNames[i], out[i]);
            }
        }
    }
}

