/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.n3.nanoxml.XMLElement;

public class OsConstraint
implements Serializable {
    private static final long serialVersionUID = 3762248660406450488L;
    private String family;
    private String name;
    private String version;
    private String arch;

    public OsConstraint(String family, String name, String version, String arch) {
        this.family = family != null ? family.toLowerCase() : null;
        this.name = name != null ? name.toLowerCase() : null;
        this.version = version != null ? version.toLowerCase() : null;
        this.arch = arch != null ? arch.toLowerCase() : null;
    }

    public boolean matchCurrentSystem() {
        boolean match = true;
        String osName = System.getProperty("os.name").toLowerCase();
        if (this.arch != null && this.arch.length() != 0) {
            match = System.getProperty("os.arch").toLowerCase().equals(this.arch);
        }
        if (match && this.version != null && this.version.length() != 0) {
            match = System.getProperty("os.version").toLowerCase().equals(this.version);
        }
        if (match && this.name != null && this.name.length() != 0) {
            match = osName.equals(this.name);
        }
        if (match && this.family != null) {
            if (this.family.equals("windows")) {
                match = OsVersion.IS_WINDOWS;
            } else if (this.family.equals("mac") || this.family.equals("osx")) {
                match = OsVersion.IS_OSX;
            } else if (this.family.equals("unix")) {
                match = OsVersion.IS_UNIX;
            }
        }
        return match && (this.family != null || this.name != null || this.version != null || this.arch != null);
    }

    public static List getOsList(XMLElement element) {
        ArrayList<OsConstraint> osList = new ArrayList<OsConstraint>();
        Iterator osIterator = element.getChildrenNamed("os").iterator();
        while (osIterator.hasNext()) {
            XMLElement os = (XMLElement)osIterator.next();
            osList.add(new OsConstraint(os.getAttribute("family", null), os.getAttribute("name", null), os.getAttribute("version", null), os.getAttribute("arch", null)));
        }
        String osattr = element.getAttribute("os");
        if (osattr != null && osattr.length() > 0) {
            osList.add(new OsConstraint(osattr, null, null, null));
        }
        return osList;
    }

    public static boolean oneMatchesCurrentSystem(List constraint_list) {
        if (constraint_list == null) {
            return true;
        }
        Iterator constraint_it = constraint_list.iterator();
        if (!constraint_it.hasNext()) {
            return true;
        }
        while (constraint_it.hasNext()) {
            OsConstraint osc = (OsConstraint)constraint_it.next();
            Debug.trace("checking if os constraints " + osc + " match current OS");
            if (!osc.matchCurrentSystem()) continue;
            Debug.trace("matched current OS.");
            return true;
        }
        Debug.trace("no match with current OS!");
        return false;
    }

    public static boolean oneMatchesCurrentSystem(XMLElement el) {
        return OsConstraint.oneMatchesCurrentSystem(OsConstraint.getOsList(el));
    }

    public void setFamily(String f) {
        this.family = f.toLowerCase();
    }

    public String getFamily() {
        return this.family;
    }

    public void setName(String n) {
        this.name = n.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String v) {
        this.version = v.toLowerCase();
    }

    public String getVersion() {
        return this.version;
    }

    public void setArch(String a) {
        this.arch = a.toLowerCase();
    }

    public String getArch() {
        return this.arch;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[Os ");
        retval.append(" family " + this.family);
        retval.append(" name " + this.name);
        retval.append(" version " + this.version);
        retval.append(" arch " + this.arch);
        retval.append(" ]");
        return retval.toString();
    }
}

