/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Panel;
import com.izforge.izpack.compiler.CompilerConfig;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.Packager;
import com.izforge.izpack.compiler.PackagerListener;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class Compiler
extends Thread {
    public static final String IZPACK_VERSION = "3.8.0";
    public static String IZPACK_HOME = ".";
    protected String basedir;
    protected String kind;
    protected String output;
    private Packager packager = null;
    private boolean compileFailed = true;
    private Properties properties;
    private VariableSubstitutor propertySubstitutor;

    public static void setIzpackHome(String izHome) {
        IZPACK_HOME = izHome;
    }

    public Compiler(String basedir, String kind, String output) throws CompilerException {
        this(basedir, kind, output, "default");
    }

    public Compiler(String basedir, String kind, String output, String compr_format) throws CompilerException {
        this(basedir, kind, output, compr_format, -1);
    }

    public Compiler(String basedir, String kind, String output, String compr_format, int compr_level) throws CompilerException {
        this.basedir = basedir;
        this.kind = kind;
        this.output = output;
        this.properties = new Properties(System.getProperties());
        this.propertySubstitutor = new VariableSubstitutor(this.properties);
        this.setProperty("izpack.version", IZPACK_VERSION);
        this.setProperty("basedir", basedir);
        this.packager = new Packager(compr_format, compr_level);
        this.packager.getCompressor().setCompiler(this);
    }

    public PackagerListener getPackagerListener() {
        return this.packager.getPackagerListener();
    }

    public void setPackagerListener(PackagerListener listener) {
        this.packager.setPackagerListener(listener);
    }

    public String getKind() {
        return this.kind;
    }

    public Properties getVariables() {
        return this.packager.getVariables();
    }

    public void compile() {
        this.start();
    }

    public void run() {
        try {
            this.createInstaller();
        }
        catch (CompilerException ce) {
            System.out.println(ce.getMessage() + "\n");
        }
        catch (Exception e) {
            if (Debug.stackTracing()) {
                e.printStackTrace();
            }
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    public void createInstaller() throws Exception {
        if (this.packager.getCompressor().getContainerPaths() != null) {
            String[] containerPaths = this.packager.getCompressor().getContainerPaths();
            String[][] decoderClassNames = this.packager.getCompressor().getDecoderClassNames();
            for (int i = 0; i < containerPaths.length; ++i) {
                URL compressorURL = null;
                if (containerPaths[i] != null) {
                    compressorURL = this.findIzPackResource(containerPaths[i], "pack compression Jar file");
                }
                if (decoderClassNames[i] == null || decoderClassNames[i].length <= 0) continue;
                this.addJarContent(compressorURL, Arrays.asList(decoderClassNames[i]));
            }
        }
        this.packager.createInstaller(new File(this.output));
        this.compileFailed = false;
    }

    public boolean wasSuccessful() {
        return !this.compileFailed;
    }

    public String replaceProperties(String value) throws CompilerException {
        return this.propertySubstitutor.substitute(value, "at");
    }

    public void setGUIPrefs(GUIPrefs prefs) {
        this.packager.setGUIPrefs(prefs);
    }

    public void setInfo(Info info) throws Exception {
        this.packager.setInfo(info);
    }

    public Packager getPackager() {
        return this.packager;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public boolean setProperty(String name, String value) {
        this.properties.put(name, value);
        return true;
    }

    public boolean addProperty(String name, String value) {
        String old = this.properties.getProperty(name);
        if (old == null) {
            this.properties.put(name, value);
            return true;
        }
        return false;
    }

    public void addJarContent(URL content) {
        this.packager.addJarContent(content);
    }

    public void addJarContent(URL content, List files) {
        this.packager.addJarContent(content, files);
    }

    public void addCustomJar(CustomData ca, URL url) {
        this.packager.addCustomJar(ca, url);
    }

    public void addLangPack(String iso3, URL iso3xmlURL, URL iso3FlagURL) {
        this.packager.addLangPack(iso3, iso3xmlURL, iso3FlagURL);
    }

    public void addNativeLibrary(String name, URL url) throws Exception {
        this.packager.addNativeLibrary(name, url);
    }

    public void addNativeUninstallerLibrary(CustomData data) {
        this.packager.addNativeUninstallerLibrary(data);
    }

    public void addPack(PackInfo pack) {
        this.packager.addPack(pack);
    }

    public void addPanelJar(Panel panel, URL url) {
        this.packager.addPanelJar(panel, url);
    }

    public void addResource(String name, URL url) {
        this.packager.addResource(name, url);
    }

    public void checkDependencies() throws CompilerException {
        this.checkDependencies(this.packager.getPacksList());
    }

    public void checkDependencies(List packs) throws CompilerException {
        HashMap<String, PackInfo> names = new HashMap<String, PackInfo>();
        for (int i = 0; i < packs.size(); ++i) {
            PackInfo pack = (PackInfo)packs.get(i);
            names.put(pack.getPack().name, pack);
        }
        int result = this.dfs(packs, names);
        if (result == -2) {
            this.parseError("Circular dependency detected");
        } else if (result == -1) {
            this.parseError("A dependency doesn't exist");
        }
    }

    private int dfs(List packs, Map names) {
        HashMap edges = new HashMap();
        for (int i = 0; i < packs.size(); ++i) {
            PackInfo pack = (PackInfo)packs.get(i);
            if (pack.colour != 0 || this.dfsVisit(pack, names, edges) == 0) continue;
            return -1;
        }
        return this.checkBackEdges(edges);
    }

    private int checkBackEdges(Map edges) {
        Set keys = edges.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            int color = (Integer)edges.get(key);
            if (color != 1) continue;
            return -2;
        }
        return 0;
    }

    private int dfsVisit(PackInfo u, Map names, Map edges) {
        u.colour = 1;
        List deps = u.getDependencies();
        if (deps != null) {
            for (int i = 0; i < deps.size(); ++i) {
                int result;
                String name = (String)deps.get(i);
                PackInfo v = (PackInfo)names.get(name);
                if (v == null) {
                    System.out.println("Failed to find dependency: " + name);
                    return -1;
                }
                Edge edge = new Edge(u, v);
                if (edges.get(edge) == null) {
                    edges.put(edge, new Integer(v.colour));
                }
                if (v.colour != 0 || (result = this.dfsVisit(v, names, edges)) == 0) continue;
                return result;
            }
        }
        u.colour = 2;
        return 0;
    }

    protected void addRecursively(File file, String targetdir, List osList, int override, PackInfo pack, Map additionals) throws IOException {
        String targetfile = targetdir + "/" + file.getName();
        if (!file.isDirectory()) {
            pack.addFile(file, targetfile, osList, override, additionals);
        } else {
            File[] files = file.listFiles();
            if (files.length == 0) {
                pack.addFile(file, targetfile, osList, override, additionals);
            } else {
                for (int i = 0; i < files.length; ++i) {
                    this.addRecursively(files[i], targetfile, osList, override, pack, additionals);
                }
            }
        }
    }

    public URL findIzPackResource(String path, String desc) throws CompilerException {
        URL url = this.getClass().getResource("/" + path);
        if (url == null) {
            File resource = new File(path);
            if (!resource.isAbsolute()) {
                resource = new File(IZPACK_HOME, path);
            }
            if (!resource.exists()) {
                this.parseError(desc + " not found: " + resource);
            }
            try {
                url = resource.toURL();
            }
            catch (MalformedURLException how) {
                this.parseError(desc + "(" + resource + ")", how);
            }
        }
        return url;
    }

    public void parseError(String message) throws CompilerException {
        this.compileFailed = true;
        throw new CompilerException(message);
    }

    public void parseError(String message, Throwable how) throws CompilerException {
        this.compileFailed = true;
        throw new CompilerException(message, how);
    }

    public static void main(String[] args) {
        CompilerConfig.main(args);
    }

    public void addCustomListener(int type, String className, String jarPath, List constraints) throws Exception {
        jarPath = this.replaceProperties(jarPath);
        URL url = this.findIzPackResource(jarPath, "CustomAction jar file");
        List filePaths = this.getContainedFilePaths(url);
        String fullClassName = this.getFullClassName(url, className);
        CustomData ca = new CustomData(fullClassName, filePaths, constraints, type);
        this.packager.addCustomJar(ca, url);
    }

    private List getContainedFilePaths(URL url) throws Exception {
        JarInputStream jis = new JarInputStream(url.openStream());
        ZipEntry zentry = null;
        ArrayList<String> fullNames = new ArrayList<String>();
        while ((zentry = jis.getNextEntry()) != null) {
            String name = zentry.getName();
            if (zentry.isDirectory()) continue;
            fullNames.add(name);
        }
        jis.close();
        return fullNames;
    }

    private String getFullClassName(URL url, String className) throws Exception {
        JarInputStream jis = new JarInputStream(url.openStream());
        ZipEntry zentry = null;
        while ((zentry = jis.getNextEntry()) != null) {
            String name = zentry.getName();
            int lastPos = name.lastIndexOf(".class");
            if (lastPos < 0) continue;
            name = name.replace('/', '.');
            int pos = -1;
            if (className != null) {
                pos = name.indexOf(className);
            }
            if (name.length() != pos + className.length() + 6) continue;
            jis.close();
            return name.substring(0, lastPos);
        }
        jis.close();
        return null;
    }

    static class CmdlinePackagerListener
    implements PackagerListener {
        CmdlinePackagerListener() {
        }

        public void packagerMsg(String info) {
            this.packagerMsg(info, 2);
        }

        public void packagerMsg(String info, int priority) {
            String prefix;
            switch (priority) {
                case 0: {
                    prefix = "[ DEBUG ] ";
                    break;
                }
                case 1: {
                    prefix = "[ ERROR ] ";
                    break;
                }
                case 4: {
                    prefix = "[ WARNING ] ";
                    break;
                }
                default: {
                    prefix = "";
                }
            }
            System.out.println(prefix + info);
        }

        public void packagerStart() {
            System.out.println("[ Begin ]");
            System.out.println();
        }

        public void packagerStop() {
            System.out.println();
            System.out.println("[ End ]");
        }
    }

    private class Edge {
        PackInfo u;
        PackInfo v;

        Edge(PackInfo u, PackInfo v) {
            this.u = u;
            this.v = v;
        }
    }
}

