/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.Panel;
import com.izforge.izpack.compiler.ByteCountingOutputStream;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerListener;
import com.izforge.izpack.compressor.PackCompressor;
import com.izforge.izpack.compressor.PackCompressorFactory;
import com.izforge.izpack.util.JarOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class Packager {
    public static final String SKELETON_SUBPATH = "lib/installer.jar";
    private File baseFile = null;
    private JarOutputStream primaryJarStream;
    private Info info = null;
    private GUIPrefs guiPrefs = null;
    private Properties variables = new Properties();
    private List panelList = new ArrayList();
    private List packsList = new ArrayList();
    private List langpackNameList = new ArrayList();
    private List customDataList = new ArrayList();
    private Map installerResourceURLMap = new HashMap();
    private Set includedJarURLs = new HashSet();
    private boolean packJarsSeparate = false;
    private PackagerListener listener;
    private PackCompressor compressor;
    private HashMap alreadyWrittenFiles = new HashMap();

    public Packager() throws CompilerException {
        this("default");
    }

    public Packager(String compr_format) throws CompilerException {
        this(compr_format, -1);
    }

    public Packager(String compr_format, int compr_level) throws CompilerException {
        this.compressor = PackCompressorFactory.get(compr_format);
        this.compressor.setCompressionLevel(compr_level);
    }

    public void createInstaller(File primaryFile) throws Exception {
        String baseName = primaryFile.getName();
        if (baseName.endsWith(".jar")) {
            baseName = baseName.substring(0, baseName.length() - 4);
            this.baseFile = new File(primaryFile.getParentFile(), baseName);
        } else {
            this.baseFile = primaryFile;
        }
        this.info.setInstallerBase(this.baseFile.getName());
        this.packJarsSeparate = this.info.getWebDirURL() != null;
        this.primaryJarStream = this.getJarOutputStream(this.baseFile.getName() + ".jar");
        this.sendStart();
        this.writeSkeletonInstaller();
        this.writeInstallerObject("info", this.info);
        this.writeInstallerObject("vars", this.variables);
        this.writeInstallerObject("GUIPrefs", this.guiPrefs);
        this.writeInstallerObject("panelsOrder", this.panelList);
        this.writeInstallerObject("customData", this.customDataList);
        this.writeInstallerObject("langpacks.info", this.langpackNameList);
        this.writeInstallerResources();
        this.writeIncludedJars();
        this.writePacks();
        this.primaryJarStream.closeAlways();
        this.sendStop();
    }

    public PackagerListener getPackagerListener() {
        return this.listener;
    }

    public void setPackagerListener(PackagerListener listener) {
        this.listener = listener;
    }

    private void sendMsg(String job) {
        this.sendMsg(job, 2);
    }

    private void sendMsg(String job, int priority) {
        if (this.listener != null) {
            this.listener.packagerMsg(job, priority);
        }
    }

    private void sendStart() {
        if (this.listener != null) {
            this.listener.packagerStart();
        }
    }

    private void sendStop() {
        if (this.listener != null) {
            this.listener.packagerStop();
        }
    }

    public void setInfo(Info info) throws Exception {
        this.sendMsg("Setting the installer information", 3);
        this.info = info;
        if (!this.getCompressor().useStandardCompression() && this.getCompressor().getDecoderMapperName() != null) {
            this.info.setPackDecoderClassName(this.getCompressor().getDecoderMapperName());
        }
    }

    public void setGUIPrefs(GUIPrefs prefs) {
        this.sendMsg("Setting the GUI preferences", 3);
        this.guiPrefs = prefs;
    }

    public Properties getVariables() {
        return this.variables;
    }

    public void addPanelJar(Panel panel, URL jarURL) {
        this.panelList.add(panel);
        this.addJarContent(jarURL);
    }

    public void addCustomJar(CustomData ca, URL url) {
        this.customDataList.add(ca);
        this.addJarContent(url);
    }

    public void addPack(PackInfo pack) {
        this.packsList.add(pack);
    }

    public List getPacksList() {
        return this.packsList;
    }

    public void addLangPack(String iso3, URL xmlURL, URL flagURL) {
        this.sendMsg("Adding langpack: " + iso3, 3);
        this.langpackNameList.add(iso3);
        this.addResource("flag." + iso3, flagURL);
        this.installerResourceURLMap.put("langpacks/" + iso3 + ".xml", xmlURL);
    }

    public void addResource(String resId, URL url) {
        this.sendMsg("Adding resource: " + resId, 3);
        this.installerResourceURLMap.put("res/" + resId, url);
    }

    public void addNativeLibrary(String name, URL url) throws Exception {
        this.sendMsg("Adding native library: " + name, 3);
        this.installerResourceURLMap.put("native/" + name, url);
    }

    public void addJarContent(URL jarURL) {
        this.addJarContent(jarURL, null);
    }

    public void addJarContent(URL jarURL, List files) {
        Object[] cont = new Object[]{jarURL, files};
        this.sendMsg("Adding content of jar: " + jarURL.getFile(), 3);
        this.includedJarURLs.add(cont);
    }

    public void addNativeUninstallerLibrary(CustomData data) {
        this.customDataList.add(data);
    }

    private void writeSkeletonInstaller() throws IOException {
        this.sendMsg("Copying the skeleton installer", 3);
        InputStream is = Packager.class.getResourceAsStream("/lib/installer.jar");
        if (is == null) {
            File skeleton = new File(Compiler.IZPACK_HOME, SKELETON_SUBPATH);
            is = new FileInputStream(skeleton);
        }
        ZipInputStream inJarStream = new ZipInputStream(is);
        this.copyZip(inJarStream, this.primaryJarStream);
    }

    private void writeInstallerObject(String entryName, Object object) throws IOException {
        this.primaryJarStream.putNextEntry(new ZipEntry(entryName));
        ObjectOutputStream out = new ObjectOutputStream(this.primaryJarStream);
        out.writeObject(object);
        out.flush();
        this.primaryJarStream.closeEntry();
    }

    private void writeInstallerResources() throws IOException {
        this.sendMsg("Copying " + this.installerResourceURLMap.size() + " files into installer");
        Iterator i = this.installerResourceURLMap.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            InputStream in = ((URL)this.installerResourceURLMap.get(name)).openStream();
            this.primaryJarStream.putNextEntry(new ZipEntry(name));
            this.copyStream(in, this.primaryJarStream);
            this.primaryJarStream.closeEntry();
            in.close();
        }
    }

    private void writeIncludedJars() throws IOException {
        this.sendMsg("Merging " + this.includedJarURLs.size() + " jars into installer");
        Iterator i = this.includedJarURLs.iterator();
        while (i.hasNext()) {
            Object[] current = (Object[])i.next();
            InputStream is = ((URL)current[0]).openStream();
            ZipInputStream inJarStream = new ZipInputStream(is);
            this.copyZip(inJarStream, this.primaryJarStream, (List)current[1]);
        }
    }

    private void writePacks() throws Exception {
        int num = this.packsList.size();
        this.sendMsg("Writing " + num + " Pack" + (num > 1 ? "s" : "") + " into installer");
        HashMap<File, long[]> storedFiles = new HashMap<File, long[]>();
        int packNumber = 0;
        Iterator packIter = this.packsList.iterator();
        while (packIter.hasNext()) {
            PackInfo packInfo = (PackInfo)packIter.next();
            Pack pack = packInfo.getPack();
            pack.nbytes = 0L;
            JarOutputStream packStream = this.primaryJarStream;
            if (this.packJarsSeparate) {
                String name = this.baseFile.getName() + ".pack" + packNumber + ".jar";
                packStream = this.getJarOutputStream(name);
            }
            OutputStream comprStream = packStream;
            this.sendMsg("Writing Pack " + packNumber + ": " + pack.name, 3);
            ZipEntry entry = new ZipEntry("packs/pack" + packNumber);
            if (!this.compressor.useStandardCompression()) {
                entry.setMethod(0);
                entry.setComment(this.compressor.getCompressionFormatSymbols()[0]);
                packStream.putNextEntry(entry);
                packStream.flush();
                comprStream = this.compressor.getOutputStream(packStream);
            } else {
                int level = this.compressor.getCompressionLevel();
                if (level >= 0 && level < 10) {
                    packStream.setLevel(level);
                }
                packStream.putNextEntry(entry);
                packStream.flush();
            }
            ByteCountingOutputStream dos = new ByteCountingOutputStream(comprStream);
            ObjectOutputStream objOut = new ObjectOutputStream(dos);
            objOut.writeInt(packInfo.getPackFiles().size());
            Iterator iter = packInfo.getPackFiles().iterator();
            while (iter.hasNext()) {
                boolean addFile = !pack.loose;
                PackFile pf = (PackFile)iter.next();
                File file = packInfo.getFile(pf);
                long[] info = (long[])storedFiles.get(file);
                if (info != null && !this.packJarsSeparate) {
                    pf.setPreviousPackFileRef((int)info[0], info[1]);
                    addFile = false;
                }
                objOut.writeObject(pf);
                objOut.flush();
                if (addFile && !pf.isDirectory()) {
                    long pos = dos.getByteCount();
                    FileInputStream inStream = new FileInputStream(file);
                    long bytesWritten = this.copyStream(inStream, objOut);
                    if (bytesWritten != pf.length()) {
                        throw new IOException("File size mismatch when reading " + file);
                    }
                    inStream.close();
                    storedFiles.put(file, new long[]{packNumber, pos});
                }
                pack.nbytes += pf.length();
            }
            objOut.writeInt(packInfo.getParsables().size());
            iter = packInfo.getParsables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getExecutables().size());
            iter = packInfo.getExecutables().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.writeInt(packInfo.getUpdateChecks().size());
            iter = packInfo.getUpdateChecks().iterator();
            while (iter.hasNext()) {
                objOut.writeObject(iter.next());
            }
            objOut.flush();
            if (!this.compressor.useStandardCompression()) {
                comprStream.close();
            }
            packStream.closeEntry();
            if (this.packJarsSeparate) {
                packStream.closeAlways();
            }
            ++packNumber;
        }
        this.primaryJarStream.putNextEntry(new ZipEntry("packs.info"));
        ObjectOutputStream out = new ObjectOutputStream(this.primaryJarStream);
        out.writeInt(this.packsList.size());
        Iterator i = this.packsList.iterator();
        while (i.hasNext()) {
            PackInfo pack = (PackInfo)i.next();
            out.writeObject(pack.getPack());
        }
        out.flush();
        this.primaryJarStream.closeEntry();
    }

    private JarOutputStream getJarOutputStream(String name) throws IOException {
        File file = new File(this.baseFile.getParentFile(), name);
        this.sendMsg("Building installer jar: " + file.getAbsolutePath());
        JarOutputStream jar = new JarOutputStream(file);
        jar.setLevel(9);
        jar.setPreventClose(true);
        return jar;
    }

    private void copyZip(ZipInputStream zin, ZipOutputStream out) throws IOException {
        this.copyZip(zin, out, null);
    }

    private void copyZip(ZipInputStream zin, ZipOutputStream out, List files) throws IOException {
        java.util.zip.ZipEntry zentry;
        if (!this.alreadyWrittenFiles.containsKey(out)) {
            this.alreadyWrittenFiles.put(out, new HashSet());
        }
        HashSet currentSet = (HashSet)this.alreadyWrittenFiles.get(out);
        while ((zentry = zin.getNextEntry()) != null) {
            String currentName = zentry.getName();
            String testName = currentName.replace('/', '.');
            testName = testName.replace('\\', '.');
            if (files != null) {
                Iterator i = files.iterator();
                boolean founded = false;
                while (i.hasNext()) {
                    String doInclude = (String)i.next();
                    if (!testName.matches(doInclude)) continue;
                    founded = true;
                    break;
                }
                if (!founded) continue;
            }
            if (currentSet.contains(currentName)) continue;
            try {
                out.putNextEntry(new ZipEntry(currentName));
                this.copyStream(zin, out);
                out.closeEntry();
                zin.closeEntry();
                currentSet.add(currentName);
            }
            catch (ZipException x) {}
        }
    }

    private long copyStream(InputStream in, OutputStream out) throws IOException {
        int bytesInBuffer;
        byte[] buffer = new byte[5120];
        long bytesCopied = 0L;
        while ((bytesInBuffer = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesInBuffer);
            bytesCopied += (long)bytesInBuffer;
        }
        return bytesCopied;
    }

    public PackCompressor getCompressor() {
        return this.compressor;
    }
}

