/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compressor;

import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compressor.PackCompressor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;

public abstract class PackCompressorBase
implements PackCompressor {
    protected String[] formatNames = null;
    protected String[] containerPaths = null;
    protected String decoderMapper = null;
    protected String[][] decoderClassNames = null;
    protected String encoderClassName = null;
    protected Class[] paramsClasses = null;
    private Compiler compiler;
    private Constructor constructor;
    private int level = -1;

    public String[] getContainerPaths() {
        return this.containerPaths;
    }

    public String getEncoderClassName() {
        return this.encoderClassName;
    }

    public String[][] getDecoderClassNames() {
        return this.decoderClassNames;
    }

    public boolean useStandardCompression() {
        return false;
    }

    public String[] getCompressionFormatSymbols() {
        return this.formatNames;
    }

    public String getDecoderMapperName() {
        return this.decoderMapper;
    }

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void setCompressionLevel(int level) {
        this.level = level;
    }

    public int getCompressionLevel() {
        return this.level;
    }

    public boolean needsBufferedOutputStream() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadClass(String className) throws Exception {
        if (this.getEncoderClassName() == null) {
            return;
        }
        Class<?> encoder = null;
        if (this.getContainerPaths() == null) {
            encoder = Class.forName(className);
        }
        if (encoder == null) {
            int i;
            String[] rawPaths = this.getContainerPaths();
            URL[] uRLs = new URL[rawPaths.length];
            Object instance = null;
            int j = 0;
            for (i = 0; i < rawPaths.length; ++i) {
                String jarPath;
                URL url;
                if (rawPaths[i] == null || (url = this.compiler.findIzPackResource(jarPath = this.compiler.replaceProperties(rawPaths[i]), "Pack compressor jar file")) == null) continue;
                uRLs[j++] = url;
                if (this.getClass().getResource("/" + jarPath) == null) continue;
                InputStream in = null;
                FileOutputStream outFile = null;
                byte[] buffer = new byte[5120];
                File tf = null;
                try {
                    int bytesInBuffer;
                    tf = File.createTempFile("izpj", ".jar");
                    tf.deleteOnExit();
                    outFile = new FileOutputStream(tf);
                    in = this.getClass().getResourceAsStream("/" + jarPath);
                    long bytesCopied = 0L;
                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                        outFile.write(buffer, 0, bytesInBuffer);
                        bytesCopied += (long)bytesInBuffer;
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (outFile != null) {
                        outFile.close();
                    }
                }
                url = tf.toURL();
            }
            if (j > 0) {
                if (j < uRLs.length) {
                    URL[] nurl = new URL[j];
                    for (i = 0; i < j; ++i) {
                        nurl[i] = uRLs[i];
                    }
                    uRLs = nurl;
                }
                URLClassLoader ucl = new URLClassLoader(uRLs, PackCompressor.class.getClassLoader());
                encoder = ucl.loadClass(className);
            }
        }
        if (encoder != null) {
            this.constructor = encoder.getDeclaredConstructor(this.paramsClasses);
        } else {
            this.compiler.parseError("Cannot find defined compressor " + className);
        }
    }

    protected OutputStream getOutputInstance(OutputStream slave) throws Exception {
        if (this.needsBufferedOutputStream()) {
            slave = new BufferedOutputStream(slave);
        }
        Object[] params = this.resolveConstructorParams(slave);
        if (this.constructor == null) {
            this.loadClass(this.getEncoderClassName());
        }
        if (this.constructor == null) {
            return null;
        }
        Object instance = null;
        if (!OutputStream.class.isInstance(instance = this.constructor.newInstance(params))) {
            this.compiler.parseError("'" + this.getEncoderClassName() + "' must be derived from " + OutputStream.class.toString());
        }
        return instance;
    }

    protected Object[] resolveConstructorParams(OutputStream slave) throws Exception {
        if (this.level == -1) {
            this.paramsClasses = new Class[1];
            this.paramsClasses[0] = Class.forName("java.io.OutputStream");
            Object[] params = new Object[]{slave};
            return params;
        }
        this.paramsClasses = new Class[2];
        this.paramsClasses[0] = Class.forName("java.io.OutputStream");
        this.paramsClasses[1] = Integer.TYPE;
        Object[] params = new Object[]{slave, new Integer(this.level)};
        return params;
    }
}

