/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Manifest;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class JarOutputStream
extends ZipOutputStream {
    private static final int JAR_MAGIC = 51966;
    private boolean firstEntry = true;
    private boolean preventClose = false;

    public JarOutputStream(OutputStream out) throws IOException {
        super(out);
    }

    public JarOutputStream(File fout, Manifest man) throws IOException {
        super(fout);
        if (man == null) {
            throw new NullPointerException("man");
        }
        ZipEntry e = new ZipEntry("META-INF/MANIFEST.MF");
        this.putNextEntry(e);
        man.write(new BufferedOutputStream(this));
        this.closeEntry();
    }

    public JarOutputStream(File arg0) throws IOException {
        super(arg0);
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        if (this.firstEntry) {
            byte[] edata = ze.getExtra();
            if (edata != null && !JarOutputStream.hasMagic(edata)) {
                byte[] tmp = new byte[edata.length + 4];
                System.arraycopy(tmp, 4, edata, 0, edata.length);
                edata = tmp;
            } else {
                edata = new byte[4];
            }
            JarOutputStream.set16(edata, 0, 51966);
            JarOutputStream.set16(edata, 2, 0);
            ze.setExtra(edata);
            this.firstEntry = false;
        }
        super.putNextEntry(ze);
    }

    public boolean isPreventClose() {
        return this.preventClose;
    }

    public void setPreventClose(boolean preventClose) {
        this.preventClose = preventClose;
    }

    public void close() throws IOException {
        if (!this.isPreventClose()) {
            super.close();
        }
    }

    public void closeAlways() throws IOException {
        this.setPreventClose(false);
        this.close();
    }

    private static boolean hasMagic(byte[] edata) {
        try {
            for (int i = 0; i < edata.length; i += JarOutputStream.get16(edata, i + 2) + 4) {
                if (JarOutputStream.get16(edata, i) != 51966) continue;
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int get16(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    private static void set16(byte[] b, int off, int value) {
        b[off + 0] = (byte)value;
        b[off + 1] = (byte)(value >> 8);
    }
}

