/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Panel;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.compiler.IPackager;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerListener;
import com.izforge.izpack.compressor.PackCompressor;
import com.izforge.izpack.compressor.PackCompressorFactory;
import com.izforge.izpack.rules.Condition;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackagerBase
implements IPackager {
    public static final String SKELETON_SUBPATH = "lib/installer.jar";
    protected File baseFile = null;
    protected Info info = null;
    protected GUIPrefs guiPrefs = null;
    protected Properties variables = new Properties();
    protected List<Panel> panelList = new ArrayList<Panel>();
    protected List<PackInfo> packsList = new ArrayList<PackInfo>();
    protected List<String> langpackNameList = new ArrayList<String>();
    protected List<CustomData> customDataList = new ArrayList<CustomData>();
    protected Map<String, URL> installerResourceURLMap = new HashMap<String, URL>();
    protected Map<String, Condition> rules = new HashMap<String, Condition>();
    protected Map<String, List<DynamicVariable>> dynamicvariables = new HashMap<String, List<DynamicVariable>>();
    protected Set<Object[]> includedJarURLs = new HashSet<Object[]>();
    protected boolean packJarsSeparate = false;
    protected PackagerListener listener;
    protected PackCompressor compressor;
    protected HashMap<FilterOutputStream, HashSet<String>> alreadyWrittenFiles = new HashMap();

    protected void sendMsg(String job) {
        this.sendMsg(job, 2);
    }

    protected void sendMsg(String job, int priority) {
        if (this.listener != null) {
            this.listener.packagerMsg(job, priority);
        }
    }

    protected void sendStart() {
        if (this.listener != null) {
            this.listener.packagerStart();
        }
    }

    protected void sendStop() {
        if (this.listener != null) {
            this.listener.packagerStop();
        }
    }

    @Override
    public void addCustomJar(CustomData ca, URL url) {
        this.customDataList.add(ca);
        this.addJarContent(url);
    }

    @Override
    public void addJarContent(URL jarURL) {
        this.addJarContent(jarURL, null);
    }

    @Override
    public void addJarContent(URL jarURL, List<String> files) {
        Object[] cont = new Object[]{jarURL, files};
        this.sendMsg("Adding content of jar: " + jarURL.getFile(), 3);
        this.includedJarURLs.add(cont);
    }

    @Override
    public void addLangPack(String iso3, URL xmlURL, URL flagURL) {
        this.sendMsg("Adding langpack: " + iso3, 3);
        this.langpackNameList.add(iso3);
        this.addResource("flag." + iso3, flagURL);
        this.installerResourceURLMap.put("langpacks/" + iso3 + ".xml", xmlURL);
    }

    @Override
    public void addNativeLibrary(String name, URL url) throws Exception {
        this.sendMsg("Adding native library: " + name, 3);
        this.installerResourceURLMap.put("native/" + name, url);
    }

    @Override
    public void addNativeUninstallerLibrary(CustomData data) {
        this.customDataList.add(data);
    }

    @Override
    public void addPack(PackInfo pack) {
        this.packsList.add(pack);
    }

    @Override
    public void addPanelJar(Panel panel, URL jarURL) {
        this.panelList.add(panel);
        this.addJarContent(jarURL);
    }

    @Override
    public void addResource(String resId, URL url) {
        this.sendMsg("Adding resource: " + resId, 3);
        this.installerResourceURLMap.put("res/" + resId, url);
    }

    @Override
    public PackCompressor getCompressor() {
        return this.compressor;
    }

    @Override
    public PackagerListener getPackagerListener() {
        return this.listener;
    }

    @Override
    public List<PackInfo> getPacksList() {
        return this.packsList;
    }

    @Override
    public Properties getVariables() {
        return this.variables;
    }

    @Override
    public void initPackCompressor(String compr_format, int compr_level) throws CompilerException {
        this.compressor = PackCompressorFactory.get(compr_format);
        this.compressor.setCompressionLevel(compr_level);
    }

    @Override
    public void setGUIPrefs(GUIPrefs prefs) {
        this.sendMsg("Setting the GUI preferences", 3);
        this.guiPrefs = prefs;
    }

    @Override
    public void setInfo(Info info) throws Exception {
        this.sendMsg("Setting the installer information", 3);
        this.info = info;
        if (!this.getCompressor().useStandardCompression() && this.getCompressor().getDecoderMapperName() != null) {
            this.info.setPackDecoderClassName(this.getCompressor().getDecoderMapperName());
        }
    }

    @Override
    public void setPackagerListener(PackagerListener listener) {
        this.listener = listener;
    }

    @Override
    public Map<String, Condition> getRules() {
        return this.rules;
    }

    @Override
    public void setRules(Map<String, Condition> rules) {
        this.rules = rules;
    }

    protected void writeInstaller() throws Exception {
        this.writeSkeletonInstaller();
        this.writeInstallerObject("info", this.info);
        this.writeInstallerObject("vars", this.variables);
        this.writeInstallerObject("GUIPrefs", this.guiPrefs);
        this.writeInstallerObject("panelsOrder", this.panelList);
        this.writeInstallerObject("customData", this.customDataList);
        this.writeInstallerObject("langpacks.info", this.langpackNameList);
        this.writeInstallerObject("rules", this.rules);
        this.writeInstallerObject("dynvariables", this.dynamicvariables);
        this.writeInstallerResources();
        this.writeIncludedJars();
        this.writePacks();
    }

    protected abstract void writeInstallerObject(String var1, Object var2) throws IOException;

    protected abstract void writeSkeletonInstaller() throws IOException;

    protected abstract void writeInstallerResources() throws IOException;

    protected abstract void writeIncludedJars() throws IOException;

    protected abstract void writePacks() throws Exception;

    @Override
    public Map<String, List<DynamicVariable>> getDynamicVariables() {
        return this.dynamicvariables;
    }

    @Override
    public void setDynamicVariables(Map<String, List<DynamicVariable>> dynamicvariables) {
        this.dynamicvariables = dynamicvariables;
    }
}

