/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import net.n3.nanoxml.XMLElement;

public class OrCondition
extends Condition {
    private static final long serialVersionUID = 8341350377205144199L;
    protected Condition leftoperand;
    protected Condition rightoperand;

    public OrCondition() {
    }

    public OrCondition(Condition operand1, Condition operand2) {
        this.leftoperand = operand1;
        this.rightoperand = operand2;
    }

    public void readFromXML(XMLElement xmlcondition) {
        try {
            if (xmlcondition.getChildrenCount() != 2) {
                Debug.log("or-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(1));
        }
        catch (Exception e) {
            Debug.log("missing element in or-condition");
        }
    }

    public boolean isTrue() {
        return this.leftoperand.isTrue() || this.rightoperand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on:<ul><li>");
        details.append(this.leftoperand.getDependenciesDetails());
        details.append("</li> OR <li>");
        details.append(this.rightoperand.getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }
}

