/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.Info;
import com.izforge.izpack.Panel;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.compiler.Compiler;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.compiler.IPackager;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.compiler.PackagerHelper;
import com.izforge.izpack.compiler.PackagerListener;
import com.izforge.izpack.compiler.Property;
import com.izforge.izpack.event.CompilerListener;
import com.izforge.izpack.installer.InstallerRequirement;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParserFactory;
import net.n3.nanoxml.XMLWriter;
import org.apache.tools.ant.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerConfig
extends Thread {
    public static final String VERSION = "1.0";
    public static final String STANDARD = "standard";
    public static final String WEB = "web";
    private static boolean YES = true;
    private static boolean NO = false;
    private static final String IZ_TEST_FILE = "ShellLink.dll";
    private static final String IZ_TEST_SUBDIR = "bin" + File.separator + "native" + File.separator + "izpack";
    private String filename;
    private String installText;
    protected String basedir;
    private Compiler compiler;
    protected List<CompilerListener> compilerListeners = new ArrayList<CompilerListener>();

    public static void setIzpackHome(String string) {
        Compiler.setIzpackHome(string);
    }

    public CompilerConfig(String string, String string2, String string3, String string4) throws CompilerException {
        this(string, string2, string3, string4, null);
    }

    public CompilerConfig(String string, String string2, String string3, String string4, PackagerListener packagerListener) throws CompilerException {
        this(string, string2, string3, string4, "default", packagerListener);
    }

    public CompilerConfig(String string, String string2, String string3, String string4, String string5, PackagerListener packagerListener) throws CompilerException {
        this(string, string2, string3, string4, string5, packagerListener, null);
    }

    public CompilerConfig(String string, String string2, String string3, PackagerListener packagerListener, String string4) throws CompilerException {
        this(null, string, string2, string3, "default", packagerListener, string4);
    }

    public CompilerConfig(String string, String string2, String string3, String string4, String string5, PackagerListener packagerListener, String string6) throws CompilerException {
        this(string, string2, string3, string4, string5, -1, packagerListener, string6);
    }

    public CompilerConfig(String string, String string2, String string3, String string4, String string5, int n, PackagerListener packagerListener, String string6) throws CompilerException {
        this.filename = string;
        this.installText = string6;
        this.basedir = string2;
        this.compiler = new Compiler(string2, string3, string4, string5, n);
        this.compiler.setPackagerListener(packagerListener);
    }

    public boolean addProperty(String string, String string2) {
        return this.compiler.addProperty(string, string2);
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public PackagerListener getPackagerListener() {
        return this.compiler.getPackagerListener();
    }

    public void compile() {
        this.start();
    }

    @Override
    public void run() {
        try {
            this.executeCompiler();
        }
        catch (CompilerException compilerException) {
            System.out.println(compilerException.getMessage() + "\n");
        }
        catch (Exception exception) {
            if (Debug.stackTracing()) {
                exception.printStackTrace();
            }
            System.out.println("ERROR: " + exception.getMessage());
        }
    }

    public void executeCompiler() throws Exception {
        File file = new File(this.basedir).getAbsoluteFile();
        if (!file.canRead() || !file.isDirectory()) {
            throw new CompilerException("Invalid base directory: " + file);
        }
        this.compiler.setProperty("basedir", file.toString());
        XMLElement xMLElement = this.getXMLTree();
        this.loadPackagingInformation(xMLElement);
        this.addCustomListeners(xMLElement);
        this.substituteProperties(xMLElement);
        this.addVariables(xMLElement);
        this.addDynamicVariables(xMLElement);
        this.addConditions(xMLElement);
        this.addInfo(xMLElement);
        this.addGUIPrefs(xMLElement);
        this.addLangpacks(xMLElement);
        this.addResources(xMLElement);
        this.addNativeLibraries(xMLElement);
        this.addJars(xMLElement);
        this.addPanels(xMLElement);
        this.addPacks(xMLElement);
        this.addInstallerRequirement(xMLElement);
        this.compiler.createInstaller();
    }

    private void addInstallerRequirement(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("addInstallerRequirement", 1, xMLElement);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("installerrequirements");
        ArrayList<InstallerRequirement> arrayList = new ArrayList<InstallerRequirement>();
        if (xMLElement2 != null) {
            Vector<XMLElement> vector = xMLElement2.getChildrenNamed("installerrequirement");
            for (XMLElement xMLElement3 : vector) {
                InstallerRequirement installerRequirement = new InstallerRequirement();
                String string = xMLElement3.getAttribute("condition");
                installerRequirement.setCondition(string);
                String string2 = xMLElement3.getAttribute("message");
                installerRequirement.setMessage(string2);
                arrayList.add(installerRequirement);
            }
        }
        this.compiler.addInstallerRequirement(arrayList);
        this.notifyCompilerListener("addInstallerRequirement", 2, xMLElement);
    }

    private void loadPackagingInformation(XMLElement xMLElement) throws CompilerException {
        XMLElement xMLElement2;
        this.notifyCompilerListener("loadPackager", 1, xMLElement);
        XMLElement xMLElement3 = xMLElement.getFirstChildNamed("packaging");
        String string = "com.izforge.izpack.compiler.Packager";
        String string2 = "com.izforge.izpack.installer.Unpacker";
        XMLElement xMLElement4 = null;
        if (xMLElement3 != null) {
            xMLElement4 = xMLElement3.getFirstChildNamed("packager");
            if (xMLElement4 != null) {
                string = this.requireAttribute(xMLElement4, "class");
            }
            if ((xMLElement2 = xMLElement3.getFirstChildNamed("unpacker")) != null) {
                string2 = this.requireAttribute(xMLElement2, "class");
            }
        }
        this.compiler.initPackager(string);
        if (xMLElement4 != null && (xMLElement2 = xMLElement4.getFirstChildNamed("options")) != null) {
            this.compiler.getPackager().addConfigurationInformation(xMLElement2);
        }
        this.compiler.addProperty("UNPACKER_CLASS", string2);
        this.notifyCompilerListener("loadPackager", 2, xMLElement);
    }

    public boolean wasSuccessful() {
        return this.compiler.wasSuccessful();
    }

    protected void addGUIPrefs(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("addGUIPrefs", 1, xMLElement);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("guiprefs");
        GUIPrefs gUIPrefs = new GUIPrefs();
        if (xMLElement2 != null) {
            Object object;
            Object object2;
            Object object3;
            gUIPrefs.resizable = this.requireYesNoAttribute(xMLElement2, "resizable");
            gUIPrefs.width = this.requireIntAttribute(xMLElement2, "width");
            gUIPrefs.height = this.requireIntAttribute(xMLElement2, "height");
            for (XMLElement serializable2 : xMLElement2.getChildrenNamed("laf")) {
                object3 = this.requireAttribute(serializable2, "name");
                this.requireChildNamed(serializable2, "os");
                for (XMLElement xMLElement3 : serializable2.getChildrenNamed("os")) {
                    object2 = this.requireAttribute(xMLElement3, "family");
                    gUIPrefs.lookAndFeelMapping.put((String)object2, (String)object3);
                }
                Iterator<XMLElement> iterator = serializable2.getChildrenNamed("param").iterator();
                object2 = new TreeMap();
                while (iterator.hasNext()) {
                    XMLElement xMLElement4 = iterator.next();
                    String string = this.requireAttribute(xMLElement4, "name");
                    String string2 = this.requireAttribute(xMLElement4, "value");
                    object2.put(string, string2);
                }
                gUIPrefs.lookAndFeelParams.put((String)object3, (Map<String, String>)object2);
            }
            for (XMLElement xMLElement5 : xMLElement2.getChildrenNamed("modifier")) {
                object3 = this.requireAttribute(xMLElement5, "key");
                object = this.requireAttribute(xMLElement5, "value");
                gUIPrefs.modifier.put((String)object3, (String)object);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("liquid", "liquidlnf.jar");
            hashMap.put("kunststoff", "kunststoff.jar");
            hashMap.put("metouia", "metouia.jar");
            hashMap.put("looks", "looks.jar");
            hashMap.put("substance", "substance.jar");
            hashMap.put("nimbus", "nimbus.jar");
            object3 = gUIPrefs.lookAndFeelMapping.keySet().iterator();
            while (object3.hasNext()) {
                object = gUIPrefs.lookAndFeelMapping.get(object3.next());
                String string = (String)hashMap.get(object);
                if (string == null) {
                    this.parseError(xMLElement2, "Unrecognized Look and Feel: " + (String)object);
                }
                object2 = this.findIzPackResource("lib/" + string, "Look and Feel Jar file", xMLElement2);
                this.compiler.addJarContent((URL)object2);
            }
        }
        this.compiler.setGUIPrefs(gUIPrefs);
        this.notifyCompilerListener("addGUIPrefs", 2, xMLElement);
    }

    protected void addJars(XMLElement xMLElement) throws Exception {
        this.notifyCompilerListener("addJars", 1, xMLElement);
        for (XMLElement xMLElement2 : xMLElement.getChildrenNamed("jar")) {
            String string = this.requireAttribute(xMLElement2, "src");
            URL uRL = this.findProjectResource(string, "Jar file", xMLElement2);
            this.compiler.addJarContent(uRL);
            String string2 = xMLElement2.getAttribute("stage");
            if (string2 == null || !"both".equalsIgnoreCase(string2) && !"uninstall".equalsIgnoreCase(string2)) continue;
            CustomData customData = new CustomData(null, this.getContainedFilePaths(uRL), null, 3);
            this.compiler.addCustomJar(customData, uRL);
        }
        this.notifyCompilerListener("addJars", 2, xMLElement);
    }

    protected void addNativeLibraries(XMLElement xMLElement) throws Exception {
        Object object;
        Object object2;
        XMLElement xMLElement22;
        boolean bl = false;
        this.notifyCompilerListener("addNativeLibraries", 1, xMLElement);
        for (XMLElement xMLElement22 : xMLElement.getChildrenNamed("native")) {
            object2 = this.requireAttribute(xMLElement22, "type");
            object = this.requireAttribute(xMLElement22, "name");
            String string = "bin/native/" + (String)object2 + "/" + (String)object;
            URL uRL = this.findIzPackResource(string, "Native Library", xMLElement22);
            this.compiler.addNativeLibrary((String)object, uRL);
            String string2 = xMLElement22.getAttribute("stage");
            List<OsConstraint> list = OsConstraint.getOsList(xMLElement22);
            if (string2 == null || !"both".equalsIgnoreCase(string2) && !"uninstall".equalsIgnoreCase(string2)) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add((String)object);
            CustomData customData = new CustomData(null, arrayList, list, 2);
            this.compiler.addNativeUninstallerLibrary(customData);
            bl = true;
        }
        if (bl && this.validateYesNoAttribute((XMLElement)(object2 = (xMLElement22 = this.requireChildNamed(xMLElement, "info")).getFirstChildNamed("uninstaller")), "write", YES)) {
            object = this.findIzPackResource("lib/uninstaller-ext.jar", "Uninstaller extensions", xMLElement22);
            this.compiler.addResource("IzPack.uninstaller-ext", (URL)object);
        }
        this.notifyCompilerListener("addNativeLibraries", 2, xMLElement);
    }

    protected void addPacks(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("addPacks", 1, xMLElement);
        this.addPacksSingle(xMLElement);
        this.compiler.checkDependencies();
        this.compiler.checkExcludes();
        this.notifyCompilerListener("addPacks", 2, xMLElement);
    }

    private void addPacksSingle(XMLElement xMLElement) throws CompilerException {
        Object object;
        Object iOException;
        Object object2;
        Object object3;
        boolean bl;
        String string;
        String string2;
        this.notifyCompilerListener("addPacksSingle", 1, xMLElement);
        XMLElement xMLElement2 = this.requireChildNamed(xMLElement, "packs");
        Vector<XMLElement> vector = xMLElement2.getChildrenNamed("pack");
        Vector<XMLElement> vector2 = xMLElement2.getChildrenNamed("refpack");
        if (vector.isEmpty() && vector2.isEmpty()) {
            this.parseError(xMLElement2, "<packs> requires a <pack> or <refpack>");
        }
        File file = new File(this.basedir);
        for (XMLElement object5 : vector) {
            Object object4;
            Object object6;
            Object object7;
            List<OsConstraint> list;
            Object object8;
            Object object9;
            String string3 = this.requireAttribute(object5, "name");
            string2 = object5.getAttribute("id");
            string = object5.getAttribute("packImgId");
            bl = "true".equalsIgnoreCase(object5.getAttribute("loose", "false"));
            object3 = this.requireChildNamed(object5, "description").getContent();
            boolean bl2 = this.requireYesNoAttribute(object5, "required");
            object2 = object5.getAttribute("group");
            iOException = object5.getAttribute("installGroups");
            object = object5.getAttribute("excludeGroup");
            boolean bl3 = "yes".equalsIgnoreCase(object5.getAttribute("uninstall", "yes"));
            String string4 = object5.getAttribute("parent");
            String string5 = object5.getAttribute("condition");
            if (bl2 && object != null) {
                this.parseError(object5, "Pack, which has excludeGroup can not be required.", new Exception("Pack, which has excludeGroup can not be required."));
            }
            PackInfo packInfo = new PackInfo(string3, string2, (String)object3, bl2, bl, (String)object, bl3);
            packInfo.setOsConstraints(OsConstraint.getOsList(object5));
            packInfo.setParent(string4);
            packInfo.setCondition(string5);
            if (object == null) {
                packInfo.setPreselected(this.validateYesNoAttribute(object5, "preselected", YES));
            } else {
                packInfo.setPreselected(this.validateYesNoAttribute(object5, "preselected", NO));
            }
            if (object2 != null) {
                packInfo.setGroup((String)object2);
            }
            if (iOException != null) {
                Iterator<XMLElement> iterator = new StringTokenizer((String)iOException, ",");
                while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                    String string6 = ((StringTokenizer)((Object)iterator)).nextToken();
                    packInfo.addInstallGroup(string6);
                }
            }
            if (string != null) {
                packInfo.setPackImgId(string);
            }
            for (XMLElement xMLElement3 : object5.getChildrenNamed("parsable")) {
                object9 = this.requireAttribute(xMLElement3, "targetfile");
                object8 = xMLElement3.getAttribute("type", "plain");
                list = xMLElement3.getAttribute("encoding", null);
                object7 = OsConstraint.getOsList(xMLElement3);
                String string7 = xMLElement3.getAttribute("condition");
                ParsableFile parsableFile = new ParsableFile((String)object9, (String)object8, (String)((Object)list), (List<OsConstraint>)object7);
                parsableFile.setCondition(string7);
                packInfo.addParsable(parsableFile);
            }
            for (XMLElement xMLElement4 : object5.getChildrenNamed("executable")) {
                object9 = new ExecutableFile();
                list = xMLElement4.getAttribute("condition");
                ((ExecutableFile)object9).setCondition((String)((Object)list));
                ((ExecutableFile)object9).path = this.requireAttribute(xMLElement4, "targetfile");
                object8 = xMLElement4.getAttribute("stage", "never");
                if ("postinstall".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).executionStage = 0;
                } else if ("uninstall".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).executionStage = 2;
                }
                object8 = xMLElement4.getAttribute("type", "bin");
                if ("jar".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).type = 1;
                    ((ExecutableFile)object9).mainClass = xMLElement4.getAttribute("class");
                }
                if ("abort".equalsIgnoreCase((String)(object8 = xMLElement4.getAttribute("failure", "ask")))) {
                    ((ExecutableFile)object9).onFailure = 0;
                } else if ("warn".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).onFailure = 1;
                } else if ("ignore".equalsIgnoreCase((String)object8)) {
                    ((ExecutableFile)object9).onFailure = 3;
                }
                object8 = xMLElement4.getAttribute("keep");
                ((ExecutableFile)object9).keepFile = "true".equalsIgnoreCase((String)object8);
                object7 = xMLElement4.getFirstChildNamed("args");
                if (null != object7) {
                    for (XMLElement xMLElement5 : ((XMLElement)object7).getChildrenNamed("arg")) {
                        ((ExecutableFile)object9).argList.add(this.requireAttribute(xMLElement5, "value"));
                    }
                }
                ((ExecutableFile)object9).osList = OsConstraint.getOsList(xMLElement4);
                packInfo.addExecutable((ExecutableFile)object9);
            }
            for (XMLElement xMLElement6 : object5.getChildrenNamed("file")) {
                object9 = this.requireAttribute(xMLElement6, "src");
                object8 = this.requireAttribute(xMLElement6, "targetdir");
                list = OsConstraint.getOsList(xMLElement6);
                int n = this.getOverrideValue(xMLElement6);
                Map map = this.getAdditionals(xMLElement6);
                boolean bl4 = "true".equalsIgnoreCase(xMLElement6.getAttribute("unpack"));
                object6 = xMLElement6.getAttribute("condition");
                object4 = new File((String)object9);
                if (!((File)object4).isAbsolute()) {
                    object4 = new File(this.basedir, (String)object9);
                }
                try {
                    if (bl4) {
                        this.addArchiveContent(file, (File)object4, (String)object8, list, n, packInfo, map, (String)object6);
                        continue;
                    }
                    this.addRecursively(file, (File)object4, (String)object8, list, n, packInfo, map, (String)object6);
                }
                catch (Exception exception) {
                    this.parseError(xMLElement6, exception.getMessage(), exception);
                }
            }
            for (XMLElement xMLElement7 : object5.getChildrenNamed("singlefile")) {
                object9 = this.requireAttribute(xMLElement7, "src");
                object8 = this.requireAttribute(xMLElement7, "target");
                list = OsConstraint.getOsList(xMLElement7);
                int n = this.getOverrideValue(xMLElement7);
                Map map = this.getAdditionals(xMLElement7);
                String string8 = xMLElement7.getAttribute("condition");
                object6 = new File((String)object9);
                if (!((File)object6).isAbsolute()) {
                    object6 = new File(this.basedir, (String)object9);
                }
                try {
                    packInfo.addFile(file, (File)object6, (String)object8, list, n, map, string8);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.parseError(xMLElement7, fileNotFoundException.getMessage(), fileNotFoundException);
                }
            }
            for (XMLElement xMLElement8 : object5.getChildrenNamed("fileset")) {
                String string9;
                int n;
                String[] stringArray;
                String[] stringArray2;
                String[][] stringArrayArray;
                String[] stringArray3;
                object9 = this.requireAttribute(xMLElement8, "dir");
                object8 = new File((String)object9);
                if (!((File)object8).isAbsolute()) {
                    object8 = new File(this.basedir, (String)object9);
                }
                if (!((File)object8).isDirectory()) {
                    this.parseError(xMLElement8, "Invalid directory 'dir': " + (String)object9);
                }
                boolean bl5 = this.validateYesNoAttribute(xMLElement8, "casesensitive", YES);
                boolean bl6 = this.validateYesNoAttribute(xMLElement8, "defaultexcludes", YES);
                String string10 = this.requireAttribute(xMLElement8, "targetdir");
                List<OsConstraint> list2 = OsConstraint.getOsList(xMLElement8);
                int n2 = this.getOverrideValue(xMLElement8);
                object4 = this.getAdditionals(xMLElement8);
                String string11 = xMLElement8.getAttribute("condition");
                Vector<XMLElement> vector3 = null;
                String[] stringArray4 = null;
                vector3 = xMLElement8.getChildrenNamed("include");
                if (!vector3.isEmpty()) {
                    stringArray4 = new String[vector3.size()];
                    for (int i = 0; i < vector3.size(); ++i) {
                        stringArray3 = vector3.get(i);
                        stringArray4[i] = this.requireAttribute((XMLElement)stringArray3, "name");
                    }
                }
                String[] stringArray5 = null;
                vector3 = xMLElement8.getChildrenNamed("exclude");
                if (!vector3.isEmpty()) {
                    stringArray5 = new String[vector3.size()];
                    for (int i = 0; i < vector3.size(); ++i) {
                        stringArrayArray = vector3.get(i);
                        stringArray5[i] = this.requireAttribute((XMLElement)stringArrayArray, "name");
                    }
                }
                stringArray3 = new String[]{"includes", "excludes"};
                stringArrayArray = new String[][]{stringArray4, stringArray5};
                for (int i = 0; i < stringArray3.length; ++i) {
                    stringArray2 = xMLElement8.getAttribute(stringArray3[i]);
                    if (stringArray2 == null || stringArray2.length() <= 0) continue;
                    stringArray = new StringTokenizer((String)stringArray2, ", ", false);
                    int n3 = stringArray.countTokens();
                    String[] stringArray6 = null;
                    if (stringArrayArray[i] != null && stringArrayArray[i].length > 0) {
                        stringArray6 = new String[n3 += stringArrayArray[i].length];
                        for (n = 0; n < stringArrayArray[i].length; ++n) {
                            stringArray6[n] = stringArrayArray[i][n];
                        }
                    }
                    if (stringArray6 == null) {
                        stringArray6 = new String[n3];
                    }
                    while (n < n3) {
                        stringArray6[n] = stringArray.nextToken();
                        ++n;
                    }
                    stringArrayArray[i] = stringArray6;
                }
                stringArray4 = stringArrayArray[0];
                stringArray5 = stringArrayArray[1];
                DirectoryScanner directoryScanner = new DirectoryScanner();
                directoryScanner.setIncludes(stringArray4);
                directoryScanner.setExcludes(stringArray5);
                if (bl6) {
                    directoryScanner.addDefaultExcludes();
                }
                directoryScanner.setBasedir((File)object8);
                directoryScanner.setCaseSensitive(bl5);
                directoryScanner.scan();
                stringArray2 = directoryScanner.getIncludedFiles();
                stringArray = directoryScanner.getIncludedDirectories();
                for (String string12 : stringArray2) {
                    try {
                        string9 = new File(string10, string12).getPath();
                        packInfo.addFile(file, new File((File)object8, string12), string9, list2, n2, (Map)object4, string11);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.parseError(xMLElement8, fileNotFoundException.getMessage(), fileNotFoundException);
                    }
                }
                String[] stringArray7 = stringArray;
                n = stringArray7.length;
                for (int i = 0; i < n; ++i) {
                    String string12;
                    string12 = stringArray7[i];
                    try {
                        string9 = new File(string10, string12).getPath();
                        packInfo.addFile(file, new File((File)object8, string12), string9, list2, n2, (Map)object4, string11);
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.parseError(xMLElement8, fileNotFoundException.getMessage(), fileNotFoundException);
                    }
                }
            }
            for (XMLElement xMLElement9 : object5.getChildrenNamed("updatecheck")) {
                object9 = xMLElement9.getAttribute("casesensitive");
                object8 = new ArrayList();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (XMLElement xMLElement10 : xMLElement9.getChildrenNamed("include")) {
                    ((ArrayList)object8).add(this.requireAttribute(xMLElement10, "name"));
                }
                for (XMLElement xMLElement11 : xMLElement9.getChildrenNamed("exclude")) {
                    arrayList.add(this.requireAttribute(xMLElement11, "name"));
                }
                packInfo.addUpdateCheck(new UpdateCheck((ArrayList<String>)object8, arrayList, (String)object9));
            }
            for (XMLElement xMLElement12 : object5.getChildrenNamed("depends")) {
                object9 = this.requireAttribute(xMLElement12, "packname");
                packInfo.addDependency((String)object9);
            }
            this.compiler.addPack(packInfo);
        }
        for (XMLElement xMLElement13 : vector2) {
            string2 = this.requireAttribute(xMLElement13, "file");
            string = xMLElement13.getAttribute("selfcontained");
            bl = Boolean.valueOf(string);
            object3 = new File(string2);
            if (!((File)object3).isAbsolute()) {
                object3 = new File(this.basedir, string2);
            }
            if (!((File)object3).canRead()) {
                throw new CompilerException("Invalid file: " + object3);
            }
            InputStream inputStream = null;
            if (bl) {
                if (!((File)object3).getAbsolutePath().endsWith(".zip")) {
                    throw new CompilerException("Invalid file: " + object3 + ". Selfcontained files can only be of type zip.");
                }
                try {
                    object2 = new ZipFile((File)object3, 1);
                    iOException = ((ZipFile)object2).getEntry("META-INF/izpack.xml");
                    inputStream = ((ZipFile)object2).getInputStream((ZipEntry)iOException);
                }
                catch (IOException iOException2) {
                    throw new CompilerException("Error reading META-INF/izpack.xml in " + object3);
                }
            }
            try {
                inputStream = new FileInputStream(((File)object3).getAbsolutePath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CompilerException("FileNotFoundException exception while reading refXMLFile");
            }
            object2 = null;
            try {
                object2 = new StdXMLReader(inputStream);
            }
            catch (CompilerException compilerException) {
                throw new CompilerException("Compiler exception while reading refXMLFile");
            }
            catch (IOException iOException3) {
                throw new CompilerException("IOException exception while reading refXMLFile");
            }
            iOException = new StdXMLParser();
            ((StdXMLParser)iOException).setBuilder(XMLBuilderFactory.createXMLBuilder());
            ((StdXMLParser)iOException).setReader((IXMLReader)object2);
            ((StdXMLParser)iOException).setValidator(new NonValidator());
            object = null;
            try {
                object = (XMLElement)((StdXMLParser)iOException).parse();
            }
            catch (XMLException xMLException) {
                throw new CompilerException("Error parsing installation file", xMLException);
            }
            if (!"installation".equalsIgnoreCase(((XMLElement)object).getName())) {
                this.parseError((XMLElement)object, "this is not an IzPack XML installation file");
            }
            if (!VERSION.equalsIgnoreCase(this.requireAttribute((XMLElement)object, "version"))) {
                this.parseError((XMLElement)object, "the file version is different from the compiler version");
            }
            this.substituteProperties((XMLElement)object);
            this.addResources((XMLElement)object);
            try {
                inputStream.close();
            }
            catch (IOException iOException4) {
                iOException4.printStackTrace();
            }
            this.addPacksSingle((XMLElement)object);
        }
        this.notifyCompilerListener("addPacksSingle", 2, xMLElement);
    }

    public void checkDependencies(List<PackInfo> list) throws CompilerException {
        HashMap<String, PackInfo> hashMap = new HashMap<String, PackInfo>();
        for (PackInfo packInfo : list) {
            hashMap.put(packInfo.getPack().name, packInfo);
        }
        int n = this.dfs(list, hashMap);
        if (n == -2) {
            this.parseError("Circular dependency detected");
        } else if (n == -1) {
            this.parseError("A dependency doesn't exist");
        }
    }

    private int dfs(List<PackInfo> list, Map<String, PackInfo> map) {
        HashMap<Edge, Integer> hashMap = new HashMap<Edge, Integer>();
        for (PackInfo packInfo : list) {
            if (packInfo.colour != 0 || this.dfsVisit(packInfo, map, hashMap) == 0) continue;
            return -1;
        }
        return this.checkBackEdges(hashMap);
    }

    private int checkBackEdges(Map<Edge, Integer> map) {
        Set<Edge> set = map.keySet();
        for (Edge edge : set) {
            int n = map.get(edge);
            if (n != 1) continue;
            return -2;
        }
        return 0;
    }

    private int dfsVisit(PackInfo packInfo, Map<String, PackInfo> map, Map<Edge, Integer> map2) {
        packInfo.colour = 1;
        List<String> list = packInfo.getDependencies();
        if (list != null) {
            for (String string : list) {
                int n;
                PackInfo packInfo2 = map.get(string);
                if (packInfo2 == null) {
                    System.out.println("Failed to find dependency: " + string);
                    return -1;
                }
                Edge edge = new Edge(packInfo, packInfo2);
                if (map2.get(edge) == null) {
                    map2.put(edge, packInfo2.colour);
                }
                if (packInfo2.colour != 0 || (n = this.dfsVisit(packInfo2, map, map2)) == 0) continue;
                return n;
            }
        }
        packInfo.colour = 2;
        return 0;
    }

    protected void addArchiveContent(File file, File file2, String string, List<OsConstraint> list, int n, PackInfo packInfo, Map map, String string2) throws IOException {
        ZipEntry zipEntry;
        FileInputStream fileInputStream = new FileInputStream(file2);
        ZipInputStream zipInputStream = new ZipInputStream(fileInputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            try {
                File file3 = File.createTempFile("izpack", null);
                file3.deleteOnExit();
                FileOutputStream fileOutputStream = new FileOutputStream(file3);
                PackagerHelper.copyStream(zipInputStream, fileOutputStream);
                fileOutputStream.close();
                packInfo.addFile(file, file3, string + "/" + zipEntry.getName(), list, n, map, string2);
            }
            catch (IOException iOException) {
                throw new IOException("Couldn't create temporary file for " + zipEntry.getName() + " in archive " + file2 + " (" + iOException.getMessage() + ")");
            }
        }
        fileInputStream.close();
    }

    protected void addRecursively(File file, File file2, String string, List<OsConstraint> list, int n, PackInfo packInfo, Map map, String string2) throws IOException {
        String string3 = string + "/" + file2.getName();
        if (!file2.isDirectory()) {
            packInfo.addFile(file, file2, string3, list, n, map, string2);
        } else {
            File[] fileArray = file2.listFiles();
            if (fileArray.length == 0) {
                packInfo.addFile(file, file2, string3, list, n, map, string2);
            } else {
                for (File file3 : fileArray) {
                    this.addRecursively(file, file3, string3, list, n, packInfo, map, string2);
                }
            }
        }
    }

    protected void addPanels(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("addPanels", 1, xMLElement);
        XMLElement xMLElement2 = this.requireChildNamed(xMLElement, "panels");
        Vector<XMLElement> vector = xMLElement2.getChildrenNamed("panel");
        if (vector.isEmpty()) {
            this.parseError(xMLElement2, "<panels> requires a <panel>");
        }
        for (XMLElement xMLElement3 : vector) {
            Panel panel = new Panel();
            panel.osConstraints = OsConstraint.getOsList(xMLElement3);
            String string = xMLElement3.getAttribute("classname");
            String string2 = xMLElement3.getAttribute("id");
            panel.setPanelid(string2);
            String string3 = xMLElement3.getAttribute("condition");
            panel.setCondition(string3);
            String string4 = "bin/panels/" + string + ".jar";
            URL uRL = this.findIzPackResource(string4, "Panel jar file", xMLElement3);
            String string5 = null;
            try {
                string5 = this.getFullClassName(uRL, string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            panel.className = string5 != null ? string5 : string;
            this.compiler.addPanelJar(panel, uRL);
        }
        this.notifyCompilerListener("addPanels", 2, xMLElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addResources(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("addResources", 1, xMLElement);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("resources");
        if (xMLElement2 == null) {
            return;
        }
        for (XMLElement xMLElement3 : xMLElement2.getChildrenNamed("res")) {
            URL uRL;
            String string = this.requireAttribute(xMLElement3, "id");
            String string2 = this.requireAttribute(xMLElement3, "src");
            boolean bl = this.validateYesNoAttribute(xMLElement3, "parse", NO);
            boolean bl2 = this.validateYesNoAttribute(xMLElement3, "parsexml", NO);
            URL uRL2 = uRL = this.findProjectResource(string2, "Resource", xMLElement3);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                Serializable serializable;
                Object object;
                Object object2;
                if (bl2 || bl && !this.compiler.getVariables().isEmpty()) {
                    object2 = File.createTempFile("izpp", null);
                    ((File)object2).deleteOnExit();
                    object = new FileOutputStream((File)object2);
                    outputStream = new BufferedOutputStream((OutputStream)object);
                    uRL2 = ((File)object2).toURL();
                }
                if (bl2) {
                    Object object3;
                    object2 = XMLParserFactory.createDefaultXMLParser();
                    object = new StdXMLReader(null, uRL.toExternalForm());
                    object2.setReader((IXMLReader)object);
                    serializable = (XMLElement)object2.parse();
                    if (bl && !this.compiler.getVariables().isEmpty()) {
                        object3 = new ByteArrayOutputStream();
                        XMLWriter xMLWriter = new XMLWriter((OutputStream)object3);
                        xMLWriter.write((XMLElement)serializable);
                        inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray());
                    } else {
                        object3 = new XMLWriter(outputStream);
                        ((XMLWriter)object3).write((XMLElement)serializable);
                    }
                }
                if (bl) {
                    if (this.compiler.getVariables().isEmpty()) {
                        uRL2 = uRL;
                        this.parseWarn(xMLElement3, "No variables defined. " + uRL2.getPath() + " not parsed.");
                    } else {
                        object2 = xMLElement3.getAttribute("type");
                        object = xMLElement3.getAttribute("encoding");
                        if (null == inputStream) {
                            inputStream = new BufferedInputStream(uRL.openStream());
                        }
                        serializable = new VariableSubstitutor(this.compiler.getVariables());
                        ((VariableSubstitutor)serializable).substitute(inputStream, outputStream, (String)object2, (String)object);
                    }
                }
            }
            catch (Exception exception) {
                this.parseError(xMLElement3, exception.getMessage(), exception);
            }
            finally {
                if (null != outputStream) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.compiler.addResource(string, uRL2);
        }
        this.notifyCompilerListener("addResources", 2, xMLElement);
    }

    protected void addLangpacks(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("addLangpacks", 1, xMLElement);
        XMLElement xMLElement2 = this.requireChildNamed(xMLElement, "locale");
        Vector<XMLElement> vector = xMLElement2.getChildrenNamed("langpack");
        if (vector.isEmpty()) {
            this.parseError(xMLElement2, "<locale> requires a <langpack>");
        }
        for (XMLElement xMLElement3 : vector) {
            String string = this.requireAttribute(xMLElement3, "iso3");
            String string2 = "bin/langpacks/installer/" + string + ".xml";
            URL uRL = this.findIzPackResource(string2, "ISO3 file", xMLElement3);
            string2 = "bin/langpacks/flags/" + string + ".gif";
            URL uRL2 = this.findIzPackResource(string2, "ISO3 flag image", xMLElement3);
            this.compiler.addLangPack(string, uRL, uRL2);
        }
        this.notifyCompilerListener("addLangpacks", 2, xMLElement);
    }

    protected void addInfo(XMLElement xMLElement) throws Exception {
        String string;
        Object object;
        Serializable serializable;
        XMLElement xMLElement2;
        String string2;
        Object object2;
        XMLElement xMLElement3;
        Object object3;
        Serializable serializable2;
        XMLElement xMLElement4;
        this.notifyCompilerListener("addInfo", 1, xMLElement);
        XMLElement xMLElement5 = this.requireChildNamed(xMLElement, "info");
        Info info = new Info();
        info.setAppName(this.requireContent(this.requireChildNamed(xMLElement5, "appname")));
        info.setAppVersion(this.requireContent(this.requireChildNamed(xMLElement5, "appversion")));
        XMLElement xMLElement6 = xMLElement5.getFirstChildNamed("appsubpath");
        if (xMLElement6 != null) {
            info.setInstallationSubPath(this.requireContent(xMLElement6));
        }
        if ((xMLElement4 = xMLElement5.getFirstChildNamed("url")) != null) {
            serializable2 = this.requireURLContent(xMLElement4);
            info.setAppURL(((URL)serializable2).toString());
        }
        if ((serializable2 = xMLElement5.getFirstChildNamed("authors")) != null) {
            object3 = ((XMLElement)serializable2).getChildrenNamed("author").iterator();
            while (object3.hasNext()) {
                xMLElement3 = (XMLElement)object3.next();
                object2 = this.requireAttribute(xMLElement3, "name");
                string2 = this.requireAttribute(xMLElement3, "email");
                info.addAuthor(new Info.Author((String)object2, string2));
            }
        }
        if ((object3 = xMLElement5.getFirstChildNamed("javaversion")) != null) {
            info.setJavaVersion(this.requireContent((XMLElement)object3));
        }
        if ((xMLElement3 = xMLElement5.getFirstChildNamed("requiresjdk")) != null) {
            info.setJdkRequired("yes".equals(xMLElement3.getContent()));
        }
        if ((object2 = xMLElement5.getFirstChildNamed("webdir")) != null) {
            info.setWebDirURL(this.requireURLContent((XMLElement)object2).toString());
        }
        if ((string2 = this.compiler.getKind()) != null) {
            if (string2.equalsIgnoreCase(WEB) && object2 == null) {
                this.parseError(xMLElement5, "<webdir> required when \"WEB\" installer requested");
            } else if (string2.equalsIgnoreCase(STANDARD) && object2 != null) {
                info.setWebDirURL(null);
            }
        }
        info.setPack200Compression((xMLElement2 = xMLElement5.getFirstChildNamed("pack200")) != null);
        XMLElement xMLElement7 = xMLElement5.getFirstChildNamed("uninstaller");
        if (this.validateYesNoAttribute(xMLElement7, "write", YES)) {
            serializable = this.findIzPackResource("lib/uninstaller.jar", "Uninstaller", xMLElement5);
            this.compiler.addResource("IzPack.uninstaller", (URL)serializable);
            if (xMLElement7 != null) {
                object = xMLElement7.getAttribute("name");
                if (object != null && ((String)object).length() > ".jar".length()) {
                    info.setUninstallerName((String)object);
                }
                if (xMLElement7.hasAttribute("condition")) {
                    string = xMLElement7.getAttribute("condition");
                    info.setUninstallerCondition(string);
                }
            }
        }
        if ((serializable = xMLElement5.getFirstChildNamed("summarylogfilepath")) != null) {
            info.setSummaryLogFilePath(this.requireContent((XMLElement)serializable));
        }
        if ((object = xMLElement5.getFirstChildNamed("writeinstallationinformation")) != null) {
            string = this.requireContent((XMLElement)object);
            info.setWriteInstallationInformation(this.validateYesNo(string));
        }
        string = this.compiler.getProperty("UNPACKER_CLASS");
        info.setUnpackerClassName(string);
        this.compiler.setInfo(info);
        this.notifyCompilerListener("addInfo", 2, xMLElement);
    }

    protected void addVariables(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("addVariables", 1, xMLElement);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("variables");
        if (xMLElement2 == null) {
            return;
        }
        Properties properties = this.compiler.getVariables();
        for (XMLElement xMLElement3 : xMLElement2.getChildrenNamed("variable")) {
            String string = this.requireAttribute(xMLElement3, "name");
            String string2 = this.requireAttribute(xMLElement3, "value");
            if (properties.contains(string)) {
                this.parseWarn(xMLElement3, "Variable '" + string + "' being overwritten");
            }
            properties.setProperty(string, string2);
        }
        this.notifyCompilerListener("addVariables", 2, xMLElement);
    }

    protected void addDynamicVariables(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("addDynamicVariables", 1, xMLElement);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("dynamicvariables");
        if (xMLElement2 == null) {
            return;
        }
        Map<String, List<DynamicVariable>> map = this.compiler.getDynamicVariables();
        for (XMLElement xMLElement3 : xMLElement2.getChildrenNamed("variable")) {
            String string = this.requireAttribute(xMLElement3, "name");
            String string2 = this.requireAttribute(xMLElement3, "value");
            String string3 = xMLElement3.getAttribute("condition");
            List<Object> list = new ArrayList();
            if (map.containsKey(string)) {
                list = map.get(string);
            } else {
                map.put(string, list);
            }
            DynamicVariable dynamicVariable = new DynamicVariable();
            dynamicVariable.setName(string);
            dynamicVariable.setValue(string2);
            dynamicVariable.setConditionid(string3);
            if (list.remove(dynamicVariable)) {
                this.parseWarn(xMLElement3, "Dynamic Variable '" + string + "' will be overwritten");
            }
            list.add(dynamicVariable);
        }
        this.notifyCompilerListener("addDynamicVariables", 2, xMLElement);
    }

    protected void addConditions(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("addConditions", 1, xMLElement);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("conditions");
        Map<String, Condition> map = this.compiler.getConditions();
        if (xMLElement2 != null) {
            for (XMLElement xMLElement3 : xMLElement2.getChildrenNamed("condition")) {
                Condition condition = RulesEngine.analyzeCondition(xMLElement3);
                if (condition != null) {
                    String string = condition.getId();
                    if (map.containsKey(string)) {
                        this.parseWarn(xMLElement3, "Condition with id '" + string + "' will be overwritten");
                    }
                    map.put(string, condition);
                    continue;
                }
                this.parseWarn(xMLElement3, "Condition couldn't be instantiated.");
            }
        }
        this.notifyCompilerListener("addConditions", 2, xMLElement);
    }

    protected void substituteProperties(XMLElement xMLElement) throws CompilerException {
        this.notifyCompilerListener("substituteProperties", 1, xMLElement);
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("properties");
        if (xMLElement2 != null) {
            for (XMLElement xMLElement3 : xMLElement2.getChildrenNamed("property")) {
                Property property = new Property(xMLElement3, this);
                property.execute();
            }
        }
        if (xMLElement2 != null) {
            xMLElement.removeChild(xMLElement2);
        }
        this.substituteAllProperties(xMLElement);
        if (xMLElement2 != null) {
            xMLElement.addChild(xMLElement2);
        }
        this.notifyCompilerListener("substituteProperties", 2, xMLElement);
    }

    protected void substituteAllProperties(XMLElement xMLElement) throws CompilerException {
        Object object;
        String string;
        Enumeration enumeration = xMLElement.enumerateAttributeNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.compiler.replaceProperties(xMLElement.getAttribute(string));
            xMLElement.setAttribute(string, (String)object);
        }
        string = xMLElement.getContent();
        if (string != null) {
            xMLElement.setContent(this.compiler.replaceProperties(string));
        }
        object = xMLElement.enumerateChildren();
        while (object.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)object.nextElement();
            this.substituteAllProperties(xMLElement2);
        }
    }

    private void assertIsNormalReadableFile(File file, String string) throws CompilerException {
        if (file != null) {
            if (!file.exists()) {
                throw new CompilerException(string + " does not exist: " + file);
            }
            if (!file.isFile()) {
                throw new CompilerException(string + " is not a regular file: " + file);
            }
            if (!file.canRead()) {
                throw new CompilerException(string + " is not readable by application: " + file);
            }
        }
    }

    protected XMLElement getXMLTree() throws CompilerException, IOException {
        Object object;
        IXMLReader iXMLReader = null;
        if (this.filename != null) {
            object = new File(this.filename).getAbsoluteFile();
            this.assertIsNormalReadableFile((File)object, "Configuration file");
            iXMLReader = new StdXMLReader(new FileInputStream(this.filename));
            iXMLReader.setSystemID(((File)object).toURL().toExternalForm());
            this.compiler.setProperty("izpack.file", ((File)object).toString());
        } else if (this.installText != null) {
            iXMLReader = StdXMLReader.stringReader(this.installText);
        } else {
            throw new CompilerException("Neither install file nor text specified");
        }
        object = new StdXMLParser();
        ((StdXMLParser)object).setBuilder(XMLBuilderFactory.createXMLBuilder());
        ((StdXMLParser)object).setReader(iXMLReader);
        ((StdXMLParser)object).setValidator(new NonValidator());
        XMLElement xMLElement = null;
        try {
            xMLElement = (XMLElement)((StdXMLParser)object).parse();
        }
        catch (Exception exception) {
            throw new CompilerException("Error parsing installation file", exception);
        }
        if (!"installation".equalsIgnoreCase(xMLElement.getName())) {
            this.parseError(xMLElement, "this is not an IzPack XML installation file");
        }
        if (!VERSION.equalsIgnoreCase(this.requireAttribute(xMLElement, "version"))) {
            this.parseError(xMLElement, "the file version is different from the compiler version");
        }
        return xMLElement;
    }

    protected int getOverrideValue(XMLElement xMLElement) throws CompilerException {
        int n = 4;
        String string = xMLElement.getAttribute("override");
        if (string != null) {
            if ("true".equalsIgnoreCase(string)) {
                n = 1;
            } else if ("false".equalsIgnoreCase(string)) {
                n = 0;
            } else if ("asktrue".equalsIgnoreCase(string)) {
                n = 3;
            } else if ("askfalse".equalsIgnoreCase(string)) {
                n = 2;
            } else if ("update".equalsIgnoreCase(string)) {
                n = 4;
            } else {
                this.parseError(xMLElement, "invalid value for attribute \"override\"");
            }
        }
        return n;
    }

    private URL findProjectResource(String string, String string2, XMLElement xMLElement) throws CompilerException {
        URL uRL = null;
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.basedir, string);
        }
        if (!file.exists()) {
            this.parseError(xMLElement, string2 + " not found: " + file);
        }
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            this.parseError(xMLElement, string2 + "(" + file + ")", malformedURLException);
        }
        return uRL;
    }

    private URL findIzPackResource(String string, String string2, XMLElement xMLElement) throws CompilerException {
        URL uRL = this.getClass().getResource("/" + string);
        if (uRL == null) {
            File file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(Compiler.IZPACK_HOME, string);
            }
            if (!file.exists()) {
                this.parseError(xMLElement, string2 + " not found: " + file);
            }
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                this.parseError(xMLElement, string2 + "(" + file + ")", malformedURLException);
            }
        }
        return uRL;
    }

    protected void parseError(String string) throws CompilerException {
        throw new CompilerException(this.filename + ":" + string);
    }

    protected void parseError(XMLElement xMLElement, String string) throws CompilerException {
        throw new CompilerException(this.filename + ":" + xMLElement.getLineNr() + ": " + string);
    }

    protected void parseError(XMLElement xMLElement, String string, Throwable throwable) throws CompilerException {
        throw new CompilerException(this.filename + ":" + xMLElement.getLineNr() + ": " + string, throwable);
    }

    protected void parseWarn(XMLElement xMLElement, String string) {
        System.out.println(this.filename + ":" + xMLElement.getLineNr() + ": " + string);
    }

    protected XMLElement requireChildNamed(XMLElement xMLElement, String string) throws CompilerException {
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed(string);
        if (xMLElement2 == null) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires child <" + string + ">");
        }
        return xMLElement2;
    }

    protected URL requireURLContent(XMLElement xMLElement) throws CompilerException {
        URL uRL = null;
        try {
            uRL = new URL(this.requireContent(xMLElement));
        }
        catch (MalformedURLException malformedURLException) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires valid URL", malformedURLException);
        }
        return uRL;
    }

    protected String requireContent(XMLElement xMLElement) throws CompilerException {
        String string = xMLElement.getContent();
        if (string == null || string.length() == 0) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires content");
        }
        return string;
    }

    protected boolean validateYesNo(String string) {
        boolean bl = false;
        if ("yes".equalsIgnoreCase(string)) {
            bl = true;
        } else if ("no".equalsIgnoreCase(string)) {
            bl = false;
        } else {
            Debug.trace("yes/no not found. trying true/false");
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    protected String requireAttribute(XMLElement xMLElement, String string) throws CompilerException {
        String string2 = xMLElement.getAttribute(string);
        if (string2 == null) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires attribute '" + string + "'");
        }
        return string2;
    }

    protected int requireIntAttribute(XMLElement xMLElement, String string) throws CompilerException {
        String string2 = xMLElement.getAttribute(string);
        if (string2 == null || string2.length() == 0) {
            this.parseError(xMLElement, "<" + xMLElement.getName() + "> requires attribute '" + string + "'");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.parseError(xMLElement, "'" + string + "' must be an integer");
            return 0;
        }
    }

    protected boolean requireYesNoAttribute(XMLElement xMLElement, String string) throws CompilerException {
        String string2 = this.requireAttribute(xMLElement, string);
        if ("yes".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2)) {
            return false;
        }
        this.parseError(xMLElement, "<" + xMLElement.getName() + "> invalid attribute '" + string + "': Expected (yes|no)");
        return false;
    }

    protected boolean validateYesNoAttribute(XMLElement xMLElement, String string, boolean bl) {
        if (xMLElement == null) {
            return bl;
        }
        String string2 = xMLElement.getAttribute(string, bl ? "yes" : "no");
        if ("yes".equalsIgnoreCase(string2)) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2)) {
            return false;
        }
        this.parseWarn(xMLElement, "<" + xMLElement.getName() + "> invalid attribute '" + string + "': Expected (yes|no) if present");
        return bl;
    }

    public static void main(String[] stringArray) {
        System.out.println("");
        System.out.println(".::  IzPack - Version 4.1.0 ::.");
        System.out.println("");
        System.out.println("< compiler specifications version: 1.0 >");
        System.out.println("");
        System.out.println("- Copyright (c) 2001-2008 Julien Ponge");
        System.out.println("- Visit http://izpack.org/ for the latest releases");
        System.out.println("- Released under the terms of the Apache Software License version 2.0.");
        System.out.println("");
        int n = 1;
        String string = ".";
        String string2 = System.getProperty("IZPACK_HOME");
        if (string2 != null) {
            string = string2;
        }
        try {
            String string3 = ".";
            String string4 = STANDARD;
            String string5 = "default";
            int n2 = -1;
            int n3 = stringArray.length;
            if (n3 < 1) {
                throw new Exception("no arguments given");
            }
            if ("-?".equalsIgnoreCase(stringArray[0])) {
                System.out.println("-> Command line parameters are : (xml file) [args]");
                System.out.println("   (xml file): the xml file describing the installation");
                System.out.println("   -h (IzPack home) : the root path of IzPack. This will be needed");
                System.out.println("               if the compiler is not called in the root directory  of IzPack.");
                System.out.println("               Do not forget quotations if there are blanks in the path.");
                System.out.println("   -b (base) : indicates the base path that the compiler will use for filenames");
                System.out.println("               of sources. Default is the current path. Attend to -h.");
                System.out.println("   -k (kind) : indicates the kind of installer to generate");
                System.out.println("               default is standard");
                System.out.println("   -o (out)  : indicates the output file name");
                System.out.println("               default is the xml file name\n");
                System.out.println("   -c (compression)  : indicates the compression format to be used for packs");
                System.out.println("               default is the internal deflate compression\n");
                System.out.println("   -l (compression-level)  : indicates the level for the used compression format");
                System.out.println("                if supported. Only integer are valid\n");
                System.out.println("   When using vm option -DSTACKTRACE=true there is all kind of debug info ");
                System.out.println("");
                n = 0;
            } else {
                String string6 = stringArray[0];
                String string7 = string6.substring(0, string6.length() - 3) + "jar";
                block10: for (int i = 1; i < n3; ++i) {
                    if (stringArray[i].startsWith("-") && stringArray[i].length() == 2) {
                        switch (stringArray[i].toLowerCase().charAt(1)) {
                            case 'b': {
                                if (i + 1 < n3) {
                                    string3 = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("base argument missing");
                            }
                            case 'k': {
                                if (i + 1 < n3) {
                                    string4 = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("kind argument missing");
                            }
                            case 'o': {
                                if (i + 1 < n3) {
                                    string7 = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("output argument missing");
                            }
                            case 'c': {
                                if (i + 1 < n3) {
                                    string5 = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("compression format argument missing");
                            }
                            case 'l': {
                                if (i + 1 < n3) {
                                    n2 = Integer.parseInt(stringArray[++i]);
                                    continue block10;
                                }
                                throw new Exception("compression level argument missing");
                            }
                            case 'h': {
                                if (i + 1 < n3) {
                                    string = stringArray[++i];
                                    continue block10;
                                }
                                throw new Exception("IzPack home path argument missing");
                            }
                            default: {
                                throw new Exception("unknown argument");
                            }
                        }
                    }
                    throw new Exception("bad argument");
                }
                string = CompilerConfig.resolveIzPackHome(string);
                System.out.println("-> Processing  : " + string6);
                System.out.println("-> Output      : " + string7);
                System.out.println("-> Base path   : " + string3);
                System.out.println("-> Kind        : " + string4);
                System.out.println("-> Compression : " + string5);
                System.out.println("-> Compr. level: " + n2);
                System.out.println("-> IzPack home : " + string);
                System.out.println("");
                Compiler.setIzpackHome(string);
                Compiler.CmdlinePackagerListener cmdlinePackagerListener = new Compiler.CmdlinePackagerListener();
                CompilerConfig compilerConfig = new CompilerConfig(string6, string3, string4, string7, string5, n2, cmdlinePackagerListener, null);
                compilerConfig.executeCompiler();
                while (compilerConfig.isAlive()) {
                    Thread.sleep(100L);
                }
                if (compilerConfig.wasSuccessful()) {
                    n = 0;
                }
                System.out.println("Build time: " + new Date());
            }
        }
        catch (Exception exception) {
            System.err.println("-> Fatal error :");
            System.err.println("   " + exception.getMessage());
            exception.printStackTrace();
            System.err.println("");
            System.err.println("(tip : use -? to get the commmand line parameters)");
        }
        System.exit(n);
    }

    private static String resolveIzPackHome(String string) {
        File file = new File(string, IZ_TEST_SUBDIR + File.separator + IZ_TEST_FILE);
        if (file.exists()) {
            return string;
        }
        String string2 = Compiler.class.getName();
        string2 = string2.replace('.', '/');
        string2 = "/" + string2 + ".class";
        URL uRL = Compiler.class.getResource(string2);
        String string3 = uRL.getFile();
        int n = string3.indexOf(string2);
        if ((string3 = string3.substring(0, n)).endsWith("!")) {
            if (string3.endsWith("standalone-compiler.jar!") || string3.endsWith("standalone-compiler-4.0.0.jar!") || string3.matches("standalone-compiler-[\\d\\.]+.jar!")) {
                return ".";
            }
            string3 = string3.substring(0, string3.length() - 1);
        }
        File file2 = null;
        file2 = URI.create(string3).isAbsolute() ? new File(URI.create(string3)) : new File(string3);
        while (true) {
            if (file2 == null) {
                throw new IllegalArgumentException("No valid IzPack home directory found");
            }
            file = new File(file2, IZ_TEST_SUBDIR + File.separator + IZ_TEST_FILE);
            if (file.exists()) {
                return file2.getAbsolutePath();
            }
            file2 = file2.getParentFile();
        }
    }

    private void addCustomListeners(XMLElement xMLElement) throws Exception {
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("listeners");
        if (xMLElement2 == null) {
            return;
        }
        for (XMLElement xMLElement3 : xMLElement2.getChildrenNamed("listener")) {
            Object[] objectArray = this.getCompilerListenerInstance(xMLElement3);
            if (objectArray != null) {
                this.addCompilerListener((CompilerListener)objectArray[0]);
            }
            String[] stringArray = new String[]{"installer", "uninstaller"};
            int[] nArray = new int[]{0, 1};
            for (int i = 0; i < stringArray.length; ++i) {
                String string = xMLElement3.getAttribute(stringArray[i]);
                if (string == null) continue;
                String string2 = xMLElement3.getAttribute("jar");
                if ((string2 = this.compiler.replaceProperties(string2)) == null) {
                    string2 = "bin/customActions/" + string + ".jar";
                }
                List<OsConstraint> list = OsConstraint.getOsList(xMLElement3);
                this.compiler.addCustomListener(nArray[i], string, string2, list);
            }
        }
    }

    private List<String> getContainedFilePaths(URL uRL) throws Exception {
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream());
        ZipEntry zipEntry = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (zipEntry.isDirectory()) continue;
            arrayList.add(string);
        }
        jarInputStream.close();
        return arrayList;
    }

    private String getFullClassName(URL uRL, String string) throws IOException {
        JarInputStream jarInputStream = new JarInputStream(uRL.openStream());
        ZipEntry zipEntry = null;
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            int n = string2.lastIndexOf(".class");
            if (n < 0) continue;
            string2 = string2.replace('/', '.');
            int n2 = -1;
            int n3 = -1;
            if (string != null) {
                n2 = string2.indexOf(string);
                n3 = string2.toLowerCase().indexOf(string.toLowerCase());
            }
            if (n2 != -1 && string2.length() == n2 + string.length() + 6) {
                jarInputStream.close();
                return string2.substring(0, n);
            }
            if (n3 == -1 || string2.length() != n3 + string.length() + 6) continue;
            throw new IllegalArgumentException("Fatal error! The declared panel name in the xml file (" + string + ") differs in case to the founded class file (" + string2 + ").");
        }
        jarInputStream.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getCompilerListenerInstance(XMLElement xMLElement) throws Exception {
        Object object;
        URL uRL;
        String string;
        String string2 = xMLElement.getAttribute("compiler");
        Class<?> clazz = null;
        Object var4_4 = null;
        if (string2 == null) {
            return null;
        }
        String string3 = xMLElement.getAttribute("jar");
        if ((string3 = this.compiler.replaceProperties(string3)) == null) {
            string3 = "bin/customActions/" + string2 + ".jar";
        }
        if ((string = this.getFullClassName(uRL = this.findIzPackResource(string3, "CustomAction jar file", xMLElement), string2)) == null) {
            return null;
        }
        if (uRL != null) {
            if (this.getClass().getResource("/" + string3) != null) {
                object = null;
                FileOutputStream fileOutputStream = null;
                byte[] byArray = new byte[5120];
                File file = null;
                try {
                    int n;
                    file = File.createTempFile("izpj", ".jar");
                    file.deleteOnExit();
                    fileOutputStream = new FileOutputStream(file);
                    object = this.getClass().getResourceAsStream("/" + string3);
                    long l = 0L;
                    while ((n = ((InputStream)object).read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                        l += (long)n;
                    }
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                uRL = file.toURL();
            }
            object = new URLClassLoader(new URL[]{uRL}, CompilerListener.class.getClassLoader());
            clazz = ((ClassLoader)object).loadClass(string);
        }
        if (clazz != null) {
            var4_4 = clazz.newInstance();
        } else {
            this.parseError(xMLElement, "Cannot find defined compiler listener " + string2);
        }
        if (!CompilerListener.class.isInstance(var4_4)) {
            this.parseError(xMLElement, "'" + string2 + "' must be implemented " + CompilerListener.class.toString());
        }
        object = OsConstraint.getOsList(xMLElement);
        return new Object[]{var4_4, string2, object};
    }

    private void addCompilerListener(CompilerListener compilerListener) {
        this.compilerListeners.add(compilerListener);
    }

    private void notifyCompilerListener(String string, int n, XMLElement xMLElement) throws CompilerException {
        Iterator<CompilerListener> iterator = this.compilerListeners.iterator();
        IPackager iPackager = this.compiler.getPackager();
        while (iterator != null && iterator.hasNext()) {
            CompilerListener compilerListener = iterator.next();
            compilerListener.notify(string, n, xMLElement, iPackager);
        }
    }

    private Map getAdditionals(XMLElement xMLElement) throws CompilerException {
        Iterator<CompilerListener> iterator = this.compilerListeners.iterator();
        Map map = null;
        try {
            while (iterator != null && iterator.hasNext()) {
                map = iterator.next().reviseAdditionalDataMap(map, xMLElement);
            }
        }
        catch (CompilerException compilerException) {
            this.parseError(xMLElement, compilerException.getMessage());
        }
        return map;
    }

    private class Edge {
        PackInfo u;
        PackInfo v;

        Edge(PackInfo packInfo, PackInfo packInfo2) {
            this.u = packInfo;
            this.v = packInfo2;
        }
    }
}

