/*
 * Decompiled with CFR 0.152.
 */
package com.telcordia;

import com.telcordia.MessageQueue;
import com.telcordia.rmi.RMIStackClientThread;
import com.telcordia.rmi.RMIStackServerImpl;
import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.OAM_IF;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.TooManyListenersException;

public class JainMgcpStackImpl
implements JainMgcpStack,
JainMgcpProvider,
OAM_IF {
    private int _port = 2427;
    private String _protocolVersion = "0.1";
    private int _providerCount = 0;
    private RMIStackServerImpl _rmiStackServerImpl = null;
    private RMIStackClientThread _rmiStackClient = null;
    private JainMgcpListener _jainMgcpListener = null;
    private int _currentTranHandle = 0;
    private MessageQueue _mq = new MessageQueue();

    public JainMgcpProvider createProvider() throws CreateProviderException {
        try {
            ++this._providerCount;
            return this;
        }
        catch (Exception exception) {
            throw new CreateProviderException("Failed to create JainMgcpProvider for unknown reason.");
        }
    }

    public void deleteProvider(JainMgcpProvider jainMgcpProvider) throws DeleteProviderException {
        if (this._providerCount == 0 || jainMgcpProvider != this) {
            throw new DeleteProviderException("No such provider exists!");
        }
        --this._providerCount;
    }

    public int getPort() {
        return this._port;
    }

    public String getProtocolVersion() {
        return this._protocolVersion;
    }

    public void setProtocolVersion(String string) {
        this._protocolVersion = string;
    }

    public void addJainMgcpListener(JainMgcpListener jainMgcpListener) throws TooManyListenersException {
        if (this._jainMgcpListener == null) {
            try {
                this._rmiStackServerImpl = new RMIStackServerImpl(this._port);
            }
            catch (RemoteException remoteException) {
                System.err.println("Problem creating local server object");
                System.exit(1);
            }
            this._jainMgcpListener = jainMgcpListener;
            this._rmiStackServerImpl.setJainMgcpListener(this._jainMgcpListener);
            try {
                Naming.rebind("RMIStackServer", this._rmiStackServerImpl);
                System.out.println("Successful registration of server object with rmiregistry");
            }
            catch (Exception exception) {
                System.err.println("RMIStackServerInit Exception: " + exception);
                System.exit(1);
            }
        } else {
            throw new TooManyListenersException();
        }
    }

    public void removeJainMgcpListener(JainMgcpListener jainMgcpListener) {
        if (this._jainMgcpListener == jainMgcpListener) {
            this._rmiStackServerImpl.removeJainMgcpListener();
            this._jainMgcpListener = null;
            try {
                Naming.unbind("RMIStackServer");
                System.err.println("Successfully unbound local RMI Stack Server from registry.");
            }
            catch (Exception exception) {
                System.err.println("Problem unbinding local RMI Stack Server from registry. " + exception.getMessage());
            }
            try {
                if (UnicastRemoteObject.unexportObject(this._rmiStackServerImpl, true)) {
                    System.err.println("Unexported local RMI Stack Server successfully.");
                } else {
                    System.err.println("Couldn't unexport local RMI Stack Server.");
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                System.err.println(noSuchObjectException.getMessage());
            }
        }
    }

    public JainMgcpStack getJainMgcpStack() {
        return this;
    }

    public void sendMgcpEvents(JainMgcpEvent[] jainMgcpEventArray) {
        if (this._rmiStackClient == null) {
            this._rmiStackClient = new RMIStackClientThread(this._rmiStackServerImpl, this._mq);
            this._rmiStackClient.start();
        }
        if (this._jainMgcpListener != null) {
            if (jainMgcpEventArray[0] instanceof JainMgcpCommandEvent) {
                jainMgcpEventArray[0].setTransactionHandle(this.nextTransactionHandle());
            }
            this._mq.enqueue(jainMgcpEventArray[0]);
            this._mq.signal();
        } else {
            System.err.println("No listener available. Request is refused.");
        }
    }

    private synchronized int nextTransactionHandle() {
        if (this._currentTranHandle == 999999999) {
            this._currentTranHandle = 0;
        }
        return ++this._currentTranHandle % 1000000000;
    }

    public void setPort(int n) {
        this._port = n;
    }
}

