/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip;

import jain.protocol.ip.IPPeerUnavailableException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class JainIPFactory
extends ClassLoader {
    private static String pathName = null;
    private static JainIPFactory instance = null;
    private static Vector loadedIPObjects = null;

    private JainIPFactory() {
        pathName = "com.sun";
        loadedIPObjects = new Vector();
    }

    public Object createIPObject(String objectClassName) throws IPPeerUnavailableException {
        String fqClassName = pathName + "." + objectClassName;
        Class<?> newClass = this.findLoadedClass(fqClassName);
        if (newClass == null) {
            try {
                newClass = this.loadClass(fqClassName, true);
            }
            catch (ClassNotFoundException e) {
                throw new IPPeerUnavailableException("Class " + fqClassName + " could not be loaded!");
            }
        }
        Object loadIPObject = null;
        try {
            loadIPObject = newClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IPPeerUnavailableException("Class " + fqClassName + " could not be instantiated!");
        }
        catch (IllegalAccessException e) {
            throw new IPPeerUnavailableException("Class " + fqClassName + " is not accessible!");
        }
        loadedIPObjects.add(loadIPObject);
        return loadIPObject;
    }

    public static JainIPFactory getInstance() {
        if (instance == null) {
            instance = new JainIPFactory();
        }
        return instance;
    }

    public void setPathName(String pathName) {
        JainIPFactory.pathName = pathName.toLowerCase();
    }

    public String getPathName() {
        return pathName;
    }

    public Vector getJainIPObject() {
        return loadedIPObjects;
    }

    protected synchronized Class findClass(String fqClassName) throws ClassNotFoundException {
        byte[] classData = null;
        try {
            File classFile = new File(fqClassName + ".class");
            classData = new byte[(int)classFile.length()];
            FileInputStream inFile = new FileInputStream(classFile);
            int length = inFile.read(classData);
            inFile.close();
        }
        catch (IOException readError) {
            throw new ClassNotFoundException(fqClassName);
        }
        Class<?> newClass = null;
        try {
            newClass = this.defineClass(fqClassName, classData, 0, classData.length);
        }
        catch (ClassFormatError e) {
            throw new ClassNotFoundException(fqClassName);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ClassNotFoundException(fqClassName);
        }
        catch (SecurityException e) {
            throw new ClassNotFoundException(fqClassName);
        }
        return newClass;
    }
}

