/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.InfoCode;

public final class AuditConnection
extends JainMgcpCommandEvent {
    private ConnectionIdentifier connectionIdentifier = null;
    private InfoCode[] requestedInfo = null;

    public AuditConnection(Object source, EndpointIdentifier endpointIdentifier, ConnectionIdentifier connectionIdentifier, InfoCode[] requestedInfo) throws IllegalArgumentException {
        super(source, endpointIdentifier, 101);
        this.setConnectionIdentifier(connectionIdentifier);
        this.setRequestedInfo(requestedInfo);
    }

    public void setConnectionIdentifier(ConnectionIdentifier connectionIdentifier) throws IllegalArgumentException {
        if (connectionIdentifier == null) {
            throw new IllegalArgumentException("Connection Identifier cannot be null!");
        }
        this.connectionIdentifier = connectionIdentifier;
    }

    public void setRequestedInfo(InfoCode[] requestedInfo) throws IllegalArgumentException {
        if (requestedInfo == null) {
            throw new IllegalArgumentException("Requested Info cannot be null!");
        }
        int i = 0;
        while (i < requestedInfo.length) {
            int ic = requestedInfo[i].getInfoCode();
            if (ic != 2 && ic != 4 && ic != 6 && ic != 7 && ic != 17 && ic != 18 && ic != 12) {
                throw new IllegalArgumentException("Entry " + i + " in the list of requested information " + "parameters is not valid for the AuditConnection command!");
            }
            ++i;
        }
        this.requestedInfo = requestedInfo;
    }

    public ConnectionIdentifier getConnectionIdentifier() {
        return this.connectionIdentifier;
    }

    public InfoCode[] getRequestedInfo() {
        return this.requestedInfo;
    }

    public String toString() {
        String text = super.BuildCommandHeader("AUCX");
        text = text + "I: " + this.connectionIdentifier.toString() + "\n";
        text = text + "F: ";
        int i = 0;
        while (i < this.requestedInfo.length) {
            if (i != 0) {
                text = text + ",";
            }
            text = text + this.requestedInfo[i].toString();
            ++i;
        }
        text = text + "\n";
        return text;
    }
}

