/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.InfoCode;
import jain.protocol.ip.mgcp.message.parms.WildcardNotPermittedException;

public class AuditEndpoint
extends JainMgcpCommandEvent {
    private InfoCode[] requestedInfo = null;

    public AuditEndpoint(Object source, EndpointIdentifier endpointIdentifier) throws IllegalArgumentException {
        super(source, endpointIdentifier, 102);
    }

    public AuditEndpoint(Object source, EndpointIdentifier endpointIdentifier, InfoCode[] requestedInfo) throws WildcardNotPermittedException, IllegalArgumentException {
        this(source, endpointIdentifier);
        String loc_ep_name = endpointIdentifier.getLocalEndpointName();
        if (loc_ep_name.indexOf(42) != -1 || loc_ep_name.indexOf(63) != -1) {
            throw new WildcardNotPermittedException("Endpoint Identifier cannot contain a wildcard character in this context!");
        }
        this.setRequestedInfo(requestedInfo);
    }

    public void setRequestedInfo(InfoCode[] requestedInfo) throws IllegalArgumentException {
        if (requestedInfo == null) {
            throw new IllegalArgumentException("Requested Info cannot be null!");
        }
        int i = 0;
        while (i < requestedInfo.length) {
            int ic = requestedInfo[i].getInfoCode();
            if (ic != 8 && ic != 10 && ic != 9 && ic != 5 && ic != 15 && ic != 16 && ic != 4 && ic != 3 && ic != 11 && ic != 20 && ic != 1 && ic != 21 && ic != 22 && ic != 13 && ic != 19) {
                throw new IllegalArgumentException("Entry " + i + " in the list of requested information parameters " + "is not valid for the Audit Endpoint command!");
            }
            ++i;
        }
        this.requestedInfo = requestedInfo;
    }

    public InfoCode[] getRequestedInfo() {
        return this.requestedInfo;
    }

    public String toString() {
        String text = super.BuildCommandHeader("AUEP");
        if (this.requestedInfo != null) {
            text = text + "F: ";
            int i = 0;
            while (i < this.requestedInfo.length) {
                if (i != 0) {
                    text = text + ",";
                }
                text = text + this.requestedInfo[i].toString();
                ++i;
            }
            text = text + "\n";
        }
        return text;
    }

    public void clearAllReqInfoItems() {
        this.requestedInfo = null;
    }
}

