/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message.parms;

import java.io.Serializable;

public final class NotifiedEntity
implements Serializable {
    private String localName = null;
    private String domainName = null;
    private int portNumber = 2427;

    public NotifiedEntity(String domainName) throws IllegalArgumentException {
        if (domainName == null) {
            throw new IllegalArgumentException("Domain Name must not be null!");
        }
        this.localName = null;
        this.domainName = domainName;
        this.portNumber = 2427;
    }

    public NotifiedEntity(String localName, String domainName) throws IllegalArgumentException {
        this(domainName);
        if (localName == null) {
            throw new IllegalArgumentException("Local Name must not be null in this context!");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Domain Name must not be null!");
        }
        this.localName = localName;
    }

    public NotifiedEntity(String localName, String domainName, int portNumber) throws IllegalArgumentException {
        this(localName, domainName);
        if (localName == null) {
            throw new IllegalArgumentException("Local Name must not be null in this context!");
        }
        if (domainName == null) {
            throw new IllegalArgumentException("Domain Name must not be null!");
        }
        if (portNumber < 1 || portNumber > 99999) {
            throw new IllegalArgumentException("Port number is not valid!");
        }
        this.portNumber = portNumber;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String toString() {
        return this.localName + "@" + this.domainName + ":" + this.portNumber;
    }
}

