/*
 * Decompiled with CFR 0.152.
 */
import jain.protocol.ip.JainIPFactory;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.OAM_IF;
import java.lang.reflect.Array;

public class TCK {
    private static JainMgcpProvider _p = null;
    private static JainMgcpListener _l = null;
    private static final int CALL_AGENT = 1;
    private static final int RGW = 2;
    private static boolean finished = false;
    public static String remoteIP = null;

    public static synchronized boolean isFinished() {
        return finished;
    }

    public static synchronized void setFinished() {
        finished = true;
    }

    private static void printUsage() {
        System.err.println("Usage:\njavac TCK ca|CA|rgw|RGW PathName RemoteIP [\"verbose\"]\n     where \"ca\" designates Call Agent behavior\n           \"rgw\" designates Gateway behavior\n           \"PathName\" is the high-level path name of the JainMgcpStack implementation (e.g., com.telcordia)\n           \"RemoteIP\" is the remote host name or IP address\n           \"verbose\" is an optional parameter that indicates verbose trace should be produced.");
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 0;
        boolean bl = false;
        JainIPFactory jainIPFactory = null;
        JainMgcpStack jainMgcpStack = null;
        OAM_IF oAM_IF = null;
        System.out.println("JAIN MGCP TCK");
        int n2 = Array.getLength(stringArray);
        if (n2 < 3) {
            TCK.printUsage();
            System.exit(1);
        }
        if ("ca".compareTo(stringArray[0].toLowerCase()) == 0) {
            n = 1;
        } else if ("rgw".compareTo(stringArray[0].toLowerCase()) == 0) {
            n = 2;
        } else {
            TCK.printUsage();
            System.exit(1);
        }
        System.out.println("This instance is a " + (n == 1 ? "Call Agent" : "Gateway") + ".");
        System.out.println("Using " + stringArray[1] + " as the path name for JainMgcpStackImpl.");
        System.out.println("Remote entity is " + stringArray[2] + ".");
        remoteIP = stringArray[2];
        if (n2 == 4 && stringArray[3].compareTo("verbose") == 0) {
            System.out.println("Verbose trace selected.");
            bl = true;
        }
        System.out.println();
        TestAPI testAPI = new TestAPI(bl);
        if (n == 1) {
            if (testAPI.TestCA()) {
                System.out.println("Test of Call Agent API succeeded!");
            } else {
                System.err.println("Test of Call Agent API failed!");
                System.err.println("Exiting now.");
                System.exit(1);
            }
        } else if (testAPI.TestRGW()) {
            System.out.println("Test of Gateway API succeeded!");
        } else {
            System.err.println("Test of Gateway API failed!");
            System.err.println("Exiting now.");
            System.exit(1);
        }
        System.out.println();
        System.out.println("Continuing with messaging tests.");
        try {
            System.out.println("Getting an instance of JainIPFactory.");
            jainIPFactory = JainIPFactory.getInstance();
        }
        catch (Exception exception) {
            System.err.println("Got an exception:  " + exception.getMessage());
            System.err.println("Exiting now.");
            System.exit(1);
        }
        System.out.println("Setting path name for stack implementation to " + stringArray[1] + ".");
        jainIPFactory.setPathName(stringArray[1]);
        System.out.println("Creating a JainMgcpStack object.");
        try {
            object = jainIPFactory.createIPObject("JainMgcpStackImpl");
            jainMgcpStack = (JainMgcpStack)object;
            oAM_IF = (OAM_IF)object;
        }
        catch (Exception exception) {
            System.err.println("Got an exception:  " + exception.getMessage());
            System.err.println("Exiting now.");
            System.exit(1);
        }
        if (n == 1) {
            System.out.println("Setting port to Call Agent default port 2727");
            oAM_IF.setPort(2727);
        } else {
            System.out.println("Setting port to Gateway default port 2427");
            oAM_IF.setPort(2427);
        }
        try {
            System.out.println("Creating a JainMgcpProvider object");
            _p = jainMgcpStack.createProvider();
        }
        catch (Exception exception) {
            System.err.println("Got an exception:  " + exception.getMessage());
            System.err.println("Exiting now.");
            System.exit(1);
        }
        System.out.println("Creating a JainMgcpListener object");
        _l = new JainMgcpListenerImpl(_p);
        try {
            System.out.println("Adding JainMgcpListener object to JainMgcpProvider's list");
            _p.addJainMgcpListener(_l);
        }
        catch (Exception exception) {
            System.err.println("Got an exception:  " + exception.getMessage());
            System.err.println("Exiting now.");
            System.exit(1);
        }
        object = new TestMsg(_p, remoteIP);
        ((TestMsg)object).runTests();
        long l = System.currentTimeMillis();
        while (!TCK.isFinished() && System.currentTimeMillis() - l < 120000L) {
            Thread.yield();
        }
        if (TCK.isFinished()) {
            System.out.println("Test of messaging capability succeeded!");
        } else {
            System.out.println("Test of messaging capability failed!");
        }
        System.exit(1);
    }
}

