/*
 * Decompiled with CFR 0.152.
 */
package jakarta.activation;

import jakarta.activation.DataSource;
import jakarta.activation.FileTypeMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileDataSource
implements DataSource {
    private Path _path = null;
    private FileTypeMap typeMap = null;

    public FileDataSource(File file) {
        this._path = file.toPath();
    }

    public FileDataSource(Path path) {
        this._path = path;
    }

    public FileDataSource(String name) {
        this(Paths.get(name, new String[0]));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this._path, new OpenOption[0]);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this._path, new OpenOption[0]);
    }

    @Override
    public String getContentType() {
        if (this.typeMap == null) {
            return FileTypeMap.getDefaultFileTypeMap().getContentType(this._path);
        }
        return this.typeMap.getContentType(this._path);
    }

    @Override
    public String getName() {
        return this._path.getFileName().toString();
    }

    public File getFile() {
        return this._path.toFile();
    }

    public Path getPath() {
        return this._path;
    }

    public void setFileTypeMap(FileTypeMap map) {
        this.typeMap = map;
    }
}

