/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.repository;

import jakarta.data.repository.KeysetCursor;
import jakarta.data.repository.Pageable;
import jakarta.data.repository.Sort;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class Pagination
implements Pageable {
    private final Pageable.Cursor cursor;
    private final Pageable.Mode mode;
    private final long page;
    private final int size;
    private final List<Sort> sorts;

    Pagination(long pageNumber, int maxPageSize, List<Sort> sorts, Pageable.Mode mode, Pageable.Cursor cursor) {
        if (pageNumber < 1L) {
            throw new IllegalArgumentException("pageNumber: " + pageNumber);
        }
        if (maxPageSize < 1) {
            throw new IllegalArgumentException("maxPageSize: " + maxPageSize);
        }
        if (mode != Pageable.Mode.OFFSET && (cursor == null || cursor.size() == 0)) {
            throw new IllegalArgumentException("No keyset values were provided.");
        }
        this.page = pageNumber;
        this.size = maxPageSize;
        this.sorts = sorts;
        this.mode = mode;
        this.cursor = cursor;
    }

    @Override
    public Pageable afterKeyset(Object ... keyset) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_NEXT, new KeysetCursor(keyset));
    }

    @Override
    public Pageable beforeKeyset(Object ... keyset) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_PREVIOUS, new KeysetCursor(keyset));
    }

    @Override
    public Pageable afterKeysetCursor(Pageable.Cursor keysetCursor) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_NEXT, keysetCursor);
    }

    @Override
    public Pageable beforeKeysetCursor(Pageable.Cursor keysetCursor) {
        return new Pagination(this.page, this.size, this.sorts, Pageable.Mode.CURSOR_PREVIOUS, keysetCursor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pagination pageable = (Pagination)o;
        return this.size == pageable.size && this.page == pageable.page && this.mode == pageable.mode && Objects.equals(this.cursor, pageable.cursor) && this.sorts.equals(pageable.sorts);
    }

    @Override
    public Pageable.Cursor cursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.page, this.sorts, this.mode, this.cursor});
    }

    @Override
    public Pageable.Mode mode() {
        return this.mode;
    }

    @Override
    public Pageable next() {
        if (this.mode == Pageable.Mode.OFFSET) {
            return new Pagination(this.page + 1L, this.size, this.sorts, Pageable.Mode.OFFSET, null);
        }
        throw new UnsupportedOperationException("Not supported for keyset pagination. Instead use afterKeyset or afterKeysetCursor to provide the next keyset values or obtain the nextPageable from a KeysetAwareSlice.");
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.mode == Pageable.Mode.OFFSET ? 100 : 150).append("Pageable{page=").append(this.page).append(", size=").append(this.size);
        if (this.cursor != null) {
            s.append(", mode=").append((Object)this.mode).append(", ").append(this.cursor.size()).append(" keys");
        }
        for (Sort sort : this.sorts) {
            s.append(", ").append(sort.property()).append(sort.isAscending() ? " ASC" : " DESC");
        }
        return s.append("}").toString();
    }

    @Override
    public long page() {
        return this.page;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<Sort> sorts() {
        return this.sorts;
    }

    @Override
    public Pageable page(long pageNumber) {
        return new Pagination(pageNumber, this.size, this.sorts, this.mode, this.cursor);
    }

    @Override
    public Pageable size(int maxPageSize) {
        return new Pagination(this.page, maxPageSize, this.sorts, this.mode, this.cursor);
    }

    @Override
    public Pageable sortBy(Iterable<Sort> sorts) {
        List<Sort> sortList = sorts == null ? Collections.emptyList() : StreamSupport.stream(sorts.spliterator(), false).collect(Collectors.toUnmodifiableList());
        return new Pagination(this.page, this.size, sortList, this.mode, this.cursor);
    }

    @Override
    public Pageable sortBy(Sort ... sorts) {
        return new Pagination(this.page, this.size, sorts == null ? Collections.emptyList() : List.of(sorts), this.mode, this.cursor);
    }
}

