/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.repository;

import jakarta.data.repository.Direction;
import java.util.Objects;

public final class Sort {
    private final String property;
    private final Direction direction;
    private final boolean ignoreCase;

    private Sort(String property, Direction direction, boolean ignoreCase) {
        this.property = property;
        this.direction = direction;
        this.ignoreCase = ignoreCase;
    }

    public String property() {
        return this.property;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }

    public boolean isAscending() {
        return Direction.ASC.equals((Object)this.direction);
    }

    public boolean isDescending() {
        return Direction.DESC.equals((Object)this.direction);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sort sort = (Sort)o;
        return Objects.equals(this.property, sort.property) && this.direction == sort.direction && this.ignoreCase == sort.ignoreCase;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.property, this.direction, this.ignoreCase});
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.property.length() + 32).append("Sort{property='").append(this.property).append("', direction=").append((Object)this.direction);
        if (this.ignoreCase) {
            s.append(", ignore case");
        }
        s.append('}');
        return s.toString();
    }

    public static Sort of(String property, Direction direction, boolean ignoreCase) {
        Objects.requireNonNull(property, "property is required");
        Objects.requireNonNull(direction, "direction is required");
        return new Sort(property, direction, ignoreCase);
    }

    public static Sort asc(String property) {
        return Sort.of(property, Direction.ASC, false);
    }

    public static Sort ascIgnoreCase(String property) {
        return Sort.of(property, Direction.ASC, true);
    }

    public static Sort desc(String property) {
        return Sort.of(property, Direction.DESC, false);
    }

    public static Sort descIgnoreCase(String property) {
        return Sort.of(property, Direction.DESC, true);
    }
}

