/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.repository;

public record Limit(int maxResults, long startAt) {
    private static final long DEFAULT_START_AT = 1L;

    public Limit {
        if (startAt < 1L) {
            throw new IllegalArgumentException("startAt: " + startAt);
        }
        if (maxResults < 1) {
            throw new IllegalArgumentException("maxResults: " + maxResults);
        }
    }

    public static Limit of(int maxResults) {
        return new Limit(maxResults, 1L);
    }

    public static Limit range(long startAt, long endAt) {
        if (endAt < startAt) {
            throw new IllegalArgumentException("startAt: " + startAt + ", endAt: " + endAt);
        }
        if (endAt - startAt >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("startAt: " + startAt + ", endAt: " + endAt + ", maxResults > 2147483647");
        }
        return new Limit((int)(endAt - startAt + 1L), startAt);
    }
}

